#####################################################
#
# rcWaWi
# Datum  : 13.06.2012 13:49:27 Uhr
# Mandant: wawi
#
#####################################################
#
# TABLE 'ABTEILUNG'
#
drop table if exists `ABTEILUNG`;

create table `ABTEILUNG` (
  `ABTEILUNG_ID` int(3) Not Null auto_increment,
  `ABTEILUNG` varchar(30) Not Null,
  `POSITION` int(2) Default '0' Not Null,
  `GELOESCHT` enum('N','J') Default 'N' Not Null,
  PRIMARY KEY (ABTEILUNG_ID),
  UNIQUE KEY MA_Abteilung_ID (ABTEILUNG_ID)
);


#
# TABLE 'ABTEILUNG' DATA
#
INSERT INTO ABTEILUNG VALUES ('1','','1','N');
INSERT INTO ABTEILUNG VALUES ('2','Verkauf','2','N');
INSERT INTO ABTEILUNG VALUES ('3','Einkauf','3','N');



#
# TABLE 'ANREDE'
#
drop table if exists `ANREDE`;

create table `ANREDE` (
  `ANREDE_ID` int(3) Not Null auto_increment,
  `ANREDE` varchar(30) Not Null,
  `POSITION` int(2) Default '0' Not Null,
  `GELOESCHT` enum('J','N') Default 'N' Not Null,
  PRIMARY KEY (ANREDE_ID)
);


#
# TABLE 'ANREDE' DATA
#
INSERT INTO ANREDE VALUES ('1','','1','N');
INSERT INTO ANREDE VALUES ('2','Frau','2','N');
INSERT INTO ANREDE VALUES ('3','Herr','3','N');
INSERT INTO ANREDE VALUES ('4','Familie','4','N');
INSERT INTO ANREDE VALUES ('5','Schule','5','N');
INSERT INTO ANREDE VALUES ('6','Firma','6','N');



#
# TABLE 'ARTIKEL'
#
drop table if exists `ARTIKEL`;

create table `ARTIKEL` (
  `ARTIKEL_ID` int(7) Not Null auto_increment,
  `ARTNR` varchar(10) Not Null,
  `ARTNR_KREDITOR` varchar(15) Default '0' Not Null,
  `KREDITOR_ID` int(11),
  `HERSTELLER_ID` int(6),
  `WG_ID` int(6) Default '0',
  `LAND_ID` int(4) Default '0',
  `LAGER_ID` int(3),
  `MWST_ID` int(3) Default '0',
  `KALKU_ID` int(3),
  `SHOP_PRODUCTS_ID` int(11) Default '-1' Not Null,
  `BEZEICHNUNG` varchar(60) Not Null,
  `BESCHREIBUNG` varchar(150),
  `BESCHREIBUNG_LANG` blob,
  `EAN` int(13),
  `BARCODE` int(13),
  `LAENGE` decimal(8,2),
  `BREITE` decimal(8,2),
  `HOEHE` decimal(8,2),
  `GEWICHT` decimal(8,2) Default '0.00' Not Null,
  `VOLUMEN` decimal(8,2),
  `EP` decimal(10,4) Default '0.0000' Not Null,
  `UVP` decimal(10,4) Default '0.0000' Not Null,
  `PUV1` decimal(10,4),
  `PUV2` decimal(10,4),
  `KALKU_EURO1` decimal(10,4),
  `KALKU_EURO2` decimal(10,4),
  `KALKU_PROZENT` decimal(10,4),
  `KALKU_PUV1` decimal(10,4),
  `KALKU_PUV2` decimal(10,4),
  `LADENPREIS` decimal(10,4) Default '0.0000' Not Null,
  `SHOPPREIS` decimal(10,4) Default '0.0000' Not Null,
  `BILD1` varchar(20),
  `BILD2` varchar(20),
  `BILD3` varchar(20),
  `BILD4` varchar(20),
  `ANMERKUNGEN` blob,
  `ART_TITLE` varchar(255),
  `ART_DESC` blob,
  `ART_KEYWORDS` blob,
  `MENGENEINHEIT` varchar(5),
  `VERPACK_EINHEIT` int(5),
  `BESTELLBAR_AB` date,
  `VERFUEGBAR` date,
  `HINZUGEFUEGT` date,
  `AUSLIEFERBAR_PLAN` date,
  `AUSLIEFERBAR_IST` date,
  `GEAENDERT` date,
  `UVP_BINDUNG` enum('J','N') Default 'N',
  `SHOPARTIKEL` enum('J','N') Default 'N',
  `PORTOFREI` enum('J','N') Default 'N',
  `GELOESCHT` enum('J','N') Default 'N',
  `MWST_SATZ` int(3),
  PRIMARY KEY (ARTIKEL_ID),
  UNIQUE KEY ARTNR (ARTNR)
);


#
# TABLE 'ARTIKEL_AKTION'
#
drop table if exists `ARTIKEL_AKTION`;

create table `ARTIKEL_AKTION` (
  `AKTION_ID` int(7) Not Null auto_increment,
  `ARTIKEL_ID` int(7) Default '0' Not Null,
  `VON` date Default '0000-00-00' Not Null,
  `BIS` date Default '0000-00-00' Not Null,
  `LADENPREIS` decimal(10,4) Default '0.0000' Not Null,
  `SHOPPREIS` decimal(10,4) Default '0.0000' Not Null,
  `GELOESCHT` enum('J','N') Default 'N',
  PRIMARY KEY (AKTION_ID)
);


#
# TABLE 'ARTIKEL_ET'
#
drop table if exists `ARTIKEL_ET`;

create table `ARTIKEL_ET` (
  `ERSATZTEIL_ID` int(12) Not Null auto_increment,
  `ARTIKEL_ID` int(7) Default '0' Not Null,
  `ARTIKEL_ET_ID` int(7) Default '0' Not Null,
  `GELOESCHT` enum('J','N') Default 'N',
  PRIMARY KEY (ERSATZTEIL_ID)
);


#
# TABLE 'ARTIKEL_INVENTUR'
#
drop table if exists `ARTIKEL_INVENTUR`;

create table `ARTIKEL_INVENTUR` (
  `ID` int(11) Not Null auto_increment,
  `ARTIKEL_ID` int(11),
  `SOLL` int(5),
  `IST` int(5),
  `GELOESCHT` enum('J','N') Default 'N',
  PRIMARY KEY (ID),
  UNIQUE KEY ID (ID)
);


#
# TABLE 'ARTIKEL_WG'
#
drop table if exists `ARTIKEL_WG`;

create table `ARTIKEL_WG` (
  `WG_ID` int(6) Not Null auto_increment,
  `WG_PARENT` int(6) Default '0',
  `WG_NAME` varchar(20),
  `WG_TITEL` varchar(20),
  `WG_BESCHREIBUNG` blob,
  `WG_BILD` varchar(10),
  `WG_SORT` int(3) Default '0' Not Null,
  `WG_SHOP_ID` int(6) Default '-1' Not Null,
  `WG_SHOP_PARENT` int(6) Default '-1' Not Null,
  `WG_TITLE` varchar(255),
  `WG_DESC` blob,
  `WG_KEYWORDS` blob,
  `GELOESCHT` enum('J','N') Default 'N' Not Null,
  PRIMARY KEY (WG_ID),
  UNIQUE KEY WG_ID (WG_ID)
);


#
# TABLE 'AUFTRAG_EINZELBUCHUNG'
#
drop table if exists `AUFTRAG_EINZELBUCHUNG`;

create table `AUFTRAG_EINZELBUCHUNG` (
  `ID` int(10) Not Null auto_increment,
  `BELEGNR` int(10),
  `ANZAHL` varchar(6),
  `ARTIKEL_ID` int(7),
  `ARTNR` varchar(10),
  `BEZEICHNUNG` varchar(60),
  `BRUTTO` varchar(10),
  `RABATT` varchar(10),
  `VERKAUFSPREIS` varchar(10),
  `MWST_SATZ` varchar(6),
  `GELOESCHT` enum('J','N') Default 'N' Not Null,
  `GELOESCHT_VON` varchar(5),
  `ART_ABGEBUCHT_DATUM` date,
  PRIMARY KEY (ID),
  UNIQUE KEY ID (ID)
);


#
# TABLE 'AUFTRAG_EINZELBUCHUNG' DATA
#
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('1','1001','1','0','','Malschablone','9.90','10.00','8.90','7.60','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('2','1001','3','0','','Ballon zum Modellieren','0.60','10.00','1.60','7.60','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('3','1001','1','0','','Fischkleister','7.90','10.00','7.10','7.60','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('4','1001','2','0','','Nylon Faden','3.50','10.00','6.30','7.60','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('5','1001','2','0','','Quetschperlen','4.50','10.00','8.10','7.60','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('6','1001','1','0','','Sprhkleber','12.90','10.00','11.60','7.60','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('7','1001','1','0','','Texti Farbe','6.80','10.00','6.10','7.60','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('8','1001','1','0','','Strukturschneei','11.50','10.00','10.35','7.60','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('9','1001','1','0','','Malschablone','16.90','10.00','15.20','7.60','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('10','1001','1','0','','Trendy Filz 3mm','11.90','10.00','10.70','7.60','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('11','1002','60','0','','Holzperlen 8 mm rot','3.60','20.00','172.80','7.60','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('12','1002','60','0','','Holzperlen 8 mm weiss','3.60','20.00','172.80','7.60','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('13','1002','60','0','','Holzperlen 8 mm roh','4.80','20.00','230.40','7.60','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('14','1002','23','0','','Holzperlen 12 mm rot','3.60','20.00','66.25','7.60','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('15','1002','23','0','','Holzperlen 12 mm weiss','3.60','20.00','66.25','7.60','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('16','1002','39','0','','Holzperlen 15 mm rot','3.60','20.00','112.30','7.60','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('17','1002','39','0','','Holzperlen 15 mm','3.60','20.00','112.30','7.60','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('18','1003','1','0','900 305','Giesspulver Schiefer 5 kg.','43.90','0','43.90','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('19','1003','1','0','100 005','Giesspulver weiss  5 kg','36.50','0.00','36.50','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('20','1003','1','0','cp 554','Giessform Asia Bilderrahmen','12.90','0.00','12.90','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('21','1003','1','0','cp 553','Giessform Asia Bilderrahmen','12.90','0.00','12.90','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('22','1003','1','0','cp 556','Giessform Asia  Kerzenhalter','12.90','0.00','12.90','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('23','1003','1','0','8742 48','Giessform 3-D Budda','26.90','0.00','26.90','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('24','1004','1','0','900 305','Giessmasse schiefer 5 kg.','43.90','0','43.90','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('25','1004','1','0','100 005','Giessmasse weiss 5 kg.','36.50','0.00','36.50','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('26','1004','1','0','8742 48','Giessform 3-D Budda','26.90','0.00','26.90','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('27','1004','1','0','CP 556','Giessform Asia Kerzenhalter','12.90','0.00','12.90','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('28','1004','1','0','CP 554','Giessform Asia Bilderrahmen','12.90','0.00','12.90','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('29','1004','1','0','CP 553','Giessform Asia Bilderrahmen','12.90','0.00','12.90','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('30','1005','1','0','900 305','Giessmasse schiefer 5 kg.','43.90','0','43.90','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('31','1005','1','0','100 005','Giessmasse weiss 5 kg.','36.50','0.00','36.50','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('32','1005','1','0','8742 48','Giessform 3-D Budda','26.90','0.00','26.90','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('33','1005','1','0','CP 556','Giessform Asia Kerzenhalter','12.90','0.00','12.90','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('34','1005','1','0','CP 554','Giessform Asia Bilderrahmen','12.90','0.00','12.90','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('35','1005','1','0','CP 553','Giessform Asia Bilderrahmen','12.90','0.00','12.90','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('36','1006','1','0','900 305','Giessmasse schiefer 5 kg.','43.90','0','43.90','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('37','1006','1','0','100 005','Giessmasse weiss 5 kg.','36.50','0.00','36.50','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('38','1006','1','0','8742 48','Giessform 3-D Budda','26.90','0.00','26.90','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('39','1006','1','0','CP 556','Giessform Asia Kerzenhalter','12.90','0.00','12.90','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('40','1006','1','0','CP 554','Giessform Asia Bilderrahmen','12.90','0.00','12.90','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('41','1006','1','0','CP 553','Giessform Asia Bilderrahmen','12.90','0.00','12.90','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('42','1007','1','0','900 305','Giessmasse schiefer 5 kg.','43.90','0','43.90','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('43','1007','1','0','100 005','Giessmasse weiss 5 kg.','36.50','0.00','36.50','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('44','1007','1','0','8742 48','Giessform 3-D Budda','26.90','0.00','26.90','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('45','1007','1','0','CP 556','Giessform Asia Kerzenhalter','12.90','0.00','12.90','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('46','1007','1','0','CP 554','Giessform Asia Bilderrahmen','12.90','0.00','12.90','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('47','1007','1','0','CP 553','Giessform Asia Bilderrahmen','12.90','0.00','12.90','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('48','1008','1','0','900 305','Giessmasse schiefer 5 kg.','43.90','0','43.90','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('49','1008','1','0','100 005','Giessmasse weiss 5 kg.','36.50','0.00','36.50','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('50','1008','1','0','8742 48','Giessform 3-D Budda','26.90','0.00','26.90','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('51','1008','1','0','CP 556','Giessform Asia Kerzenhalter','12.90','0.00','12.90','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('52','1008','1','0','CP 554','Giessform Asia Bilderrahmen','12.90','0.00','12.90','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('53','1008','1','0','CP 553','Giessform Asia Bilderrahmen','12.90','0.00','12.90','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('54','1009','1','0','900 305','Giessmasse schiefer 5 kg.','43.90','0','43.90','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('55','1009','1','0','100 005','Giessmasse weiss 5 kg.','36.50','0.00','36.50','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('56','1009','1','0','8742 48','Giessform 3-D Budda','26.90','0.00','26.90','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('57','1009','1','0','CP 556','Giessform Asia Kerzenhalter','12.90','0.00','12.90','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('58','1009','1','0','CP 554','Giessform Asia Bilderrahmen','12.90','0.00','12.90','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('59','1009','1','0','CP 553','Giessform Asia Bilderrahmen','12.90','0.00','12.90','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('60','1010','1','0','900 305','Giessmasse schiefer 5 kg.','43.90','0','43.90','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('61','1010','1','0','100 005','Giessmasse weiss 5 kg.','36.50','0.00','36.50','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('62','1010','1','0','8742 48','Giessform 3-D Budda','26.90','0.00','26.90','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('63','1010','1','0','CP 556','Giessform Asia Kerzenhalter','12.90','0.00','12.90','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('64','1010','1','0','CP 554','Giessform Asia Bilderrahmen','12.90','0.00','12.90','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('65','1010','1','0','CP 553','Giessform Asia Bilderrahmen','12.90','0.00','12.90','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('66','1011','1','0','111','Test','1.00','0.00','1.00','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('67','1012','1','0','','test','2.00','0','2.00','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('68','1013','1','0','','test','2.00','0','2.00','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('69','1013','1','0','','test','2.00','0','2.00','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('70','1014','1','0','123','Testartikel','12.00','0','12.00','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('71','1015','2','0','','Holzperlen Beutel','3.60','10.00','6.50','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('72','1015','1','0','','Schm. Faden','2.70','10.00','2.45','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('73','1015','2','0','','Polaris Perlen Beutel','6.00','10.00','10.80','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('74','1015','8','0','','Schm. Ringli','0.10','10.00','0.70','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('75','1015','8','0','','Karabiner','0.90','10.00','6.50','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('76','1015','3','0','','Textil Pen','3.80','10.00','10.25','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('77','1015','2','0','-','Textil Plus Farbe','3.40','10.00','6.80','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('78','1015','1','0','','Ton Topf','1.60','10.00','1.45','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('79','1015','1','0','-','1 Meter Drahtgitter','6.90','10.00','6.20','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('80','1015','10','0','','Wackelaugen','0.45','10.00','4.05','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('81','1015','26','0','','Wackelaugen','0.40','10.00','9.35','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('82','1015','20','0','','Wackelaugen','0.35','10.00','6.30','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('83','1015','2','0','','Federn Marabu','2.90','10.00','5.20','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('84','1015','3','0','','Federn Marabu','2.90','10.00','7.85','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('85','1015','3','0','','Bast Farbig','3.20','10.00','8.65','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('86','1015','2','0','-','2 Meter Drahtgitter','6.90','10.00','12.40','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('87','1015','3','0','','Federn Marabu','2.90','10.00','7.85','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('88','1015','1','0','','Textil Pen','3.90','10.00','3.50','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('89','1016','3','0','','Aufsatz Giesskanne','9.90','10','26.75','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('90','1016','1','0','','Bastelbuch','12.95','10.00','11.65','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('91','1016','8','0','','Deko Blume Sisal','2.50','10.00','18.00','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('92','1017','2','0','','Deco-Painter rot','4.90','0.00','9.80','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('93','1017','2','0','','UHU Kraftkleber','5.90','0.00','11.80','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('94','1017','21','0','','Moosgummi ass. Farben','1.90','0.00','39.90','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('95','1018','210','0','','Perlen assortiert','0.20','10.00','37.80','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('96','1018','1','0','','Nylon Draht','12.80','10.00','11.50','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('97','1018','1','0','','Quetsch Perlen','4.50','10.00','4.05','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('98','1018','1','0','','Verschluss Schmuck','2.20','10.00','2.00','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('99','1018','1','0','','Klebepistole','19.90','10.00','17.90','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('100','1018','1','0','','Klebe Stick','6.90','10.00','6.20','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('101','1019','5','0','','Acryl Farben 250 ml.','15.90','10.00','71.55','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('102','1019','3','0','','Acryl Farben 50 ml. ','5.80','10.00','15.65','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('103','1019','2','0','','Acryl Farben 50 ml. ','7.80','10.00','14.05','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('104','1019','1','0','','Fisch Kleister','8.80','10.00','7.90','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('105','1019','1','0','','Modellier Gewebe','6.90','10.00','6.20','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('106','1019','1','0','','Papiermach','4.90','10.00','4.40','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('107','1019','10','0','','Masken aus Papiermischung','9.80','10.00','88.20','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('108','1019','1','0','','Maske aus Kunststoff','7.50','10.00','6.75','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('109','1019','1','0','','Pinselset','7.20','10.00','6.50','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('110','1019','3','0','','Papiermach','4.90','10.00','13.25','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('111','1020','12','0','','Ferienpassmitglieder','12.00','0','144.00','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('112','1021','1','0','-','Drahtgeflecht 2,2 meter  6.90/meter','15.20','10.00','13.70','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('113','1021','26','0','-','Fimo assortiert','3.70','10.00','86.60','0.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('114','1021','2','0','','Perlen','3.90','10.00','7.00','0.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('115','1021','3','0','','Textil Painter','3.80','10.00','10.25','0.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('116','1021','3','0','-','Plakat sen','3.30','10.00','8.65','0.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('117','1021','2','0','','Nylonfaden','2.60','10.00','4.70','0.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('118','1022','3','0','','Modelliergewebe','13.80','10','37.25','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('119','1022','2','0','','Juteband per Meter','1.60','10.00','2.90','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('120','1022','2','0','','Dekoband per meter','1.40','10.00','2.50','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('121','1022','2','0','','Bast','3.20','10.00','5.75','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('122','1022','4','0','','Styropor Pilz','2.40','10.00','8.65','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('123','1022','1','0','','Deko Stern AKTION','7.45','0.00','7.45','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('124','1023','3','0','','Vlies Eissterne Hellblau per Meter','5.90','0.00','17.70','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('125','1024','2','0','','Engelsflgel','5.70','10','10.25','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('126','1024','1','0','','Moosgummi','1.90','10.00','1.70','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('127','1024','7','0','','Figurendraht / Bastdraht per Meter','1.70','10.00','10.70','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('128','1024','16','0','','Styropor Kegelform','2.30','10.00','33.10','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('129','1024','16','0','','Styropor Kugelform','0.70','10.00','10.10','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('130','1024','2','0','','Kerra Flott Giessmasse 5 kg.','36.50','10.00','65.70','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('131','1024','3','0','','Kerra Flott Giessmasse 1 kg.','8.60','10.00','23.20','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('132','1024','11','0','','Engelsflgel','6.90','10.00','68.30','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('133','1024','1','0','','Styropor Kegelform','3.80','10.00','3.40','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('134','1024','1','0','','Styropor Kugelform','1.05','10.00','0.95','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('135','1025','2','0','','Engelsflgel','5.70','10','10.25','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('136','1025','1','0','','Moosgummi','1.90','10.00','1.70','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('137','1025','7','0','','Figurendraht / Bastdraht per Meter','1.70','10.00','10.70','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('138','1025','16','0','','Styropor Kegelform','2.30','10.00','33.10','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('139','1025','16','0','','Styropor Kugelform','0.70','10.00','10.10','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('140','1025','2','0','','Kerra Flott Giessmasse 5 kg.','36.50','10.00','65.70','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('141','1025','3','0','','Kerra Flott Giessmasse 1 kg.','8.60','10.00','23.20','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('142','1025','11','0','','Engelsflgel','6.90','10.00','68.30','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('143','1025','1','0','','Styropor Kegelform','3.80','10.00','3.40','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('144','1025','1','0','','Styropor Kugelform','1.05','10.00','0.95','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('145','1026','2','0','','Engelsflgel','5.70','10','10.25','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('146','1026','1','0','','Moosgummi','1.90','10.00','1.70','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('147','1026','7','0','','Figurendraht / Bastdraht per Meter','1.70','10.00','10.70','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('148','1026','16','0','','Styropor Kegelform','2.30','10.00','33.10','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('149','1026','16','0','','Styropor Kugelform','0.70','10.00','10.10','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('150','1026','2','0','','Kerra Flott Giessmasse 5 kg.','36.50','10.00','65.70','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('151','1026','3','0','','Kerra Flott Giessmasse 1 kg.','8.60','10.00','23.20','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('152','1026','11','0','','Engelsflgel','6.90','10.00','68.30','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('153','1026','1','0','','Styropor Kegelform','3.80','10.00','3.40','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('154','1026','1','0','','Styropor Kugelform','1.05','10.00','0.95','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('155','1027','2','0','','Engelsflgel','5.70','10','10.25','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('156','1027','1','0','','Moosgummi','1.90','10.00','1.70','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('157','1027','7','0','','Figurendraht / Bastdraht per Meter','1.70','10.00','10.70','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('158','1027','16','0','','Styropor Kegelform','2.30','10.00','33.10','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('159','1027','16','0','','Styropor Kugelform','0.70','10.00','10.10','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('160','1027','2','0','','Kerra Flott Giessmasse 5 kg.','36.50','10.00','65.70','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('161','1027','3','0','','Kerra Flott Giessmasse 1 kg.','8.60','10.00','23.20','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('162','1027','11','0','','Engelsflgel','6.90','10.00','68.30','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('163','1027','1','0','','Styropor Kegelform','3.80','10.00','3.40','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('164','1027','1','0','','Styropor Kugelform','1.05','10.00','0.95','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('165','1028','2','0','','Engelsflgel','5.70','10','10.25','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('166','1028','1','0','','Moosgummi','1.90','10.00','1.70','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('167','1028','7','0','','Figurendraht / Bastdraht per Meter','1.70','10.00','10.70','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('168','1028','16','0','','Styropor Kegelform','2.30','10.00','33.10','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('169','1028','16','0','','Styropor Kugelform','0.70','10.00','10.10','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('170','1028','2','0','','Kerra Flott Giessmasse 5 kg.','36.50','10.00','65.70','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('171','1028','3','0','','Kerra Flott Giessmasse 1 kg.','8.60','10.00','23.20','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('172','1028','11','0','','Engelsflgel','6.90','10.00','68.30','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('173','1028','1','0','','Styropor Kegelform','3.80','10.00','3.40','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('174','1028','1','0','','Styropor Kugelform','1.05','10.00','0.95','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('175','1029','2','0','','Engelsflgel','5.70','10','10.25','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('176','1029','1','0','','Moosgummi','1.90','10.00','1.70','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('177','1029','7','0','','Figuren Bast Draht','1.70','10.00','10.70','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('178','1029','16','0','','Styropor Kegel 20 cm.','2.30','10.00','33.10','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('179','1029','16','0','','Styropor Kugel 6 cm.','0.70','10.00','10.10','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('180','1029','2','0','','Kerra Flott Giessmasse 5 kg.','36.50','10.00','65.70','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('181','1029','3','0','','Kerra Flott Giessmasse 1kg.','8.60','10.00','23.20','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('182','1029','11','0','','Engelsflgel','6.90','10.00','68.30','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('183','1029','1','0','','Styropor Kegel','3.80','10.00','3.40','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('184','1029','1','0','','Styropor Kugel','1.05','10.00','0.95','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('185','1030','3','0','','Deko Perlen','4.50','10.00','12.15','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('186','1030','4','0','','Deko Perlen','3.90','10.00','14.05','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('187','1030','6','0','','Deko Perlen','5.90','10.00','31.85','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('188','1030','4','0','','Glitter silber','3.30','10.00','11.90','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('189','1030','2','0','','Glitter silber','3.20','10.00','5.75','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('190','1030','1','0','','Gliter blau','3.20','10.00','2.90','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('191','1031','1','0','','Bilderrahmen','6.90','0','6.90','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('192','1032','5','0','','Mosaik Color Pen assortiert','6.90','10','31.05','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('193','1033','1','0','','Deko Federn','2.60','10','2.35','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('194','1033','1','0','','Holz Leiter','2.90','10.00','2.60','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('195','1033','1','0','','Spiegelbox','9.90','10.00','8.90','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('196','1033','1','0','','Glimmer','3.30','10.00','2.95','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('197','1033','1','0','','Glimmer','3.20','10.00','2.90','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('198','1033','1','0','','Flip Flop`s','3.50','10.00','3.15','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('199','1033','6','0','','Perlen Luna','1.10','10.00','5.95','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('200','1033','1','0','','Faltpapier Sort.','7.90','10.00','7.10','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('201','1033','1','0','','Deko Federn','2.60','10.00','2.35','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('202','1033','1','0','','Spiegel Box','3.80','10.00','3.40','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('203','1033','4','0','','Plastk Eier','0.60','10.00','2.15','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('204','1033','1','0','','Ohrhaken','2.00','10.00','1.80','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('205','1033','1','0','','Karabiner','2.20','10.00','2.00','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('206','1033','1','0','','Deko Blten','7.90','10.00','7.10','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('207','1033','1','0','','Bindedraht','2.50','10.00','2.25','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('208','1033','3','0','','Fun Liner Glitter','5.60','10.00','15.10','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('209','1033','2','0','','Deko Sticker','6.50','10.00','11.70','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('210','1033','3','0','','Marmorierfarbe','3.60','10.00','9.70','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('211','1033','1','0','','Natur Bast','3.60','10.00','3.25','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('212','1033','1','0','','Schaschlick Spiesse','3.90','10.00','3.50','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('213','1033','4','0','','Deko Blten','0.30','10.00','1.10','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('214','1034','1','0','','ko - Seifenblock 250 gr.','7.60','10','6.85','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('215','1034','2','0','','ko - Seifenblock 500 gr.','13.90','10.00','25.00','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('216','1034','2','0','','ko - Seifenblock 1500 gr.','39.90','10.00','71.80','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('217','1034','1','0','','Giessform','9.90','10.00','8.90','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('218','1034','2','0','','Frippe Sckchen  6 Stk.','7.90','10.00','14.20','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('219','1034','5','0','','3 - D Liner','5.60','10.00','25.20','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('220','1034','3','0','','Sticker','6.50','10.00','17.55','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('221','1035','1','0','','Crea - Pop Folie','6.90','10','6.20','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('222','1035','1','0','','Perlen ass.','9.90','10.00','8.90','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('223','1035','1','0','','Vlies  1/2 M','1.70','10.00','1.55','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('224','1036','2','0','','Giesspulver Crea-flott','8.60','10.00','15.50','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('225','1036','1','0','','Giessform','24.50','10.00','22.05','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('226','1036','1','0','','Schwemmholz 1 Kg.','36.00','10.00','32.40','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('227','1036','1','0','','Alu Draht 20 M','19.90','10.00','17.90','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('228','1036','60','0','','Acrybello Teile AKTION','0.50','0.00','30.00','8.00','N','',NULL);
INSERT INTO AUFTRAG_EINZELBUCHUNG VALUES ('229','1037','2','0','','Alu Draht  20 Meter','19.90','10','35.80','8.00','N','',NULL);



#
# TABLE 'AUFTRAG_PROTOKOLL'
#
drop table if exists `AUFTRAG_PROTOKOLL`;

create table `AUFTRAG_PROTOKOLL` (
  `ID` int(10) Not Null auto_increment,
  `DATUM` date,
  `BELEGNR` varchar(10),
  `BELEGNR_OFFERTE` varchar(10),
  `DATUM_OFFERTE` date,
  `BELEGNR_BESTAETIGUNG` varchar(10),
  `DATUM_BESTAETIGUNG` date,
  `BELEGNR_LIEFERSCHEIN` varchar(10),
  `DATUM_LIEFERSCHEIN` date,
  `BELEGNR_RECHNUNG` varchar(10),
  `DATUM_RECHNUNG` date,
  `ABGESCHLOSSEN` enum('N','J'),
  `DATUM_ABGESCHLOSSEN` date,
  `DEBITORNR_RE` int(10),
  `DEBITORNR_WE` int(10),
  `DEBITORNR_AG` int(11),
  `KONTAKTPERSON` varchar(20),
  `KOMMISSION` varchar(40),
  `BRUTTO` varchar(10),
  `RABATT` varchar(10),
  `VERKAUFSPREIS` varchar(10),
  `PORTO` varchar(10),
  `BRUTTOKREDIT` varchar(10),
  `BK_BASIS_MWST1` varchar(10),
  `BK_BASIS_MWST2` varchar(10),
  `BK_MWST1` varchar(10),
  `BK_MWST2` varchar(10),
  `SKONTO_TAGE` int(3),
  `SKONTO_PROZENT` varchar(10),
  `VALUTA_TAGE` int(3),
  `BEMERKUNGEN` blob,
  `GELOESCHT` enum('N','J'),
  `GELOESCHT_DATUM` date,
  `GELOESCHT_VON` varchar(5),
  `GELOESCHT_GRUND` blob,
  `MWST1_SATZ` varchar(10),
  `MWST2_SATZ` varchar(10),
  PRIMARY KEY (ID),
  UNIQUE KEY Rechnung_ID (ID)
);


#
# TABLE 'AUFTRAG_PROTOKOLL' DATA
#
INSERT INTO AUFTRAG_PROTOKOLL VALUES ('1','2010-11-25','1001','0',NULL,'0',NULL,'0',NULL,'40001','2010-11-25','J','2010-12-28','907','907','907','Frau Schr','Frau Schr','95.60','9.65','85.95','0.00','85.95',NULL,NULL,NULL,NULL,'10','2.00','30','Sammelrechnung','N',NULL,'','',NULL,NULL);
INSERT INTO AUFTRAG_PROTOKOLL VALUES ('2','2010-12-18','1002','0','2010-12-18','0',NULL,'0','2010-11-26','0',NULL,'N',NULL,'911','911','911','Tommila Laura','','1166.40','233.30','933.10','0.00','933.10',NULL,NULL,NULL,NULL,'10','0.00','30','Sammelrechnung','N',NULL,'','',NULL,NULL);
INSERT INTO AUFTRAG_PROTOKOLL VALUES ('3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'J','2011-03-26',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'J','2011-03-26','1',NULL,NULL,NULL);
INSERT INTO AUFTRAG_PROTOKOLL VALUES ('4',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'J','2011-03-26',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'J','2011-03-26','1',NULL,NULL,NULL);
INSERT INTO AUFTRAG_PROTOKOLL VALUES ('5','2011-03-26','1005','0',NULL,'0',NULL,'0','2011-03-16','0','2011-03-26','J','2011-03-26','369','369','369','','','146.00','0.00','146.00','10.00','156.00',NULL,NULL,NULL,NULL,'10','0.00','30','','J','2011-03-26','1','',NULL,NULL);
INSERT INTO AUFTRAG_PROTOKOLL VALUES ('6','2011-03-26','1006','0',NULL,'0',NULL,'0','2011-03-16','0','2011-03-26','J','2011-03-26','369','369','369','','','146.00','0.00','146.00','10.00','156.00',NULL,NULL,NULL,NULL,'10','0.00','30','','J','2011-03-26','1','',NULL,NULL);
INSERT INTO AUFTRAG_PROTOKOLL VALUES ('7','2011-03-26','1007','0',NULL,'0',NULL,'0','2011-03-16','0','2011-03-26','J','2011-03-26','369','369','369','','','146.00','0.00','146.00','10.00','156.00',NULL,NULL,NULL,NULL,'10','0.00','30','','J','2011-03-26','1','',NULL,NULL);
INSERT INTO AUFTRAG_PROTOKOLL VALUES ('8','2011-03-26','1008','0',NULL,'0',NULL,'0','2011-03-16','0','2011-03-26','J','2011-03-26','369','369','369','','','146.00','0.00','146.00','18.00','164.00',NULL,NULL,NULL,NULL,'10','0.00','30','','J','2011-03-26','1','',NULL,NULL);
INSERT INTO AUFTRAG_PROTOKOLL VALUES ('9','2011-03-26','1009','0',NULL,'0',NULL,'0','2011-03-16','0','2011-03-26','J','2011-03-26','369','369','369','','','146.00','0.00','146.00','10.00','156.00',NULL,NULL,NULL,NULL,'10','0.00','30','','J','2011-03-26','1','',NULL,NULL);
INSERT INTO AUFTRAG_PROTOKOLL VALUES ('10','2011-03-16','1010','0',NULL,'0',NULL,'0','2011-03-16','0',NULL,'J','2011-03-26','369','369','369','','','146.00','0.00','146.00','10.00','156.00',NULL,NULL,NULL,NULL,'10','2.00','30','','J','2011-03-26','1','',NULL,NULL);
INSERT INTO AUFTRAG_PROTOKOLL VALUES ('11','2011-03-16','1011','0',NULL,'0',NULL,'0','2011-03-16','0',NULL,'J','2011-03-26','369','369','369','','','1.00','0.00','1.00','10.00','11.00',NULL,NULL,NULL,NULL,'10','2.00','30','','J','2011-03-26','1','',NULL,NULL);
INSERT INTO AUFTRAG_PROTOKOLL VALUES ('12','2011-03-26','1012','0',NULL,'0',NULL,'0',NULL,'40002','2011-03-26','J','2011-03-26','151','151','151','','','2.00','0.00','2.00','10.00','12.00',NULL,NULL,NULL,NULL,'10','2.00','30','','J','2011-03-26','1','',NULL,NULL);
INSERT INTO AUFTRAG_PROTOKOLL VALUES ('13','2011-03-26','1013','0',NULL,'0',NULL,'0',NULL,'40003','2011-03-26','J','2011-03-26','151','151','151','','','4.00','0.00','4.00','0.00','4.00',NULL,NULL,NULL,NULL,'10','2.00','30','','J','2011-03-26','1','',NULL,NULL);
INSERT INTO AUFTRAG_PROTOKOLL VALUES ('14','2011-03-26','1014','0',NULL,'0',NULL,'0','2011-03-26','0','2011-03-26','J','2011-03-26','369','369','369','Test','','12.00','0.00','12.00','10.00','22.00',NULL,NULL,NULL,NULL,'10','2.00','30','','J','2011-03-26','1','',NULL,NULL);
INSERT INTO AUFTRAG_PROTOKOLL VALUES ('15','2011-04-21','1015','0',NULL,'0',NULL,'0',NULL,'40010','2011-04-21','J','2011-06-04','579','579','579','','Frau Flury','129.00','12.20','116.80','0.00','116.80',NULL,NULL,NULL,NULL,'10','2.00','30','Ware abgeholt am:  13.1., 25.2, 02.3., 12.3.','N',NULL,'','',NULL,NULL);
INSERT INTO AUFTRAG_PROTOKOLL VALUES ('16','2011-05-05','1016','0',NULL,'0',NULL,'0',NULL,'40011','2011-05-05','J','2011-06-04','912','912','912','z.H. Frau Lomitana','','62.65','6.25','56.40','0.00','56.40',NULL,NULL,NULL,NULL,'10','2.00','30','Ware abgeholt am: 18.02.2011','N',NULL,'','',NULL,NULL);
INSERT INTO AUFTRAG_PROTOKOLL VALUES ('17','2011-05-06','1017','0',NULL,'0',NULL,'0',NULL,'40012','2011-05-06','J','2011-06-17','913','913','913','Frau Hgi Erika','','61.50','0.00','61.50','10.00','71.50',NULL,NULL,NULL,NULL,'10','2.00','30','gem Lieferung vom 20.4.2011\r\nWare mit Rckgaberecht','N',NULL,'','',NULL,NULL);
INSERT INTO AUFTRAG_PROTOKOLL VALUES ('18','2011-08-17','1018','0',NULL,'0',NULL,'0',NULL,'40013','2011-08-17','J','2011-10-06','579','579','579','','z.H. Frau Flury ','88.30','8.85','79.45','0.00','79.45','0.00','79.45','0.00','5.89','10','2.00','30','Ware abgeholt am: 10.06.2011','N',NULL,'','','2.50','8.00');
INSERT INTO AUFTRAG_PROTOKOLL VALUES ('19','2011-08-17','1019','0',NULL,'0',NULL,'0',NULL,'40014','2011-08-17','J','2011-10-06','914','914','914','','z.H. Frau Jrg- Flury Sandra','260.50','26.05','234.45','0.00','234.45','0.00','234.45','0.00','17.37','10','2.00','30','Ware abgeholt am: 11.06.2011 + 21.06.2011','N',NULL,'','','2.50','8.00');
INSERT INTO AUFTRAG_PROTOKOLL VALUES ('20','2011-10-19','1020','0',NULL,'0',NULL,'0',NULL,'40015','2011-10-19','J','2011-12-01','916','916','916','Frau Charlotte Borer','','144.00','0.00','144.00','10','154.00','0.00','154.00','0.00','11.41','10','2.00','30','Ferienpass \"Bilder und Figuren giessen\"','N',NULL,'','','2.50','8.00');
INSERT INTO AUFTRAG_PROTOKOLL VALUES ('21','2011-11-03','1021','0',NULL,'0',NULL,'0',NULL,'40016','2011-11-03','J','2011-12-08','917','917','917','z.H. Frau Pamuk','','145.70','14.80','130.90','0.00','130.90','0.00','13.70','0.00','1.01','10','2.00','30','Ware abgeholt am: 24.08.2011 und 13.09.2011','N',NULL,'','','2.50','8.00');
INSERT INTO AUFTRAG_PROTOKOLL VALUES ('22','2011-11-03','1022','0',NULL,'0',NULL,'0',NULL,'40017','2011-11-03','J','2011-12-08','918','918','918','z.H. Frau Kohler B.','Ware abgeholt am: 30.08.2011','70.85','6.35','64.50','0.00','64.50','0.00','64.50','0.00','4.78','10','2.00','30','','N',NULL,'','','2.50','8.00');
INSERT INTO AUFTRAG_PROTOKOLL VALUES ('23','2011-11-30','1023','0',NULL,'0',NULL,'0',NULL,'40018','2011-11-30','J','2011-12-08','356','356','356','','','17.70','0.00','17.70','3.60','21.30','0.00','21.30','0.00','1.58','10','0.00','30','Telefonische Bestellung vom 30.November 2011','N',NULL,'','','2.50','8.00');
INSERT INTO AUFTRAG_PROTOKOLL VALUES ('24',NULL,'1024',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'N',NULL,NULL,NULL,NULL,NULL);
INSERT INTO AUFTRAG_PROTOKOLL VALUES ('25',NULL,'1025',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'N',NULL,NULL,NULL,NULL,NULL);
INSERT INTO AUFTRAG_PROTOKOLL VALUES ('26',NULL,'1026',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'N',NULL,NULL,NULL,NULL,NULL);
INSERT INTO AUFTRAG_PROTOKOLL VALUES ('27',NULL,'1027',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'N',NULL,NULL,NULL,NULL,NULL);
INSERT INTO AUFTRAG_PROTOKOLL VALUES ('28',NULL,'1028',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'N',NULL,NULL,NULL,NULL,NULL);
INSERT INTO AUFTRAG_PROTOKOLL VALUES ('29','2011-12-01','1029','0',NULL,'0',NULL,'0',NULL,'40019','2011-12-01','J','2012-01-13','919','919','919','z.H. Frau Zeltner','','252.75','25.35','227.40','0.00','227.40','0.00','227.40','0.00','16.84','10','2.00','30','Ware abgeholt am: 1.Okt, 23.Nov. / Retouren am: 30.11. (Ware mit Rckgaberecht)','N',NULL,'','','2.50','8.00');
INSERT INTO AUFTRAG_PROTOKOLL VALUES ('30','2011-12-02','1030','0',NULL,'0',NULL,'0',NULL,'40020','2011-12-02','J','2011-12-29','502','502','502','Frau Rickli','','87.30','8.70','78.60','0.00','78.60','0.00','78.60','0.00','5.82','10','2.00','30','Lieferschein vom 1. Dezember 2011','N',NULL,'','','2.50','8.00');
INSERT INTO AUFTRAG_PROTOKOLL VALUES ('31','2011-12-03','1031','0',NULL,'0',NULL,'0',NULL,'40021','2011-12-03','J','2012-01-10','920','920','920','Frau Jggi','','6.90','0.00','6.90','6.00','12.90','0.00','12.90','0.00','0.96','10','2.00','30','Nachlieferung','N',NULL,'','','2.50','8.00');
INSERT INTO AUFTRAG_PROTOKOLL VALUES ('32','2011-12-14','1032','0',NULL,'0',NULL,'0',NULL,'40022','2011-12-14','J','2012-01-13','921','921','921','z.H. Frau Emch M.','','34.50','3.45','31.05','0.00','31.05','0.00','31.05','0.00','2.30','10','2.00','30','Ware abgeholt am: 14.12.2011','N',NULL,'','','2.50','8.00');
INSERT INTO AUFTRAG_PROTOKOLL VALUES ('33','2012-03-24','1033','0',NULL,'0',NULL,'0',NULL,'40023','2012-03-24','J','2012-05-04','921','921','921','Frau Emch','','112.60','11.30','101.30','0.00','101.30','0.00','101.30','0.00','7.50','10','2.00','30','Lieferschein vom 23.02.2012 Ware abgeholt von Frau Emch\r\nLieferschein vom 17.03.2012 Ware abgeholt von Frau Emch','N',NULL,'','','2.50','8.00');
INSERT INTO AUFTRAG_PROTOKOLL VALUES ('34','2012-05-15','1034','0',NULL,'0',NULL,'0',NULL,'40024','2012-05-15','N',NULL,'921','921','921','Frau Emch Michaela','','188.40','18.90','169.50','0.00','169.50','0.00','169.50','0.00','12.56','10','2.00','30','Lieferschein vom 09.05.2012','N',NULL,'','','2.50','8.00');
INSERT INTO AUFTRAG_PROTOKOLL VALUES ('35','2012-05-15','1035','0',NULL,'0',NULL,'0',NULL,'40025','2012-05-15','J','2012-06-13','918','918','918','Frau Kohler','','18.50','1.85','16.65','0.00','16.65','0.00','16.65','0.00','1.23','10','2.00','30','Lieferschein vom 15.04.2012','N',NULL,'','','2.50','8.00');
INSERT INTO AUFTRAG_PROTOKOLL VALUES ('36','2012-05-15','1036','0',NULL,'0',NULL,'0',NULL,'40026','2012-05-15','J','2012-06-08','579','579','579','Frau B. Flury','','127.60','9.75','117.85','0.00','117.85','0.00','117.85','0.00','8.73','10','2.00','30','Lieferschein vom 20.04.2012','N',NULL,'','','2.50','8.00');
INSERT INTO AUFTRAG_PROTOKOLL VALUES ('37','2012-05-15','1037','0',NULL,'0',NULL,'0',NULL,'40027','2012-05-15','N',NULL,'922','922','922','Freudiger Lukas','','39.80','4.00','35.80','0.00','35.80','0.00','35.80','0.00','2.65','10','2.00','30','Lieferschein vom 20.04.2012\r\n                    vom 21.04.2012','N',NULL,'','','2.50','8.00');



#
# TABLE 'AUFTRAGSBESTAETIGUNG_EINZELBUCHUNG'
#
drop table if exists `AUFTRAGSBESTAETIGUNG_EINZELBUCHUNG`;

create table `AUFTRAGSBESTAETIGUNG_EINZELBUCHUNG` (
  `ID` int(10) Not Null auto_increment,
  `BELEGNR` varchar(10),
  `ANZAHL` varchar(6),
  `ARTIKEL_ID` int(7),
  `ARTNR` varchar(10),
  `BEZEICHNUNG` varchar(60),
  `BRUTTO` varchar(10),
  `RABATT` varchar(10),
  `VERKAUFSPREIS` varchar(10),
  `MWST_SATZ` varchar(6),
  `GELOESCHT` enum('J','N') Default 'N' Not Null,
  `GELOESCHT_VON` varchar(5),
  PRIMARY KEY (ID),
  UNIQUE KEY ID (ID)
);


#
# TABLE 'AUFTRAGSBESTAETIGUNG_PROTOKOLL'
#
drop table if exists `AUFTRAGSBESTAETIGUNG_PROTOKOLL`;

create table `AUFTRAGSBESTAETIGUNG_PROTOKOLL` (
  `ID` int(10) Not Null auto_increment,
  `BELEGNR` varchar(10),
  `BELEGNR_AUFTRAG` varchar(10),
  `DATUM` date,
  `DEBITORNR_RE` int(10),
  `DEBITORNR_WE` int(10),
  `DEBITORNR_AG` int(11),
  `KONTAKTPERSON` varchar(20),
  `KOMMISSION` varchar(40),
  `BRUTTO` varchar(10),
  `RABATT` varchar(10),
  `VERKAUFSPREIS` varchar(10),
  `PORTO` varchar(10),
  `BRUTTOKREDIT` varchar(10),
  `BK_BASIS_MWST1` varchar(10),
  `BK_BASIS_MWST2` varchar(10),
  `BK_MWST1` varchar(10),
  `BK_MWST2` varchar(10),
  `ZAHLUNGSZIEL` int(3),
  `SKONTO_PROZENT` decimal(5,2),
  `SKONTO_TAGE` varchar(2),
  `BEMERKUNGEN` blob,
  `GELOESCHT` enum('N','J'),
  `GELOESCHT_DATUM` date,
  `GELOESCHT_VON` varchar(5),
  `GELOESCHT_GRUND` blob,
  `MWST1_SATZ` varchar(10),
  `MWST2_SATZ` varchar(10),
  PRIMARY KEY (ID),
  UNIQUE KEY Rechnung_ID (ID)
);


#
# TABLE 'BANK'
#
drop table if exists `BANK`;

create table `BANK` (
  `BANK_ID` int(8) Not Null auto_increment,
  `BLZ` int(8) Default '0' Not Null,
  `BANK_NAME` varchar(30) Not Null,
  `BIC` varchar(11),
  `PLZ_ID` int(11) Default '0' Not Null,
  `LAENDERCODE` char(3),
  `PRUEFZIFFER` int(3),
  `GELOESCHT` enum('J','N') Default 'N',
  PRIMARY KEY (BANK_ID)
);


#
# TABLE 'BENUTZERGRUPPEN'
#
drop table if exists `BENUTZERGRUPPEN`;

create table `BENUTZERGRUPPEN` (
  `BENUTZERGRUPPE_ID` int(11) Not Null auto_increment,
  `BENUTZERGRUPPE` char(20),
  `GELOESCHT` enum('J','N'),
  PRIMARY KEY (BENUTZERGRUPPE_ID),
  UNIQUE KEY Benutzergruppen_ID (BENUTZERGRUPPE_ID)
);


#
# TABLE 'BENUTZERGRUPPEN' DATA
#
INSERT INTO BENUTZERGRUPPEN VALUES ('1','','N');
INSERT INTO BENUTZERGRUPPEN VALUES ('2','Hauptadministrator','N');
INSERT INTO BENUTZERGRUPPEN VALUES ('3','Administrator','J');
INSERT INTO BENUTZERGRUPPEN VALUES ('4','Verkauf','J');



#
# TABLE 'BR_VERKAUF'
#
drop table if exists `BR_VERKAUF`;

create table `BR_VERKAUF` (
  `BR_VERKAUF_ID` int(11) Not Null auto_increment,
  `MITARBEITER_ID` int(5) Default '0' Not Null,
  `ZUGRIFF` enum('J','N') Default 'N' Not Null,
  `MAX_RABATT_PROZENT` decimal(5,2) Default '0.00' Not Null,
  `MAX_SKONTO_TAG` int(3) Default '0' Not Null,
  `MAX_SKONTO_PROZENT` decimal(5,2) Default '0.00' Not Null,
  `MAX_ZAHLUNGSZIEL` int(3) Default '0' Not Null,
  PRIMARY KEY (BR_VERKAUF_ID),
  UNIQUE KEY BR_Verkauf_ID (BR_VERKAUF_ID)
);


#
# TABLE 'BR_VERKAUF' DATA
#
INSERT INTO BR_VERKAUF VALUES ('1','1','J','100','90','100','100');
INSERT INTO BR_VERKAUF VALUES ('2','2','J','99','60','10','90');



#
# TABLE 'DEBITOREN'
#
drop table if exists `DEBITOREN`;

create table `DEBITOREN` (
  `DEBITOR_ID` int(10) Not Null auto_increment,
  `DEBITOR_SHOP_ID` int(11) Default '-1' Not Null,
  `DEBITORNR` int(10) Default '0' Not Null,
  `KONTAKTDATEN_ID` int(10) Default '0' Not Null,
  `DEBITORNR_WE` int(10) Default '0' Not Null,
  `DEBITORNR_RE` int(10) Default '0' Not Null,
  `DEBITOR_SEIT` date Default '0000-00-00',
  `SKONTO_TAGE` int(2),
  `SKONTO_PROZENT` decimal(5,2) Default '0.00',
  `ZAHLUNGSZIEL` int(3),
  `KREDITLIMIT` decimal(6,2),
  `PORTOFREI` enum('J','N') Default 'N' Not Null,
  `RABATT_PROZENT` decimal(5,2) Default '0.00',
  `MAHNSPERRE` enum('J','N') Default 'N' Not Null,
  `LIEFERSPERRE` enum('J','N') Default 'N' Not Null,
  `RECHNUNGSSPERRE` enum('J','N') Default 'N' Not Null,
  `WERBUNG_BRIEF` enum('J','N') Default 'N' Not Null,
  `WERBUNG_EMAIL` enum('J','N') Default 'N' Not Null,
  `DEBITOREN_GRUPPE_ID` int(3) Default '0' Not Null,
  `PASSWORT` varchar(32),
  `GELOESCHT` enum('J','N') Default 'N' Not Null,
  `ANMERKUNGEN` blob,
  `KURSPROGRAMM` enum('J','N') Default 'J',
  `WERBESTUFE` char(2),
  `FOTO` longblob,
  PRIMARY KEY (DEBITOR_ID),
  UNIQUE KEY DEBITOR_ID (DEBITOR_ID)
);


#
# TABLE 'DEBITOREN' DATA
#
INSERT INTO DEBITOREN VALUES ('1','-1','100','1','1','1','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','2',NULL);
INSERT INTO DEBITOREN VALUES ('2','-1','101','2','2','2','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('3','-1','102','3','3','3','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('4','-1','103','4','4','4','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('5','-1','104','5','5','5','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('6','-1','105','6','6','6','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('7','-1','106','7','7','7','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('8','-1','107','8','8','8','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('9','-1','108','9','9','9','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('10','-1','109','10','10','10','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('11','-1','110','11','11','11','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('12','-1','111','12','12','12','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('13','-1','112','13','13','13','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('14','-1','113','14','14','14','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('15','-1','114','15','15','15','2001-01-10','10','2','30','500','N','10','N','N','N','J','J','1',NULL,'N','','J','3',NULL);
INSERT INTO DEBITOREN VALUES ('16','-1','115','16','16','16','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('17','-1','116','17','17','17','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('18','-1','117','18','18','18','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('19','-1','118','19','19','19','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('20','-1','119','20','20','20','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('21','-1','120','21','21','21','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('22','-1','121','22','22','22','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('23','-1','122','23','23','23','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('24','-1','123','24','24','24','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('25','-1','124','25','25','25','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('26','-1','125','26','26','26','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('27','-1','126','27','27','27','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('28','-1','127','28','28','28','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','3',NULL);
INSERT INTO DEBITOREN VALUES ('29','-1','128','29','29','29','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('30','-1','129','30','30','30','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('31','-1','130','31','31','31','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('32','-1','131','32','32','32','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('33','-1','132','33','33','33','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('34','-1','133','34','34','34','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('35','-1','134','35','35','35','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('36','-1','135','36','36','36','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('37','-1','136','37','37','37','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('38','-1','137','38','137','137','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'J','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('39','-1','138','39','39','39','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('40','-1','139','40','40','40','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('41','-1','140','41','41','41','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('42','-1','141','42','42','42','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('43','-1','142','43','43','43','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('44','-1','143','44','44','44','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('45','-1','144','45','45','45','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('46','-1','145','46','46','46','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('47','-1','146','47','47','47','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('48','-1','147','48','48','48','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('49','-1','148','49','49','49','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('50','-1','149','50','50','50','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('51','-1','150','51','51','51','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('52','-1','151','52','52','52','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('53','-1','152','53','53','53','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('54','-1','153','54','54','54','2001-01-10','10','2','30','500','N','10','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('55','-1','154','55','55','55','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('56','-1','155','56','56','56','2001-01-10','10','2','30','500','N','10','N','N','N','J','J','1',NULL,'N','','J','3',NULL);
INSERT INTO DEBITOREN VALUES ('57','-1','156','57','57','57','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('58','-1','157','58','58','58','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('59','-1','158','59','59','59','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('60','-1','159','60','60','60','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('61','-1','160','61','61','61','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('62','-1','161','62','62','62','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('63','-1','162','63','63','63','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('64','-1','163','64','64','64','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('65','-1','164','65','65','65','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('66','-1','165','66','66','66','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','3',NULL);
INSERT INTO DEBITOREN VALUES ('67','-1','166','67','67','67','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','3',NULL);
INSERT INTO DEBITOREN VALUES ('68','-1','167','68','68','68','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('69','-1','168','69','69','69','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('70','-1','169','70','70','70','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('71','-1','170','71','170','170','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'J','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('72','-1','171','72','72','72','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('73','-1','172','73','73','73','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('74','-1','173','74','74','74','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('75','-1','174','75','75','75','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('76','-1','175','76','76','76','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('77','-1','176','77','77','77','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('78','-1','177','78','78','78','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('79','-1','178','79','79','79','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('80','-1','179','80','80','80','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('81','-1','180','81','81','81','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('82','-1','181','82','82','82','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('83','-1','182','83','83','83','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('84','-1','183','84','84','84','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('85','-1','184','85','85','85','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('86','-1','185','86','86','86','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('87','-1','186','87','87','87','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('88','-1','187','88','88','88','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('89','-1','188','89','89','89','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('90','-1','189','90','90','90','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('91','-1','190','91','91','91','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('92','-1','191','92','92','92','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('93','-1','192','93','93','93','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('94','-1','193','94','94','94','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('95','-1','194','95','95','95','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('96','-1','195','96','96','96','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('97','-1','196','97','97','97','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('98','-1','197','98','98','98','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('99','-1','198','99','99','99','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('100','-1','199','100','100','100','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('101','-1','200','101','101','101','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('102','-1','201','102','102','102','2001-01-10','10','2','30','500','N','10','N','N','N','J','J','1',NULL,'N','','J','2',NULL);
INSERT INTO DEBITOREN VALUES ('103','-1','202','103','103','103','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('104','-1','203','104','104','104','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('105','-1','204','105','105','105','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('106','-1','205','106','106','106','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('107','-1','206','107','107','107','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('108','-1','207','108','207','207','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'J','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('109','-1','208','109','109','109','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('110','-1','209','110','110','110','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('111','-1','210','111','111','111','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('112','-1','211','112','112','112','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('113','-1','212','113','113','113','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('114','-1','213','114','114','114','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('115','-1','214','115','115','115','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('116','-1','215','116','116','116','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('117','-1','216','117','117','117','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('118','-1','217','118','118','118','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('119','-1','218','119','119','119','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('120','-1','219','120','120','120','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('121','-1','220','121','121','121','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('122','-1','221','122','122','122','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','3',NULL);
INSERT INTO DEBITOREN VALUES ('123','-1','222','123','123','123','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('124','-1','223','124','124','124','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('125','-1','224','125','224','224','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'J','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('126','-1','225','126','126','126','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('127','-1','226','127','127','127','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('128','-1','227','128','128','128','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('129','-1','228','129','129','129','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','3',NULL);
INSERT INTO DEBITOREN VALUES ('130','-1','229','130','130','130','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('131','-1','230','131','131','131','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('132','-1','231','132','132','132','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('133','-1','232','133','133','133','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('134','-1','233','134','134','134','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('135','-1','234','135','135','135','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('136','-1','235','136','136','136','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('137','-1','236','137','137','137','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('138','-1','237','138','138','138','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('139','-1','238','139','139','139','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('140','-1','239','140','140','140','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('141','-1','240','141','141','141','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('142','-1','241','142','142','142','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','3',NULL);
INSERT INTO DEBITOREN VALUES ('143','-1','242','143','143','143','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('144','-1','243','144','144','144','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('145','-1','244','145','145','145','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('146','-1','245','146','146','146','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('147','-1','246','147','147','147','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','2',NULL);
INSERT INTO DEBITOREN VALUES ('148','-1','247','148','148','148','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('149','-1','248','149','149','149','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('150','-1','249','150','150','150','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('151','-1','250','151','250','250','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'J','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('152','-1','251','152','152','152','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('153','-1','252','153','153','153','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('154','-1','253','154','154','154','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('155','-1','254','155','155','155','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('156','-1','255','156','255','255','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'J','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('157','-1','256','157','157','157','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('158','-1','257','158','158','158','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('159','-1','258','159','159','159','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('160','-1','259','160','160','160','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('161','-1','260','161','161','161','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('162','-1','261','162','162','162','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('163','-1','262','163','163','163','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('164','-1','263','164','164','164','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('165','-1','264','165','165','165','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('166','-1','265','166','166','166','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('167','-1','266','167','167','167','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('168','-1','267','168','168','168','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('169','-1','268','169','169','169','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('170','-1','269','170','170','170','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('171','-1','270','171','171','171','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('172','-1','271','172','172','172','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('173','-1','272','173','173','173','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('174','-1','273','174','174','174','2001-01-10','10','2','30','500','N','10','N','N','N','J','J','1',NULL,'N','','J','3',NULL);
INSERT INTO DEBITOREN VALUES ('175','-1','274','175','175','175','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','3',NULL);
INSERT INTO DEBITOREN VALUES ('176','-1','275','176','176','176','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','3',NULL);
INSERT INTO DEBITOREN VALUES ('177','-1','276','177','177','177','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('178','-1','277','178','277','277','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'J','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('179','-1','278','179','179','179','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('180','-1','279','180','180','180','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('181','-1','280','181','181','181','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('182','-1','281','182','182','182','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('183','-1','282','183','183','183','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('184','-1','283','184','283','283','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'J','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('185','-1','284','185','185','185','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('186','-1','285','186','186','186','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','3',NULL);
INSERT INTO DEBITOREN VALUES ('187','-1','286','187','187','187','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('188','-1','287','188','188','188','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('189','-1','288','189','189','189','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('190','-1','289','190','190','190','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('191','-1','290','191','191','191','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('192','-1','291','192','291','291','2001-01-10','10','2','30','500','N','10','N','N','N','J','J','1',NULL,'J','','J','3',NULL);
INSERT INTO DEBITOREN VALUES ('193','-1','292','193','193','193','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('194','-1','293','194','194','194','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('195','-1','294','195','195','195','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('196','-1','295','196','196','196','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('197','-1','296','197','197','197','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('198','-1','297','198','198','198','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('199','-1','298','199','199','199','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','2',NULL);
INSERT INTO DEBITOREN VALUES ('200','-1','299','200','200','200','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('201','-1','300','201','201','201','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('202','-1','301','202','202','202','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('203','-1','302','203','203','203','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('204','-1','303','204','303','303','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'J','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('205','-1','304','205','304','304','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'J','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('206','-1','305','206','206','206','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('207','-1','306','207','207','207','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('208','-1','307','208','307','307','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'J','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('209','-1','308','209','209','209','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('210','-1','309','210','210','210','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('211','-1','310','211','211','211','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('212','-1','311','212','212','212','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('213','-1','312','213','213','213','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('214','-1','313','214','214','214','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('215','-1','314','215','215','215','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('216','-1','315','216','216','216','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('217','-1','316','217','217','217','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('218','-1','317','218','218','218','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('219','-1','318','219','219','219','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('220','-1','319','220','319','319','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'J','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('221','-1','320','221','221','221','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('222','-1','321','222','222','222','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('223','-1','322','223','322','322','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'J','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('224','-1','323','224','224','224','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('225','-1','324','225','225','225','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','3',NULL);
INSERT INTO DEBITOREN VALUES ('226','-1','325','226','226','226','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('227','-1','326','227','227','227','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('228','-1','327','228','228','228','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('229','-1','328','229','229','229','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('230','-1','329','230','230','230','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('231','-1','330','231','231','231','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('232','-1','331','232','232','232','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('233','-1','332','233','332','332','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'J','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('234','-1','333','234','333','333','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'J','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('235','-1','334','235','334','334','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'J','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('236','-1','335','236','236','236','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('237','-1','336','237','237','237','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('238','-1','337','238','238','238','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('239','-1','338','239','239','239','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('240','-1','339','240','240','240','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('241','-1','340','241','241','241','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('242','-1','341','242','242','242','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','2',NULL);
INSERT INTO DEBITOREN VALUES ('243','-1','342','243','243','243','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','2',NULL);
INSERT INTO DEBITOREN VALUES ('244','-1','343','244','244','244','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','3',NULL);
INSERT INTO DEBITOREN VALUES ('245','-1','344','245','245','245','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('246','-1','345','246','246','246','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('247','-1','346','247','247','247','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('248','-1','347','248','248','248','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('249','-1','348','249','249','249','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('250','-1','349','250','250','250','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','2',NULL);
INSERT INTO DEBITOREN VALUES ('251','-1','350','251','251','251','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('252','-1','351','252','252','252','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('253','-1','352','253','253','253','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('254','-1','353','254','254','254','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('255','-1','354','255','255','255','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('256','-1','355','256','256','256','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','2',NULL);
INSERT INTO DEBITOREN VALUES ('257','-1','356','257','257','257','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('258','-1','357','258','258','258','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('259','-1','358','259','259','259','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('260','-1','359','260','260','260','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('261','-1','360','261','261','261','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('262','-1','361','262','262','262','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('263','-1','362','263','263','263','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','2',NULL);
INSERT INTO DEBITOREN VALUES ('264','-1','363','264','264','264','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','2',NULL);
INSERT INTO DEBITOREN VALUES ('265','-1','364','265','364','364','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'J','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('266','-1','365','266','266','266','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('267','-1','366','267','267','267','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('268','-1','367','268','367','367','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'J','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('269','-1','368','269','269','269','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('270','-1','369','270','369','369','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('271','-1','370','271','271','271','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('272','-1','371','272','272','272','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('273','-1','372','273','273','273','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('274','-1','373','274','373','373','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'J','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('275','-1','374','275','275','275','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('276','-1','375','276','375','375','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'J','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('277','-1','376','277','376','376','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'J','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('278','-1','377','278','278','278','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','3',NULL);
INSERT INTO DEBITOREN VALUES ('279','-1','378','279','279','279','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('280','-1','379','280','280','280','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('281','-1','380','281','281','281','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('282','-1','381','282','282','282','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('283','-1','382','283','283','283','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('284','-1','383','284','284','284','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('285','-1','384','285','285','285','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('286','-1','385','286','286','286','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('287','-1','386','287','287','287','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('288','-1','387','288','288','288','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('289','-1','388','289','289','289','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('290','-1','389','290','290','290','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('291','-1','390','291','291','291','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('292','-1','391','292','292','292','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('293','-1','392','293','293','293','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('294','-1','393','294','294','294','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('295','-1','394','295','295','295','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','3',NULL);
INSERT INTO DEBITOREN VALUES ('296','-1','395','296','296','296','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('297','-1','396','297','297','297','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('298','-1','397','298','298','298','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','3',NULL);
INSERT INTO DEBITOREN VALUES ('299','-1','398','299','299','299','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('300','-1','399','300','300','300','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('301','-1','400','301','301','301','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('302','-1','401','302','302','302','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('303','-1','402','303','303','303','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('304','-1','403','304','304','304','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('305','-1','404','305','305','305','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('306','-1','405','306','306','306','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('307','-1','406','307','307','307','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('308','-1','407','308','308','308','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('309','-1','408','309','309','309','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('310','-1','409','310','310','310','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('311','-1','410','311','311','311','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('312','-1','411','312','312','312','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('313','-1','412','313','313','313','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('314','-1','413','314','314','314','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('315','-1','414','315','315','315','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('316','-1','415','316','316','316','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('317','-1','416','317','317','317','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','3',NULL);
INSERT INTO DEBITOREN VALUES ('318','-1','417','318','318','318','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('319','-1','418','319','319','319','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('320','-1','419','320','320','320','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('321','-1','420','321','321','321','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('322','-1','421','322','322','322','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('323','-1','422','323','323','323','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('324','-1','423','324','324','324','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('325','-1','424','325','325','325','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('326','-1','425','326','326','326','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('327','-1','426','327','327','327','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('328','-1','427','328','328','328','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('329','-1','428','329','329','329','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('330','-1','429','330','330','330','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('331','-1','430','331','331','331','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','2',NULL);
INSERT INTO DEBITOREN VALUES ('332','-1','431','332','332','332','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('333','-1','432','333','333','333','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('334','-1','433','334','334','334','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('335','-1','434','335','335','335','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('336','-1','435','336','336','336','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('337','-1','436','337','337','337','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('338','-1','437','338','338','338','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('339','-1','438','339','339','339','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('340','-1','439','340','340','340','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('341','-1','440','341','341','341','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('342','-1','441','342','342','342','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('343','-1','442','343','343','343','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('344','-1','443','344','344','344','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('345','-1','444','345','345','345','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('346','-1','445','346','346','346','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('347','-1','446','347','347','347','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('348','-1','447','348','447','447','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'J','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('349','-1','448','349','349','349','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('350','-1','449','350','350','350','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('351','-1','450','351','351','351','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('352','-1','451','352','352','352','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('353','-1','452','353','353','353','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('354','-1','453','354','354','354','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('355','-1','454','355','355','355','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('356','-1','455','356','356','356','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('357','-1','456','357','357','357','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('358','-1','457','358','358','358','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('359','-1','458','359','359','359','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('360','-1','459','360','360','360','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('361','-1','460','361','361','361','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('362','-1','461','362','362','362','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('363','-1','462','363','363','363','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('364','-1','463','364','364','364','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('365','-1','464','365','365','365','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('366','-1','465','366','366','366','2001-01-10','10','2','30','500','N','0','N','N','N','N','N','1',NULL,'N','','N','1',NULL);
INSERT INTO DEBITOREN VALUES ('367','-1','466','367','367','367','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('368','-1','467','368','368','368','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('369','-1','468','369','369','369','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('370','-1','469','370','370','370','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','2',NULL);
INSERT INTO DEBITOREN VALUES ('371','-1','470','371','371','371','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('372','-1','471','372','372','372','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('373','-1','472','373','373','373','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('374','-1','473','374','374','374','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('375','-1','474','375','375','375','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('376','-1','475','376','376','376','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('377','-1','476','377','377','377','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('378','-1','477','378','378','378','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('379','-1','478','379','379','379','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('380','-1','479','380','380','380','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('381','-1','480','381','381','381','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('382','-1','481','382','382','382','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('383','-1','482','383','383','383','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('384','-1','483','384','384','384','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('385','-1','484','385','385','385','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('386','-1','485','386','386','386','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('387','-1','486','387','387','387','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('388','-1','487','388','388','388','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('389','-1','488','389','389','389','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('390','-1','489','390','390','390','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('391','-1','490','391','391','391','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('392','-1','491','392','392','392','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('393','-1','492','393','393','393','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('394','-1','493','394','394','394','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('395','-1','494','395','395','395','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('396','-1','495','396','396','396','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('397','-1','496','397','397','397','2001-01-10','10','2','30','500','N','10','N','N','N','J','J','1',NULL,'N','','J','2',NULL);
INSERT INTO DEBITOREN VALUES ('398','-1','497','398','398','398','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','2',NULL);
INSERT INTO DEBITOREN VALUES ('399','-1','498','399','399','399','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','2',NULL);
INSERT INTO DEBITOREN VALUES ('400','-1','499','400','400','400','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','2',NULL);
INSERT INTO DEBITOREN VALUES ('401','-1','500','401','401','401','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('402','-1','501','402','402','402','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','2',NULL);
INSERT INTO DEBITOREN VALUES ('403','-1','502','403','403','403','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','2',NULL);
INSERT INTO DEBITOREN VALUES ('404','-1','503','404','404','404','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('405','-1','504','405','405','405','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('406','-1','505','406','406','406','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('407','-1','506','407','407','407','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('408','-1','507','408','408','408','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('409','-1','508','409','409','409','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('410','-1','509','410','410','410','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('411','-1','510','411','411','411','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('412','-1','511','412','412','412','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('413','-1','512','413','413','413','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('414','-1','513','414','414','414','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('415','-1','514','415','415','415','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('416','-1','515','416','416','416','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('417','-1','516','417','516','516','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'J','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('418','-1','517','418','418','418','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('419','-1','518','419','419','419','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('420','-1','519','420','420','420','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('421','-1','520','421','421','421','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('422','-1','521','422','422','422','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','2',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('423','-1','522','423','423','423','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('424','-1','523','424','424','424','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('425','-1','524','425','425','425','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('426','-1','525','426','426','426','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('427','-1','526','427','427','427','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('428','-1','527','428','428','428','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('429','-1','528','429','429','429','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('430','-1','529','430','430','430','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('431','-1','530','431','431','431','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('432','-1','531','432','531','531','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'J','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('433','-1','532','433','433','433','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('434','-1','533','434','434','434','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('435','-1','534','435','435','435','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('436','-1','535','436','436','436','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','2',NULL);
INSERT INTO DEBITOREN VALUES ('437','-1','536','437','437','437','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('438','-1','537','438','438','438','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('439','-1','538','439','439','439','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('440','-1','539','440','440','440','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('441','-1','540','441','441','441','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('442','-1','541','442','442','442','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('443','-1','542','443','443','443','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('444','-1','543','444','444','444','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('445','-1','544','445','445','445','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('446','-1','545','446','446','446','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('447','-1','546','447','447','447','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('448','-1','547','448','448','448','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('449','-1','548','449','449','449','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('450','-1','549','450','450','450','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('451','-1','550','451','451','451','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('452','-1','551','452','551','551','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'J','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('453','-1','552','453','453','453','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('454','-1','553','454','454','454','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('455','-1','554','455','455','455','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','2',NULL);
INSERT INTO DEBITOREN VALUES ('456','-1','555','456','456','456','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('457','-1','556','457','457','457','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('458','-1','557','458','557','557','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'J','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('459','-1','558','459','459','459','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('460','-1','559','460','460','460','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('461','-1','560','461','461','461','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('462','-1','561','462','462','462','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('463','-1','562','463','562','562','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'J','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('464','-1','563','464','464','464','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('465','-1','564','465','564','564','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'J','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('466','-1','565','466','466','466','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('467','-1','566','467','467','467','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('468','-1','567','468','468','468','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','2',NULL);
INSERT INTO DEBITOREN VALUES ('469','-1','568','469','469','469','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('470','-1','569','470','569','569','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'J','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('471','-1','570','471','471','471','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('472','-1','571','472','472','472','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','2',NULL);
INSERT INTO DEBITOREN VALUES ('473','-1','572','473','572','572','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'J','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('474','-1','573','474','474','474','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('475','-1','574','475','475','475','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','2',NULL);
INSERT INTO DEBITOREN VALUES ('476','-1','575','476','575','575','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'J','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('477','-1','576','477','477','477','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('478','-1','577','478','478','478','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('479','-1','578','479','479','479','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('480','-1','579','480','480','480','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','2',NULL);
INSERT INTO DEBITOREN VALUES ('481','-1','580','481','580','580','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'J','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('482','-1','581','482','581','581','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'J','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('483','-1','582','483','483','483','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('484','-1','583','484','484','484','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('485','-1','584','485','584','584','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'J','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('486','-1','585','486','486','486','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('487','-1','586','487','586','586','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'J','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('488','-1','587','488','488','488','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','2',NULL);
INSERT INTO DEBITOREN VALUES ('489','-1','588','489','489','489','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('490','-1','589','490','490','490','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('491','-1','590','491','590','590','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'J','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('492','-1','591','492','492','492','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('493','-1','592','493','592','592','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'J','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('494','-1','593','494','494','494','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('495','-1','594','495','495','495','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('496','-1','595','496','496','496','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('497','-1','596','497','497','497','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('498','-1','597','498','498','498','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('499','-1','598','499','598','598','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'J','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('500','-1','599','500','500','500','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('501','-1','600','501','501','501','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('502','-1','601','502','502','502','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('503','-1','602','503','503','503','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('504','-1','603','504','603','603','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'J','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('505','-1','604','505','604','604','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'J','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('506','-1','605','506','605','605','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'J','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('507','-1','606','507','507','507','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('508','-1','607','508','607','607','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'J','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('509','-1','608','509','509','509','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('510','-1','609','510','510','510','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('511','-1','610','511','511','511','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('512','-1','611','512','512','512','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('513','-1','612','513','513','513','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('514','-1','613','514','514','514','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('515','-1','614','515','515','515','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('516','-1','615','516','516','516','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('517','-1','616','517','517','517','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('518','-1','617','518','518','518','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('519','-1','618','519','519','519','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('520','-1','619','520','520','520','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('521','-1','620','521','521','521','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('522','-1','621','522','522','522','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('523','-1','622','523','523','523','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('524','-1','623','524','524','524','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('525','-1','624','525','525','525','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('526','-1','625','526','526','526','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('527','-1','626','527','527','527','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('528','-1','627','528','528','528','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('529','-1','628','529','529','529','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('530','-1','629','530','530','530','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('531','-1','630','531','531','531','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('532','-1','631','532','532','532','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('533','-1','632','533','533','533','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('534','-1','633','534','534','534','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('535','-1','634','535','535','535','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('536','-1','635','536','536','536','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('537','-1','636','537','537','537','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('538','-1','637','538','538','538','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('539','-1','638','539','539','539','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('540','-1','639','540','540','540','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('541','-1','640','541','541','541','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('542','-1','641','542','542','542','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('543','-1','642','543','543','543','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('544','-1','643','544','544','544','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('545','-1','644','545','545','545','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('546','-1','645','546','546','546','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('547','-1','646','547','547','547','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('548','-1','647','548','548','548','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('549','-1','648','549','549','549','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('550','-1','649','550','550','550','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('551','-1','650','551','551','551','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('552','-1','651','552','552','552','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('553','-1','652','553','553','553','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('554','-1','653','554','554','554','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('555','-1','654','555','555','555','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('556','-1','655','556','556','556','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('557','-1','656','557','557','557','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('558','-1','657','558','558','558','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('559','-1','658','559','559','559','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('560','-1','659','560','560','560','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('561','-1','660','561','561','561','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('562','-1','661','562','562','562','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('563','-1','662','563','563','563','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('564','-1','663','564','564','564','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('565','-1','664','565','565','565','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('566','-1','665','566','665','665','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'J','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('567','-1','666','567','567','567','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('568','-1','667','568','568','568','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('569','-1','668','569','569','569','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('570','-1','669','570','570','570','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('571','-1','670','571','571','571','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('572','-1','671','572','572','572','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('573','-1','672','573','573','573','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('574','-1','673','574','574','574','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('575','-1','674','575','575','575','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('576','-1','675','576','576','576','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('577','-1','676','577','577','577','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('578','-1','677','578','578','578','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('579','-1','678','579','579','579','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('580','-1','679','580','679','679','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'J','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('581','-1','680','581','581','581','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('582','-1','681','582','582','582','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('583','-1','682','583','682','682','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'J','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('584','-1','683','584','584','584','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('585','-1','684','585','585','585','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('586','-1','685','586','586','586','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('587','-1','686','587','587','587','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('588','-1','687','588','588','588','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('589','-1','688','589','589','589','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('590','-1','689','590','590','590','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('591','-1','690','591','591','591','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('592','-1','691','592','592','592','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('593','-1','692','593','593','593','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('594','-1','693','594','594','594','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('595','-1','694','595','595','595','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('596','-1','695','596','596','596','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('597','-1','696','597','597','597','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('598','-1','697','598','598','598','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('599','-1','698','599','599','599','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('600','-1','699','600','600','600','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('601','-1','700','601','601','601','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('602','-1','701','602','602','602','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','2',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('603','-1','702','603','603','603','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('604','-1','703','604','604','604','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('605','-1','704','605','605','605','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('606','-1','705','606','606','606','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('607','-1','706','607','607','607','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('608','-1','707','608','608','608','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('609','-1','708','609','609','609','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('610','-1','709','610','610','610','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('611','-1','710','611','611','611','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('612','-1','711','612','711','711','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'J','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('613','-1','712','613','613','613','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('614','-1','713','614','614','614','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('615','-1','714','615','615','615','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('616','-1','715','616','616','616','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('617','-1','716','617','716','716','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'J','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('618','-1','717','618','618','618','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('619','-1','718','619','619','619','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('620','-1','719','620','620','620','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('621','-1','720','621','621','621','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('622','-1','721','622','622','622','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('623','-1','722','623','623','623','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('624','-1','723','624','624','624','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('625','-1','724','625','625','625','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('626','-1','725','626','725','725','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'J','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('627','-1','726','627','627','627','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('628','-1','727','628','628','628','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('629','-1','728','629','728','728','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'J','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('630','-1','729','630','630','630','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('631','-1','730','631','631','631','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('632','-1','731','632','632','632','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('633','-1','732','633','633','633','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('634','-1','733','634','634','634','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('635','-1','734','635','635','635','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('636','-1','735','636','735','735','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'J','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('637','-1','736','637','637','637','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('638','-1','737','638','638','638','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('639','-1','738','639','639','639','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('640','-1','739','640','640','640','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('641','-1','740','641','641','641','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('642','-1','741','642','642','642','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('643','-1','742','643','643','643','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('644','-1','743','644','644','644','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('645','-1','744','645','645','645','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('646','-1','745','646','646','646','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('647','-1','746','647','647','647','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('648','-1','747','648','648','648','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('649','-1','748','649','649','649','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('650','-1','749','650','650','650','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('651','-1','750','651','651','651','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('652','-1','751','652','751','751','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'J','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('653','-1','752','653','653','653','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('654','-1','753','654','654','654','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('655','-1','754','655','655','655','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('656','-1','755','656','656','656','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('657','-1','756','657','657','657','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('658','-1','757','658','658','658','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('659','-1','758','659','659','659','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('660','-1','759','660','660','660','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('661','-1','760','661','760','760','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'J','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('662','-1','761','662','662','662','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('663','-1','762','663','663','663','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('664','-1','763','664','664','664','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('665','-1','764','665','665','665','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('666','-1','765','666','666','666','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('667','-1','766','667','667','667','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('668','-1','767','668','668','668','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('669','-1','768','669','669','669','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('670','-1','769','670','670','670','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('671','-1','770','671','671','671','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','2',NULL);
INSERT INTO DEBITOREN VALUES ('672','-1','771','672','672','672','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('673','-1','772','673','673','673','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('674','-1','773','674','674','674','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('675','-1','774','675','675','675','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('676','-1','775','676','676','676','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','2',NULL);
INSERT INTO DEBITOREN VALUES ('677','-1','776','677','677','677','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','2',NULL);
INSERT INTO DEBITOREN VALUES ('678','-1','777','678','678','678','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('679','-1','778','679','679','679','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('680','-1','779','680','680','680','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('681','-1','780','681','681','681','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('682','-1','781','682','682','682','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('683','-1','782','683','683','683','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('684','-1','783','684','684','684','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('685','-1','784','685','685','685','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('686','-1','785','686','686','686','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('687','-1','786','687','687','687','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('688','-1','787','688','688','688','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('689','-1','788','689','689','689','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('690','-1','789','690','690','690','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('691','-1','790','691','691','691','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('692','-1','791','692','692','692','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('693','-1','792','693','693','693','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('694','-1','793','694','694','694','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('695','-1','794','695','695','695','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('696','-1','795','696','696','696','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('697','-1','796','697','697','697','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('698','-1','797','698','698','698','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','2',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('699','-1','798','699','699','699','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','3',NULL,'N','','J','2',NULL);
INSERT INTO DEBITOREN VALUES ('700','-1','799','700','700','700','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','2',NULL);
INSERT INTO DEBITOREN VALUES ('701','-1','800','701','701','701','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('702','-1','801','702','702','702','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('703','-1','802','703','703','703','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('704','-1','803','704','704','704','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','Umzug Ausland','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('705','-1','804','705','705','705','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','2',NULL);
INSERT INTO DEBITOREN VALUES ('706','-1','805','706','706','706','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','2',NULL);
INSERT INTO DEBITOREN VALUES ('707','-1','806','707','707','707','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','2',NULL);
INSERT INTO DEBITOREN VALUES ('708','-1','807','708','708','708','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('709','-1','808','709','709','709','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('710','-1','809','710','710','710','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('711','-1','810','711','711','711','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('712','-1','811','712','712','712','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('713','-1','812','713','713','713','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('714','-1','813','714','714','714','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('715','-1','814','715','715','715','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('716','-1','815','716','716','716','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('717','-1','816','717','717','717','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('718','-1','817','718','718','718','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('719','-1','818','719','719','719','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('720','-1','819','720','720','720','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('721','-1','820','721','721','721','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('722','-1','821','722','722','722','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('723','-1','822','723','723','723','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('724','-1','823','724','724','724','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('725','-1','824','725','725','725','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','2',NULL);
INSERT INTO DEBITOREN VALUES ('726','-1','825','726','726','726','2001-01-10','10','2','30','500','N','0','N','N','N','N','N','1',NULL,'N','','N','1',NULL);
INSERT INTO DEBITOREN VALUES ('727','-1','826','727','727','727','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('728','-1','827','728','728','728','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','2',NULL);
INSERT INTO DEBITOREN VALUES ('729','-1','828','729','729','729','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('730','-1','829','730','730','730','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('731','-1','830','731','731','731','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','2',NULL);
INSERT INTO DEBITOREN VALUES ('732','-1','831','732','732','732','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','2',NULL);
INSERT INTO DEBITOREN VALUES ('733','-1','832','733','733','733','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','2',NULL);
INSERT INTO DEBITOREN VALUES ('734','-1','833','734','734','734','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','2',NULL);
INSERT INTO DEBITOREN VALUES ('735','-1','834','735','735','735','2001-01-10','10','2','30','500','N','10','N','N','N','J','J','1',NULL,'N','','J','2',NULL);
INSERT INTO DEBITOREN VALUES ('736','-1','835','736','736','736','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','2',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('737','-1','836','737','737','737','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('738','-1','837','738','738','738','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('739','-1','838','739','739','739','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('740','-1','839','740','740','740','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('741','-1','840','741','741','741','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('742','-1','841','742','742','742','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('743','-1','842','743','743','743','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('744','-1','843','744','744','744','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('745','-1','844','745','745','745','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('746','-1','845','746','746','746','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('747','-1','846','747','747','747','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','2',NULL);
INSERT INTO DEBITOREN VALUES ('748','-1','847','748','748','748','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','2',NULL);
INSERT INTO DEBITOREN VALUES ('749','-1','848','749','749','749','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('750','-1','849','750','750','750','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','2',NULL);
INSERT INTO DEBITOREN VALUES ('751','-1','850','751','751','751','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('752','-1','851','752','752','752','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('753','-1','852','753','753','753','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('754','-1','853','754','754','754','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('755','-1','854','755','755','755','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('756','-1','855','756','756','756','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('757','-1','856','757','757','757','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('758','-1','857','758','758','758','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('759','-1','858','759','759','759','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('760','-1','859','760','760','760','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('761','-1','860','761','761','761','2001-01-10','10','2','30','500','N','10','N','N','N','J','J','1',NULL,'N','','J','2',NULL);
INSERT INTO DEBITOREN VALUES ('762','-1','861','762','762','762','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('763','-1','862','763','763','763','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('764','-1','863','764','764','764','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('765','-1','864','765','765','765','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('766','-1','865','766','766','766','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('767','-1','866','767','767','767','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('768','-1','867','768','768','768','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('769','-1','868','769','769','769','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('770','-1','869','770','770','770','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('771','-1','870','771','771','771','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('772','-1','871','772','772','772','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('773','-1','872','773','773','773','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('774','-1','873','774','774','774','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('775','-1','874','775','775','775','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('776','-1','875','776','776','776','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('777','-1','876','777','777','777','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('778','-1','877','778','778','778','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('779','-1','878','779','779','779','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('780','-1','879','780','780','780','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('781','-1','880','781','781','781','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','2',NULL);
INSERT INTO DEBITOREN VALUES ('782','-1','881','782','782','782','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('783','-1','882','783','783','783','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('784','-1','883','784','784','784','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','2',NULL);
INSERT INTO DEBITOREN VALUES ('785','-1','884','785','785','785','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','2',NULL);
INSERT INTO DEBITOREN VALUES ('786','-1','885','786','786','786','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','2',NULL);
INSERT INTO DEBITOREN VALUES ('787','-1','886','787','787','787','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','2',NULL);
INSERT INTO DEBITOREN VALUES ('788','-1','887','788','788','788','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('789','-1','888','789','789','789','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('790','-1','889','790','790','790','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','2',NULL);
INSERT INTO DEBITOREN VALUES ('791','-1','890','791','791','791','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','2',NULL);
INSERT INTO DEBITOREN VALUES ('792','-1','891','792','792','792','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('793','-1','892','793','793','793','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('794','-1','893','794','794','794','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('795','-1','894','795','795','795','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('796','-1','895','796','796','796','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('797','-1','896','797','797','797','2001-01-10','10','2','30','500','N','10','N','N','N','J','N','1',NULL,'N','','J','2',NULL);
INSERT INTO DEBITOREN VALUES ('798','-1','897','798','798','798','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('799','-1','898','799','799','799','2001-01-10','10','2','30','500','N','25','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('800','-1','899','800','899','899','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('801','-1','900','801','801','801','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('802','-1','901','802','802','802','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','2',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('803','-1','902','803','803','803','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','2',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('804','-1','903','804','804','804','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('805','-1','904','805','805','805','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','3',NULL);
INSERT INTO DEBITOREN VALUES ('806','-1','905','806','806','806','2001-01-10','10','2','30','500','N','0','N','N','N','J','J','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('807','-1','906','807','807','807','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('808','-1','907','808','808','808','2001-01-10','10','2','30','500','N','10','N','N','N','J','J','1',NULL,'N','','J','2',NULL);
INSERT INTO DEBITOREN VALUES ('809','-1','908','809','809','809','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('810','-1','909','810','810','810','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','2',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('811','-1','910','811','811','811','2001-01-10','10','2','30','500','N','0','N','N','N','J','N','1',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('812','-1','911','812','911','911','2010-11-25','10','2','30','500','N','0','N','N','N','N','N','2',NULL,'N','','N','1',NULL);
INSERT INTO DEBITOREN VALUES ('813','-1','912','815','912','912','2011-05-05','10','2','30','500','N','10','N','N','N','N','N','2',NULL,'N','','N','1',NULL);
INSERT INTO DEBITOREN VALUES ('814','-1','913','816','913','913','2011-05-06','10','2','30','500','N','0','N','N','N','N','N','2',NULL,'N','','N','1',NULL);
INSERT INTO DEBITOREN VALUES ('815','-1','914','818','914','914','2011-08-17','10','2','30','500','N','10','N','N','N','N','N','3',NULL,'N','','N','0',NULL);
INSERT INTO DEBITOREN VALUES ('816','-1','915','819','915','915','2011-10-12','10','2','30','500','N','0','N','N','N','N','J','2',NULL,'N','','J','0',NULL);
INSERT INTO DEBITOREN VALUES ('817','-1','916','821','916','916','2011-10-19','10','2','30','500','N','0','N','N','N','N','N','2',NULL,'N','','N','0',NULL);
INSERT INTO DEBITOREN VALUES ('818','-1','917','822','917','917','2011-11-03','10','2','30','500','N','10','N','N','N','N','J','2',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('819','-1','918','823','918','918','2011-11-03','10','2','30','500','N','10','N','N','N','N','J','2',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('820','-1','919','824','919','919','2011-11-03','10','2','30','0','N','10','N','N','N','N','J','2',NULL,'N','','J','1',NULL);
INSERT INTO DEBITOREN VALUES ('821','-1','920','825','920','920','2011-12-03','10','2','30','500','N','0','N','N','N','N','N','2',NULL,'N','','N','0',NULL);
INSERT INTO DEBITOREN VALUES ('822','-1','921','826','921','921','2011-12-14','10','2','30','0','N','10','N','N','N','N','N','3',NULL,'N','','N','0',NULL);
INSERT INTO DEBITOREN VALUES ('823','-1','922','827','922','922','2012-05-15','10','2','30','500','N','10','N','N','N','N','N','2',NULL,'N','','N','0',NULL);



#
# TABLE 'DEBITOREN_GRUPPEN'
#
drop table if exists `DEBITOREN_GRUPPEN`;

create table `DEBITOREN_GRUPPEN` (
  `GRUPPEN_ID` int(11) Not Null auto_increment,
  `GRUPPEN` varchar(30) Not Null,
  `POSITION` int(3) Default '0' Not Null,
  `GELOESCHT` enum('J','N') Default 'N' Not Null,
  PRIMARY KEY (GRUPPEN_ID),
  UNIQUE KEY GRUPPEN_ID (GRUPPEN_ID)
);


#
# TABLE 'DEBITOREN_GRUPPEN' DATA
#
INSERT INTO DEBITOREN_GRUPPEN VALUES ('1','','1','N');
INSERT INTO DEBITOREN_GRUPPEN VALUES ('2','Endkonsument','2','N');
INSERT INTO DEBITOREN_GRUPPEN VALUES ('3','Schule','3','N');
INSERT INTO DEBITOREN_GRUPPEN VALUES ('4','Wiederverkufer','4','N');



#
# TABLE 'EINSTELLUNGEN'
#
drop table if exists `EINSTELLUNGEN`;

create table `EINSTELLUNGEN` (
  `ID` int(11) Not Null auto_increment,
  `MODUL` varchar(20),
  `PC_NAME` varchar(20),
  `MITARBEITER_ID` varchar(20),
  `KEY1` varchar(20),
  `WERT` varchar(50),
  `BESCHREIBUNG` varchar(50),
  PRIMARY KEY (ID),
  UNIQUE KEY ID (ID)
);


#
# TABLE 'EINSTELLUNGEN' DATA
#
INSERT INTO EINSTELLUNGEN VALUES ('1','Drucker','Thesy_1','1','Papier_Ausdruck','Ja','Beleg ausgeben?');
INSERT INTO EINSTELLUNGEN VALUES ('2','Drucker','Thesy_1','1','Drucker_OF','Dell Inkjet Printer J740','Druckername Offerten');
INSERT INTO EINSTELLUNGEN VALUES ('3','Drucker','Thesy_1','1','Drucker_AB','Dell Inkjet Printer J740','Druckername Auftragsbesttigung');
INSERT INTO EINSTELLUNGEN VALUES ('4','Drucker','Thesy_1','1','Drucker_LS','Dell Inkjet Printer J740','Druckername Lieferschein');
INSERT INTO EINSTELLUNGEN VALUES ('5','Drucker','Thesy_1','1','Drucker_RG','Dell Inkjet Printer J740','Druckername Rechnungen');
INSERT INTO EINSTELLUNGEN VALUES ('6','Drucker','Thesy_1','1','Drucker_Mahn','Dell Inkjet Printer J740','Druckername Mahnungen');
INSERT INTO EINSTELLUNGEN VALUES ('7','PDF_Drucker','Thesy_1','1','PDF_Ausdruck','Ja','PDF-Beleg ausgeben?');
INSERT INTO EINSTELLUNGEN VALUES ('8','PDF_Drucker','Thesy_1','1','Drucker_OF','rcWaWi (Spezial)','Druckername');
INSERT INTO EINSTELLUNGEN VALUES ('9','PDF_Drucker','Thesy_1','1','Drucker_AB','rcWaWi (Spezial)','Druckername Auftragsbesttigung');
INSERT INTO EINSTELLUNGEN VALUES ('10','PDF_Drucker','Thesy_1','1','Drucker_LS','rcWaWi (Spezial)','Druckername Lieferschein');
INSERT INTO EINSTELLUNGEN VALUES ('11','PDF_Drucker','Thesy_1','1','Drucker_RG','rcWaWi (Spezial)','Druckername Rechnungen');
INSERT INTO EINSTELLUNGEN VALUES ('12','PDF_Drucker','Thesy_1','1','Drucker_Mahn','rcWaWi (Spezial)','Druckername Mahnungen');
INSERT INTO EINSTELLUNGEN VALUES ('13','Drucker','Thesy_1','2','Papier_Ausdruck','Ja','Beleg ausgeben?');
INSERT INTO EINSTELLUNGEN VALUES ('14','Drucker','Thesy_1','2','Drucker_OF','Dell Inkjet Printer J740','Druckername Offerten');
INSERT INTO EINSTELLUNGEN VALUES ('15','Drucker','Thesy_1','2','Drucker_AB','Dell Inkjet Printer J740','Druckername Auftragsbesttigung');
INSERT INTO EINSTELLUNGEN VALUES ('16','Drucker','Thesy_1','2','Drucker_LS','Dell Inkjet Printer J740','Druckername Lieferschein');
INSERT INTO EINSTELLUNGEN VALUES ('17','Drucker','Thesy_1','2','Drucker_RG','Dell Inkjet Printer J740','Druckername Rechnungen');
INSERT INTO EINSTELLUNGEN VALUES ('18','Drucker','Thesy_1','2','Drucker_Mahn','Dell Inkjet Printer J740','Druckername Mahnungen');
INSERT INTO EINSTELLUNGEN VALUES ('19','PDF_Drucker','Thesy_1','2','PDF_Ausdruck','Ja','PDF-Beleg ausgeben?');
INSERT INTO EINSTELLUNGEN VALUES ('20','PDF_Drucker','Thesy_1','2','Drucker_OF','rcWaWi (Spezial)','Druckername');
INSERT INTO EINSTELLUNGEN VALUES ('21','PDF_Drucker','Thesy_1','2','Drucker_AB','rcWaWi (Spezial)','Druckername Auftragsbesttigung');
INSERT INTO EINSTELLUNGEN VALUES ('22','PDF_Drucker','Thesy_1','2','Drucker_LS','rcWaWi (Spezial)','Druckername Lieferschein');
INSERT INTO EINSTELLUNGEN VALUES ('23','PDF_Drucker','Thesy_1','2','Drucker_RG','rcWaWi (Spezial)','Druckername Rechnungen');
INSERT INTO EINSTELLUNGEN VALUES ('24','PDF_Drucker','Thesy_1','2','Drucker_Mahn','rcWaWi (Spezial)','Druckername Mahnungen');
INSERT INTO EINSTELLUNGEN VALUES ('25','OnlineBackup','Thesy_1','2','Speichern','Ja','Soll ein Backup Online gestellt werden?');



#
# TABLE 'EINSTELLUNGEN_FARBSCHEMA_MASTER'
#
drop table if exists `EINSTELLUNGEN_FARBSCHEMA_MASTER`;

create table `EINSTELLUNGEN_FARBSCHEMA_MASTER` (
  `ID` int(11) Not Null auto_increment,
  `KEY1` varchar(20),
  `WERT` varchar(50),
  `BESCHREIBUNG` varchar(50),
  `KLONEN` enum('Nein','Ja') Default 'Nein',
  PRIMARY KEY (ID),
  UNIQUE KEY ID (ID)
);


#
# TABLE 'EINSTELLUNGEN_FARBSCHEMA_MASTER' DATA
#
INSERT INTO EINSTELLUNGEN_FARBSCHEMA_MASTER VALUES ('63','Feld_nurlesen','$00EEC2A6',NULL,'Nein');
INSERT INTO EINSTELLUNGEN_FARBSCHEMA_MASTER VALUES ('64','Feld_soll','$FFFFFF',NULL,'Nein');
INSERT INTO EINSTELLUNGEN_FARBSCHEMA_MASTER VALUES ('65','Feld_muss','$00CBFEFD',NULL,'Nein');
INSERT INTO EINSTELLUNGEN_FARBSCHEMA_MASTER VALUES ('66','CtrlGrid','$00FE9E94',NULL,'Nein');
INSERT INTO EINSTELLUNGEN_FARBSCHEMA_MASTER VALUES ('67','GroupBox','$00EEC2A6',NULL,'Nein');
INSERT INTO EINSTELLUNGEN_FARBSCHEMA_MASTER VALUES ('68','Hintergrund','$FFFFFF',NULL,'Nein');
INSERT INTO EINSTELLUNGEN_FARBSCHEMA_MASTER VALUES ('69','Grid_Color','$00F1ECEB',NULL,'Nein');
INSERT INTO EINSTELLUNGEN_FARBSCHEMA_MASTER VALUES ('70','Grid_FixColor','$00D7D7D7',NULL,'Nein');
INSERT INTO EINSTELLUNGEN_FARBSCHEMA_MASTER VALUES ('71','CtrlGrid_Color','$00F1ECEB',NULL,'Nein');
INSERT INTO EINSTELLUNGEN_FARBSCHEMA_MASTER VALUES ('72','CtrlGrid_Select','$00E6939B',NULL,'Nein');
INSERT INTO EINSTELLUNGEN_FARBSCHEMA_MASTER VALUES ('73','CtrlGrid_DBEdit','$00E5E5E5',NULL,'Nein');



#
# TABLE 'EINSTELLUNGEN_MASTER'
#
drop table if exists `EINSTELLUNGEN_MASTER`;

create table `EINSTELLUNGEN_MASTER` (
  `ID` int(11) Not Null auto_increment,
  `MODUL` varchar(20),
  `KEY1` varchar(20),
  `WERT` varchar(50),
  `BESCHREIBUNG` varchar(50),
  `KLONEN` enum('Nein','Ja') Default 'Nein',
  PRIMARY KEY (ID),
  UNIQUE KEY ID (ID)
);


#
# TABLE 'EINSTELLUNGEN_MASTER' DATA
#
INSERT INTO EINSTELLUNGEN_MASTER VALUES ('1','OnlineBackup','Speichern','Ja','Soll ein Backup Online gestellt werden?','Ja');
INSERT INTO EINSTELLUNGEN_MASTER VALUES ('2','OnlineBackup','Host','test.cueni.net','Hostname?','Nein');
INSERT INTO EINSTELLUNGEN_MASTER VALUES ('3','OnlineBackup','Port','21','Portnummer (i.d.R. 21)','Nein');
INSERT INTO EINSTELLUNGEN_MASTER VALUES ('4','OnlineBackup','Username','cueninet','Username?','Nein');
INSERT INTO EINSTELLUNGEN_MASTER VALUES ('5','OnlineBackup','Passwort','mb770310','Passwort?','Nein');
INSERT INTO EINSTELLUNGEN_MASTER VALUES ('6','OnlineBackup','ChangeDir','www/wawi_hobbystuebli','Genaues (Unter-) Verzeichnis?','Nein');
INSERT INTO EINSTELLUNGEN_MASTER VALUES ('7','KeyVerwaltung','Pfad','c:\\rcwawi 2\\key\\','Standardpfad fr die exportierten Key-Dateien','Nein');
INSERT INTO EINSTELLUNGEN_MASTER VALUES ('8','PDF_Drucker','PDF_Ausdruck','Ja','PDF-Beleg ausgeben?','Ja');
INSERT INTO EINSTELLUNGEN_MASTER VALUES ('9','PDF_Drucker','Drucker_OF','','Druckername','Ja');
INSERT INTO EINSTELLUNGEN_MASTER VALUES ('10','PDF_Drucker','Drucker_AB','','Druckername Auftragsbesttigung','Ja');
INSERT INTO EINSTELLUNGEN_MASTER VALUES ('11','PDF_Drucker','Drucker_LS','','Druckername Lieferschein','Ja');
INSERT INTO EINSTELLUNGEN_MASTER VALUES ('12','PDF_Drucker','Drucker_RG','','Druckername Rechnungen','Ja');
INSERT INTO EINSTELLUNGEN_MASTER VALUES ('13','PDF_Drucker','Drucker_Mahn','','Druckername Mahnungen','Ja');
INSERT INTO EINSTELLUNGEN_MASTER VALUES ('14','Drucker','Papier_Ausdruck','','Beleg ausgeben?','Ja');
INSERT INTO EINSTELLUNGEN_MASTER VALUES ('15','Drucker','BelegAnzahl','','Anzahl der auszugebenden Belege','Ja');
INSERT INTO EINSTELLUNGEN_MASTER VALUES ('16','Drucker','Drucker_OF','','Druckername Offerten','Ja');
INSERT INTO EINSTELLUNGEN_MASTER VALUES ('17','Drucker','Drucker_AB','','Druckername Auftragsbesttigung','Ja');
INSERT INTO EINSTELLUNGEN_MASTER VALUES ('18','Drucker','Drucker_LS','','Druckername Lieferschein','Ja');
INSERT INTO EINSTELLUNGEN_MASTER VALUES ('19','Drucker','Drucker_RG','','Druckername Rechnungen','Ja');
INSERT INTO EINSTELLUNGEN_MASTER VALUES ('20','Drucker','Drucker_Mahn','','Druckername Mahnungen','Ja');
INSERT INTO EINSTELLUNGEN_MASTER VALUES ('21','Drucker','BelegAnzahl_OF','2','Anzahl Ausdrucke des Belegs','Nein');
INSERT INTO EINSTELLUNGEN_MASTER VALUES ('22','Drucker','BelegAnzahl_AB','2','Anzahl Ausdrucke des Belegs','Nein');
INSERT INTO EINSTELLUNGEN_MASTER VALUES ('23','Drucker','BelegAnzahl_LS','2','Anzahl Ausdrucke des Belegs','Nein');
INSERT INTO EINSTELLUNGEN_MASTER VALUES ('24','Drucker','BelegAnzahl_RG','2','Anzahl Ausdrucke des Belegs','Nein');
INSERT INTO EINSTELLUNGEN_MASTER VALUES ('25','Drucker','BelegAnzahl_Mahn','2','Anzahl Ausdrucke des Belegs','Nein');
INSERT INTO EINSTELLUNGEN_MASTER VALUES ('26','MWSt','MWST_0','0.00','Mewertsteuer 0','Nein');
INSERT INTO EINSTELLUNGEN_MASTER VALUES ('27','MWSt','MWST_1','2.50','Mehrwertsteuer klein','Nein');
INSERT INTO EINSTELLUNGEN_MASTER VALUES ('28','MWSt','MWST_2','8.00','Mehrwertsteuer gross','Nein');
INSERT INTO EINSTELLUNGEN_MASTER VALUES ('29','Auftrag','StartNr_Auftrag','1000','Startnummer der Auftrge','Nein');
INSERT INTO EINSTELLUNGEN_MASTER VALUES ('30','Auftrag','StartNr_OF','10000','Startnummer der Offerten','Nein');
INSERT INTO EINSTELLUNGEN_MASTER VALUES ('31','Auftrag','StartNr_AB','20000','Startnummer der Auftragsbesttigungen','Nein');
INSERT INTO EINSTELLUNGEN_MASTER VALUES ('32','Auftrag','StartNr_LS','30000','Startnummer der Lieferscheine','Nein');
INSERT INTO EINSTELLUNGEN_MASTER VALUES ('33','Auftrag','StartNr_RG','40000','Startnummer der Rechnungen','Nein');
INSERT INTO EINSTELLUNGEN_MASTER VALUES ('34','Auftrag','StartNr_Mahn','100','Startnummer der Mahnungen','Nein');
INSERT INTO EINSTELLUNGEN_MASTER VALUES ('35','Auftrag','Werbetext_OF','Besten Dank fr Ihre Anfrage!','Standard-Werbetext','Nein');
INSERT INTO EINSTELLUNGEN_MASTER VALUES ('36','Auftrag','Werbetext_AB','Besten Dank fr Ihren Auftrag!','Standard-Werbetext','Nein');
INSERT INTO EINSTELLUNGEN_MASTER VALUES ('37','Auftrag','Werbetext_LS','Besten Dank fr Ihren Auftrag!','Standard-Werbetext','Nein');
INSERT INTO EINSTELLUNGEN_MASTER VALUES ('38','Auftrag','Werbetext_RG','Besten Dank fr Ihren Einkauf!','Standard-Werbetext','Nein');
INSERT INTO EINSTELLUNGEN_MASTER VALUES ('39','PDF_Drucker','Pfad_OF','c:\\rcWaWi 2\\PDF','Wo sollen die PDF-Belege abgelegt werden?','Nein');
INSERT INTO EINSTELLUNGEN_MASTER VALUES ('40','PDF_Drucker','Pfad_AB','c:\\rcWaWi 2\\PDF','Wo sollen die PDF-Belege abgelegt werden?','Nein');
INSERT INTO EINSTELLUNGEN_MASTER VALUES ('41','PDF_Drucker','Pfad_LS','c:\\rcWaWi 2\\PDF','Wo sollen die PDF-Belege abgelegt werden?','Nein');
INSERT INTO EINSTELLUNGEN_MASTER VALUES ('42','PDF_Drucker','Pfad_RG','c:\\rcWaWi 2\\PDF','Wo sollen die PDF-Belege abgelegt werden?','Nein');
INSERT INTO EINSTELLUNGEN_MASTER VALUES ('43','PDF_Drucker','Pfad_Mahn','c:\\rcWaWi 2\\PDF','Wo sollen die PDF-Belege abgelegt werden?','Nein');
INSERT INTO EINSTELLUNGEN_MASTER VALUES ('44','Auftrag','Max_Pos','20','Anzahl max. Auftragspositionen','Nein');
INSERT INTO EINSTELLUNGEN_MASTER VALUES ('45','Auftrag','Versandkosten','10','Versandkosten','Nein');
INSERT INTO EINSTELLUNGEN_MASTER VALUES ('46','Auftrag','Skonto_Tag','10','Skonto','Nein');
INSERT INTO EINSTELLUNGEN_MASTER VALUES ('47','Auftrag','Skonto_Prozent','2','Skonto in Prozent','Nein');
INSERT INTO EINSTELLUNGEN_MASTER VALUES ('48','Auftrag','Rabatt_Prozent','0','Grundrabatt','Nein');
INSERT INTO EINSTELLUNGEN_MASTER VALUES ('49','Auftrag','Zahlungsziel','30','Zahlungsziel','Nein');
INSERT INTO EINSTELLUNGEN_MASTER VALUES ('50','Auftrag','Kreditlimitte','500','Kreditlimitte','Nein');
INSERT INTO EINSTELLUNGEN_MASTER VALUES ('51','Mahnwesen','1. Stufe','0.00','Mahnspesen','Nein');
INSERT INTO EINSTELLUNGEN_MASTER VALUES ('52','Mahnwesen','2. Stufe','10.00','Mahnspesen','Nein');
INSERT INTO EINSTELLUNGEN_MASTER VALUES ('53','Mahnwesen','3. Stufe','20.00','Mahnspesen','Nein');
INSERT INTO EINSTELLUNGEN_MASTER VALUES ('54','Mahnwesen','4. Stufe','30.00','Mahnspesen','Nein');
INSERT INTO EINSTELLUNGEN_MASTER VALUES ('55','Debitor','Startnummer','100','Startnummer','Nein');
INSERT INTO EINSTELLUNGEN_MASTER VALUES ('56','Kreditor','Startnummer','100','Startnummer','Nein');
INSERT INTO EINSTELLUNGEN_MASTER VALUES ('57','Mitarbeiter','Standardpasswort','Initial','Standardpasswort fr einen neuen Mitarbeiter','Nein');



#
# TABLE 'ERRORLOG'
#
drop table if exists `ERRORLOG`;

create table `ERRORLOG` (
  `ID` int(11) Not Null auto_increment,
  `DATUM` date,
  `MITARBEITER_ID` int(11),
  `PC_NAME` varchar(20),
  `MODUL` varchar(20),
  `KEY1` varchar(20),
  `FEHLERMELDUNG` blob,
  PRIMARY KEY (ID),
  UNIQUE KEY ID (ID)
);


#
# TABLE 'FIBU_HAUPTBUCH'
#
drop table if exists `FIBU_HAUPTBUCH`;

create table `FIBU_HAUPTBUCH` (
  `ID` int(11) Not Null auto_increment,
  `ZEITSTEMPEL` timestamp Default '0000-00-00 00:00:00' Not Null,
  `BUCHUNGSSATZ` varchar(20),
  `BEMERKUNGEN` varchar(20),
  `KONTO_SOLL` int(6),
  `KONTO_HABEN` int(6),
  `BETRAG` double(9,2),
  `BELEGDATUM` varchar(10),
  `DEBITORNR` varchar(10),
  `KREDITORNR` varchar(10),
  `BESCHREIBUNG` varchar(20),
  `BELEGART` varchar(10),
  `BELEGNR` varchar(20),
  `BETRAG_EXKL0` varchar(10),
  `BETRAG_EXKL1` varchar(10),
  `BETRAG_EXKL2` varchar(10),
  `BETRAG_MWST1` varchar(10),
  `BETRAG_MWST2` varchar(10),
  PRIMARY KEY (ID),
  UNIQUE KEY ID (ID)
);


#
# TABLE 'FIBU_KONTEN'
#
drop table if exists `FIBU_KONTEN`;

create table `FIBU_KONTEN` (
  `KONTORAHMEN` varchar(10) Not Null,
  `KONTO` bigint(5) unsigned Default '0' Not Null,
  `KONTONAME` varchar(100) Not Null,
  `KONTOART` int(3) unsigned Default '0' Not Null,
  `NEBENKONTO` bigint(5) unsigned Default '0' Not Null,
  `STEUERSATZ` decimal(6,0) Default '0' Not Null,
  `BILANZKONTO` enum('N','Y') Default 'N' Not Null,
  `NK_AUSWAHL` enum('N','Y') Default 'N' Not Null,
  `USTVA_ZEILE` bigint(5) unsigned Default '0' Not Null,
  `BWA_GRUPPE` bigint(5) unsigned Default '0',
  `BANK_BLZ` varchar(15),
  `BANK_KONTO` varchar(15),
  `BANK_NAME` varchar(255),
  `KONTO_INHABER` varchar(255),
  PRIMARY KEY (KONTORAHMEN, KONTO)
);


#
# TABLE 'GESCHLECHT'
#
drop table if exists `GESCHLECHT`;

create table `GESCHLECHT` (
  `GESCHLECHT_ID` int(3) Not Null auto_increment,
  `GESCHLECHT` varchar(20) Not Null,
  `POSITION` int(2),
  `GELOESCHT` enum('J','N') Default 'N' Not Null,
  PRIMARY KEY (GESCHLECHT_ID)
);


#
# TABLE 'GESCHLECHT' DATA
#
INSERT INTO GESCHLECHT VALUES ('1','','1','N');
INSERT INTO GESCHLECHT VALUES ('2','W','2','N');
INSERT INTO GESCHLECHT VALUES ('3','M','3','N');



#
# TABLE 'HERSTELLER'
#
drop table if exists `HERSTELLER`;

create table `HERSTELLER` (
  `HERSTELLER_ID` int(6) Not Null auto_increment,
  `HERSTELLER` varchar(20) Not Null,
  `WEBSITE` varchar(40),
  `GELOESCHT` enum('J','N') Default 'N' Not Null,
  PRIMARY KEY (HERSTELLER_ID)
);


#
# TABLE 'INFO'
#
drop table if exists `INFO`;

create table `INFO` (
  `ID` int(11) Not Null auto_increment,
  `VERSION_DB` varchar(11),
  `DATUM_DB` date,
  PRIMARY KEY (ID)
);


#
# TABLE 'INFO' DATA
#
INSERT INTO INFO VALUES ('2','2.01','2010-10-05');



#
# TABLE 'KALKULATION'
#
drop table if exists `KALKULATION`;

create table `KALKULATION` (
  `ID` int(2) Default '0' Not Null,
  `SCHEMA` varchar(15) Not Null,
  `WERT_PROZENT` decimal(10,4) Default '0.0000',
  `WERT_EURO1` float(10,4) Default '0.0000',
  `WERT_EURO2` decimal(10,4) Default '0.0000',
  `PUV1` decimal(10,4),
  `PUV2` decimal(10,4),
  PRIMARY KEY (ID)
);


#
# TABLE 'KONTAKTDATEN'
#
drop table if exists `KONTAKTDATEN`;

create table `KONTAKTDATEN` (
  `KONTAKTDATEN_ID` int(10) Not Null auto_increment,
  `GESCHLECHT_ID` int(3),
  `ANREDE_ID` int(3),
  `TITEL_ID` int(3),
  `ZIVILSTAND_ID` varchar(10),
  `FIRMA` varchar(40),
  `FIRMA_ZUSATZ` varchar(40),
  `VORNAME` varchar(30),
  `NACHNAME` varchar(30),
  `ABTEILUNG` varchar(40),
  `STRASSE1` varchar(30),
  `STRASSE2` varchar(30),
  `POSTFACH` varchar(11),
  `PLZ_ID` int(11),
  `TEL_P` varchar(20),
  `TEL_G1` varchar(20),
  `TEL_G2` varchar(20),
  `FAX_P` varchar(20),
  `FAX_G` varchar(20),
  `HANDY` varchar(20),
  `EMAIL_P` varchar(50),
  `EMAIL_G` varchar(50),
  `INTERNET` varchar(30),
  `GEBURTSTAG` date,
  `KONTOINHABER1` varchar(30),
  `KONTO1` varchar(20),
  `BANK1` varchar(25),
  `BLZ1` varchar(8),
  `IBAN1` varchar(40),
  `SWIFT1` varchar(20),
  `KONTOINHABER2` varchar(30),
  `KONTO2` varchar(20),
  `BANK2` varchar(25),
  `BLZ2` varchar(8),
  `IBAN2` varchar(40),
  `SWIFT2` varchar(20),
  `MITARBEITER` enum('J','N') Default 'N' Not Null,
  `DEBITOR` enum('J','N') Default 'N' Not Null,
  `KREDITOR` enum('J','N') Default 'N' Not Null,
  `WEBKONTAKT` enum('J','N') Default 'N' Not Null,
  `GELOESCHT` enum('J','N') Default 'N' Not Null,
  PRIMARY KEY (KONTAKTDATEN_ID)
);


#
# TABLE 'KONTAKTDATEN' DATA
#
INSERT INTO KONTAKTDATEN VALUES ('1','1','1','1','1','','','Oberbipp','Volksschule','','z.Hd. Frau Aeschlimann','','','924','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('2','1','1','1','1','','','Gabi','Obrecht - Guozzini','','Allmendweg 1','','','684','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('3','1','1','1','1','','','Therese','Schaad - Schenk','','Geissfluestrasse 9','','','2605','032/ 641 21 69','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('4','1','1','1','1','','','Marianne','Rotschi','','von Rollstrasse 2','','','2691','062/ 396 20 85','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('5','1','1','1','1','','','Claudia','Luternauer','','am Chrtzstutz 4','','','2126','062/ 754 09 60','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('6','1','1','1','1','','','Barbara','Jggi - Wyss','','Lochmatte 35','','','2675','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('7','1','1','1','1','','','Doris','Jggi','','Rmerstrasse 6','','','2691','062/396 03 77','','','','','','aschi.jaeggi@tele2.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('8','1','1','1','1','','','Sandra','Schenker','','Emetstrasse 576','','','2695','062/ 394 10 48','','','','','','erholungsoase@msn.com','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('9','1','1','1','1','','','Regina','Glaser','','Dorfackerstrasse 27','','','2614','032/ 685 21 94','','','','','079/ 687 08 56','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('10','1','1','1','1','','','Jacqueline','Eigenmann','','Oberfeldweg 26','','','2671','062/398 20 50','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('11','1','1','1','1','','','Rita','Fischer','','Fliederweg 2','','','59','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('12','1','1','1','1','','','Jolanda','Lanz','','Lehnfeldstrasse 24','','','2691','062/ 396 01 54','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('13','1','1','1','1','','','Marita','Pflger','','Reinacherstrasse 206','','','1095','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('14','1','1','1','1','','','Jeanine','Lang','','Sinfonieweg 1','','','648','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('15','1','1','1','1','','','Silvia','Burkhard','','Hausmattstrasse 6','','','930','032/ 922 08 28','','','','','','s.h.burkhard@bluewin.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('16','1','1','1','1','','','Annemarie','Bandi','','Oltenstrasse 9','','','922','032/ 637 16 25','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('17','1','1','1','1','','','Madeleine','Steffen','','Erlenweg 2','','','371','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('18','1','1','1','1','','','Catherine','Bader','','Grod 282','','','27','062/ 751 30 53','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('19','1','1','1','1','','','Marlene','Staudenmann','','Bntackerstrasse 22','','','2639','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('20','1','1','1','1','','','Brigitte','Mller','','Rossiweg 64','','','2694','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('21','1','1','1','1','','','Pia','Luder','','Spiegelberg 13','','','669','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('22','1','1','1','1','','','Linda','Mathys','','Hauptstrasse 25','','','2640','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('23','1','1','1','1','','','Nelly','Franic','','Falkenweg 4','','','924','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('24','1','1','1','1','','','Annemarie','Lthi','','Hubel','','','681','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('25','1','1','1','1','','','Brigitte','Binggeli','','Bernerschachen','','','922','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('26','1','1','1','1','','','Janettte','Waldmann','','Kirchgasse 30','','','942','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('27','1','1','1','1','','','Anita','Schaller','','Ziegelacker','','','1985','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('28','1','1','1','1','','','Vreni','Haudenschild','','Gemeindehofweg 9','','','928','032/ 633 11 65','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('29','1','1','1','1','','','Erika','Brlisauer','','Buchenweg 31','','','2031','041/ 448 43 91','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('30','1','1','1','1','','','Beatrice','Lanz','','Hauptstrasse 10','','','2608','032/ 622 76 60','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('31','1','1','1','1','','','Ursula','Spahr','','Aeschistrasse 47','','','667','062/ 961 70 28','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('32','1','1','1','1','','','Christine','Annaheim','','Rtistrasse 7a','','','2617','032/ 637 25 97','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('33','1','1','1','1','','','Iris','Zimmerli','','Dammweg 41','','','928','032/ 633 13 21','','','','','','iris.zimmerli @ggs.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('34','1','1','1','1','','','Katrin','Zeller - Esseiva','','Hintergasse 8','','','2627','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('35','1','1','1','1','','','Annemarie','Ingold','','Feldstrasse 10','','','2692','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('36','1','1','1','1','','','Jenaine','Hnni','','Wiedlisbachstrasse 12','','','924','032/ 636 37 01','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('37','1','1','1','1','','','Maya','Schranz','','Dorfgasse 8','','','587','031/ 751 54 09','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('38','1','1','1','','','','Lisbeth','Bernhard','','Buchenweg 1','','','922','032/ 637 18 82','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','J');
INSERT INTO KONTAKTDATEN VALUES ('39','1','1','1','1','','','Doris','Bongard','','Scheidgasse 18','','','273','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('40','1','1','1','1','','','Irene','Ballerini','','Dorfstrasse 43','','','2092','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('41','1','1','1','1','','','Ursula','Stalder','','Lehmgrubenweg 8','','','924','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('42','1','1','1','1','','','Beatrice','Niggli','','Husmatten 657','','','2676','062/ 393 28 47','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('43','1','1','1','1','','','Esther','Hauser','','Vorstadt 46','','','684','032/ 631 16 60','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('44','1','1','1','1','','','Karin','Blaser','','Mittlere Strasse 3','','','882','033/ 823 03 52','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('45','1','1','1','1','','','Caroline','Bettschen','','Rainstrasse 1','','','2616','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('46','1','1','1','1','','','Renata','Zeltner','','Hint.Hammer 47 / 217','','','2697','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('47','1','1','1','1','','','Regula','Wolf','','Moosgasse 13','','','924','032/ 636 33 80','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('48','1','1','1','1','','','T. + E.','Wagner','','Wangenstrasse 11','','','923','032/ 636 32 66','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('49','1','1','1','1','','','Regula','Von Mhlenen','','Koppigerstrasse 36','','','711','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('50','1','1','1','1','','','Theres','Scheidegger','','Frauchsrtli','','','922','032/ 637 13 34','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('51','1','1','1','1','','','Karin','Zimmermann','','Kirchgasse 10','','','675','062/ 923 63 25','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('52','1','1','1','1','','','Josiane','Maillard','','Reckweg 7','','','380','','','','','','','majolo@freesurf.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('53','1','1','1','1','','','Barbara','Flury','','Dammweg 1','','','684','032/637 20 72','','','','','','barbara.flury3@bluewin.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('54','1','1','1','1','','','Karin','Wildi - Leuenberger','','Buchlistrasse 22 a','Krabbelgruppe','','928','032/633 25 74','','','','','','k.wildi@ggs.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('55','1','1','1','1','','','Sonja','Barrer','','Hombergstrasse 36','','','2663','062/ 212 02 76','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('56','1','1','1','1','','','Madlen','Heizmann','','Bleihollenweg','','','1008','061/ 761 31 64','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('57','1','1','1','1','','','Barbara','Zimmermann-Hofstette','','Dorfstrasse 24','','','2674','','','','','','','h.babs@gmx.net','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('58','1','1','1','1','','','Charlotte','Borer','','Kirchgasse 256','','','2676','062/ 393 10 51','','','','','','dietercharlotte@bluemail.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('59','1','1','1','1','','','Silvia','Schnholzer','','Rmerstrasse 4','','','2623','','','','','','','mschoenholzer@dplanet.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('60','1','1','1','1','','','Madeleine','Wyss','','Solothurnstrasse 19','','','922','032/ 637 36 66','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('61','1','1','1','1','','','Gabriela','Lthi','','Erleweg 32','','','2598','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('62','1','1','1','1','','','Daniela','Beck','','Rainstrasse 3 A','','','2616','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('63','1','1','1','1','','','Ruth','Widmar','','Weiermattstrasse 23','','','2684','062/ 295 04 90','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('64','1','1','1','1','','','R.','Brgger','','Wartenfelsstrasse 17 a','','','2685','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('65','1','1','1','1','','','Lara','Vaterlaus','','Blauchen 3','','','923','032/ 636 24 18','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('66','1','1','1','1','','','Francois','Rotzetter','','Kreuzmattstrasse 53','','','1411','','','','','','079/ 687 82 35','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('67','1','1','1','1','','','Jnes','Obi','','Zuchwilerstrasse 87','','','2614','032/ 685 31 12','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('68','1','1','1','1','','','Frnzi','Krhenbhl','','Schwarzpeter - Weg 674','','','2676','062/ 393 32 32','','','062/ 393 32 33','','','fraenzi - urs@bluewin.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('69','1','1','1','1','','','Bernadette','Walliser','','Bergstrasse 29','','','2616','','','','','','','bwalliser@bluewin.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('70','1','1','1','1','','','Susi','Schranz','','Sennjggel','','','948','','','','','','','ccs@bluewin.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('71','1','1','1','','','','Rita','Knsli -Kunz','','Wilenbachstrasse 11','alte Adresse!','','4341','01 / 860 18 28','','','','','','sknueslis@freesurf.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','J');
INSERT INTO KONTAKTDATEN VALUES ('72','1','1','1','1','','','Christine','Hfliger','','Ibach','','','698','','','','','','','christine.haefliger@freesurf.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('73','1','1','1','1','','','Marie - Louise','Frst','','Nesslerenweg 66','','','531','','','','','','','fuerst66@bluewin.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('74','1','1','1','1','','','Karin','Ruchti','','Vorstadt 35','','','684','','','','','','','hansruedi.ruchti@bluewin.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('75','1','1','1','1','','','Nancy','Cosi','','Flurstrasse 39','','','2561','032/ 645 23 84','','','','','076/ 418 08 69','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('76','1','1','1','1','','','Nicole','Fh','','Kaselfeldstrasse 45','','','2603','032/ 618 16 80','','','','','','faehkissling@bluewin.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('77','1','1','1','1','','','Sandra','Zimmermann - Kurth','','Solothurnstrasse 14','','','922','032/ 637 16 67','','','','','','zimmermann.sandra@gmx.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('78','1','1','1','1','','','Susanne','Mller - Heiniger','','Msliweg 4','','','945','062/ 923 03 41','','','','','','sumueller@gmx.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('79','1','1','1','1','','','Karin','Steiner','','Allmendstrasse 35','','','2617','032/ 637 32 13','','','','','','kssteiner@bluewin.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('80','1','1','1','1','','','Helga','Oliva','','Neumattstrasse 2','','','2636','032/ 675 42 50','','','032/ 675 42 50','','','helga.oliva@freesurf.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('81','1','1','1','1','','','Tamara','Regger','','Brittnauerstrasse 45','','','25','062/ 752 47 57','','','','','','tami.ruegger@bluemail.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('82','1','1','1','1','','','Andrea','Arnold','','Buchenstrasse','','','2616','','','','','','078/ 754 18 04','and.arnold@bluewin.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('83','1','1','1','1','','','Daniela','Kuchen','','Sonnenrain 225','','','639','032/ 351 57 06','','','','','','d.s.kuchen@gmx.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('84','1','1','1','1','','','Ruth','Baumann','','Tieracker 33','','','2670','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('85','1','1','1','1','','','Marlies','Garius','','Hauptstrasse 24','','','708','034/ 413 11 22','034/ 413 21 80','','','','','garius@solnet.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('86','1','1','1','1','','','Monika','Leuenberger','','Dhlenweg 6','','','684','032/ 631 23 49','','','','','','monika.leuenberger@bluewin.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('87','1','1','1','1','','','Antoinette','Flury','','Poststrasse 185','','','2676','','','','','','','antoinetteflury@sunrise.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('88','1','1','1','1','','','Franziska','Schubiger','','Unterfhrungsstrasse 24','','','2620','','','','','','','franziska.schubiger@solnet.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('89','1','1','1','1','','','Daniela','Mller','','Zelgliweg 11','','','928','032/ 633 13 02','','','','','','daniela.mueller - bigler@bluewin.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('90','1','1','1','1','','','Regina','Hohl - Fuchs','','Kaselfeldstrasse 37','','','2603','032/ 618 01 59','','','','','','hohl - fuchs@bluewin.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('91','1','1','1','1','','','Marianne','Steimer','','Sonnenrainstrasse 14','','','2616','032/ 622 72 76','','','','','','urs.steimer@gawnet.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('92','1','1','1','1','','','Brigitte','Palacios','','Buentackerstrasse 16','','','2639','','','','','','','palacios@bluewin.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('93','1','1','1','1','','','Brigitte','Wagner','','Solothurnstrasse 16','','','922','032/ 637 32 55','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('94','1','1','1','1','','','Ruth','Steiner','','Weiherstrasse 17','','','2648','032/ 661 12 34','','','','','','thomas.steiner@newmail.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('95','1','1','1','1','','','Simone','Imhof','','Gummenweg 16','','','925','032/636 21 33','','','','','','simone.imhof@ascom.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('96','1','1','1','1','','','Heidi','Hni','','Byfang 13','','','923','032/ 636 38 11','','','','','','k.haeni@bluewin.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('97','1','1','1','1','','','Rita','Knsli - Kunz','','Wuhrmattweg 304','','','70','062/ 871 07 16','','','','','','r.knuesli@stoeu.com','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('98','1','1','1','1','','','Silvia','Scheidegger','','Tulpenweg 1','','','928','','','','','','','scheidegger.s@solnet.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('99','1','1','1','1','','','Antoinette','Gerber','','Untergasse 10 b','','','942','','','','','','','an.gerber@datacomm.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('100','1','1','1','1','','','Sandra','Anderegg','','Sgerweg 10','','','924','032/ 636 08 38','','','','','','sandra.anderegg@smile.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('101','1','1','1','1','','','Corinne','Geiser','','La Fin Dessous 85','','','437','032/ 493 28 59','','','','','','cgeiser@freesurf.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('102','1','1','1','1','','','Bechburg','Kreisschule','','z.hd. Sibylle Heer','Jurastrasse 4','','2691','032/ 636 29 75','','','','','','ilton@bluewin.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('103','1','1','1','1','','','Ruth','Schaad','','Pfaffentalweg 1','','','924','032/636 26 05','','','','','','ruth.schaad@bluewin.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('104','1','1','1','1','','','Renate','Gdel - Pauli','','Dorf 57','','','951','','','','','','','guedel - pauli@bluewin.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('105','1','1','1','1','','','Ursula','Jenni','','In den Grten 16','','','888','','','','','','','ursulajenni@freesurf.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('106','1','1','1','1','','','Therese','Rz','','Staadstrasse 238','','','2558','032/ 652 91 03','','','','','','therese@gmx.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('107','1','1','1','1','','','Jeannette','Spycher','','Mattenweg 11','','','2638','032/ 675 68 18','','','','','','j - spycher@bluewin.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('108','1','1','1','','','','Marianne','Steimer','','Sonnenrainstrasse 14','','','2616','032/ 622 72 76','','','','','','urs.steimer@bluewin.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','J');
INSERT INTO KONTAKTDATEN VALUES ('109','1','1','1','1','','','Ursula','Iff','','Weihergasse 24','','','924','0327 636 21 87','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('110','1','1','1','1','','','Diana','Sutter','','Amselweg 10','','','924','032/ 636 22 76','','','032/ 636 22 76','','','hd.sutter@freesurf.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('111','1','1','1','1','','','Isa','Von Arx','','Rue du collge 6','','','3751','026/ 675 52 16','','','','','079/ 434 84 17','g.bayard@bluewin.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('112','1','1','1','1','','','Marianne','Hofer','','Bleicheweg 391','','','952','062/ 965 38 55','','','','','','marianne.didi@bluewin.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('113','1','1','1','1','','','Ren - Louis','Berger','','Bechburgstrasse 15','','','2598','032/ 623 07 57','','','032/ 623 07 57','','078/ 896 81 44','info@bergers-clean-team.ch','','www.bergers-clean-team.ch','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('114','1','1','1','1','','','Monika','Brudermann','','Farnernstrasse 1','','','925','032/ 636 39 36','','','032/ 636 06 88','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('115','1','1','1','1','','','Daniel','Bader','','Katzenmoosweg 273','','','27','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('116','1','1','1','1','','','Erich','Kupferschmid','','Zweigenweg 4','','','1011','061/ 761 19 75','','','','','079/357 95 62','edenj.Kupferschmied@tele2.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('117','1','1','1','1','','','Eva','Valli','','Wylerweg 44','','','716','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('118','1','1','1','1','','','Cornelia','Humm','','Hausmattweg 23','','','19','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('119','1','1','1','1','','','Sabine','Grimbichler','','Oberfeldweg 32','','','2671','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('120','1','1','1','1','','','Brit Eli','Sparby','','Dorfstrasse 4','','','922','032/ 637 25 73','','','','','','sparby.stuber@bluewin.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('121','1','1','1','1','','','Ruedi','Leuenberger','','Ey 4','','','686','','','','','','','leubi@besonet.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('122','1','1','1','1','','','Heidi','Ingold','','Eiche 26','','','923','032/ 636 35 73','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('123','1','1','1','1','','','Susanne','Kurt','','Untere Drrmhlestrasse 8','','','928','032/633 29 30','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('124','1','1','1','1','','','Elsbeth','Jggi','','Fulenbacherstrasse 171','','','2672','062/ 216 16 59','','','062/ 216 5225','','','o.e.jeaggi@bluewin.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('125','1','1','1','','','','Karin','Wildi','','Buchlistrasse 22 a','','','928','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','J');
INSERT INTO KONTAKTDATEN VALUES ('126','1','1','1','1','','','Nicole','Baumgartner','','Dorfstrasse 39','','','679','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('127','1','1','1','1','','','Vanessa','Ryf','','Schulhausstrasse 2','','','928','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('128','1','1','1','1','','','Franziska','Sartori','','Haltenrain 4','','','2614','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('129','1','1','1','1','','','Fabienne','Senn','','Zelgliweg 40','','','928','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('130','1','1','1','1','','','Daniela','Pasquariello','','Ahornweg 7','','','2621','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('131','1','1','1','1','','','Rosmarie','Peyer','','Mattenweg 2','','','2628','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('132','1','1','1','1','','','Nina','Studer','','Mlimattstrasse 14','','','2640','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('133','1','1','1','1','','','Hanspeter','Christen','','Dorfstrasse 23','','','2617','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('134','1','1','1','1','','','Hans - Ulrich','Dutly','','Hagacker 77','','','2660','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('135','1','1','1','1','','','Myrta','Zurlinden','','Oeleweg 14','','','923','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('136','1','1','1','1','','','Doris','Gehriger','','Breitholzweg 17','','','924','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('137','1','1','1','1','','','Manfred','Poschung','','Fhrenweg 10','','','2598','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('138','1','1','1','1','','','Patricia','Frei','','Moosgasse 1','','','924','032/ 636 12 21','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('139','1','1','1','1','','','Erika','Schweizer','','Bahnhofstrasse 47','','','2673','062/ 393 32 21','','','','','079/273 50 16','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('140','1','1','1','1','','','Emma','Binz','','Werkstrasse 9','','','2617','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('141','1','1','1','1','','','Anna','Annaheim Rilli','','Werkstrasse 9','','','2617','032/ 637 22 69','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('142','1','1','1','1','','','Geri','Wolf','','Rthistrasse 6','','','2604','032/ 623 13 64','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('143','1','1','1','1','','','Dora','Reinmann','','Grossholzweg 46','','','713','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('144','1','1','1','1','','','Karin','Uebersax','','Obergerlafingenstrasse 15','','','2639','','','','','','079/ 688 16 44','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('145','1','1','1','1','','','Monika','Scherrer','','Dorfstrasse 11','','','685','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('146','1','1','1','1','','','Alice','Vogt','','Riedstrasse 47','','','2561','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('147','1','1','1','1','','','Wasseramt','Kreisschule usseres','','z.h. Scheidegger Margrith','Dgenmooseg 4','','2625','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('148','1','1','1','1','','','Peter','Nnlist','','Mattenweg 1','','','2691','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('149','1','1','1','1','','','Annemarie','Egger','','Lehmgrubenweg 6','','','924','032/ 636 14 57','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('150','1','1','1','1','','','Brigitte','Senn','','Tannstrasse 4','','','2636','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('151','1','1','1','','','','Nicola','Bernhard','','Buchenweg 1','','','922','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','J');
INSERT INTO KONTAKTDATEN VALUES ('152','1','1','1','1','','','Beatrice','Gschwind','','Kirchstrasse 483','','','2695','062/ 394 10 69','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('153','1','1','1','1','','','Monika','Daumller','','Breitenstrasse 14 a','','','637','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('154','1','1','1','1','','','Andrea','Egger','','Schnmattstrasse 13','','','2625','032/ 614 04 45','','','','','','andrea.egger.adam@bluemail.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('155','1','1','1','1','','','Christina','Lemp','','Tulpenweg 2','','','922','032/ 637 31 09','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('156','1','1','1','','','','Ursula','Spahr','','Aeschistrasse 47','','','667','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','J');
INSERT INTO KONTAKTDATEN VALUES ('157','1','1','1','1','','','Jacqueline','Leventis','','Finkenweg 20','','','928','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('158','1','1','1','1','','','Melinda','Bongni','','Gerberweg 15','','','924','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('159','1','1','1','1','','','Sandra','Schwegler','','Hubelweg 34','','','666','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('160','1','1','1','1','','','Claudia','Pochelon','','Reckholderweg 26 b','','','2606','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('161','1','1','1','1','','','Caroline','Bader','','Sonnhaldenweg 8','','','2691','062/ 396 36 49','','','','','','carolinebader@gmx.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('162','1','1','1','1','','','Monika','Kamber','','Bahnhofstrasse 3','','','2677','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('163','1','1','1','1','','','Brigitte','Folletto','','Sonnhalde 27','','','923','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('164','1','1','1','1','','','Michel','Klaus','','Drosselweg 2','','','2624','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('165','1','1','1','1','','','Nicole','Brki','','Fhrenweg 5','','','2618','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('166','1','1','1','1','','','Susanne','Knzig','','Juraweg 70','','','679','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('167','1','1','1','1','','','Anette - Sandra','Schwab','','Dorfstrasse 35','','','2651','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('168','1','1','1','1','','','Anette','Beutler','','Meiniswilerstrasse 60','','','934','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('169','1','1','1','1','','','Caroline','Kopp','','Galgenholzweg 30','','','923','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('170','1','1','1','1','','','Ursula','Meer','','Kserei Leinbtzen 302','','','698','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('171','1','1','1','1','','','Madlen','Bader','','Im Winkel 916','','','2700','062/  391 44 48','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('172','1','1','1','1','','','Kurt','Schneeberger','','Bifangstrasse 4 b','','','684','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('173','1','1','1','1','','','Edith','Regger','','Titlisweg 13','','','35','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('174','1','1','1','1','','','Dora','Greub','','Buchholzstrasse 100','','','809','033/ 336 03 49','','','','','','dortin@hispeed.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('175','1','1','1','1','','','Trudy','Kiener','','Stutzbodenweg 18','','','684','032/ 636 30 50','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('176','1','1','1','1','','','Renate','Bsiger','','Schwarzenbach','','','937','062/ 922  56 84','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('177','1','1','1','1','','','Marianne','Sommer','','Neumattweg 24','','','923','032/ 636 16 11','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('178','1','1','1','','','','Sandra','Zimmermann','','Solothurnstrasse 14','','','922','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','J');
INSERT INTO KONTAKTDATEN VALUES ('179','1','1','1','1','','','Pia','Kopp','','Galgenholzweg 3','','','923','032/ 636 16 16','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('180','1','1','1','1','','','Ernst','Wullschleger','','Allmendweg 7','','','666','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('181','1','1','1','1','','','Ruth','Bassin','','Arvenweg 11','','','2614','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('182','1','1','1','1','','','Theo','Schneider','','z-Hd. Frau Brunner','Gartenstrasse 12','','923','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('183','1','1','1','1','','','Markus','Frholz','','Schulhausstrasse 17','','','2604','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('184','1','1','1','','','','Kurt','Schneeberger','','Bifangstrasse 4 b','','','684','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','J');
INSERT INTO KONTAKTDATEN VALUES ('185','1','1','1','1','','','Emil','Bietenholz','','Ramisbhl 477','','','2695','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('186','1','1','1','1','','','Hlne','Gugelmann','','Baselstrasse 23','','','923','032/636 05 24','','','','','079/ 751 38 77','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('187','1','1','1','1','','','Ursula','Mgli','','Amselweg 5','','','924','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('188','1','1','1','1','','','Rosa','Bader','','Von Roll - Strasse 8','','','2691','062/ 396 33 37','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('189','1','1','1','1','','','Marianne','Wittwer','','Aarwangenstrasse 7','','','941','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('190','1','1','1','1','','','Brigitte','Anderegg','','Pfaffenthalweg 3','','','924','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('191','1','1','1','1','','','Michel','Wlti','','Bahnhofstrasse 28','','','2620','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('192','1','1','1','','','','Patrick + Claudia','Schmid -(Cueni)','','Ribimattweg 8','','','2635','032/ 672 28 89','079/292 92 50','','','','079/ 381 86 85 Claud','hallucinogen@tiscali.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','J');
INSERT INTO KONTAKTDATEN VALUES ('193','1','1','1','1','','','Jacqueline','Jenzer','','Wangenriedstrasse 6','','','680','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('194','1','1','1','1','','','Rita','Heckendorn','','Talweg 2','','','1035','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('195','1','1','1','1','','','Regula','Schaad','','Mhlegasse 7','','','924','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('196','1','1','1','1','','','Monika','Wyder','','Oberhofweg 15','','','2604','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('197','1','1','1','1','','','Jos','Rodriguez','','Burgunderstrasse 13 a','','','2603','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('198','1','1','1','1','','','Urs','Probst','','Nelkenweg 6','','','2603','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('199','1','1','1','1','','','Pegasus','Wohnheim','','z.Hd. Frau Danis','Oberdorfstrasse 72','','669','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('200','1','1','1','1','','','Erika','Stilli','','Terrassenweg 31','','','666','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('201','1','1','1','1','','','Heidi','Knuchel','','Turbenstrasse 23','','','2603','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('202','1','1','1','1','','','Lorenz','Giacometto','','Weissensteinstrasse 123','','','2606','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('203','1','1','1','1','','','Andr','Viatte - Brunner','','Weissensteinstrasse 11','','','2604','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('204','1','1','1','','','','Mary','Bossard','','Sonnackerstrasse 9 a','','','4210','041 / 761 05 45','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','J');
INSERT INTO KONTAKTDATEN VALUES ('205','1','1','1','','','','Ursula','Spahr','','Aeschistrasse 47','','','667','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','J');
INSERT INTO KONTAKTDATEN VALUES ('206','1','1','1','1','','','Tanja','Lang','','Sgetweg 10','','','924','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('207','1','1','1','1','','','Barbara','Schwarz','','Geissfluestrasse 9','','','2605','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('208','1','1','1','','','','Therese','Schaad','','Geissfluestrasse 9','','','2605','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','J');
INSERT INTO KONTAKTDATEN VALUES ('209','1','1','1','1','','','Maya','Bucher','','Geissfluestrasse 14','','','2605','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('210','1','1','1','1','','','Corinne','Stckli','','Studackerweg 42','','','2625','032/ 614 40 48','','','','','','stephan.stoeckli@besonet.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('211','1','1','1','1','','','Rita','Freiburghaus','','Weissensteinstrasse 123','','','2606','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('212','1','1','1','1','','','Mirella','De Filippi','','Bergli 1','','','2610','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('213','1','1','1','1','','','Caroline','Jggi','','Fuchsackerweg 2','','','2625','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('214','1','1','1','1','','','Kathrin','Knzig','','Stolzrtiweg 4','','','923','032/ 636 23 81','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('215','1','1','1','1','','','Karl','Fuchs','','Spiegelberg 5','','','669','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('216','1','1','1','1','','','Barbara','Ryf','','Breitmattstrasse 1','','','922','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('217','1','1','1','1','','','Beatrice','Kopp','','Neumattweg 2','','','923','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('218','1','1','1','1','','','Remo','Meer','','Ruchackerstrasse 20','','','2620','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('219','1','1','1','1','','','Daniela','Kaiser','','Brennereistrasse 10','','','2624','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('220','1','1','1','','','','Christoph','Baumgartner','','Dorfstrasse 39','','','679','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','J');
INSERT INTO KONTAKTDATEN VALUES ('221','1','1','1','1','','','Martha','Hofstetter','','Eichhof 2','','','924','032/ 636 14 71','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('222','1','1','1','1','','','Erika','Scheidegger','','Industriestrasse 5','','','923','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('223','1','1','1','','','','Dieter','Borer','','Kirchgasse','','','2676','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','J');
INSERT INTO KONTAKTDATEN VALUES ('224','1','1','1','1','','','Tanja','Lang','','Sgetweg 10','','','924','032/ 636 22 85','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('225','1','1','1','1','','','Fredi','Salvisberger','','Holzgasse 30','','','923','032/ 636 23 32','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('226','1','1','1','1','','','Claudia','Luternauer','','Netzelen 107','','','2127','062/ 754 09 60','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('227','1','1','1','1','','','Beat','Mller','','Lehmgrubenweg 4','','','25','','','','','','','sternflitzer@bluewin.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('228','1','1','1','1','','','Ursula','Kurt','','Ahornweg 4','','','923','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('229','1','1','1','1','','','Regula','Gardi','','Schachenstrasse 4','','','2621','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('230','1','1','1','1','','','Ursula','Weber - Flury','','Bielstrasse 17','','','923','032/ 636 17 16','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('231','1','1','1','1','','','Merceders','Hnzi','','Hagenackerstrasse 606','','','2676','062/ 393 28 31','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('232','1','1','1','1','','','Klri','Anderegg','','Rosenweg 7','','','924','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('233','1','1','1','','','','Marianne','Steimer','','Sonnenrainstrasse 14','','','2616','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','J');
INSERT INTO KONTAKTDATEN VALUES ('234','1','1','1','','','','Sonja','Barrer','','Hombergstrasse 36','','','2663','062/ 212 02 76','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','J');
INSERT INTO KONTAKTDATEN VALUES ('235','1','1','1','','','','Daniela','Beck','','Rainstrasse 3 a','','','2616','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','J');
INSERT INTO KONTAKTDATEN VALUES ('236','1','1','1','1','','','Rosmarie','Mller - Tschumi','','Hhenstrasse 42','','','2616','032/ 622 80 30','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('237','1','1','1','1','','','Thekla','Beutler - Recher','','Mittlerer Weg 2','','','1035','061/ 961 85 55','','','','','','thekla@gmx.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('238','1','1','1','1','','','Claudia','Stalder - Gehriger','','Drosselweg 19','','','928','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('239','1','1','1','1','','','Mary','Bossard','','Sonnackerstrasse 9 a','','','4210','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('240','1','1','1','1','','','Linda','Kurth','','Hohbhlhof','','','922','032/ 637 32 57','','','','','','linda.kurth@bluewin.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('241','1','1','1','1','','','Rosmarie','Allemann - Reist','','Hohle 2','','','923','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('242','1','1','1','1','','','','Oberaargauisches','','Pflegeheim','z.H. Frau Ldi \"Therapie\"','','923','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('243','1','1','1','1','','','','Schulhaus Oberdorf','','z.Hd.Fischer Urs','','','2691','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('244','1','1','1','1','','','Martin','Brunner','','Blauenweg 4','','','1006','','','','','','079/ 222 80 32','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('245','1','1','1','1','','','Gisela','Kummer','','Tannstrasse 6','','','2636','032/ 675 55 24','','','','','','wgkummer@freesurf.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('246','1','1','1','1','','','Barbara','Frank','','Sonnhalde 29','','','923','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('247','1','1','1','1','','','Dora','Leuenberger','','Stierenweidweg','','','923','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('248','1','1','1','1','','','Brigitte','Rthlisberger','','Humpergstrasse 22','','','683','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('249','1','1','1','1','','','Renate','Schtz','','Finkenweg 1','','','924','','','','','','','r.schuetz@ggs.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('250','1','1','1','1','','','Marianna','Zbinden','','Ferienpass Anti - Lngwilig','Hhenweg 8','','669','062/ 968 09 04','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('251','1','1','1','1','','','Erna','Zeltner','','Oberdorf 2','','','2677','062/ 393 16 64','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('252','1','1','1','1','','','Edith','Studer','','Allmendstrasse 23','','','2671','062/ 216 28 40','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('253','1','1','1','1','','','Ruth','Suter','','Oberdorfstrasse 2','','','922','032/ 637 37 69','032/ 637 13 66','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('254','1','1','1','1','','','Jaqueline','Sutter','','Montaz 10','','','393','032/ 485 13 23','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('255','1','1','1','1','','','Barbara','Tang','','Steinenbergweg 11','','','2693','062/ 391 26 20','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('256','1','1','1','1','','','Textiles Werken','Kleinklasse','','z.hd. Frau I.Schmid','','','2674','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('257','1','1','1','1','','','Gertrud','Tschanz','','Gyrischachenstrasse 36','','','686','034/ 422 35 43','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('258','1','1','1','1','','','Isabelle','Tschumi','','Gmeinmattweg 1','','','926','032/ 636 29 28','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('259','1','1','1','1','','','Sonja','Tschumi','','Ahornstrasse 15','','','2616','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('260','1','1','1','1','','','Sandra','Vgeli','','Grubenweg 3','','','2562','032/ 641 18 84','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('261','1','1','1','1','','','Evelyne','Walter','','Weihermatt 739','','','2700','062/ 391 24 56','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('262','1','1','1','1','','','Rosmarie','Walter','','Vogelherdstrasse 23','','','2691','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('263','1','1','1','1','','','Kontiki','Wohnheim','','z.hd. Frau Haller Rosmarie','Drosselweg 42','','2614','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('264','1','1','1','1','','',' Wasseramt','Kreisschule','','z.hd.Frau Scheidegger Margrith','Dgenmoosweg 4','','2625','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('265','1','1','1','','','','Karin','Schlpbach','','Schulhausstrasse 1','','','929','032/ 636 04 51','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','J');
INSERT INTO KONTAKTDATEN VALUES ('266','1','1','1','1','','','Silvia','Schmid - Frei','','Dorfgasse 88 a','','','930','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('267','1','1','1','1','','','Monique','Scholl','','Unt. Winkel 1','','','925','032/ 636 10 88','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('268','1','1','1','','','','Maja','Schranz','','Dorfgasse 8','','','587','031/ 751 54 09','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','J');
INSERT INTO KONTAKTDATEN VALUES ('269','1','1','1','1','','','Sandra','Schwaab','','Dorfstrasse 35','','','2651','032/ 677 25 92','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('270','1','1','1','','','','Jolanda','Schwander','','Lyssachstrasse 14','','','686','034/ 422 96 68','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('271','1','1','1','1','','','Sonja','Leuenberger','','Dhlenweg 3','','','684','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('272','1','1','1','1','','','Silvia','Senger','','Arvenweg 3','','','2637','032/ 675 72 22','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('273','1','1','1','1','','','Renate','Singer','','Bndliweg 7','','','2621','032/ 614 21 05','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('274','1','1','1','','','','Ursula','Spahr','','Aeschistrasse 47','','','667','062/ 961 70 28','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','J');
INSERT INTO KONTAKTDATEN VALUES ('275','1','1','1','1','','','Gabi','Spti','','Schmiedeweg','','','678','062/ 961 47 08','','','062/ 961 80 47','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('276','1','1','1','','','','Claudia','Stalder','','Drosselweg 19','','','928','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','J');
INSERT INTO KONTAKTDATEN VALUES ('277','1','1','1','','','','Ursula','Stalder','','Lehmgrubenweg 8','','','924','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','J');
INSERT INTO KONTAKTDATEN VALUES ('278','1','1','1','1','','','Renate','Kopp','','Baumgarten 15 a','','','681','062/ 963 33 16','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('279','1','1','1','1','','','Nathalie','Steiner','','Milien du Village 99','','','411','032/  481 30 18','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('280','1','1','1','1','','','Melanie','Leuenberger','','Rttistrasse 10','','','711','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('281','1','1','1','1','','','Susanne','Stettler','','Msliweg 6','','','945','062/ 922 89 89','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('282','1','1','1','1','','','Rosmarie','Mller','','Hhenstrasse 42','','','2616','032/ 622 80 30','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('283','1','1','1','1','','','Annegret','Obi','','Steingasse 12 a','','','924','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('284','1','1','1','1','','','Erika','Parrat','','Industriestrasse 5','','','923','032/  636 22 23','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('285','1','1','1','1','','','R.','Payer','','Mattweg 2','','','2628','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('286','1','1','1','1','','','Elsbeth','Phillot','','Moosstrasse 8','','','371','032/ 652 76 83','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('287','1','1','1','1','','','Marianne','Probst','','Mhlegasse 1','','','2693','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('288','1','1','1','1','','','Susanne','Probst','','Ringstrasse 1','','','923','032/ 636 36 41','','','','','','rs.probst@bluewin.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('289','1','1','1','1','','','Maria','Pugliese','','Beundenstrasse 31','','','922','032/ 637 20 07','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('290','1','1','1','1','','','Hermann','Ramseier','','Stockackerweg 3','','','2678','062/ 926 28 76','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('291','1','1','1','1','','','Clorinda','Rentsch','','Dreherhsli','','','722','034/ 496 88 65','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('292','1','1','1','1','','','Doris','Rickli','','Burach 25 a','','','681','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('293','1','1','1','1','','','Doris','Rothenbhler','','Wiesenweg 7','','','684','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('294','1','1','1','1','','','Elisabeth','Ryf','','Schulhausstrasse 2','','','929','032/ 636 25 39','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('295','1','1','1','1','','','Michel','Cueni','','Brittnauerstrasse 45','','','25','','','','','','079/ 694 85 10','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('296','1','1','1','1','','','Heidi','Schaad','','Lehmgrubenweg 1','','','924','032/ 636 37 51','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('297','1','1','1','1','','','Susanne','Schaad','','Dorfstrasse 4','','','929','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('298','1','1','1','1','','','Daniela','Gisep','','Neuweg 9','','','923','032/ 636 23 21','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('299','1','1','1','1','','','Monika','Mller','','Sonnenhofstrasse 10','','','2603','032/ 618 41 67','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('300','1','1','1','1','','','Margrith','Kser','','Linde','','','949','032/ 965 31 63','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('301','1','1','1','1','','','Edith','Kpfer','','Schalunenstrasse 30','','','710','034/ 445 17 75','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('302','1','1','1','1','','','Liane','Fiechter','','Hllstrasse 5','','','2679','062/ 926 10 52','','','','','','liane.fiechter@gmx.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('303','1','1','1','1','','','Manuela','Lehmann','','Luzernstrasse 32','','','2625','032/ 614 23 13','','','','','079/ 563 08 44','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('304','1','1','1','1','','','Anette','Leuenberger','','Sngetiweg 8','','','942','062/ 963 21 20','','','','','079/ 405 81 16','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('305','1','1','1','1','','','Donatella','Dorasz','','Buchlistrasse 20 a','','','928','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('306','1','1','1','1','','','Franziska','Schneeberger','','Lotzwilstrasse 7','','','675','062/ 922 61 84','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('307','1','1','1','1','','','Marlis','Mehr','','Erlenstrasse 39','','','2558','032/ 652 82 09','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('308','1','1','1','1','','','Elisabeth','Meier','','Dhlenweg 4','','','684','032/ 631 26 47','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('309','1','1','1','1','','','Anners','Minder','','Bnliweg 3','','','923','032/ 636 20 50','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('310','1','1','1','1','','','Marianne','Moll','','Bifngli 303','','','2677','062/ 393 14 77','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('311','1','1','1','1','','','Therese','Moll','','Gerberweg 55','','','380','032/ 331 71 70','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('312','1','1','1','1','','','Verena','Mosimann','','Oberfeldweg 12 c','','','928','032/ 633 22 17','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('313','1','1','1','1','','','Margrith','Scheidegger','','Dgenmoosweg 4','Kreisschule .Wasseramt','','2625','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('314','1','1','1','1','','','Linda','Mudoni','','Wiedlisbachstrasse 22','','','924','032/ 636 39 13','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('315','1','1','1','1','','','Esther','Mhlemann','','Sonnhalde 23','','','923','032/ 636 11 58','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('316','1','1','1','1','','','Jolanda','Mlchi','','Stockmattweg 3','','','637','032/ 679 34 38','032/ 679 04 13','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('317','1','1','1','1','','','Silvia','Haudenschild','','Gemeindehofweg 11 a','','','928','032/ 633 06 21','','','','','079/ 705 05 65','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('318','1','1','1','1','','','Esther','Hauser','','Langnauerstrasse 8','','','27','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('319','1','1','1','1','','','Barbara','Hebeisen','','Schmiedeweg 3','','','38','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('320','1','1','1','1','','','Beatrix','Hirt','','Buchen11','','','1410','026/496 08 19','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('321','1','1','1','1','','','Susette','Hirzel - Sthli','','Tannenweg 5','','','930','062/ 922 70 24','','','062/ 923 60 75','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('322','1','1','1','1','','','Monika','Hofstetter - Born','','Eichhofweg 4','','','924','032/ 636 16 09','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('323','1','1','1','1','','','Verena','Mosimann','','Gerbeweg 15','','','924','032/ 636 06 77','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('324','1','1','1','1','','','Lilian','Hosner','','Rohrmoos 31 d','','','700','','','','','','079/ 573 90 60','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('325','1','1','1','1','','','Heidi','Hlzel','','Moosstrasse 34','','','708','032/ 665 37 26','','','','','','h.hoelzel@gawnet.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('326','1','1','1','1','','','Trudy','Jenni','','Buchsweg 67 A','','','2676','062/ 393 31 08','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('327','1','1','1','1','','','Eliane','Jggi','','Bifangstrasse 4 b','','','684','032/ 631 06 56','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('328','1','1','1','1','','','Rosmarie','Kammermann','','Hhnerbhlstrasse 15','','','515','031/ 921 29 63','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('329','1','1','1','1','','','Heidi','Kaufmann','','Hasenweg 4','','','924','032/ 636 39 15','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('330','1','1','1','1','','','Roland','Herzog','','Schmittengasse 4','','','2561','','','','','','079/ 244 77 57','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('331','1','1','1','1','','','Gruppe','Krabbel','','z.hd. Frau Wildi Karin','Buchlistrasse 22','','928','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('332','1','1','1','1','','','Erika','Krebs','','Dorfstrasse 262','','','720','034/ 496 53 15','','','034/ 496 53 15','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('333','1','1','1','1','','','Annars','Krhenmann','','Lehenweg 25','','','2668','062/ 216 45 23','','','','','079/ 647 35 29','','','','1939-01-25','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('334','1','1','1','1','','','Claudia','Dhler','','Grosssackerstrasse 19','','','2640','032/ 675 46 71','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('335','1','1','1','1','','','Lydia','Dpp - Schmucki','','Lndtestrasse 6 a','','','934','062/ 922 84 81','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('336','1','1','1','1','','','Agnes','Stckli','','Schtzgasse 18','','','925','032/ 636 14 65','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('337','1','1','1','1','','','','Einwohnergemeinde','','z.hd. Frau Spti','Schulhausstrasse 15','','2637','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('338','1','1','1','1','','','Claudia','Faieta','','Heimenhausenstrasse 5','','','683','032/ 631 27 55','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('339','1','1','1','1','','','Gerda','Fankhauser','','Winkelweg 20','','','945','062/ 923 21 20','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('340','1','1','1','1','','','Anita','Flury','','Dicknaustrasse 11','','','684','032/ 633 17 89','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('341','1','1','1','1','','','Marlies','Flury','','Rttenenstrasse 40','','','2604','032/ 622 40 77','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('342','1','1','1','1','','','Marianne','Flckiger','','Rainbndtenweg 4','','','2692','062/ 393 32 37','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('343','1','1','1','1','','','Karin','Frank','','Sandgrube 42','','','2668','062/ 216 25 33','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('344','1','1','1','1','','','Daniel + Brigitta','Furrer','','Kappelenstrasse 1','','','2644','032/ 637 34 65','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('345','1','1','1','1','','','Kathrin','Furrer','','Nennigkofenstrasse 17','','','2643','     677 17 36','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('346','1','1','1','1','','','Beatrice','Gisiger','','Eschenholz 144','','','2700','062/ 391 12 19','','','062/ 391 12 19','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('347','1','1','1','1','','','Reija','Gruber','','Amselweg 20','','','2614','032/ 685 21 67','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('348','1','1','1','','','','Alexandra','Schlapbach','','Wangenstrasse 14','','','923','032/ 636 04 51','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','J');
INSERT INTO KONTAKTDATEN VALUES ('349','1','1','1','1','','','Claudia','Gubler','','Grabenacker 20','','','2624','032/ 614 25 13','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('350','1','1','1','1','','','Heidi','Hafner','','Unterer Bifang 700','','','2676','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('351','1','1','1','1','','','Eveline','Haudenschild','','Dorfstrasse 15','','','2125','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('352','1','1','1','1','','','Karin','Bannier','','Bielstrasse 50','','','923','032/ 636 01 27','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('353','1','1','1','1','','','Renate','Kelin','','Massraga','','','2343','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('354','1','1','1','1','','','Werken 1','Schulhaus Oberdorf','','z.Hd. Fr. Schenk','Buttenstr. 8','','2691','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('355','1','1','1','1','','','Lisbeth','Bernhard','','Buchenweg 1','','','922','032/ 637 18 82','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('356','1','1','1','1','','','Dora','Bickel','','Rtschelengssli 5','','','930','062/ 922 70 02','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('357','1','1','1','1','','','Verena','Bonino','','Ofenacher 5','','','2561','032/ 645 25 60','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('358','1','1','1','1','','','Veronika','Borer','','Golpen 14','','','2689','062/ 295 44 71','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('359','1','1','1','1','','','Marianne','Botschi','','von Rollstrasse 2','','','2691','062/ 396 20 85','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('360','1','1','1','1','','','Martha','Broghammer','','Spiegelbergstrasse 3','','','2623','032/ 682 05 28','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('361','1','1','1','1','','','Elisabeth','Brki','','am Weiher','','','669','062/968 18 78','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('362','1','1','1','1','','','Kerstin','Bttiker','','Haldenweg 7','','','2616','032/ 623 63 88','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('363','1','1','1','1','','','A.','De Bona','','Utzenstorfstrasse 2','','','927','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('364','1','1','1','1','','','Ursula','Deschamps','','Gavisriedweg 34','','','352','032/ 342 24 30','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('365','1','1','1','1','','','Denise','Donetta - Brunner','','Kirchgasse 18','','','923','032/ 636 12 85','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('366','1','1','1','1','','','Silvia','Ackermann','','Arvenweg 3','','','2637','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('367','1','1','1','1','','','Brigitte','Aegerter','','Kirchgasse 6','','','2623','032/ 682 48 74','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('368','1','1','1','1','','','Elisabeth','Affolter - Strub','','Ussenacher 4','','','2641','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('369','1','1','1','1','','','Regina','Allgeier','','Kleinzelgli 3','','','231','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('370','1','1','1','1','','','Aktivierungsth.','Altersheim','','z.h. U. Wyss','Einschlagweg 38','','930','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('371','1','1','1','1','','','Maria','Anton','','Hagartenstrasse 6','','','2635','032/ 672 34 62','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('372','1','1','1','1','','','Natalie','Arnold','','Tannenweg 4','','','667','062/ 961 04 14','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('373','1','1','1','1','','','Walter','Widmer','','z.Hd. Burkhalter Martha','Mattenstrasse 7','','768','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('374','1','1','1','1','','','Marianne','Jutzeler','','Wangenstrasse 13','','','923','032/ 636 12 35','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('375','1','1','1','1','','','Chr. + U.','Glanzmann','','Friedhofweg 9','','','923','032/636 06 26','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('376','1','1','1','1','','','Regula','Suter','','Felsenweg 7','','','922','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('377','1','1','1','1','','','Christine','Joye','','Dahlienweg 20','','','2624','032/ 614 33 93','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('378','1','1','1','1','','','Bernadette','Weber','','Unterbiel 73','','','1023','061/ 941 26 12','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('379','1','1','1','1','','','Morena','Romanetti','','Lehmgrubenweg 6','','','924','032/ 636 09 42','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('380','1','1','1','1','','','Andrea','Michel','','Westerholz 6','','','352','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('381','1','1','1','1','','','Sonja','Studer','','Kirchgasse 16','','','923','','','','','','079/ 215 49 43','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('382','1','1','1','1','','','Manuela','Biancini','','Jungfraustrasse 14 a','','','371','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('383','1','1','1','1','','','Michaela','Marrari','','Brunnackerweg 12','','','2624','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('384','1','1','1','1','','','Gabi','Lehmann','','Dahlienweg 14','','','2624','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('385','1','1','1','1','','','Karin','Amiet','','Mattstrasse 26','','','2621','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('386','1','1','1','1','','','Hanspeter','Hnni','','Ribibachstrasse 21','','','2638','032/ 675 44 42','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('387','1','1','1','1','','','Eveline','Krenger','','Brgglisackerweg 29','','','928','032& 633 14 21','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('388','1','1','1','1','','','Suzanna','Zurbuchen','','Hlzlisackerweg 5','','','928','032/ 633 27 58','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('389','1','1','1','1','','','Jolanda','Flck','','Sur l Crt 106','','','440','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('390','1','1','1','1','','','Brigitt','Suter','','Gewerbestrasse 5','','','379','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('391','1','1','1','1','','','Nelly','Schnider','','Dorfstrasse 8','','','2617','0327 637 14 39','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('392','1','1','1','1','','','Liliana','Fichera','','Gichenweg 19','','','2617','032/ 637 34 52','','','','','','buschu@hispeed.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('393','1','1','1','1','','','Greta','Minder','','Emmenholzweg 29','','','2614','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('394','1','1','1','1','','','Patricia','Ziegler','','Fadackerweg 16','','','2624','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('395','1','1','1','1','','','Sonja','Von Allmen Anderegg','','Brunnmattstrasse 53','','','2598','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('396','1','1','1','1','','','Ruth','Rudin','','Untergasse 20','','','924','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('397','1','1','1','1','','','Schweiz','Kinderkrebshilfe','','z.Hd. Frau Gertsch','Sonnenrain 4','','2617','','032/ 637 30 85','','032/ 637 30 16','','','info@kinderkrebshilfe.ch','','www.kinderkrebshilfe.ch','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('398','1','1','1','1','','','Pflegeheim','Oberaargauisches','','z.Hd. Frau Bula','','','923','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('399','1','1','1','1','Primarschule','','Kreisschule \"BeLoSe\"','Zweckverband','','z.Hd. Frau B. Flury','Kaselfeldstrasse 20','','2603','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('400','1','1','1','1','','','Erwin','Pflugi','','Hinter den Grten','Hornviehzunft','','1007','061 781 35 42','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('401','1','1','1','1','','','Jutta','Schild','','Stierenweidweg 11','','','923','032/ 636 05 58','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('402','1','1','1','1','','','Werken','Primarschule','','z.Hd. Frau Chr. Gerber','Erlimoosstrasse','','2561','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('403','1','1','1','1','','','Unteres Schulhaus','Werken','','z.hd. Frau Rickli','Pfarrerschmidlinweg','','2635','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('404','1','1','1','1','','','Alice','Oehrli','','Steingasse 35','','','924','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('405','1','1','1','1','','','Ruth','Schneider','','Rttenenstrasse 50','','','2604','032/ 623 29 86','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('406','1','1','1','1','','','Manuela','Schach','','Siggernweg 6','','','2618','032/ 637 29 87','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('407','1','1','1','1','','','Marianne','Allemann','','Widmeweg 19','','','924','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('408','1','1','1','1','','','Beatrice','Hippenmeyer','','Weihergasse 34','','','924','032/ 636 17 87','','','','','','b.hippenmeyer@bluewin.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('409','1','1','1','1','','','Claudia','Ischi','','Unterer Winkel 2','','','925','032/ 636 40 68','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('410','1','1','1','1','','','Rosa','Meyer','','Landstrasse 53','','','679','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('411','1','1','1','1','','','Corinne','Frommenwiler','','Hinterstdtli 15','','','923','032/ 636 32 19','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('412','1','1','1','1','','','Madlen','Sommer','','Eiche 46','','','923','032/636 05 39','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('413','1','1','1','1','','','Doris','Mller','','Brhlmattenstrasse 5','','','928','032/ 633 12 69','','','','','','doris.m@ggs.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('414','1','1','1','1','','','Myriam','Biedermann','','Rttiackerweg 2','','','2624','032/ 614 43 08','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('415','1','1','1','1','','','Elisabeth','Wirth','','Rttistrasse 7','','','673','062/ 961 61 69','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('416','1','1','1','1','','','Erika','Wendling','','Biblismattstrasse 12','','','2628','062/ 961 98 16','','','','','','eriwen@bluewin.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('417','1','1','1','','','','Erika','Wendling','','Biblismattstrasse 12','','','2628','062/ 961 98 16','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','J');
INSERT INTO KONTAKTDATEN VALUES ('418','1','1','1','1','','','Esther','Holwald','','Buchsistrasse 9','','','684','032/ 631 15 66','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('419','1','1','1','1','','','Yvonne','Saladin','','Unterdorf 127','','','2694','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('420','1','1','1','1','','','Sandra / Billi','Fluri','','Dub 23','','','2702','','','','','','076/ 318 27 54','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('421','1','1','1','1','','','Theres','Gasser','','Schmiedeweg 2','','','2638','032/ 675 35 29','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('422','1','1','1','1','','','Silvia','Huber','','Postfach 174','Gipserei Huber AG','','238','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('423','1','1','1','1','','','Trudy','Burch - Riebli','','Laubligenstrasse 7','','','2274','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('424','1','1','1','1','','','Hanni','Rebholz','','Bergstrasse 14','','','922','032/ 637 21 72','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('425','1','1','1','1','','','Silvia','Pfister','','Spiessackerstrasse 17','','','2610','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('426','1','1','1','1','','','Sonja','Bobst','','Rehgasse 417','','','2695','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('427','1','1','1','1','','','Tatiania','Marti','','Galmisweg 32','','','928','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('428','1','1','1','1','','','Ursula','Greber','','D.Schilingstrasse 32','','','2561','032/ 645 34 94','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('429','1','1','1','1','','','Paula','Stadler','','Bleichenbergstrasse 64','','','2635','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('430','1','1','1','1','','','Sabrina','Brudermann','','Hauptstrasse 70','','','2608','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('431','1','1','1','1','','','Amanda','Glutz','','Grttbachstrasse 16','','','2620','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('432','1','1','1','','','','Manuela','Bianchini','','Jungfraustrasse 14 a','','','371','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','J');
INSERT INTO KONTAKTDATEN VALUES ('433','1','1','1','1','','','Therese','Wittwer','','Schachenrain 26','','','2635','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('434','1','1','1','1','','','Britta','Anton','','Bleichenbergstrasse 15','','','2635','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('435','1','1','1','1','','','Schinznach','Kurscenter','','Veltheimerstrasse 3','z.h. Herr Sess Rolf','','94','','','','','','','www.rsu@secs.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('436','1','1','1','1','','','Mittelstufe','Schulhaus','','z.Hd. Fr. Sutter Susanne','Doktorstrssli','','928','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('437','1','1','1','1','','','Anja','Hertel','','Sonnhalde 29','','','923','032/636 04 36','','','','','','PrivateAnja@gmx.de','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('438','1','1','1','1','','','Esther','Schmid','','Siggernweg 3','','','2618','032/637 37 62','','','','','','esthischmid@bluewin.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('439','1','1','1','1','','','Verena','Sterchi','','Hauptstrasse 27','','','2620','032/682 36 88','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('440','1','1','1','1','','','Beatrice','Affolter','','Hauptstrasse 44','','','2620','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('441','1','1','1','1','','','Verena','Oehrli','','Hauacherweg 22','','','923','032/ 636 30 49','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('442','1','1','1','1','','','Marlyse','Knecht','','Bergstrasse 24','','','922','032/ 637 15 91','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('443','1','1','1','1','','','Anita und Rolf','Reber','','Schulhausstrase 43','','','2637','032/ 675 29 77','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('444','1','1','1','1','','','Esther','Gimmel','','Lingerizstrasse 77','','','2558','032/ 652 73 71','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('445','1','1','1','1','','','Susanne','Nafzger','','Gerhard Meier - Weg 13','','','928','032/ 633 15 41','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('446','1','1','1','1','','','Gisela','Ltzelschwab','','Kientalstrasse','','','850','033/ 676 21 30','','','','','','gisela@gmx.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('447','1','1','1','1','','','Annars','Wassmer','','Kirchgasse 17','','','2623','032/ 682 40 85','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('448','1','1','1','1','','','Violette','Regg','','Hofuhrenstrasse 5a','','','2621','032/ 614 34 51','','','','','078/ 845 63 66','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('449','1','1','1','1','','','Daniela','Motzet','','Finkenweg 20 A','','','928','032/ 633 04 14','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('450','1','1','1','1','','','Rita','Kolb','','Taubenreinweg 1','','','928','076/ 511 20 43','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('451','1','1','1','1','','','Theres','Zrcher','','Grnenstrasse','Postfach','','726','034/431 1824','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('452','1','1','1','','','','Elisabeth','Wirth','','Rttistrasse 7','','','673','062/961 61 69','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','J');
INSERT INTO KONTAKTDATEN VALUES ('453','1','1','1','1','','','Ursula','Widmer','','Allmend 27','','','2671','062/216 26 38','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('454','1','1','1','1','','','Sandra','Wickli','','Lnggasse 4','','','667','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('455','1','1','1','1','','','','Schulhaus Oberdorf','','Werken 1','z.Hd. Frau Bohner','','2691','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('456','1','1','1','1','','','Beatrice','Schwab','','Bifangstrasse 4 c','','','684','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('457','1','1','1','1','','','Jolanda','Schwgli','','Hauptstrasse 8','','','2639','032/675 59 05','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('458','1','1','1','','','','Renate','Schtz','','Finkenweg 1','','','924','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','J');
INSERT INTO KONTAKTDATEN VALUES ('459','1','1','1','1','','','Astrid','Sciullo','','Stampfeweg 6','','','2691','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('460','1','1','1','1','','','Heidi','Siegenthaler','','Luterbachstrasse 21','','','2621','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('461','1','1','1','1','','','Franziska','Spielmann','','Gehrenweg 3','','','2631','032/614 16 13','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('462','1','1','1','1','','','Ruth','Stampfli','','Hintergasse 18','','','2627','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('463','1','1','1','','','','Marlene','Staudenmann','','Bndtackerstrasse 22','','','2639','032/675 35 29','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','J');
INSERT INTO KONTAKTDATEN VALUES ('464','1','1','1','1','','','Elisabeth','Steffen','','Grabenmatt','','','765','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('465','1','1','1','','','','Erika','Stilli','','Terassenweg 31','','','666','062/961 10 72','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','J');
INSERT INTO KONTAKTDATEN VALUES ('466','1','1','1','1','','','Erika','Straub','','Linie','Werklehrerin','','2700','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('467','1','1','1','1','','','Jaqueline','Stuber','','Vorstadt 662','','','2694','062/391 25 60','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('468','1','1','1','1','','','Pegasus','Wohnheim','','Oberdorfstrasse 72','','','669','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('469','1','1','1','1','','','Kthy','Tschan','','Holzgasse','','','923','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('470','1','1','1','','','','Esther','Wagner','','Wangenstrasse 11','','','923','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','J');
INSERT INTO KONTAKTDATEN VALUES ('471','1','1','1','1','','','Myrtha','Weyeneth','','Dorfstrasse 4','','','925','032/636 2532','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('472','1','1','1','1','','','Susanne','Mller','','Schimmelweg 23','Krabbelgruppe','','928','032/633 22 21','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('473','1','1','1','','','','Susanne','Mller - Heiniger','','Msliweg 4','','','945','062/923 03 41','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','J');
INSERT INTO KONTAKTDATEN VALUES ('474','1','1','1','1','','','Kthy','Ntzi','','Hintere Gasse 1','','','2678','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('475','1','1','1','1','','','Pflegeheim','Oberarg.','','Kinderhort Schnggli','z.Hd.Fr. S. Felber','','923','032/636 37 22','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('476','1','1','1','','','','Gabi','Obrecht','','Allmendweg 1','','','684','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','J');
INSERT INTO KONTAKTDATEN VALUES ('477','1','1','1','1','','','M.','Oppliger','','Obere Mhlestrasse 53','','','23','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('478','1','1','1','1','','','Astrid','Perriard','','Jurastrasse 324','','','2677','062/393 28 67','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('479','1','1','1','1','','','Daniela','Portmann','','Lehngasse 17','','','2691','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('480','1','1','1','1','ZSPK','','Werken','Zentrum Sonderpdag.','','Oekingenstrasse 30','z. Hd. Fr. Flury','','2639','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('481','1','1','1','','','','Brigitte','Rthlisberger','','Humpergstrasse 22','','','683','079/374 41 30','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','J');
INSERT INTO KONTAKTDATEN VALUES ('482','1','1','1','','','','Anita','Schaller','','Ziegelacher','','','1985','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','J');
INSERT INTO KONTAKTDATEN VALUES ('483','1','1','1','1','','','Denise','Scheiben','','Sonnenhofstrasse 10','','','2603','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('484','1','1','1','1','','','Lee - Ann','Scheidegger','','Hasenmattweg 41','','','2606','032/622 90 91','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('485','1','1','1','','','','Silvia','Scheidegger','','Tulpenweg 1','','','928','032/633 29 67','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','J');
INSERT INTO KONTAKTDATEN VALUES ('486','1','1','1','1','','','Eliane','Schmutz','','Husmatt 9','','','664','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('487','1','1','1','','','','Susi','Schranz','','Sennjggel','','','948','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','J');
INSERT INTO KONTAKTDATEN VALUES ('488','1','1','1','1','','','Werken 1','Schulhaus','','Hauswirtschaft','z. Hd. Fr. J. Schmid','','2674','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('489','1','1','1','1','','','Iony','Jeanrenaud','','Hhenweg 33','','','2561','032/645 11 17','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('490','1','1','1','1','','','Bettina','Jenny','','Hausmatt 300','','','2677','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('491','1','1','1','','','','Christine','Joye','','Dahlienweg 20','','','2624','032/614 33 93','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','J');
INSERT INTO KONTAKTDATEN VALUES ('492','1','1','1','1','','','Marie','Kipfer','','Winkel 11','','','37','062/926 22 62','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('493','1','1','1','','','','Heidi','Knuchel','','Turbenstrasse 23','','','2603','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','J');
INSERT INTO KONTAKTDATEN VALUES ('494','1','1','1','1','','','Monika','Krhenbhl','','Schlossstrasse 2','','','924','032/636 39 58','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('495','1','1','1','1','','','Liesbeth','Kurth','','Weissensteinstrasse 10','','','922','032/637 23 53','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('496','1','1','1','1','','','Sandra','Knzli','','Weidstrasse 2','','','36','062/926 24 45','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('497','1','1','1','1','','','Wilma','Lauber','','Zeughausstrasse 2','','','2691','062/396 25 22','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('498','1','1','1','1','','','Petra','Lehmann','','Oberdorf 49','','','2694','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('499','1','1','1','','','','Sonja','Leuenberger','','Dhlenweg 3','','','684','032/632 14 09','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','J');
INSERT INTO KONTAKTDATEN VALUES ('500','1','1','1','1','','','Annemarie','Lthi','','Hubel','','','681','062/963 14 65','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('501','1','1','1','1','','','Evelyne','Mazzarelli','','Meisenweg 8','','','2561','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('502','1','1','1','1','','','F.','Merz - Regg','','Bahnhofstrasse 194','','','2643','032/677 18 89','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('503','1','1','1','1','','','Chantal','Moser','','Riedstrasse 30 A','','','2561','032/645 27 57','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('504','1','1','1','','','','Monika','Mller','','Sonnenhofstrasse 10','','','2603','032/618 41 67','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','J');
INSERT INTO KONTAKTDATEN VALUES ('505','1','1','1','','','','Nelly','Franic','','Falkenweg 4','','','924','032/636 36 84','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','J');
INSERT INTO KONTAKTDATEN VALUES ('506','1','1','1','','','','Barbara','Frank','','Sonnhalde 29','','','923','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','J');
INSERT INTO KONTAKTDATEN VALUES ('507','1','1','1','1','','','Urs','Frank','','Sandgrube 42','','','2668','062/216 25 33','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('508','1','1','1','','','','Rita','Freiburghaus','','Langendorfstrasse 48','','','2598','032/623 58 71','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','J');
INSERT INTO KONTAKTDATEN VALUES ('509','1','1','1','1','','','Heidi','Furter','','Heglerenstrasse 564','','','2694','062/391 35 45','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('510','1','1','1','1','','','Beatrice','Feg','','Weihergasse 5','','','924','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('511','1','1','1','1','','','Vreni','Frst','','Mittelgustrasse 35','','','2671','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('512','1','1','1','1','','','Verena','Gerber','','Kaiserstrasse 8','','','2635','032/675 28 68','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('513','1','1','1','1','','','Regula','Gertsch','','Sonnenrain 4','','','2617','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('514','1','1','1','1','','','Gabriela','Graber','','Banckerstrasse 32','','','2671','062/296 00 76','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('515','1','1','1','1','','','Regula','Heggendorn','','Buchli 23','','','928','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('516','1','1','1','1','','','Bea','Henzi','','Breitenfeld 4','','','2603','032/618 26 22','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('517','1','1','1','1','','','Daniela','Iff','','Hintergasse 157','','','952','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('518','1','1','1','1','','','Daniela','Affolter','','Theilmatt 287','','','2631','032/514 32 64','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('519','1','1','1','1','','','Anna','Balmer','','Luzernstrasse 24','','','2624','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('520','1','1','1','1','','','Katrin','Balmer','','Solothurnerstrasse 36','','','922','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('521','1','1','1','1','','','Jaqueline','Beck','','Tharadstrasse 3','','','2623','032/682 49 55','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('522','1','1','1','1','','','Manuela','Beer','','Bipperstrasse 27','','','935','032/693 13 85','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('523','1','1','1','1','','','Thoos','Bertram','','Eiche 3','','','923','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('524','1','1','1','1','','','Karin','Bickel','','Plattenstrasse 14','','','948','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('525','1','1','1','1','','','Walter','Bossert','','Bielstrasse 122','','','2558','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('526','1','1','1','1','','','Heidi','Brunner','','Randfluhweg 4','','','923','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('527','1','1','1','1','','','Rene','Br','','Wuhrmattstrasse 4','','','23','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('528','1','1','1','1','','','Ruth','Christen','','Steinackerstrasse 12','','','36','062/926 38 82','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('529','1','1','1','1','','','Ursula','David','','Kirchgasse 16','','','2623','032/682 30 86','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('530','1','1','1','1','','','Erika','Dietschi','','Herzimatt 606','','','2694','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('531','1','1','1','1','','','Marina','Egger','','Im Kupferschmied 16','','','19','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('532','1','1','1','1','','','Cornelia','Bader','','Bergstrasse 20','','','929','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('533','1','1','1','1','','','Doris','Bangard','','Oberdorf 62','','','2694','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('534','1','1','1','1','','','Elisabeth','Berger','','Weingarten 539','','','2673','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('535','1','1','1','1','','','Rosmarie','Betschart','','Staadstrasse 210','','','2558','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('536','1','1','1','1','','','Ursula','Bighetti','','Baumgartenstrasse 50','','','2558','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('537','1','1','1','1','','','Ursula','Blanc','','Forstweg 1','','','2562','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('538','1','1','1','1','','','Gisela','Boog','','Schleife 797','','','2670','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('539','1','1','1','1','','','Judith','Broch','','Braunloch','','','944','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('540','1','1','1','1','','','Denise','Buchs','','Luzernstrasse 16','','','2139','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('541','1','1','1','1','','','Margrith','Bur','','Lngackerstrasse 77','','','2562','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('542','1','1','1','1','','','Jaqueline','Brtschi','','Moosstrasse 87','','','2634','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('543','1','1','1','1','','','Stefanie','Bttig','','Grneggstrasse 11','','','1999','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('544','1','1','1','1','','','Monika','Bttikofer','','Gartenweg 2','','','2616','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('545','1','1','1','1','','','Theres','Bttikofer','','Bubengasse 84','','','2610','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('546','1','1','1','1','','','Jaqueline','Gastioni','','Neumattstrasse 31','','','992','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('547','1','1','1','1','','','Werner + Beatrix','Christ','','Gunlenfluhweg','Latexli','','2693','062/391 12 31','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('548','1','1','1','1','','','Barbara','Christen','','Buchenstrasse 1','','','2616','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('549','1','1','1','1','','','Jrene','Delfini','','Grenchenstrasse 34','','','2561','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('550','1','1','1','1','','','E.','Zedi','','Moosstrasse 28','','','2558','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('551','1','1','1','1','','','Patrick','Egli','','Feldmatt','','','2105','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('552','1','1','1','1','','','Brigitte','Fankhauser','','Kirchgasse 18','','','928','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('553','1','1','1','1','','','Christine','Fasnacht','','Moosstrasse 34','','','2558','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('554','1','1','1','1','','','Bea','Flckiger','','Erlenstrasse 22','','','2558','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('555','1','1','1','1','','','Erika','Friedli','','Eisenbahnstrasse 50 D','','','930','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('556','1','1','1','1','','','Susi','Frst','','Alte Poststrasse 8','','','2671','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('557','1','1','1','1','','','Elisabeth','Gerber','','Bittwilstrasse 15','','','669','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('558','1','1','1','1','','','Nicole','Germann','','Hauptstrasse 3','','','2698','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('559','1','1','1','1','','','Marliese','Gertsch','','Eichhlzliweg 5','','','2604','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('560','1','1','1','1','','','Hans - Ulrich','Glauser','','Bern-Zrichstrasse 19','','','708','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('561','1','1','1','1','','','Claudia','Graf','','Bittertenstrasse 3','','','2691','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('562','1','1','1','1','','','Monika','Grueb - Mosimann','','Beundtenrain 53','','','945','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('563','1','1','1','1','','','Janette','Grueb','','Kohlplatzstrasse 6','','','945','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('564','1','1','1','1','','','Jaqueline','Grtter','','Weiherweg 2','','','670','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('565','1','1','1','1','','','Elisabeth','Gunzinger','','Forstweg 16','','','2562','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('566','1','1','1','','','','Renate','Gdel - Pauli','','Dorf 57','','','951','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','J');
INSERT INTO KONTAKTDATEN VALUES ('567','1','1','1','1','','','Franziska','Gller','','Winkelweg 1','','','945','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('568','1','1','1','1','','','Isabell','Habermacher','','Niederwil','','','2102','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('569','1','1','1','1','','','Eva','Herzog','','Eschenring 38','','','27','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('570','1','1','1','1','','','Susi','Herzog','','Riedstrasse 34','','','2561','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('571','1','1','1','1','','','Caroline','Heutschi','','Byfangstrasse 4 C','','','684','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('572','1','1','1','1','','','Lotti','Hirsbrunner','','Platz','','','939','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('573','1','1','1','1','','','Lisa','Hofstetter','','Kirchrain 16','','','2012','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('574','1','1','1','1','','','Rosmarie','Huber','','Wolfgalgen 556','','','266','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('575','1','1','1','1','','','Cornelia','Hug','','Balmfluhstrasse 357','','','2610','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('576','1','1','1','1','','','Fabien','Huwyler','','Hinterbrugg','','','2083','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('577','1','1','1','1','','','Carmen','Inniger','','Reihenstrasse 9','','','2558','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('578','1','1','1','1','','','Kathrin','Janz','','Staadstrasse 93','','','2558','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('579','1','1','1','1','','','Christine','Jeanrenaud','','Freiheitsstrasse 4','','','2561','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('580','1','1','1','','','','Ursula','Jenni','','In den Grten','','','888','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','J');
INSERT INTO KONTAKTDATEN VALUES ('581','1','1','1','1','','','Nelly','Jggi','','Wolfwilstrasse 284','','','2677','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('582','1','1','1','1','','','Rita','Jggi','','Westringstrasse 22 E','','','2638','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('583','1','1','1','','','','Monika','Kamber','','Bahnhofstrasse 3','','','2677','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','J');
INSERT INTO KONTAKTDATEN VALUES ('584','1','1','1','1','','','Roland','Kaufmann','','Hundgellen','','','2086','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('585','1','1','1','1','','','Ursula','Kellerhals','','Falfenweg 3','','','928','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('586','1','1','1','1','','','Cornelia','Kissling','','Bhnestrasse 18','','','2679','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('587','1','1','1','1','','','Abita','Kneubhler','','Post','','','2066','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('588','1','1','1','1','','','Marianne','Kndel','','Allmendweg 15','','','945','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('589','1','1','1','1','','','Vreni','Kocher','','Staad 202  H','','','2558','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('590','1','1','1','1','','','Andrea','Kronenberg','','Geissacher 7','','','2103','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('591','1','1','1','1','','','Susanne','Kgi - Brauchli','','Weinhalde 8 c','','','2005','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('592','1','1','1','1','','','Marianne','Kmpfer - Gerber','','Hohle 65','','','951','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('593','1','1','1','1','','','Theres','Gysin - Knig','','Eptingerstrasse 3','Gschnggli - Egge','','1046','062/299 21 54','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('594','1','1','1','1','','','Romana','Loosli','','Neumattweg','','','923','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('595','1','1','1','1','','','Maria','Luterbacher','','Bifangstrasse 4 c','','','684','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('596','1','1','1','1','','','Daniela','Lthy','','Sternengasse 2','','','2627','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('597','1','1','1','1','','','Ruth','Marti','','Staadstrasse 224','','','2558','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('598','1','1','1','1','','','Barbara','Mathys','','Bhnerain 5','','','683','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('599','1','1','1','1','','','Claudia','Meier','','Kirchstrasse 173','','','2695','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('600','1','1','1','1','','','Michaela','Meier','','Flurstrasse 26','','','2595','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('601','1','1','1','1','','','E.','Meier- Eggenschwiler','','Neuackerstrasse 229','','','2697','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('602','1','1','1','1','','','Bernadette','Meister','','Kirchstrasse 244','','','2697','062/ 394 19 04','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('603','1','1','1','1','','','Nadia','Misteli','','Rainstrasse 43','','','2614','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('604','1','1','1','1','','','Doris','Monnori','','Juraweg 68','','','679','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('605','1','1','1','1','','','Esther','Moro','','Quellenweg 13','','','928','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('606','1','1','1','1','','','Nelly','Moser','','Gartenstrasse 19','','','2558','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('607','1','1','1','1','','','Silvia','Moser','','Hfliweg 9','','','945','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('608','1','1','1','1','','','Sonja','Mder','','Hasenweg 518','','','2670','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('609','1','1','1','1','','','Heidi','Mller - Loosli','','Wylstrasse 117','','','2631','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('610','1','1','1','1','','','Silvia','Neuenschwander','','Aerbolligen','','','956','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('611','1','1','1','1','','','Tina','Nyffenegger','','Winkelweg 24','','','945','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('612','1','1','1','','','','Helga','Oliva','','Neumattstrasse 2','','','2636','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','J');
INSERT INTO KONTAKTDATEN VALUES ('613','1','1','1','1','','','Heidi','Peter','','Tharadstrasse 12','','','2623','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('614','1','1','1','1','','','Daniela','Petrig','','Haus Lotus','','','4074','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('615','1','1','1','1','','','Therese','Plss - Wermuth','','Hnggerstrasse 668','','','2694','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('616','1','1','1','1','','','','Primarschule','','Werken 1','z. Hd. Fr. Jggi Verena','','2700','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('617','1','1','1','','','','A.','Probst - von Bren','','Nelkenweg 6','','','2603','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','J');
INSERT INTO KONTAKTDATEN VALUES ('618','1','1','1','1','','','Karin','Reinhard','','Kleinfeldstrasse 20','','','371','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('619','1','1','1','1','','','Kthy','Reist','','Sonnrain 3','','','670','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('620','1','1','1','1','','','Cornelia','Renggli','','Chommlen','','','2103','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('621','1','1','1','1','','','Veronika','Rentsch','','Bahnhofstrasse 42','','','930','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('622','1','1','1','1','','','Susanne','Richard','','Schafnaustrasse 1','','','2621','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('623','1','1','1','1','','','Dominique','Rohrbach','','Wilerstrasse 32','','','2636','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('624','1','1','1','1','','','Barbara','Rohrer','','Stapfmatt 281','','','2697','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('625','1','1','1','1','','','Roland','Roth','','Stapfmatt','','','2697','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('626','1','1','1','','','','Therese','Rz','','Staad 238','','','2558','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','J');
INSERT INTO KONTAKTDATEN VALUES ('627','1','1','1','1','','','Pierina','Saladin','','Brhlweg 22','','','2595','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('628','1','1','1','1','','','Dorli','Schaad','','Staadstrasse 213','','','2558','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('629','1','1','1','','','','Ruth','Schaad','','Pfaffenthalweg 1','','','924','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','J');
INSERT INTO KONTAKTDATEN VALUES ('630','1','1','1','1','','','Edith','Scheidegger','','Schleife 798','','','2670','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('631','1','1','1','1','','','Monika','Scheidegger','','Rotweg','','','1985','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('632','1','1','1','1','','','Elisabeth','Scheppis','','Clacisstrasse 1','','','2598','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('633','1','1','1','1','','','Claudia','Scheurer','','Staadstrasse 186','','','2558','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('634','1','1','1','1','','','Regina','Schmuck','','Dorfstrasse 25','','','662','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('635','1','1','1','1','','','Marianne','Schnider','','Lebernstrasse 62','','','2558','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('636','1','1','1','','','','Claire','Schwegler','','Hubelweg 34','','','666','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','J');
INSERT INTO KONTAKTDATEN VALUES ('637','1','1','1','1','','','Esther','Schr','','Rmerbrunnenweg 23','','','2558','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('638','1','1','1','1','','','Marliese','Schr','','Wiesenstrasse 21','','','941','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('639','1','1','1','1','','','Aurora','Schrer','','Winkelweg 18','','','945','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('640','1','1','1','1','','','Barbara','Simon','','Gssli 6','Postfach','','943','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('641','1','1','1','1','','','Esther','Simon','','Murmeliweg 4','','','924','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('642','1','1','1','1','','','Irene','Singer','','Balmbergstrasse 2','','','922','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('643','1','1','1','1','','','Beatrix','Sommer','','Burghof','','','2561','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('644','1','1','1','1','','','Monika','Spaar','','Bndliweg','','','2674','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('645','1','1','1','1','','','Bertha','Sperreisen','','Grothweg 29','','','2558','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('646','1','1','1','1','','','Heidi','Sperreisen','','Staad 232','','','2558','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('647','1','1','1','1','','','Janette','Spycher','','Mittenweg 11','','','2638','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('648','1','1','1','1','','','Susi','Stauffer','','Staad 246','','','2558','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('649','1','1','1','1','','','Rosmarie','Steffen','','Aareweg 11','','','621','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('650','1','1','1','1','','','Ursula','Steffen','','Bourbakiweg','','','1985','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('651','1','1','1','1','','','Barbara','Steiger','','Bahnstrasse 2','','','945','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('652','1','1','1','','','','Peter','Stermcnik','','Oberdorfstrasse 72','Rssli H','','669','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','J');
INSERT INTO KONTAKTDATEN VALUES ('653','1','1','1','1','','','Belinda','Stich','','Rbackerstrasse 38','','','1010','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('654','1','1','1','1','','','Catherine','Stolzer','','Tharadstrasse 16','','','2623','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('655','1','1','1','1','','','Cornelia','Streuli','','Ischlagweg 2','','','2561','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('656','1','1','1','1','','','Verena','Studer','','Chrzi 4','','','929','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('657','1','1','1','1','','','Stefanie','Stutz','','Riedstrasse 63','','','2561','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('658','1','1','1','1','','','Renate','Suter','','Sonnenrainweg 1','','','928','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('659','1','1','1','1','','','Esther','Tschumi','','Unterholz 10','','','684','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('660','1','1','1','1','','','Ursula','Vangelista','','Belchenweg 11','','','942','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('661','1','1','1','','','','Alice','Vogt - Lderach','','Riedstrasse 47','','','2561','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','J');
INSERT INTO KONTAKTDATEN VALUES ('662','1','1','1','1','','','Therese','Vogt','','Jurastrasse 115','','','2558','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('663','1','1','1','1','','','Margrith','von Burg - Hofer','','Dorfstrasse 25','','','2561','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('664','1','1','1','1','','','Vreni','von Burg','','Grossmattstrasse 12','','','2643','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('665','1','1','1','1','','','Vreni','Bur','','Lngmattweg 5','','','2562','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('666','1','1','1','1','','','Eliane','Wagner','','Riedgasse','','','934','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('667','1','1','1','1','','','Beatrice','Walter','','Hofmattenweg 6','','','651','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('668','1','1','1','1','','','Ruth','Wehrli','','Schlsselmattweg 2','','','928','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('669','1','1','1','1','','','Valeria','Weibel','','Ziegelmattstrasse 26','','','548','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('670','1','1','1','1','','','Ruth','Wenga','','Neue Zelg','','','2561','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('671','1','1','1','1','','','Hubersdorf','Primarschulhaus','','z.H. Frau Wyss','','','2618','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('672','1','1','1','1','','','B.','Wingeler','','Hasenmattstrasse 44A','','','2561','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('673','1','1','1','1','','','Anita','Wirz','','Weissensteinstrasse 6','','','667','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('674','1','1','1','1','','','\"Werkgruppe\"','TLG  Calendula','','Oberstrasse 36','z.Hd. Frau Crausaz','','666','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('675','1','1','1','1','','','Patricia','Schertenleib','','Riemberghof','','','2645','032/ 621 95 28','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('676','1','1','1','1','','','','Schulhaus','','Wiedlisbachstrasse 5','z.Hd. Frau Rubin','','924','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('677','1','1','1','1','','','Pflegeheim','Oberaargauisches','','\"Aktivierungs-Therapie\"','z.H. Frau S. Mller','','923','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('678','1','1','1','1','','','Iris','Iseli','','Kirchgasse 14','','','928','','','','','','079 309 44 62','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('679','1','1','1','1','','','Sandra','Fuhrimann','','Bachweg 52','','','2666','062/ 212 21 04','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('680','1','1','1','1','','','Sabrina','Rthlisberger','','Schleife 47','','','2670','','','','','','','sabi.r @ freesurf.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('681','1','1','1','1','','','E.','Tschannen','','Moosbrunnstrasse 1','','','712','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('682','1','1','1','1','','','Martha','Hasik','','Mhlegasse 4','','','924','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('683','1','1','1','1','','','Regula','Jakob','','Narzissenweg 1','','','2635','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('684','1','1','1','1','','','Sarah','Schnider','','Burgweg 3','','','2691','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('685','1','1','1','1','','','Barbara','Berger','','Finkenweg 1','','','684','032/ 631 11 29','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('686','1','1','1','1','','','Janet','Niederhuser','','Rossackernweg 14','','','923','032/ 636 11 88','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('687','1','1','1','1','','','Alexandra','Mller','','Steingasse 26 b','','','924','032/ 636 26 49','','','','','','schnaeg2@bluewin.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('688','1','1','1','1','','','Patricia','Peter','','Nordstrasse 9','','','2620','032/ 682 25 86','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('689','1','1','1','1','','','Denise','Suter','','Baselstrasse 3','','','2615','032/ 623 80 13','','','','','','Schmuerzi@bluewin.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('690','1','1','1','1','','','Lydia','Bader','','Brunnenweg 11','','','2691','062/ 396 21 11','','','','','','babru11@bluewin.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('691','1','1','1','1','','','Merhaba','Schaich','','Hegi 36','','','2676','062/ 393 29 11','','','','','','merhabart@bluewin.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('692','1','1','1','1','','','Cornelia','Gunziger','','Brunnenweg 10','','','2691','062/ 393 36 26','','','','','','c.gunziger@csb-system.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('693','1','1','1','1','','','Yvonne','Rogenmoser','','Wiedlisbachstrasse 26','','','924','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('694','1','1','1','1','','','Marcela','Kricke','','Dorfstrasse 1','','','685','032/ 631 00 53','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('695','1','1','1','1','','','Jaqueline','Bieli','','Mettelen 242','','','2696','062/ 394 12 23','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('696','1','1','1','1','','','Lisbeth','Nydegger','','Im Grngli 123','','','2609','032/ 637 20 83','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('697','1','1','1','1','','','Kthy','Minder','','Herrengasse 3','','','924','032/ 636 28 56','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('698','1','1','1','1','','','','Graber','','Dorfstrasse 7','','','684','032/ 631 16 37','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('699','1','1','1','1','','','Simon','Lutz','','Hagenbuchenstrasse 25','','','1010','061/781 22 74','','','','','079/ 479 04 20','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('700','1','1','1','1','','','Daniel','Bader','','Grod 282','','','27','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('701','1','1','1','1','Msli - Zentrum','','Beatrice','Schwab','','Waldstrasse 54','Betreuung und Pflege im Alter','','711','','032/666 45 11','','','032/666 45 12','','','info@zentrummoesli.ch','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('702','1','1','1','1','Kindergugge Sprisseli','','Jaqueline','Junker','','Dammstrasse 25','','','2614','032/685 25 94','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('703','1','1','1','1','','','Anita','Fhndrich','','Schnenboden 3','','','2033','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('704','1','1','1','1','','','urs','roth','','Adressnderung','','','4578','','','','','','','ap.ursroth@gawnet.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('705','1','1','1','1','','','Pflegeheim','Oberaargauisches','','z.H. Herr Furrer','','','923','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('706','1','1','1','1','','','Pflegeheim','Oberaargauisches','','z.H. Herr Bluem Beat','','','923','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('707','1','1','1','1','','','\"Tango\"','Gruppe','','Wohnheim im Dorf','Hauptstrasse 6','','675','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('708','1','1','1','1','','','Doris','Rohn','','Bielstrasse 48','','','923','032/636 23 01','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('709','1','1','1','1','','','Doris','Neeser','','Bhlenweg 7','','','923','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('710','1','1','1','1','','','Hanna','Schpfer','','Tulpenweg 9','','','924','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('711','1','1','1','1','','','Sandro','Leuenberger','','Bhlenweg 7','','','923','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('712','1','1','1','1','','','Sonja','Kurt','','Erlenweg 12','','','2623','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('713','1','1','1','1','','','Corinne','Niederhauser','','Kaselfeldstrasse 43','','','2603','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('714','1','1','1','1','','','Nia','Perrey','','Schulhausstrasse 6','','','683','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('715','1','1','1','1','','','Nathalie','Arnold','','Tannenweg 4','','','667','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('716','1','1','1','1','','','Claudia','Gubler','','Grubenacker 20','','','2624','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('717','1','1','1','1','','','Alexandra','Mller','','Schulhausstrasse 1','','','928','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('718','1','1','1','1','','','Marlyse','Knecht','','Bergstrasse 21','','','922','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('719','1','1','1','1','','','Dora','Sommer','','Feldweg 10','','','683','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('720','1','1','1','1','','','Ruth','Bchler','','Bahnhofstrasse 5','','','924','','','','','','','Ruth.Bchler@bluewin.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('721','1','1','1','1','','','Eveline','Maurhofer','','Lehmgrubenweg 8','','','924','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('722','1','1','1','1','','','Mariannne','Toscan','','Bifangstrasse 4','','','684','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('723','1','1','1','1','','','Heidi','Engetschwiler','','Hauptstrasse 15','Gewerbeverein','','2623','','','','','','079/250 39 70','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('724','1','1','1','1','','','Regula','Gardi','','Schachenstrasse 4','','','2621','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('725','1','1','1','1','','','Mittelstufe','Schulhaus','','z.H. Frau Hunziker','Doktorstrssli','','928','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('726','1','1','1','1','','','Irene','Althaus','','Ksereistrasse 1','','','680','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('727','1','1','1','1','','','','Kreisschule','','z. Hd. Hr. Ryser','','','2617','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('728','1','1','1','1','','','Oberbipp','Volksschule','','Frau Schtz','','','924','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('729','1','1','1','1','','','Nicole','Baumberger','','Moosgssli 12','','','708','','','','','','','info@d-baumberger.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('730','1','1','1','1','','','Ursula + Hansueli','Anderegg','','Pfaffenthalweg','','','924','032/ 636 25 42','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('731','1','1','1','1','','','Zelgli','Oberstufe','','z.H. Frau Lutz Haase','','','2614','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('732','1','1','1','1','Kreisschule','','BE - LO - SE','Schulhaus 1','','Turnerweg','z.H. Frau Dummermuth','','2562','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('733','1','1','1','1','','','Pflegeheim','Oberaargauisches','','KITA / Schnggli','z.H. Frau Zimmerli','','923','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('734','1','1','1','1','','','z.H. Frau Affolter','Kindergarten','','Haldenweg 1','','','2614','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('735','1','1','1','1','','','Pflegeheim','Oberaargauisches','','Schnggli','z.H. Frau Zimmerli','','923','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('736','1','1','1','1','','','Brangre','Nikli','','Chemin des Tires 3','','','2162','032/731 89 49','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('737','1','1','1','1','','','Kthy','Krathiger','','Meisenweg 4','','','924','032/ 636 17 06','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('738','1','1','1','1','','','Ariane','Bopp','','Ltthogerweg 1','','','923','032/ 636 05 19','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('739','1','1','1','1','','','Martha','Staubitzer','','Jurastrasse 14','','','680','062/ 961 32 04','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('740','1','1','1','1','','','Sandra','Flck','','Wehribachstrasse 1','','','923','032/ 636 14 44','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('741','1','1','1','1','','','Ruth','Liechti','','Klebenstrasse 49','','','933','062/ 922 07 47','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('742','1','1','1','1','','','Pia','Schlup','','Hasengasse 1','','','925','032/ 636 02 40','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('743','1','1','1','1','','','Martha','Allemann','','Sonnhalde 25','','','923','032/ 636 34 43','','','','','','almarola25@hotmail.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('744','1','1','1','1','','','Corinne','Ruch','','Stierenweidweg 3','','','923','032/ 636 2589','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('745','1','1','1','1','','','Barbara','Christen','','Gerackerstrasse 14','','','2610','076/ 441 53 74','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('746','1','1','1','1','','','Helene','Hrzeler','','Reckenkien 91','','','2700','062/ 391 37 43','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('747','1','1','1','1','','','Pflegeheim','Oberaargauisches','','z.H. Frau Amach Sybille','','','923','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('748','1','1','1','1','','','','Primarschule','','z.H. Frau Wyss','Frankbuchserstrasse 7','','2598','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('749','1','1','1','1','','','Feldbrunnen','Primarschule','','z.H. Frau Eng','','','2615','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('750','1','1','1','1','','','Pflegeheim','Oberaargauisches','','z.H. Frau Frey','','','923','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('751','1','1','1','1','','','Orietta','Felber','','Gummenweg 1a','','','925','032/ 636 13 39','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('752','1','1','1','1','','','Sanella','Heimann','','Winkelstrasse 27','','','20','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('753','1','1','1','1','','','Cornelia','Schmid','','Bhlenweg 9a','','','923','032/636 30 69','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('754','1','1','1','1','','','Susanna','Jost','','Kirchweg 6','','','683','032/631 28 16','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('755','1','1','1','1','','','Christine','Bichsel','','Rttistrasse 5','','','2617','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('756','1','1','1','1','','','Dagmar','Mahni','','Riedstrasse 47','','','2561','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('757','1','1','1','1','','','Janine','Cartier','','Jurastrasse 30','','','2677','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('758','1','1','1','1','','','Elsbeth','Anliker','','Bahnhofstrasse 1','','','941','062/ 961 22 80','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('759','1','1','1','1','','','Rosmarie','Kurth','','Oberdorfstrasse 8','','','922','032/ 637 12 65','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('760','1','1','1','1','','','Sybillle','Ramseier','','Lrchenweg 12','','','668','062/961 05 74','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('761','1','1','1','1','','','Wohnheim Matzendorf','Genossenschaft VEBO','','Fluri Petra','Dorfstrasse 29','','2695','','062/ 394 23 25','','062/ 394 22 19','','','wh1.matzendorf@vebo.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('762','1','1','1','1','','','Maja','Bachmann','','Schmiedengasse 9','','','683','032/ 631 26 86','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('763','1','1','1','1','','','Christine','Leibundgut','','Drfli 7 a','','','940','062/ 927 11 15','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('764','1','1','1','1','','','Esther','Schertenleib','','Lrchenweg 5','','','668','062/ 961 60 46','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('765','1','1','1','1','','','Sandra','Bucher','','Brchhsliweg 1','','','2693','062/ 391 25 08','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('766','1','1','1','1','','','Renate','Schwarz','','Kapellenweg 9','','','943','062/ 929 31 32','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('767','1','1','1','1','','','Silviana','Knzig','','Bliweg 2','','','924','032/ 636 20 48','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('768','1','1','1','1','','','Amelie','Ernst','','Bollgasse 5','','','924','032/ 636 17 43','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('769','1','1','1','1','','','Beatrice','Hofer','','Dorfstrasse 142','','','2674','062/ 398 42 07','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('770','1','1','1','1','','','Karin','Ryser','','Hnikenstrasse 3','','','2631','032/614 12 40','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('771','1','1','1','1','','','Sabrina','Gall','','Stockrain 7','','','923','','','','','','077/ 441 40 20','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('772','1','1','1','1','','','Ruth','Stuber','','Schachenstrasse 19','','','2620','032/682 65 74','','','','','','stuber.r@bluewin.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('773','1','1','1','1','','','Margareta','Kull','','Sager 163 a','','','960','062/ 966 01 24','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('774','1','1','1','1','','','Nicole','Wolf','','Vorstettli 2','','','2610','032/637 16 22','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('775','1','1','1','1','','','Ursula','Bloch','','Obere Drmhle 20','','','928','032/ 633 10 71','','','','','','beatbloch@ggs.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('776','1','1','1','1','','','Daniela','Kellerhals','','Birkenweg 9','','','928','032/636 06 60','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('777','1','1','1','1','','','Franz','Morone','','Amselweg 5','','','928','032/ 633 17 31','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('778','1','1','1','1','','','Heidi','Schindelholz','','Oberfeldweg 2','','','2693','','','','','','','heidi.sch-holz@bluewin.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('779','1','1','1','1','','','Isabella','Kohl','','Friedhofweg 1','','','923','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('780','1','1','1','1','','','z.H. Frau Widmer Eva','Perosa AG Littau','','Abteilung Dekoration','Weissensteinstrasse 8','','923','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('781','1','1','1','1','','','','Volksschule','','z.H. Frau Rubin','Wiedlisbacherstrasse 5','','924','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('782','1','1','1','1','','','Karin','Flhmann','','Bilestrasse 26','Gewerbeverein','','923','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('783','1','1','1','1','','','Brigitte','Wyss','','Wiesengrund 5','','','2679','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('784','1','1','1','1','***','','','Primarschule','','z.H. Frau Walker','Kaselfeldstrasse 20','','2603','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('785','1','1','1','1','***','','Werken 1','Primarschule','','z.H. Herr Grimm','Kaselfeldstrasse 20','','2603','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('786','1','1','1','1','','','Bechburg','Kreisschule','','z.H. Frau Schmid','Jurastrasse 4','','2691','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('787','1','1','1','1','','','Pflegeheim','Oberaargauisches','','z.H. Herr Kraul','','','923','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('788','1','1','1','1','','','Jolanda','Schwgli','','Vale','','','3150','079/752 25 07','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('789','1','1','1','1','','','Erika','Hgi','','Brunnenweg 3','Kirchgemeinde','','928','032/633 18 52','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('790','1','1','1','1','','','Pflegeheim','Oberaargauisches','','Abteilung Therapie','z.H. Frau Schenk','','923','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('791','1','1','1','1','','','','Hnggi','','HPS Balsthal','Falkensteinerstrasse','','2693','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('792','1','1','1','1','Mitteldorfschulhaus','','','Primarschule','','z. Hd. Frau R. Luterbacher','Hauptstrasse 45','','2623','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('793','1','1','1','1','','','','Tomexpo AG','','z.H. Herr Affendranger','Gartenstrasse','','923','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('794','1','1','1','1','','','Andrea','Cueni','','Allmendstrasse 23','','','2558','032/652 51 78','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('795','1','1','1','1','','','Margrith','Ntzi - Studer','','Kestenholzstrasse 40','','','2678','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('796','1','1','1','1','Schulzentrum','','Th.','Baumann','','Schllerstrasse 1','Postfach','','2623','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('797','1','1','1','1','Frau','','Franziska','Wyss','','Primarschule','Herr Rudolf Wyss','','2563','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('798','1','1','1','1','Marktgemeinde Gurk','','Judith','Witschnig','','Dr. Schnerichstrasse 12','Fremdenverkehrsamt','','4579','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('799','1','1','1','1','Firma','','','Tomwood AG','','Gartenstrasse 4','','','923','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('800','1','1','1','','','','Jrg','Thrier','','Sigihang 32','','','2031','041/448 47 47','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('801','1','1','1','1','','','','Sekundarschule','','Bielstrasse 10','','','923','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('802','1','1','1','1','','','Angela','Heiniger','','Emmentalstrasse 13','','','686','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('803','1','1','1','1','ideefix gmbh','','Daniel','Meier','','Bahnhofstrasse 5','','','2673','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('804','1','1','1','1','YOPA GmbH','','Marylyn','Knuchel','','Vorstadt 4','','','684','','032/631 60 75','','','032/631 60 79','','','marylyn.knuchel@yopa.ch','www.yopa.ch','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('805','1','1','1','1','','','Rita','Sutter','','Unterfeldweg 4','','','2643','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('806','1','1','1','1','','','Eliane','Baschung','','Strasse','','','2598','','','','','','','eliane.baschung@ggs.ch','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('807','1','1','1','1','Firma BKS','','','Kabelservice AG','','Fabrikstrasse 8','Abt. Konfektion','','2623','','032/681 54 54 (39)','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('808','1','1','1','1','SRO AG','','Silvia','Reusser / Frau Schr','','Pflegedienstleiterin','Stelliweg 24','','666','','062 955 52 25','','','062 955 51 95','','','s.reusser@sro.ch','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('809','1','1','1','1','','','Petra','Meyer','','Bergstrasse 12','','','922','032/637 10 09','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('810','1','1','1','1','','','','B. Niccli','','Chemain','Bestirs 3','','2162','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('811','1','1','1','1','','','Nicli','Brangre','','Ch des Tires 3','','','2162','032/ 731 89 49','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('812','1','1','1','','','','Laura','Tommila','','Stierenweidweg','','','923','','','','','','078 689 20 60','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('813','2','2','1','3','','','Theres','Cueni','','Gartenstrasse 4','','','922','','','','','','','','','','1000-01-01','','','','','','','','','','','','','J','N','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('814','2','2','1','2','','','Claudia','Cueni','','Gartenstrasse 4','','','923','','','','','','','','','','1000-01-01','','','','','','','','','','','','','J','N','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('815','1','2','1','','Lebensgarten Aktivierung','Bleichenmatt','','Lomitana','','Schachenstrasse 5','','','2635','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('816','1','1','1','','','','Sarah','Eggenberger','Ref. Kirchgemeinde','Kirchgase 13','','','928','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('817','1','1','1','','Delphin Healing GmbH','','Sandra','Jrg - Flury','','Sptrain 11','','','56','','062 723 04 47','032 631 17 63','','062 723 08 62','','','delphin-healing.ch','','1000-01-01','','','','','','','','','','','','','N','N','J','N','N');
INSERT INTO KONTAKTDATEN VALUES ('818','1','1','1','','Delphin - Healing GmbH','','Sandra','Jrg - Flury','','Sptrain 11','','','56','032 631 17 63','062 723 04 47','','062 723 08 62','','','sandra.joerg@delphin-healing.ch','www.delphin-healing.ch','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('819','1','1','1','','Regionales','','','Arbeitszentrum','','Oberholzweg 14','','','666','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('820',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'N','N','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('821','1','1','1','','Kultur Plus','','','z. Hd. Studer Carina','','Gemeinde Oberbuchsiten','','','2676','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('822','1','1','1','','Oberstufe Verband','Zentrum Wiedlisbach','','z.H. Frau Pamuk','','Bielstrasse 10','','','923','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('823','1','1','1','','Alterswohnheim Riedli','','','z.H. Frau Kohler B.','','Riedgasse 24','','','934','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('824','1','1','1','','Frauenverein','','Andrea','Zeltner','','Wolfwilerstrasse 83','','','2677','','062 393 08 53','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('825','1','1','1','','','','','Jggi Inge','','Schachenstrasse 11','','','2635','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('826','1','1','1','','Primarschule','','','z.H. Frau M. Emch','','Scheibenstrasse 1','','','26','','','','','','','','','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');
INSERT INTO KONTAKTDATEN VALUES ('827','1','1','1','','Freudiger Gartenpflege','','','Lukas Freudiger','','Neuweg 8','','','923','','','','','','076 395 77 76','','lukas.freudiger@bluewin.ch','','1000-01-01','','','','','','','','','','','','','N','J','N','N','N');



#
# TABLE 'KREDITOREN'
#
drop table if exists `KREDITOREN`;

create table `KREDITOREN` (
  `KREDITOR_ID` int(3) Not Null auto_increment,
  `KREDITOR_NR` varchar(10),
  `KUNDEN_NR` varchar(20),
  `KREDITOR_ART_PF` char(3),
  `NAE_FREIE_ARTNR` varchar(10) Not Null,
  `KONTAKTDATEN_ID` int(10) Default '0' Not Null,
  `SKONTO_TAGE` int(2),
  `SKONTO_PROZENT` decimal(5,2),
  `ZAHLUNGSZIEL` int(3),
  `USTID` varchar(20),
  `KREDITOR_SEIT` date Default '0000-00-00' Not Null,
  `ANMERKUNGEN` blob,
  `UVP_BINDUNG` enum('J','N') Default 'N' Not Null,
  `KREDITLIMIT` decimal(8,2),
  `GELOESCHT` enum('J','N') Default 'N' Not Null,
  `RABATT_PROZENT` decimal(5,2),
  PRIMARY KEY (KREDITOR_ID),
  UNIQUE KEY KREDITOR_ID (KREDITOR_ID)
);


#
# TABLE 'KREDITOREN' DATA
#
INSERT INTO KREDITOREN VALUES ('1','100','','','1','817','0','0','0','','2011-08-17','','N','0','N','10');



#
# TABLE 'LAENDER'
#
drop table if exists `LAENDER`;

create table `LAENDER` (
  `LAND_ID` int(4) Not Null auto_increment,
  `LAND` varchar(64),
  `LAND_E` varchar(64),
  `ISO_ALPHA2` char(2),
  `ISO_ALPHA3` char(3),
  `ISO_NUM` int(5),
  `TLD` varchar(5),
  `VORWAHL` varchar(6),
  `WAEHRUNG` varchar(30),
  `EU_LAND` enum('J','N') Default 'N',
  `GELOESCHT` enum('J','N') Default 'N',
  PRIMARY KEY (LAND_ID),
  KEY IDX_COUNTRIES_NAME (LAND_E)
);


#
# TABLE 'LAENDER' DATA
#
INSERT INTO LAENDER VALUES ('1','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('2','Afghanistan','Afghanistan','AF','AFG','4','.af',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('3','gypten','Egypt','EG','EGY','818','.eg',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('4','land','Aland','AX','ALA','248','.ax',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('5','Albanien','Albania','AL','ALB','8','.al',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('6','Algerien','Algeria','DZ','DZA','12','.dz',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('7','Amerikanisch-Ozeanien (US Minor Outlying Islands)','United States Minor Outlying Islands','UM','UMI','581','.um',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('8','Amerikanisch-Samoa','American Samoa','AS','ASM','16','.as',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('9','Amerikanische Jungferninseln','Virgin Islands (U.S.)','VI','VIR','850','.vi',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('10','Andorra','Andorra','AD','AND','20','.ad',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('11','Angola','Angola','AO','AGO','24','.ao',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('12','Anguilla','Anguilla','AI','AIA','660','.ai',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('13','Antarktis','Antarctica','AQ','ATA','10','.aq',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('14','Antigua und Barbuda','Antigua and Barbuda','AG','ATG','28','.ag',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('15','quatorialguinea','Equatorial Guinea','GQ','GNQ','226','.gq',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('16','Argentinien','Argentina','AR','ARG','32','.ar',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('17','Armenien','Armenia','AM','ARM','51','.am',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('18','Aruba','Aruba','AW','ABW','533','.aw',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('19','Aserbaidschan','Azerbaijan','AZ','AZE','31','.az',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('20','thiopien','Ethiopia','ET','ETH','231','.et',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('21','Australien','Australia','AU','AUS','36','.au',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('22','Bahamas','Bahamas','BS','BHS','44','.bs',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('23','Bahrain','Bahrain','BH','BHR','48','.bh',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('24','Bangladesch','Bangladesh','BD','BGD','50','.bd',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('25','Barbados','Barbados','BB','BRB','52','.bb',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('26','Belarus (Weirussland)','Belarus','BY','BLR','112','.by',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('27','Belgien','Belgium','BE','BEL','56','.be',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('28','Belize','Belize','BZ','BLZ','84','.bz',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('29','Benin','Benin','BJ','BEN','204','.bj',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('30','Bermuda','Bermuda','BM','BMU','60','.bm',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('31','Bhutan','Bhutan','BT','BTN','64','.bt',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('32','Bolivien','Bolivia','BO','BOL','68','.bo',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('33','Bosnien und Herzegowina','Bosnia and Herzegowina','BA','BIH','70','.ba',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('34','Botswana','Botswana','BW','BWA','72','.bw',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('35','Bouvetinsel','Bouvet Island','BV','BVT','74','.bv',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('36','Brasilien','Brazil','BR','BRA','76','.br',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('37','Britische Jungferninseln','Virgin Islands (British)','VG','VGB','92','.vg',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('38','Britisches Territorium im Indischen Ozean','British Indian Ocean Territory','IO','IOT','86','.io',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('39','Brunei Darussalam','Brunei Darussalam','BN','BRN','96','.bn',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('40','Bulgarien','Bulgaria','BG','BGR','100','.bg',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('41','Burkina Faso','Burkina Faso','BF','BFA','854','.bf',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('42','Burundi','Burundi','BI','BDI','108','.bi',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('43','Ceuta, Melilla',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('44','Chile','Chile','CL','CHL','152','.cl',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('45','China, Volksrepublik','China','CN','CHN','156','.cn',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('46','Cookinseln','Cook Islands','CK','COK','184','.ck',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('47','Costa Rica','Costa Rica','CR','CRI','188','.cr',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('48','Cte d\'Ivoire (Elfenbeinkste)','Cote D\'Ivoire','CI','CIV','384','.ci',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('49','Dnemark','Denmark','DK','DNK','208','.dk',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('50','Deutschland','Germany','DE','DEU','276','.de','49','EUR','J','N');
INSERT INTO LAENDER VALUES ('51','Dominica','Dominica','DM','DMA','212','.dm',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('52','Dominikanische Republik','Dominican Republic','DO','DOM','214','.do',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('53','Dschibuti','Djibouti','DJ','DJI','262','.dj',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('54','Ecuador','Ecuador','EC','ECU','218','.ec',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('55','El Salvador','El Salvador','SV','SLV','222','.sv',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('56','Eritrea','Eritrea','ER','ERI','232','.er',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('57','Estland (Reval)','Estonia','EE','EST','233','.ee',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('58','Europische Union',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('59','Falklandinseln (Malwinen)','Falkland Islands (Malvinas)','FK','FLK','238','.fk',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('60','Frer','Faroe Islands','FO','FRO','234','.fo',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('61','Fidschi','Fiji','FJ','FJI','242','.fj',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('62','Finnland','Finland','FI','FIN','246','.fi',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('63','Frankreich','France','FR','FRA','250','.fr',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('64','Franzsisch-Guayana','French Guiana','GF','GUF','254','.gf',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('65','Franzsisch-Polynesien','French Polynesia','PF','PYF','258','.pf',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('66','Franzsische Sd- und Antarktisgebiete','French Southern Territories','TF','ATF','260','.tf',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('67','Gabun','Gabon','GA','GAB','266','.ga',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('68','Gambia','Gambia','GM','GMB','270','.gm',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('69','Georgien','Georgia','GE','GEO','268','.ge',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('70','Ghana','Ghana','GH','GHA','288','.gh',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('71','Gibraltar','Gibraltar','GI','GIB','292','.gi',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('72','Grenada','Grenada','GD','GRD','308','.gd',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('73','Griechenland','Greece','GR','GRC','300','.gr',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('74','Grnland','Greenland','GL','GRL','304','.gl',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('75','Guadeloupe','Guadeloupe','GP','GLP','312','.gp',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('76','Guam','Guam','GU','GUM','316','.gu',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('77','Guatemala','Guatemala','GT','GTM','320','.gt',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('78','Guernsey (Kanalinsel)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('79','Guinea','Guinea','GN','GIN','324','.gn',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('80','Guinea-Bissau','Guinea-bissau','GW','GNB','624','.gw',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('81','Guyana','Guyana','GY','GUY','328','.gy',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('82','Haiti','Haiti','HT','HTI','332','.ht',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('83','Heard- und McDonald-Inseln','Heard and Mc Donald Islands','HM','HMD','334','.hm',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('84','Honduras','Honduras','HN','HND','340','.hn',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('85','Hongkong','Hong Kong','HK','HKG','344','.hk',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('86','Indien','India','IN','IND','356','.in',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('87','Indonesien','Indonesia','ID','IDN','360','.id',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('88','Insel Man',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('89','Irak','Iraq','IQ','IRQ','368','.iq',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('90','Iran, Islamische Republik','Iran (Islamic Republic of)','IR','IRN','364','.ir',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('91','Irland','Ireland','IE','IRL','372','.ie',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('92','Island','Iceland','IS','ISL','352','.is',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('93','Israel','Israel','IL','ISR','376','.il',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('94','Italien','Italy','IT','ITA','380','.it',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('95','Jamaika','Jamaica','JM','JAM','388','.jm',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('96','Japan','Japan','JP','JPN','392','.jp',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('97','Jemen','Yemen','YE','YEM','887','.ye',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('98','Jersey (Kanalinsel)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('99','Jordanien','Jordan','JO','JOR','400','.jo',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('100','Jugoslawien (ehemalig)','Yugoslavia','YU','YUG','891','.yu',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('101','Kaimaninseln','Cayman Islands','KY','CYM','136','.ky',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('102','Kambodscha','Cambodia','KH','KHM','116','.kh',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('103','Kamerun','Cameroon','CM','CMR','120','.cm',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('104','Kanada','Canada','CA','CAN','124','.ca',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('105','Kanarische Inseln',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('106','Kap Verde','Cape Verde','CV','CPV','132','.cv',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('107','Kasachstan','Kazakhstan','KZ','KAZ','398','.kz',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('108','Katar','Qatar','QA','QAT','634','.qa',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('109','Kenia','Kenya','KE','KEN','404','.ke',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('110','Kirgisistan','Kyrgyzstan','KG','KGZ','417','.kg',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('111','Kiribati','Kiribati','KI','KIR','296','.ki',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('112','Kokosinseln (Keelinginseln)','Cocos (Keeling) Islands','CC','CCK','166','.cc',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('113','Kolumbien','Colombia','CO','COL','170','.co',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('114','Komoren','Comoros','KM','COM','174','.km',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('115','Kongo, Demokratische Republik','Congo','CD','COD','180','.cd',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('116','Republik Kongo',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('117','Korea, Demokratische Volksrepublik (Nordkorea)','Korea, Democratic People\'s Republic of','KP','PRK','408','.kp',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('118','Korea, Republik (Sdkorea)','Korea, Republic of','KR','KOR','410','.kr',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('119','Kroatien (Hrvatska)','Croatia','HR','HRV','191','.hr',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('120','Kuba','Cuba','CU','CUB','192','.cu',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('121','Kuwait','Kuwait','KW','KWT','414','.kw',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('122','Laos, Demokratische Volksrepublik','Lao People\'s Democratic Republic','LA','LAO','418','.la',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('123','Lesotho','Lesotho','LS','LSO','426','.ls',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('124','Lettland','Latvia','LV','LVA','428','.lv',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('125','Libanon','Lebanon','LB','LBN','422','.lb',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('126','Liberia','Liberia','LR','LBR','430','.lr',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('127','Libysch-Arabische Dschamahirija (Libyen)','Libyan Arab Jamahiriya','LY','LBY','434','.ly',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('128','Liechtenstein','Liechtenstein','LI','LIE','438','.li',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('129','Litauen','Lithuania','LT','LTU','440','.lt',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('130','Luxemburg','Luxembourg','LU','LUX','442','.lu',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('131','Macao','Macau','MO','MAC','446','.mo',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('132','Madagaskar','Madagascar','MG','MDG','450','.mg',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('133','Malawi','Malawi','MW','MWI','454','.mw',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('134','Malaysia','Malaysia','MY','MYS','458','.my',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('135','Malediven','Maldives','MV','MDV','462','.mv',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('136','Mali','Mali','ML','MLI','466','.ml',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('137','Malta','Malta','MT','MLT','470','.mt',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('138','Marokko','Morocco','MA','MAR','504','.ma',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('139','Marshallinseln','Marshall Islands','MH','MHL','584','.mh',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('140','Martinique','Martinique','MQ','MTQ','474','.mq',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('141','Mauretanien','Mauritania','MR','MRT','478','.mr',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('142','Mauritius','Mauritius','MU','MUS','480','.mu',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('143','Mayotte','Mayotte','YT','MYT','175','.yt',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('144','Mazedonien, ehem. jugoslawische Republik [2b]','Macedonia, The Former Yugoslav Republic of','MK','MKD','807','.mk',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('145','Mexiko','Mexico','MX','MEX','484','.mx',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('146','Mikronesien','Micronesia, Federated States of','FM','FSM','583','.fm',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('147','Moldawien (Republik Moldau)','Moldova, Republic of','MD','MDA','498','.md',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('148','Monaco','Monaco','MC','MCO','492','.mc',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('149','Mongolei','Mongolia','MN','MNG','496','.mn',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('150','Montenegro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('151','Montserrat','Montserrat','MS','MSR','500','.ms',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('152','Mosambik','Mozambique','MZ','MOZ','508','.mz',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('153','Myanmar (Burma)','Myanmar','MM','MMR','104','.mm',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('154','Namibia','Namibia','NA','NAM','516','.na',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('155','Nauru','Nauru','NR','NRU','520','.nr',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('156','Nepal','Nepal','NP','NPL','524','.np',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('157','Neukaledonien','New Caledonia','NC','NCL','540','.nc',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('158','Neuseeland','New Zealand','NZ','NZL','554','.nz',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('159','Neutrale Zone (Saudi-Arabien und Irak)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('160','Nicaragua','Nicaragua','NI','NIC','558','.ni',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('161','Niederlande','Netherlands','NL','NLD','528','.nl',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('162','Niederlndische Antillen','Netherlands Antilles','AN','ANT','530','.an',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('163','Niger','Niger','NE','NER','562','.ne',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('164','Nigeria','Nigeria','NG','NGA','566','.ng',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('165','Niue','Niue','NU','NIU','570','.nu',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('166','Nrdliche Marianen','Northern Mariana Islands','MP','MNP','580','.mp',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('167','Norfolkinsel','Norfolk Island','NF','NFK','574','.nf',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('168','Norwegen','Norway','NO','NOR','578','.no',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('169','Oman','Oman','OM','OMN','512','.om',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('170','sterreich','Austria','AT','AUT','40','.at',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('171','Pakistan','Pakistan','PK','PAK','586','.pk',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('172','Palstinensische Autonomiegebiete',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('173','Palau','Palau','PW','PLW','585','.pw',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('174','Panama','Panama','PA','PAN','591','.pa',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('175','Papua-Neuguinea','Papua New Guinea','PG','PNG','598','.pg',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('176','Paraguay','Paraguay','PY','PRY','600','.py',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('177','Peru','Peru','PE','PER','604','.pe',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('178','Philippinen','Philippines','PH','PHL','608','.ph',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('179','Pitcairninseln','Pitcairn','PN','PCN','612','.pn',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('180','Polen','Poland','PL','POL','616','.pl',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('181','Portugal','Portugal','PT','PRT','620','.pt',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('182','Puerto Rico','Puerto Rico','PR','PRI','630','.pr',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('183','Runion','Reunion','RE','REU','638','.re',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('184','Ruanda','Rwanda','RW','RWA','646','.rw',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('185','Rumnien','Romania','RO','ROU','642','.ro',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('186','Russische Fderation','Russian Federation','RU','RUS','643','.ru',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('187','Salomonen','Solomon Islands','SB','SLB','90','.sb',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('188','Sambia','Zambia','ZM','ZMB','894','.zm',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('189','Samoa','Samoa','WS','WSM','882','.ws',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('190','San Marino','San Marino','SM','SMR','674','.sm',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('191','So Tom und Prncipe','Sao Tome and Principe','ST','STP','678','.st',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('192','Saudi-Arabien','Saudi Arabia','SA','SAU','682','.sa',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('193','Schweden','Sweden','SE','SWE','752','.se',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('194','Schweiz','Switzerland','CH','CHE','756','.ch','41','CHF','N','N');
INSERT INTO LAENDER VALUES ('195','Senegal','Senegal','SN','SEN','686','.sn',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('196','Serbien',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('197','Seychellen','Seychelles','SC','SYC','690','.sc',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('198','Sierra Leone','Sierra Leone','SL','SLE','694','.sl',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('199','Simbabwe','Zimbabwe','ZW','ZWE','716','.zw',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('200','Singapur','Singapore','SG','SGP','702','.sg',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('201','Slowakei','Slovakia (Slovak Republic)','SK','SVK','703','.sk',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('202','Slowenien','Slovenia','SI','SVN','705','.si',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('203','Somalia','Somalia','SO','SOM','706','.so',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('204','Spanien','Spain','ES','ESP','724','.es',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('205','Sri Lanka','Sri Lanka','LK','LKA','144','.lk',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('206','St. Helena','St. Helena','SH','SHN','654','.sh',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('207','St. Kitts und Nevis','Saint Kitts and Nevis','KN','KNA','659','.kn',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('208','St. Lucia','Saint Lucia','LC','LCA','662','.lc',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('209','St. Pierre und Miquelon','St. Pierre and Miquelon','PM','SPM','666','.pm',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('210','St. Vincent und die Grenadinen','Saint Vincent and the Grenadines','VC','VCT','670','.vc',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('211','Sdafrika','South Africa','ZA','ZAF','710','.za',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('212','Sudan','Sudan','SD','SDN','736','.sd',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('213','Sdgeorgien und die Sdlichen Sandwichinseln','South Georgia and the South Sandwich Islands','GS','SGS','239','.gs',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('214','Suriname','Suriname','SR','SUR','740','.sr',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('215','Svalbard und Jan Mayen','Svalbard and Jan Mayen Islands','SJ','SJM','744','.sj',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('216','Swasiland','Swaziland','SZ','SWZ','748','.sz',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('217','Syrien, Arabische Republik','Syrian Arab Republic','SY','SYR','760','.sy',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('218','Tadschikistan','Tajikistan','TJ','TJK','762','.tj',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('219','Taiwan (Formosa)','Taiwan','TW','TWN','158','.tw',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('220','Tansania, Vereinigte Republik','Tanzania, United Republic of','TZ','TZA','834','.tz',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('221','Thailand','Thailand','TH','THA','764','.th',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('222','Timor-Leste','Timor-Leste','TL','TLS','626','.tl',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('223','Togo','Togo','TG','TGO','768','.tg',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('224','Tokelau','Tokelau','TK','TKL','772','.tk',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('225','Tonga','Tonga','TO','TON','776','.to',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('226','Trinidad und Tobago','Trinidad and Tobago','TT','TTO','780','.tt',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('227','Tschad','Chad','TD','TCD','148','.td',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('228','Tschechische Republik','Czech Republic','CZ','CZE','203','.cz',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('229','Tschechoslowakei (ehemalig)',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('230','Tunesien','Tunisia','TN','TUN','788','.tn',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('231','Trkei','Turkey','TR','TUR','792','.tr',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('232','Turkmenistan','Turkmenistan','TM','TKM','795','.tm',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('233','Turks- und Caicosinseln','Turks and Caicos Islands','TC','TCA','796','.tc',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('234','Tuvalu','Tuvalu','TV','TUV','798','.tv',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('235','Uganda','Uganda','UG','UGA','800','.ug',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('236','Ukraine','Ukraine','UA','UKR','804','.ua',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('237','Ungarn','Hungary','HU','HUN','348','.hu',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('238','Uruguay','Uruguay','UY','URY','858','.uy',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('239','Usbekistan','Uzbekistan','UZ','UZB','860','.uz',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('240','Vanuatu','Vanuatu','VU','VUT','548','.vu',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('241','Vatikanstadt','Vatican City State (Holy See)','VA','VAT','336','.va',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('242','Venezuela','Venezuela','VE','VEN','862','.ve',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('243','Vereinigte Arabische Emirate','United Arab Emirates','AE','ARE','784','.ae',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('244','Vereinigte Staaten von Amerika','United States','US','USA','840','.us',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('245','Vereinigtes Knigreich von Grobritannien und Nordirland','United Kingdom','GB','GBR','826','.uk',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('246','Vietnam','Viet Nam','VN','VNM','704','.vn',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('247','Wallis und Futuna','Wallis and Futuna Islands','WF','WLF','876','.wf',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('248','Weihnachtsinsel','Christmas Island','CX','CXR','162','.cx',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('249','Westsahara','Western Sahara','EH','ESH','732','.eh',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('250','Zentralafrikanische Republik','Central African Republic','CF','CAF','140','.cf',NULL,NULL,'N','N');
INSERT INTO LAENDER VALUES ('251','Zypern','Cyprus','CY','CYP','196','.cy',NULL,NULL,'N','N');



#
# TABLE 'LAGER_BESTAND'
#
drop table if exists `LAGER_BESTAND`;

create table `LAGER_BESTAND` (
  `RECNR` int(11) Not Null auto_increment,
  `LAGER_ID` int(3) Default '0' Not Null,
  `ARTIKEL_ID` int(11) Default '0' Not Null,
  `BESTAND_AKTUELL` int(5) Default '0' Not Null,
  `BESTAND_MIN` int(5),
  `GELOESCHT` enum('J','N') Default 'N',
  PRIMARY KEY (RECNR)
);


#
# TABLE 'LAGER_ORT'
#
drop table if exists `LAGER_ORT`;

create table `LAGER_ORT` (
  `LAGER_ID` int(3) Not Null auto_increment,
  `LAGERORT` varchar(30) Not Null,
  `POSITION` int(2),
  `GELOESCHT` enum('J','N') Default 'N',
  PRIMARY KEY (LAGER_ID)
);


#
# TABLE 'LAGER_ORT' DATA
#
INSERT INTO LAGER_ORT VALUES ('1','','1','N');
INSERT INTO LAGER_ORT VALUES ('2','Keller','2','N');



#
# TABLE 'LIEFERSCHEIN_EINZELBUCHUNG'
#
drop table if exists `LIEFERSCHEIN_EINZELBUCHUNG`;

create table `LIEFERSCHEIN_EINZELBUCHUNG` (
  `ID` int(10) Not Null auto_increment,
  `BELEGNR` varchar(10),
  `ANZAHL` varchar(6),
  `ARTIKEL_ID` int(7),
  `ARTNR` varchar(10),
  `BEZEICHNUNG` varchar(60),
  `BRUTTO` varchar(10),
  `RABATT` varchar(10),
  `VERKAUFSPREIS` varchar(10),
  `MWST_SATZ` varchar(6),
  `GELOESCHT` enum('J','N') Default 'N' Not Null,
  `GELOESCHT_VON` varchar(5),
  PRIMARY KEY (ID),
  UNIQUE KEY ID (ID)
);


#
# TABLE 'LIEFERSCHEIN_EINZELBUCHUNG' DATA
#
INSERT INTO LIEFERSCHEIN_EINZELBUCHUNG VALUES ('1','30001','60','0','','Holzperlen 8 mm rot','3.60','20.00','172.80','7.60','N','');
INSERT INTO LIEFERSCHEIN_EINZELBUCHUNG VALUES ('2','30001','60','0','','Holzperlen 8 mm weiss','3.60','20.00','172.80','7.60','N','');
INSERT INTO LIEFERSCHEIN_EINZELBUCHUNG VALUES ('3','30001','60','0','','Holzperlen 8 mm roh','4.80','20.00','230.40','7.60','N','');
INSERT INTO LIEFERSCHEIN_EINZELBUCHUNG VALUES ('4','30001','23','0','','Holzperlen 12 mm rot','3.60','20.00','66.25','7.60','N','');
INSERT INTO LIEFERSCHEIN_EINZELBUCHUNG VALUES ('5','30001','23','0','','Holzperlen 12 mm weiss','3.60','20.00','66.25','7.60','N','');
INSERT INTO LIEFERSCHEIN_EINZELBUCHUNG VALUES ('6','30001','39','0','','Holzperlen 15 mm rot','3.60','20.00','112.30','7.60','N','');
INSERT INTO LIEFERSCHEIN_EINZELBUCHUNG VALUES ('7','30001','39','0','','Holzperlen 15 mm','3.60','20.00','112.30','7.60','N','');
INSERT INTO LIEFERSCHEIN_EINZELBUCHUNG VALUES ('8','30002','1','0','900 305','Giessmasse schiefer 5 kg.','43.90','0','43.90','8.00','N','');
INSERT INTO LIEFERSCHEIN_EINZELBUCHUNG VALUES ('9','30002','1','0','100 005','Giessmasse weiss 5 kg.','36.50','0.00','36.50','8.00','N','');
INSERT INTO LIEFERSCHEIN_EINZELBUCHUNG VALUES ('10','30002','1','0','8742 48','Giessform 3-D Budda','26.90','0.00','26.90','8.00','N','');
INSERT INTO LIEFERSCHEIN_EINZELBUCHUNG VALUES ('11','30002','1','0','CP 556','Giessform Asia Kerzenhalter','12.90','0.00','12.90','8.00','N','');
INSERT INTO LIEFERSCHEIN_EINZELBUCHUNG VALUES ('12','30002','1','0','CP 554','Giessform Asia Bilderrahmen','12.90','0.00','12.90','8.00','N','');
INSERT INTO LIEFERSCHEIN_EINZELBUCHUNG VALUES ('13','30002','1','0','CP 553','Giessform Asia Bilderrahmen','12.90','0.00','12.90','8.00','N','');
INSERT INTO LIEFERSCHEIN_EINZELBUCHUNG VALUES ('14','30003','1','0','900 305','Giessmasse schiefer 5 kg.','43.90','0','43.90','8.00','N','');
INSERT INTO LIEFERSCHEIN_EINZELBUCHUNG VALUES ('15','30003','1','0','100 005','Giessmasse weiss 5 kg.','36.50','0.00','36.50','8.00','N','');
INSERT INTO LIEFERSCHEIN_EINZELBUCHUNG VALUES ('16','30003','1','0','8742 48','Giessform 3-D Budda','26.90','0.00','26.90','8.00','N','');
INSERT INTO LIEFERSCHEIN_EINZELBUCHUNG VALUES ('17','30003','1','0','CP 556','Giessform Asia Kerzenhalter','12.90','0.00','12.90','8.00','N','');
INSERT INTO LIEFERSCHEIN_EINZELBUCHUNG VALUES ('18','30003','1','0','CP 554','Giessform Asia Bilderrahmen','12.90','0.00','12.90','8.00','N','');
INSERT INTO LIEFERSCHEIN_EINZELBUCHUNG VALUES ('19','30003','1','0','CP 553','Giessform Asia Bilderrahmen','12.90','0.00','12.90','8.00','N','');
INSERT INTO LIEFERSCHEIN_EINZELBUCHUNG VALUES ('20','30004','1','0','900 305','Giessmasse schiefer 5 kg.','43.90','0','43.90','8.00','N','');
INSERT INTO LIEFERSCHEIN_EINZELBUCHUNG VALUES ('21','30004','1','0','100 005','Giessmasse weiss 5 kg.','36.50','0.00','36.50','8.00','N','');
INSERT INTO LIEFERSCHEIN_EINZELBUCHUNG VALUES ('22','30004','1','0','8742 48','Giessform 3-D Budda','26.90','0.00','26.90','8.00','N','');
INSERT INTO LIEFERSCHEIN_EINZELBUCHUNG VALUES ('23','30004','1','0','CP 556','Giessform Asia Kerzenhalter','12.90','0.00','12.90','8.00','N','');
INSERT INTO LIEFERSCHEIN_EINZELBUCHUNG VALUES ('24','30004','1','0','CP 554','Giessform Asia Bilderrahmen','12.90','0.00','12.90','8.00','N','');
INSERT INTO LIEFERSCHEIN_EINZELBUCHUNG VALUES ('25','30004','1','0','CP 553','Giessform Asia Bilderrahmen','12.90','0.00','12.90','8.00','N','');
INSERT INTO LIEFERSCHEIN_EINZELBUCHUNG VALUES ('26','30005','1','0','900 305','Giessmasse schiefer 5 kg.','43.90','0','43.90','8.00','N','');
INSERT INTO LIEFERSCHEIN_EINZELBUCHUNG VALUES ('27','30005','1','0','100 005','Giessmasse weiss 5 kg.','36.50','0.00','36.50','8.00','N','');
INSERT INTO LIEFERSCHEIN_EINZELBUCHUNG VALUES ('28','30005','1','0','8742 48','Giessform 3-D Budda','26.90','0.00','26.90','8.00','N','');
INSERT INTO LIEFERSCHEIN_EINZELBUCHUNG VALUES ('29','30005','1','0','CP 556','Giessform Asia Kerzenhalter','12.90','0.00','12.90','8.00','N','');
INSERT INTO LIEFERSCHEIN_EINZELBUCHUNG VALUES ('30','30005','1','0','CP 554','Giessform Asia Bilderrahmen','12.90','0.00','12.90','8.00','N','');
INSERT INTO LIEFERSCHEIN_EINZELBUCHUNG VALUES ('31','30005','1','0','CP 553','Giessform Asia Bilderrahmen','12.90','0.00','12.90','8.00','N','');
INSERT INTO LIEFERSCHEIN_EINZELBUCHUNG VALUES ('32','30006','1','0','900 305','Giessmasse schiefer 5 kg.','43.90','0','43.90','8.00','N','');
INSERT INTO LIEFERSCHEIN_EINZELBUCHUNG VALUES ('33','30006','1','0','100 005','Giessmasse weiss 5 kg.','36.50','0.00','36.50','8.00','N','');
INSERT INTO LIEFERSCHEIN_EINZELBUCHUNG VALUES ('34','30006','1','0','8742 48','Giessform 3-D Budda','26.90','0.00','26.90','8.00','N','');
INSERT INTO LIEFERSCHEIN_EINZELBUCHUNG VALUES ('35','30006','1','0','CP 556','Giessform Asia Kerzenhalter','12.90','0.00','12.90','8.00','N','');
INSERT INTO LIEFERSCHEIN_EINZELBUCHUNG VALUES ('36','30006','1','0','CP 554','Giessform Asia Bilderrahmen','12.90','0.00','12.90','8.00','N','');
INSERT INTO LIEFERSCHEIN_EINZELBUCHUNG VALUES ('37','30006','1','0','CP 553','Giessform Asia Bilderrahmen','12.90','0.00','12.90','8.00','N','');
INSERT INTO LIEFERSCHEIN_EINZELBUCHUNG VALUES ('38','30007','1','0','900 305','Giessmasse schiefer 5 kg.','43.90','0','43.90','8.00','N','');
INSERT INTO LIEFERSCHEIN_EINZELBUCHUNG VALUES ('39','30007','1','0','100 005','Giessmasse weiss 5 kg.','36.50','0.00','36.50','8.00','N','');
INSERT INTO LIEFERSCHEIN_EINZELBUCHUNG VALUES ('40','30007','1','0','8742 48','Giessform 3-D Budda','26.90','0.00','26.90','8.00','N','');
INSERT INTO LIEFERSCHEIN_EINZELBUCHUNG VALUES ('41','30007','1','0','CP 556','Giessform Asia Kerzenhalter','12.90','0.00','12.90','8.00','N','');
INSERT INTO LIEFERSCHEIN_EINZELBUCHUNG VALUES ('42','30007','1','0','CP 554','Giessform Asia Bilderrahmen','12.90','0.00','12.90','8.00','N','');
INSERT INTO LIEFERSCHEIN_EINZELBUCHUNG VALUES ('43','30007','1','0','CP 553','Giessform Asia Bilderrahmen','12.90','0.00','12.90','8.00','N','');
INSERT INTO LIEFERSCHEIN_EINZELBUCHUNG VALUES ('44','30008','1','0','111','Test','1.00','0.00','1.00','8.00','N','');
INSERT INTO LIEFERSCHEIN_EINZELBUCHUNG VALUES ('45','30009','1','0','123','Testartikel','12.00','0','12.00','8.00','N','');



#
# TABLE 'LIEFERSCHEIN_PROTOKOLL'
#
drop table if exists `LIEFERSCHEIN_PROTOKOLL`;

create table `LIEFERSCHEIN_PROTOKOLL` (
  `ID` int(10) Not Null auto_increment,
  `BELEGNR` varchar(10),
  `BELEGNR_AUFTRAG` varchar(10),
  `DATUM` date,
  `DEBITORNR_RE` int(10),
  `DEBITORNR_WE` int(10),
  `DEBITORNR_AG` int(11),
  `KONTAKTPERSON` varchar(20),
  `KOMMISSION` varchar(40),
  `BRUTTO` varchar(10),
  `RABATT` varchar(10),
  `VERKAUFSPREIS` varchar(10),
  `PORTO` varchar(10),
  `BRUTTOKREDIT` varchar(10),
  `SKONTO_PROZENT` varchar(10),
  `BEMERKUNGEN` blob,
  `GELOESCHT` enum('N','J'),
  `GELOESCHT_DATUM` date,
  `GELOESCHT_VON` varchar(5),
  `GELOESCHT_GRUND` blob,
  PRIMARY KEY (ID),
  UNIQUE KEY Rechnung_ID (ID)
);


#
# TABLE 'LIEFERSCHEIN_PROTOKOLL' DATA
#
INSERT INTO LIEFERSCHEIN_PROTOKOLL VALUES ('1','30001','1002','2010-11-26','911','911','911','Tommila Laura','','1166.40','233.30','933.10','0.00','933.10','2.00','Sammelrechnung','J','2010-11-26','1','');
INSERT INTO LIEFERSCHEIN_PROTOKOLL VALUES ('2','30002','1005','2011-03-16','369','369','369','','','146.00','0.00','146.00','10.00','156.00','2.00','','J','2011-03-26','1','');
INSERT INTO LIEFERSCHEIN_PROTOKOLL VALUES ('3','30003','1006','2011-03-16','369','369','369','','','146.00','0.00','146.00','10.00','156.00','2.00','','J','2011-03-26','1','');
INSERT INTO LIEFERSCHEIN_PROTOKOLL VALUES ('4','30004','1007','2011-03-16','369','369','369','','','146.00','0.00','146.00','10.00','156.00','2.00','','J','2011-03-26','1','');
INSERT INTO LIEFERSCHEIN_PROTOKOLL VALUES ('5','30005','1008','2011-03-16','369','369','369','','','146.00','0.00','146.00','18.00','164.00','2.00','','J','2011-03-26','1','');
INSERT INTO LIEFERSCHEIN_PROTOKOLL VALUES ('6','30006','1009','2011-03-16','369','369','369','','','146.00','0.00','146.00','10.00','156.00','2.00','','J','2011-03-26','1','');
INSERT INTO LIEFERSCHEIN_PROTOKOLL VALUES ('7','30007','1010','2011-03-16','369','369','369','','','146.00','0.00','146.00','10.00','156.00','2.00','','J','2011-03-26','1','');
INSERT INTO LIEFERSCHEIN_PROTOKOLL VALUES ('8','30008','1011','2011-03-16','369','369','369','','','1.00','0.00','1.00','10.00','11.00','2.00','','J','2011-03-26','1','');
INSERT INTO LIEFERSCHEIN_PROTOKOLL VALUES ('9','30009','1014','2011-03-26','369','369','369','Test','','12.00','0.00','12.00','10.00','22.00','2.00','','J','2011-03-26','1','');



#
# TABLE 'MA_ANG_STATUS'
#
drop table if exists `MA_ANG_STATUS`;

create table `MA_ANG_STATUS` (
  `MA_ANG_STATUS_ID` int(3) Not Null auto_increment,
  `MA_ANG_STATUS` varchar(30) Not Null,
  `POSITION` int(2),
  `GELOESCHT` enum('N','J') Default 'N' Not Null,
  PRIMARY KEY (MA_ANG_STATUS_ID),
  UNIQUE KEY MA_STATUS_ID (MA_ANG_STATUS_ID)
);


#
# TABLE 'MA_ANG_STATUS' DATA
#
INSERT INTO MA_ANG_STATUS VALUES ('1','','1','N');
INSERT INTO MA_ANG_STATUS VALUES ('2','Angestellt','2','N');
INSERT INTO MA_ANG_STATUS VALUES ('3','Leitender Angestellter','3','N');
INSERT INTO MA_ANG_STATUS VALUES ('4','Geschftsleitung','4','N');
INSERT INTO MA_ANG_STATUS VALUES ('5','Geschftsfhrer','5','N');



#
# TABLE 'MAHNLISTE'
#
drop table if exists `MAHNLISTE`;

create table `MAHNLISTE` (
  `ID` int(10) Not Null auto_increment,
  `BELEGNR_RG` varchar(10),
  `DATUM_RG` date,
  `DATUM_VALUTA` date,
  `DEBITORNR_RE` varchar(11),
  `FIRMA` varchar(40),
  `NACHNAME` varchar(40),
  `VORNAME` varchar(40),
  `ORT` varchar(30),
  `BRUTTOKREDIT` varchar(10),
  `TEILZAHLUNGEN` varchar(10),
  `RESTBETRAG` varchar(10),
  `MAHNBETRAG` varchar(10),
  `MAHNEN` enum('True','False') Default 'True',
  `MAHNSPERRE` enum('J','N') Default 'N',
  `MAHNSTUFE` varchar(3),
  PRIMARY KEY (ID),
  UNIQUE KEY Datensatz_ID (ID)
);


#
# TABLE 'MAHNLISTE_ZAHLUNGEN'
#
drop table if exists `MAHNLISTE_ZAHLUNGEN`;

create table `MAHNLISTE_ZAHLUNGEN` (
  `ID` int(10) Not Null auto_increment,
  `BELEGNR_RG` int(10),
  `DATUM` date,
  `BETRAG` varchar(10),
  `ZAHLUNGSART` varchar(20),
  `GUTSCHRIFT` varchar(11),
  `GUTSCHEIN` varchar(20),
  `GELOESCHT` enum('N','J') Default 'N',
  PRIMARY KEY (ID),
  UNIQUE KEY ID (ID)
);


#
# TABLE 'MAHNUNG'
#
drop table if exists `MAHNUNG`;

create table `MAHNUNG` (
  `ID` int(10) Not Null auto_increment,
  `DATUM` date,
  `BELEGNR` varchar(10),
  `BELEGNR_RG` varchar(10),
  `DATUM_RG` date,
  `DATUM_VALUTA` date,
  `DEBITORNR_RE` varchar(11),
  `BRUTTOKREDIT` varchar(10),
  `TEILZAHLUNGEN` varchar(10),
  `RESTBETRAG` varchar(10),
  `MAHNSPESEN` varchar(10),
  `FORDERUNG` varchar(10),
  `MAHNSTUFE` varchar(1),
  `AUSDRUCK` enum('True','False') Default 'False',
  PRIMARY KEY (ID),
  UNIQUE KEY Datensatz_ID (ID)
);


#
# TABLE 'MAHNUNG' DATA
#
INSERT INTO MAHNUNG VALUES ('1','2012-01-10','101','40002','2026-03-20','2025-04-20','151','12.00','0.00','12.00','0.00','12.00','1','False');
INSERT INTO MAHNUNG VALUES ('2','2012-01-10','102','40003','2026-03-20','2025-04-20','151','4.00','0.00','4.00','0.00','4.00','1','False');
INSERT INTO MAHNUNG VALUES ('3','2012-01-10','103','40019','2001-12-20','2031-12-20','919','227.40','0.00','227.40','0.00','227.40','1','False');



#
# TABLE 'MAHNUNG_ZAHLUNGEN'
#
drop table if exists `MAHNUNG_ZAHLUNGEN`;

create table `MAHNUNG_ZAHLUNGEN` (
  `ID` int(10) Not Null auto_increment,
  `BELEGNR_MAHNUNG` int(10),
  `BELEGNR_RG` int(10),
  `DATUM` date,
  `BETRAG` varchar(10),
  `ZAHLUNGSART` varchar(20),
  `GUTSCHRIFT` varchar(11),
  `GUTSCHEIN` varchar(20),
  PRIMARY KEY (ID),
  UNIQUE KEY Zahlungen_ID (ID)
);


#
# TABLE 'MITARBEITER'
#
drop table if exists `MITARBEITER`;

create table `MITARBEITER` (
  `MITARBEITER_ID` int(5) Not Null auto_increment,
  `PERSONALNUMMER` varchar(5) Not Null,
  `LOGINNAME` varchar(20) Not Null,
  `KONTAKTDATEN_ID` int(10) Default '0' Not Null,
  `MA_ANG_STATUS_ID` int(3) Default '0' Not Null,
  `BENUTZERGRUPPE_ID` int(3) Default '0' Not Null,
  `ABTEILUNG_ID` int(4) Default '0' Not Null,
  `FOTO` longblob,
  `PASSWORT` varchar(32) Not Null,
  `GESPERRT` enum('J','N') Default 'N' Not Null,
  `ANMERKUNGEN` blob,
  `GELOESCHT` enum('J','N') Default 'N' Not Null,
  PRIMARY KEY (MITARBEITER_ID)
);


#
# TABLE 'MITARBEITER' DATA
#
INSERT INTO MITARBEITER VALUES ('1','100','100','0','0','2','1',NULL,'81dc9bdb52d04dc20036dbd8313ed055','N',NULL,'N');
INSERT INTO MITARBEITER VALUES ('2','1','Thesy','813','1','2','1',NULL,'81dc9bdb52d04dc20036dbd8313ed055','N','','N');
INSERT INTO MITARBEITER VALUES ('3','2','Claudia','814','1','2','1',NULL,'81dc9bdb52d04dc20036dbd8313ed055','N','','N');
INSERT INTO MITARBEITER VALUES ('4','','','820','1','1','1',NULL,'4f2a91e15af2631ff9424564b8a45fb2','N','','N');



#
# TABLE 'MWST'
#
drop table if exists `MWST`;

create table `MWST` (
  `MWST_ID` int(3) Not Null auto_increment,
  `MWST_BEZ` varchar(10) Not Null,
  `MWST` decimal(5,2) Default '0.00' Not Null,
  `GELOESCHT` enum('J','N') Default 'N',
  `POSITION` int(11),
  PRIMARY KEY (MWST_ID)
);


#
# TABLE 'OFFERTE_EINZELBUCHUNG'
#
drop table if exists `OFFERTE_EINZELBUCHUNG`;

create table `OFFERTE_EINZELBUCHUNG` (
  `ID` int(10) Not Null auto_increment,
  `BELEGNR` varchar(10),
  `ANZAHL` varchar(6),
  `ARTIKEL_ID` int(7),
  `ARTNR` varchar(10),
  `BEZEICHNUNG` varchar(60),
  `BRUTTO` varchar(10),
  `RABATT` varchar(10),
  `VERKAUFSPREIS` varchar(10),
  `MWST_SATZ` varchar(6),
  `GELOESCHT` enum('J','N') Default 'N' Not Null,
  `GELOESCHT_VON` varchar(5),
  PRIMARY KEY (ID),
  UNIQUE KEY ID (ID)
);


#
# TABLE 'OFFERTE_EINZELBUCHUNG' DATA
#
INSERT INTO OFFERTE_EINZELBUCHUNG VALUES ('1','10001','60','0','','Holzperlen 8 mm rot','3.60','20.00','172.80','7.60','N','');
INSERT INTO OFFERTE_EINZELBUCHUNG VALUES ('2','10001','60','0','','Holzperlen 8 mm weiss','3.60','20.00','172.80','7.60','N','');
INSERT INTO OFFERTE_EINZELBUCHUNG VALUES ('3','10001','60','0','','Holzperlen 8 mm roh','4.80','20.00','230.40','7.60','N','');
INSERT INTO OFFERTE_EINZELBUCHUNG VALUES ('4','10001','23','0','','Holzperlen 12 mm rot','3.60','20.00','66.25','7.60','N','');
INSERT INTO OFFERTE_EINZELBUCHUNG VALUES ('5','10001','23','0','','Holzperlen 12 mm weiss','3.60','20.00','66.25','7.60','N','');
INSERT INTO OFFERTE_EINZELBUCHUNG VALUES ('6','10001','39','0','','Holzperlen 15 mm rot','3.60','20.00','112.30','7.60','N','');
INSERT INTO OFFERTE_EINZELBUCHUNG VALUES ('7','10001','39','0','','Holzperlen 15 mm','3.60','20.00','112.30','7.60','N','');



#
# TABLE 'OFFERTE_PROTOKOLL'
#
drop table if exists `OFFERTE_PROTOKOLL`;

create table `OFFERTE_PROTOKOLL` (
  `ID` int(10) Not Null auto_increment,
  `BELEGNR` varchar(10),
  `BELEGNR_AUFTRAG` varchar(10),
  `DATUM` date,
  `DEBITORNR_RE` int(10),
  `DEBITORNR_WE` int(10),
  `DEBITORNR_AG` int(11),
  `KONTAKTPERSON` varchar(20),
  `KOMMISSION` varchar(40),
  `BRUTTO` varchar(10),
  `RABATT` varchar(10),
  `VERKAUFSPREIS` varchar(10),
  `PORTO` varchar(10),
  `BRUTTOKREDIT` varchar(10),
  `BK_BASIS_MWST1` varchar(10),
  `BK_BASIS_MWST2` varchar(10),
  `BK_MWST1` varchar(10),
  `BK_MWST2` varchar(10),
  `ZAHLUNGSZIEL` int(3),
  `SKONTO_PROZENT` decimal(5,2),
  `SKONTO_TAGE` varchar(2),
  `BEMERKUNGEN` blob,
  `GELOESCHT` enum('N','J'),
  `GELOESCHT_DATUM` date,
  `GELOESCHT_VON` varchar(5),
  `GELOESCHT_GRUND` blob,
  `MWST1_SATZ` varchar(10),
  `MWST2_SATZ` varchar(10),
  PRIMARY KEY (ID),
  UNIQUE KEY Rechnung_ID (ID)
);


#
# TABLE 'OFFERTE_PROTOKOLL' DATA
#
INSERT INTO OFFERTE_PROTOKOLL VALUES ('1','10001','1002','2010-12-18','911','911','911','Tommila Laura','','1166.40','233.30','933.10','0.00','933.10','0.00','872.60','0.00','61.63','30','0','10','Sammelrechnung','J','2011-10-19','2','',NULL,NULL);



#
# TABLE 'PLZ'
#
drop table if exists `PLZ`;

create table `PLZ` (
  `PLZ_ID` int(11) Not Null auto_increment,
  `PLZ` int(7) Default '0' Not Null,
  `ORT` varchar(30) Not Null,
  `BUNDESLAND` varchar(30),
  `BUNDESLAND_KURZ` varchar(5),
  `LAENDER_ID` int(4) Default '0' Not Null,
  `GELOESCHT` enum('J','N') Default 'N' Not Null,
  PRIMARY KEY (PLZ_ID)
);


#
# TABLE 'PLZ' DATA
#
INSERT INTO PLZ VALUES ('1','4303','Kaiseraugst','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('2','4303','Kaiseraugst Liebrti','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('3','4305','Olsberg','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('4','4310','Rheinfelden','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('5','4310','Rheinfelden 1','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('6','4312','Magden','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('7','4313','Mhlin','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('8','4314','Zeiningen','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('9','4315','Zuzgen','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('10','4316','Hellikon','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('11','4317','Wegenstetten','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('12','4322','Mumpf','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('13','4323','Wallbach','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('14','4324','Obermumpf','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('15','4325','Schupfart','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('16','4332','Stein AG','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('17','4333','Mnchwilen AG','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('18','4334','Sisseln AG','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('19','4663','Aarburg','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('20','4665','Oftringen','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('21','4665','Oftringen 1','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('22','4665','Oftringen 2','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('23','4800','Zofingen','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('24','4801','Zofingen Ringier AG','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('25','4802','Strengelbach','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('26','4803','Vordemwald','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('27','4805','Brittnau','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('28','4807','Zofingen PostFinance','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('29','4808','Zofingen PostFinance','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('30','4809','Zofingen Postfinance UBS','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('31','4809','Zofingen PF UBS Verarb.','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('32','4812','Mhlethal','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('33','4813','Uerkheim','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('34','4814','Bottenwil','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('35','4852','Rothrist','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('36','4853','Murgenthal','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('37','4853','Riken AG','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('38','4856','Glashtten','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('39','5000','Aarau','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('40','5001','Aarau','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('41','5004','Aarau','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('42','5017','Barmelweid','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('43','5018','Erlinsbach','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('44','5022','Rombach','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('45','5023','Biberstein','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('46','5024','Kttigen','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('47','5025','Asp','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('48','5026','Densbren','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('49','5027','Herznach','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('50','5028','Ueken','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('51','5032','Aarau Rohr','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('52','5033','Buchs AG','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('53','5034','Suhr','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('54','5035','Unterentfelden','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('55','5036','Oberentfelden','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('56','5037','Muhen','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('57','5040','Schftland','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('58','5042','Hirschthal','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('59','5043','Holziken','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('60','5044','Schlossrued','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('61','5046','Schmiedrued-Walde','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('62','5046','Schmiedrued','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('63','5046','Walde AG','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('64','5053','Staffelbach','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('65','5053','Wittwil','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('66','5054','Kirchleerau','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('67','5054','Moosleerau','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('68','5054','Kirchleerau-Moosleerau','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('69','5056','Attelwil','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('70','5057','Reitnau','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('71','5058','Wiliberg','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('72','5062','Oberhof','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('73','5063','Wlflinswil','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('74','5064','Wittnau','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('75','5070','Frick','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('76','5072','Oeschgen','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('77','5073','Gipf-Oberfrick','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('78','5074','Eiken','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('79','5075','Hornussen','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('80','5076','Bzen','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('81','5077','Elfingen','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('82','5078','Effingen','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('83','5079','Zeihen','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('84','5080','Laufenburg','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('85','5082','Kaisten','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('86','5083','Ittenthal','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('87','5084','Rheinsulz','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('88','5085','Sulz AG','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('89','5102','Rupperswil','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('90','5103','Wildegg','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('91','5103','Mriken AG','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('92','5105','Auenstein','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('93','5106','Veltheim AG','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('94','5107','Schinznach Dorf','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('95','5108','Oberflachs','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('96','5112','Thalheim AG','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('97','5113','Holderbank AG','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('98','5116','Schinznach Bad','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('99','5200','Brugg AG','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('100','5200','Brugg AG 3','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('101','5201','Brugg AG','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('102','5210','Windisch','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('103','5212','Hausen AG','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('104','5213','Villnachern','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('105','5222','Umiken','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('106','5223','Riniken','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('107','5224','Unterbzberg','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('108','5224','Gallenkirch','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('109','5224','Linn','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('110','5225','Oberbzberg','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('111','5232','Villigen PSI','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('112','5233','Stilli','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('113','5234','Villigen','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('114','5235','Rfenach AG','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('115','5236','Remigen','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('116','5237','Mnthal','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('117','5242','Birr','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('118','5242','Lupfig','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('119','5242','Birr-Lupfig','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('120','5243','Mlligen','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('121','5244','Birrhard','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('122','5245','Habsburg','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('123','5246','Scherz','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('124','5272','Gansingen','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('125','5273','Oberhofen AG','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('126','5274','Mettau','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('127','5275','Etzgen','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('128','5276','Wil AG','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('129','5277','Hottwil','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('130','5300','Turgi','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('131','5301','Siggenthal Station','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('132','5303','Wrenlingen','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('133','5304','Endingen','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('134','5305','Unterendingen','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('135','5306','Tegerfelden','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('136','5312','Dttingen','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('137','5313','Klingnau','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('138','5314','Kleindttingen','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('139','5315','Bttstein','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('140','5316','Leuggern','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('141','5316','Felsenau AG','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('142','5317','Hettenschwil','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('143','5318','Mandach','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('144','5322','Koblenz','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('145','5323','Rietheim','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('146','5324','Full-Reuenthal','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('147','5325','Leibstadt','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('148','5326','Schwaderloch','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('149','5330','Bad Zurzach','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('150','5332','Rekingen AG','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('151','5333','Baldingen','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('152','5334','Bbikon','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('153','5400','Baden','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('154','5401','Baden','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('155','5402','Baden','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('156','5404','Baden','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('157','5405','Dttwil AG','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('158','5405','Baden','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('159','5406','Rtihof','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('160','5406','Baden','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('161','5408','Ennetbaden','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('162','5412','Gebenstorf','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('163','5413','Birmenstorf AG','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('164','5415','Nussbaumen AG','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('165','5415','Hertenstein AG','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('166','5415','Rieden AG','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('167','5416','Kirchdorf AG','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('168','5417','Untersiggenthal','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('169','5420','Ehrendingen','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('170','5423','Freienwil','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('171','5425','Schneisingen','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('172','5426','Lengnau AG','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('173','5430','Wettingen','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('174','5430','Wettingen 1','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('175','5430','Wettingen 2','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('176','5430','Wettingen 3','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('177','5432','Neuenhof','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('178','5436','Wrenlos','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('179','5442','Fislisbach','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('180','5443','Niederrohrdorf','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('181','5444','Knten','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('182','5445','Eggenwil','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('183','5452','Oberrohrdorf','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('184','5453','Remetschwil','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('185','5454','Bellikon','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('186','5462','Siglistorf','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('187','5463','Wislikofen','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('188','5464','Rmikon AG','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('189','5465','Mellikon','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('190','5466','Kaiserstuhl AG','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('191','5467','Fisibach','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('192','5502','Hunzenschwil','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('193','5503','Schafisheim','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('194','5504','Othmarsingen','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('195','5505','Brunegg','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('196','5506','Mgenwil','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('197','5507','Mellingen','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('198','5512','Wohlenschwil','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('199','5522','Tgerig','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('200','5524','Niederwil AG','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('201','5524','Nesselnbach','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('202','5525','Fischbach-Gslikon','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('203','5600','Lenzburg','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('204','5600','Ammerswil AG','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('205','5600','Lenzburg 1','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('206','5600','Lenzburg 2','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('207','5603','Staufen','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('208','5604','Hendschiken','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('209','5605','Dottikon','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('210','5606','Dintikon','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('211','5607','Hgglingen','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('212','5608','Stetten AG','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('213','5610','Wohlen AG','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('214','5610','Wohlen AG 1','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('215','5610','Wohlen AG 2','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('216','5611','Anglikon','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('217','5612','Villmergen','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('218','5613','Hilfikon','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('219','5614','Sarmenstorf','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('220','5615','Fahrwangen','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('221','5616','Meisterschwanden','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('222','5617','Tennwil','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('223','5618','Bettwil','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('224','5619','Bttikon AG','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('225','5619','Uezwil','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('226','5620','Bremgarten AG','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('227','5620','Bremgarten AG 2','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('228','5620','Bremgarten AG 1','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('229','5621','Zufikon','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('230','5622','Waltenschwil','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('231','5623','Boswil','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('232','5624','Bnzen','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('233','5624','Waldhusern AG','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('234','5625','Kallern','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('235','5626','Hermetschwil-Staffeln','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('236','5627','Besenbren','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('237','5628','Aristau','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('238','5630','Muri AG','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('239','5632','Buttwil','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('240','5634','Merenschwand','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('241','5636','Benzenschwil','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('242','5637','Beinwil (Freiamt)','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('243','5637','Geltwil','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('244','5642','Mhlau','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('245','5643','Sins','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('246','5643','Alikon','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('247','5643','Meienberg','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('248','5644','Auw','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('249','5645','Aettenschwil','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('250','5645','Fenkrieden','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('251','5646','Abtwil AG','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('252','5647','Oberrti','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('253','5702','Niederlenz','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('254','5703','Seon','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('255','5704','Egliswil','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('256','5705','Hallwil','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('257','5706','Boniswil','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('258','5707','Seengen','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('259','5708','Birrwil','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('260','5712','Beinwil am See','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('261','5722','Grnichen','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('262','5723','Teufenthal AG','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('263','5724','Drrensch','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('264','5725','Leutwil','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('265','5726','Unterkulm','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('266','5727','Oberkulm','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('267','5728','Gontenschwil','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('268','5732','Zetzwil','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('269','5733','Leimbach AG','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('270','5734','Reinach AG','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('271','5736','Burg AG','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('272','5737','Menziken','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('273','5742','Klliken','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('274','5745','Safenwil','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('275','6042','Dietwil','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('276','8109','Kloster Fahr','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('277','8905','Islisberg','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('278','8905','Arni AG','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('279','8905','Arni-Islisberg','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('280','8916','Jonen','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('281','8917','Oberlunkhofen','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('282','8918','Unterlunkhofen','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('283','8919','Rottenschwil','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('284','8956','Killwangen','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('285','8957','Spreitenbach','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('286','8962','Bergdietikon','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('287','8964','Rudolfstetten','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('288','8965','Berikon','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('289','8965','Berikon 1','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('290','8966','Oberwil-Lieli','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('291','8967','Widen','Aargau','AG','194','N');
INSERT INTO PLZ VALUES ('292','9050','Appenzell','Appenzell Innerrhoden','AI','194','N');
INSERT INTO PLZ VALUES ('293','9050','Appenzell Eggerstanden','Appenzell Innerrhoden','AI','194','N');
INSERT INTO PLZ VALUES ('294','9050','Appenzell Enggenhtten','Appenzell Innerrhoden','AI','194','N');
INSERT INTO PLZ VALUES ('295','9050','Appenzell Meistersrte','Appenzell Innerrhoden','AI','194','N');
INSERT INTO PLZ VALUES ('296','9050','Appenzell Steinegg','Appenzell Innerrhoden','AI','194','N');
INSERT INTO PLZ VALUES ('297','9050','Appenzell Schlatt','Appenzell Innerrhoden','AI','194','N');
INSERT INTO PLZ VALUES ('298','9054','Haslen AI','Appenzell Innerrhoden','AI','194','N');
INSERT INTO PLZ VALUES ('299','9057','Weissbad','Appenzell Innerrhoden','AI','194','N');
INSERT INTO PLZ VALUES ('300','9057','Schwende','Appenzell Innerrhoden','AI','194','N');
INSERT INTO PLZ VALUES ('301','9057','Wasserauen','Appenzell Innerrhoden','AI','194','N');
INSERT INTO PLZ VALUES ('302','9058','Brlisau','Appenzell Innerrhoden','AI','194','N');
INSERT INTO PLZ VALUES ('303','9108','Gonten','Appenzell Innerrhoden','AI','194','N');
INSERT INTO PLZ VALUES ('304','9108','Gontenbad','Appenzell Innerrhoden','AI','194','N');
INSERT INTO PLZ VALUES ('305','9108','Jakobsbad','Appenzell Innerrhoden','AI','194','N');
INSERT INTO PLZ VALUES ('306','9413','Oberegg','Appenzell Innerrhoden','AI','194','N');
INSERT INTO PLZ VALUES ('307','9442','Briswilen','Appenzell Innerrhoden','AI','194','N');
INSERT INTO PLZ VALUES ('308','9035','Grub AR','Appenzell Ausserrhoden','AR','194','N');
INSERT INTO PLZ VALUES ('309','9037','Speicherschwendi','Appenzell Ausserrhoden','AR','194','N');
INSERT INTO PLZ VALUES ('310','9038','Rehetobel','Appenzell Ausserrhoden','AR','194','N');
INSERT INTO PLZ VALUES ('311','9042','Speicher','Appenzell Ausserrhoden','AR','194','N');
INSERT INTO PLZ VALUES ('312','9043','Trogen','Appenzell Ausserrhoden','AR','194','N');
INSERT INTO PLZ VALUES ('313','9044','Wald AR','Appenzell Ausserrhoden','AR','194','N');
INSERT INTO PLZ VALUES ('314','9052','Niederteufen','Appenzell Ausserrhoden','AR','194','N');
INSERT INTO PLZ VALUES ('315','9053','Teufen AR','Appenzell Ausserrhoden','AR','194','N');
INSERT INTO PLZ VALUES ('316','9055','Bhler','Appenzell Ausserrhoden','AR','194','N');
INSERT INTO PLZ VALUES ('317','9056','Gais','Appenzell Ausserrhoden','AR','194','N');
INSERT INTO PLZ VALUES ('318','9062','Lustmhle','Appenzell Ausserrhoden','AR','194','N');
INSERT INTO PLZ VALUES ('319','9063','Stein AR','Appenzell Ausserrhoden','AR','194','N');
INSERT INTO PLZ VALUES ('320','9064','Hundwil','Appenzell Ausserrhoden','AR','194','N');
INSERT INTO PLZ VALUES ('321','9100','Herisau','Appenzell Ausserrhoden','AR','194','N');
INSERT INTO PLZ VALUES ('322','9101','Herisau','Appenzell Ausserrhoden','AR','194','N');
INSERT INTO PLZ VALUES ('323','9102','Herisau','Appenzell Ausserrhoden','AR','194','N');
INSERT INTO PLZ VALUES ('324','9103','Schwellbrunn','Appenzell Ausserrhoden','AR','194','N');
INSERT INTO PLZ VALUES ('325','9104','Waldstatt','Appenzell Ausserrhoden','AR','194','N');
INSERT INTO PLZ VALUES ('326','9105','Schnengrund','Appenzell Ausserrhoden','AR','194','N');
INSERT INTO PLZ VALUES ('327','9107','Urnsch','Appenzell Ausserrhoden','AR','194','N');
INSERT INTO PLZ VALUES ('328','9112','Schachen b. Herisau','Appenzell Ausserrhoden','AR','194','N');
INSERT INTO PLZ VALUES ('329','9405','Wienacht-Tobel','Appenzell Ausserrhoden','AR','194','N');
INSERT INTO PLZ VALUES ('330','9410','Heiden','Appenzell Ausserrhoden','AR','194','N');
INSERT INTO PLZ VALUES ('331','9411','Reute AR','Appenzell Ausserrhoden','AR','194','N');
INSERT INTO PLZ VALUES ('332','9414','Schachen b. Reute','Appenzell Ausserrhoden','AR','194','N');
INSERT INTO PLZ VALUES ('333','9426','Lutzenberg','Appenzell Ausserrhoden','AR','194','N');
INSERT INTO PLZ VALUES ('334','9427','Wolfhalden','Appenzell Ausserrhoden','AR','194','N');
INSERT INTO PLZ VALUES ('335','9427','Zelg (Wolfhalden)','Appenzell Ausserrhoden','AR','194','N');
INSERT INTO PLZ VALUES ('336','9428','Walzenhausen','Appenzell Ausserrhoden','AR','194','N');
INSERT INTO PLZ VALUES ('337','1595','Clavaleyres','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('338','1657','Ablndschen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('339','1738','Sangernboden','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('340','1797','Mnchenwiler','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('341','2333','La Ferrire','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('342','2333','La Cibourg','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('343','2500','Biel/Bienne','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('344','2500','Biel/Bienne 3','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('345','2500','Biel/Bienne 4','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('346','2500','Biel/Bienne 6','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('347','2500','Biel/Bienne 7','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('348','2500','Biel/Bienne 8','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('349','2501','Biel/Bienne','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('350','2502','Biel/Bienne','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('351','2503','Biel/Bienne','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('352','2504','Biel/Bienne','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('353','2505','Biel/Bienne','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('354','2512','Tscherz-Alferme','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('355','2513','Twann','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('356','2514','Ligerz','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('357','2515','Prles','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('358','2516','Lamboing','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('359','2517','Diesse','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('360','2518','Nods','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('361','2520','La Neuveville','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('362','2532','Magglingen/Macolin','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('363','2533','Evilard','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('364','2534','Orvin','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('365','2534','Les Prs-d\'Orvin','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('366','2535','Frinvillier','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('367','2536','Plagne','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('368','2537','Vauffelin','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('369','2538','Romont BE','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('370','2542','Pieterlen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('371','2543','Lengnau BE','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('372','2552','Orpund','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('373','2553','Safnern','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('374','2554','Meinisberg','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('375','2555','Brgg BE','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('376','2556','Scheuren','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('377','2556','Schwadernau','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('378','2557','Studen BE','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('379','2558','Aegerten','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('380','2560','Nidau','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('381','2562','Port','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('382','2563','Ipsach','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('383','2564','Bellmund','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('384','2565','Jens','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('385','2572','Sutz','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('386','2572','Mrigen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('387','2575','Tuffelen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('388','2575','Hagneck','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('389','2575','Gerolfingen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('390','2576','Lscherz','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('391','2577','Siselen BE','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('392','2577','Finsterhennen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('393','2603','Pry','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('394','2604','La Heutte','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('395','2605','Sonceboz-Sombeval','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('396','2606','Corgmont','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('397','2607','Cortbert','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('398','2608','Courtelary','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('399','2608','Montagne-de-Courtelary','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('400','2610','St-Imier','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('401','2610','Mont-Soleil','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('402','2610','Mont-Crosin','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('403','2610','Les Pontins','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('404','2612','Cormoret','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('405','2613','Villeret','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('406','2615','Sonvilier','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('407','2615','Montagne-de-Sonvilier','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('408','2616','Renan BE','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('409','2616','La Cibourg','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('410','2710','Tavannes','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('411','2712','Le Fuet','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('412','2713','Bellelay','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('413','2715','Monible','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('414','2715','Chtelat','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('415','2716','Sornetan','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('416','2717','Fornet-Dessous','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('417','2717','Rebvelier','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('418','2720','Tramelan','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('419','2720','La Tanne','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('420','2722','Les Reussilles','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('421','2723','Mont-Tramelan','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('422','2732','Reconvilier','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('423','2732','Saicourt','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('424','2732','Saules BE','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('425','2732','Loveresse','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('426','2733','Pontenet','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('427','2735','Bvilard','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('428','2735','Champoz','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('429','2735','Malleray','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('430','2735','Malleray-Bvilard','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('431','2736','Sorvilier','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('432','2738','Court','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('433','2740','Moutier','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('434','2740','Moutier 1','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('435','2740','Moutier 2','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('436','2742','Perrefitte','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('437','2743','Eschert','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('438','2744','Belprahon','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('439','2745','Grandval','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('440','2746','Crmines','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('441','2747','Seehof','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('442','2747','Corcelles BE','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('443','2748','Souboz','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('444','2748','Les Ecorcheresses','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('445','2762','Roches BE','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('446','2827','Schelten','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('447','3000','Bern','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('448','3000','Bern 5','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('449','3000','Bern 6','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('450','3000','Bern 8','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('451','3000','Bern 9','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('452','3000','Bern 13','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('453','3000','Bern 14','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('454','3000','Bern 15','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('455','3000','Bern 22','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('456','3000','Bern 23','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('457','3000','Bern 25','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('458','3000','Bern 31','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('459','3000','Bern 7 Brenplatz','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('460','3000','Bern 71 CS PZ','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('461','3000','Bern 60 UPD','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('462','3000','Bern 94 UBS','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('463','3000','Bern 65 SBB','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('464','3000','Bern 90','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('465','3001','Bern','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('466','3002','Bern Postfinance','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('467','3003','Bern','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('468','3003','Bern 3 Nationalrat','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('469','3003','Bern 3 Stnderat','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('470','3004','Bern','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('471','3005','Bern','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('472','3006','Bern','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('473','3007','Bern','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('474','3008','Bern','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('475','3010','Bern','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('476','3011','Bern','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('477','3012','Bern','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('478','3013','Bern','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('479','3014','Bern','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('480','3015','Bern','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('481','3018','Bern','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('482','3019','Bern','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('483','3020','Bern','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('484','3024','Bern','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('485','3027','Bern','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('486','3029','Bern Entris','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('487','3030','Bern','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('488','3032','Hinterkappelen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('489','3033','Wohlen b. Bern','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('490','3034','Murzelen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('491','3035','Frieswil','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('492','3036','Detligen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('493','3037','Herrenschwanden','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('494','3038','Kirchlindach','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('495','3039','Bern PF Operations Center','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('496','3040','Bern','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('497','3041','Bern UBS','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('498','3042','Ortschwaben','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('499','3043','Uettligen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('500','3044','Innerberg','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('501','3045','Meikirch','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('502','3046','Wahlendorf','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('503','3047','Bremgarten b. Bern','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('504','3048','Worblaufen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('505','3049','Sriswil','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('506','3050','Bern Swisscom','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('507','3052','Zollikofen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('508','3053','Mnchenbuchsee','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('509','3053','Deisswil b. Mnchenbuchsee','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('510','3053','Diemerswil','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('511','3053','Wiggiswil','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('512','3053','Ltti','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('513','3054','Schpfen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('514','3063','Ittigen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('515','3065','Bolligen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('516','3065','Bolligen Dorf','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('517','3066','Stettlen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('518','3067','Boll','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('519','3068','Utzigen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('520','3072','Ostermundigen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('521','3072','Ostermundigen 1','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('522','3072','Ostermundigen 2','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('523','3073','Gmligen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('524','3074','Muri b. Bern','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('525','3075','Rfenacht BE','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('526','3076','Worb','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('527','3077','Enggistein','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('528','3078','Richigen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('529','3082','Schlosswil','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('530','3083','Trimstein','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('531','3084','Wabern','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('532','3085','Wabern 2 x Weihnachten','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('533','3086','Zimmerwald','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('534','3086','Englisberg','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('535','3087','Niedermuhlern','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('536','3088','Reggisberg','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('537','3088','Oberbtschel','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('538','3089','Hinterfultigen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('539','3095','Spiegel b. Bern','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('540','3096','Oberbalm','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('541','3097','Liebefeld','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('542','3098','Kniz','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('543','3098','Schliern b. Kniz','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('544','3099','Rti b. Riggisberg','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('545','3110','Mnsingen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('546','3111','Tgertschi','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('547','3112','Allmendingen b. Bern','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('548','3113','Rubigen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('549','3114','Wichtrach','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('550','3115','Gerzensee','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('551','3116','Kirchdorf BE','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('552','3116','Mhledorf BE','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('553','3116','Noflen BE','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('554','3122','Kehrsatz','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('555','3123','Belp','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('556','3124','Belpberg','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('557','3125','Toffen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('558','3126','Kaufdorf','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('559','3126','Gelterfingen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('560','3127','Mhlethurnen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('561','3127','Lohnstorf','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('562','3128','Kirchenthurnen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('563','3128','Rmligen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('564','3132','Riggisberg','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('565','3144','Gasel','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('566','3145','Niederscherli','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('567','3147','Mittelhusern','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('568','3148','Lanzenhusern','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('569','3150','Schwarzenburg','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('570','3152','Mamishaus','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('571','3153','Rschegg Gambach','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('572','3154','Rschegg Heubach','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('573','3155','Helgisried-Rohrbach','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('574','3156','Riffenmatt','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('575','3157','Milken','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('576','3158','Guggisberg','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('577','3159','Riedsttt','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('578','3172','Niederwangen b. Bern','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('579','3173','Oberwangen b. Bern','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('580','3174','Thrishaus','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('581','3176','Neuenegg','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('582','3177','Laupen BE','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('583','3179','Kriechenwil','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('584','3183','Albligen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('585','3202','Frauenkappelen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('586','3203','Mhleberg','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('587','3204','Rosshusern','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('588','3205','Gmmenen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('589','3206','Rizenbach','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('590','3206','Ferenbalm','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('591','3206','Biberen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('592','3206','Gammen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('593','3207','Wileroltigen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('594','3207','Golaten','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('595','3208','Gurbr','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('596','3225','Mntschemier','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('597','3226','Treiten','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('598','3232','Ins','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('599','3233','Tschugg','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('600','3234','Vinelz','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('601','3235','Erlach','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('602','3236','Gampelen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('603','3237','Brttelen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('604','3238','Gals','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('605','3250','Lyss','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('606','3251','Wengi b. Bren','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('607','3251','Ruppoldsried','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('608','3252','Worben','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('609','3255','Rapperswil BE','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('610','3256','Dieterswil','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('611','3256','Bangerten b. Dieterswil','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('612','3256','Seewil','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('613','3257','Grossaffoltern','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('614','3257','Ammerzwil BE','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('615','3262','Suberg','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('616','3263','Betigen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('617','3264','Diessbach b. Bren','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('618','3266','Wiler b. Seedorf','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('619','3267','Seedorf BE','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('620','3268','Lobsigen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('621','3270','Aarberg','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('622','3271','Radelfingen b. Aarberg','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('623','3272','Walperswil','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('624','3272','Epsach','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('625','3273','Kappelen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('626','3274','Hermrigen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('627','3274','Bhl b. Aarberg','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('628','3274','Merzligen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('629','3282','Bargen BE','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('630','3283','Kallnach','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('631','3283','Niederried b. Kallnach','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('632','3292','Busswil b. Bren','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('633','3293','Dotzigen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('634','3294','Bren an der Aare','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('635','3294','Meienried','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('636','3295','Rti b. Bren','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('637','3296','Arch','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('638','3297','Leuzigen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('639','3298','Oberwil b. Bren','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('640','3302','Moosseedorf','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('641','3303','Jegenstorf','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('642','3303','Zuzwil BE','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('643','3303','Ballmoos','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('644','3303','Mnchringen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('645','3305','Iffwil','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('646','3305','Scheunen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('647','3306','Etzelkofen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('648','3308','Grafenried','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('649','3309','Kernenried','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('650','3309','Zauggenried','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('651','3312','Fraubrunnen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('652','3313','Bren zum Hof','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('653','3314','Schalunen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('654','3315','Btterkinden','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('655','3315','Kriligen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('656','3317','Limpach','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('657','3317','Mlchi','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('658','3321','Schnbhl Einkaufszentrum','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('659','3322','Urtenen-Schnbhl','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('660','3322','Mattstetten','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('661','3323','Briswil BE','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('662','3324','Hindelbank','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('663','3324','Mtschwil','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('664','3325','Hettiswil b. Hindelbank','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('665','3326','Krauchthal','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('666','3360','Herzogenbuchsee','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('667','3362','Niedernz','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('668','3363','Obernz','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('669','3365','Grasswil','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('670','3365','Seeberg','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('671','3366','Bettenhausen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('672','3366','Bollodingen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('673','3367','Thrigen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('674','3367','Ochlenberg','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('675','3368','Bleienbach','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('676','3372','Wanzwil','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('677','3373','Heimenhausen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('678','3373','Rthenbach Herzogenbuchsee','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('679','3374','Wangenried','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('680','3375','Inkwil','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('681','3376','Graben','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('682','3376','Berken','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('683','3377','Walliswil b. Wangen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('684','3380','Wangen an der Aare','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('685','3380','Walliswil b. Niederbipp','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('686','3400','Burgdorf','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('687','3401','Burgdorf','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('688','3402','Burgdorf','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('689','3412','Heimiswil','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('690','3413','Kaltacker','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('691','3414','Oberburg','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('692','3415','Schafhausen im Emmental','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('693','3415','Regsauschachen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('694','3415','Hasle b. Burgdorf','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('695','3415','Hasle-Regsau','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('696','3416','Affoltern im Emmental','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('697','3417','Regsau','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('698','3418','Regsbach','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('699','3419','Biembach im Emmental','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('700','3421','Lyssach','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('701','3421','Rti b. Lyssach','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('702','3422','Kirchberg BE','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('703','3422','Rdtligen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('704','3422','Alchenflh','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('705','3423','Ersigen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('706','3424','Niedersch','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('707','3424','Obersch','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('708','3425','Koppigen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('709','3425','Willadingen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('710','3426','Aefligen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('711','3427','Utzenstorf','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('712','3428','Wiler b. Utzenstorf','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('713','3429','Hellsau','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('714','3429','Hchstetten','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('715','3432','Ltzelflh-Goldbach','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('716','3433','Schwanden im Emmental','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('717','3434','Obergoldbach','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('718','3435','Ramsei','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('719','3436','Zollbrck','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('720','3437','Rderswil','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('721','3438','Lauperswil','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('722','3439','Ranflh','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('723','3452','Grnenmatt','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('724','3453','Heimisbach','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('725','3454','Sumiswald','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('726','3455','Grnen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('727','3456','Trachselwald','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('728','3457','Wasen im Emmental','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('729','3462','Weier im Emmental','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('730','3463','Husernmoos im Emmental','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('731','3464','Schmidigen-Mhleweg','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('732','3465','Drrenroth','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('733','3472','Wynigen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('734','3472','Rumendingen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('735','3473','Alchenstorf','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('736','3474','Redisbach','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('737','3475','Riedtwil','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('738','3475','Hermiswil','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('739','3476','Oschwand','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('740','3503','Gysenstein','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('741','3504','Niederhnigen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('742','3504','Oberhnigen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('743','3506','Grosshchstetten','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('744','3507','Biglen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('745','3508','Arni BE','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('746','3510','Konolfingen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('747','3510','Freimettigen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('748','3510','Hutligen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('749','3512','Walkringen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('750','3513','Bigenthal','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('751','3531','Oberthal','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('752','3532','Zziwil','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('753','3532','Mirchel','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('754','3533','Bowil','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('755','3534','Signau','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('756','3535','Schpbach','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('757','3536','Aeschau','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('758','3537','Eggiwil','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('759','3538','Rthenbach im Emmental','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('760','3543','Emmenmatt','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('761','3550','Langnau im Emmental','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('762','3551','Oberfrittenbach','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('763','3552','Brau','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('764','3553','Gohl','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('765','3555','Trubschachen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('766','3556','Trub','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('767','3557','Fankhaus (Trub)','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('768','3600','Thun','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('769','3601','Thun','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('770','3602','Thun','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('771','3603','Thun','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('772','3604','Thun','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('773','3607','Thun','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('774','3608','Thun','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('775','3609','Thun','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('776','3612','Steffisburg','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('777','3613','Steffisburg','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('778','3614','Unterlangenegg','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('779','3615','Heimenschwand','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('780','3616','Schwarzenegg','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('781','3617','Fahrni b. Thun','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('782','3618','Sderen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('783','3619','Eriz','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('784','3619','Innereriz','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('785','3622','Homberg b. Thun','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('786','3623','Teuffenthal b. Thun','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('787','3623','Horrenbach','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('788','3623','Buchen BE','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('789','3624','Goldiwil (Thun)','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('790','3624','Schwendibach','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('791','3625','Heiligenschwendi','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('792','3626','Hnibach','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('793','3627','Heimberg','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('794','3628','Uttigen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('795','3628','Kienersrti','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('796','3629','Kiesen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('797','3629','Oppligen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('798','3629','Jaberg','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('799','3631','Hfen b. Thun','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('800','3632','Niederstocken','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('801','3632','Oberstocken','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('802','3633','Amsoldingen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('803','3634','Thierachern','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('804','3635','Uebeschi','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('805','3636','Lngenbhl','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('806','3636','Forst b. Lngenbhl','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('807','3638','Blumenstein','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('808','3638','Pohlern','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('809','3645','Gwatt (Thun)','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('810','3645','Zwieselberg','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('811','3646','Einigen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('812','3647','Reutigen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('813','3652','Hilterfingen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('814','3653','Oberhofen am Thunersee','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('815','3654','Gunten','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('816','3655','Sigriswil','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('817','3656','Tschingel ob Gunten','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('818','3656','Aeschlen ob Gunten','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('819','3656','Ringoldswil','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('820','3657','Schwanden (Sigriswil)','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('821','3658','Merligen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('822','3661','Uetendorf','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('823','3662','Seftigen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('824','3663','Gurzelen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('825','3664','Burgistein','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('826','3665','Wattenwil','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('827','3671','Brenzikofen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('828','3671','Herbligen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('829','3672','Oberdiessbach','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('830','3672','Aeschlen b. Oberdiessbach','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('831','3673','Linden','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('832','3674','Bleiken b. Oberdiessbach','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('833','3700','Spiez','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('834','3702','Hondrich','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('835','3703','Aeschi b. Spiez','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('836','3703','Aeschiried','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('837','3704','Krattigen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('838','3705','Faulensee','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('839','3706','Leissigen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('840','3707','Drligen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('841','3711','Emdthal','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('842','3711','Mlenen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('843','3713','Reichenbach im Kandertal','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('844','3714','Frutigen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('845','3714','Wengi b. Frutigen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('846','3715','Adelboden','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('847','3716','Kandergrund','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('848','3717','Blausee-Mitholz','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('849','3718','Kandersteg','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('850','3722','Scharnachtal','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('851','3723','Kiental','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('852','3724','Ried (Frutigen)','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('853','3725','Achseten','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('854','3752','Wimmis','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('855','3753','Oey','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('856','3754','Diemtigen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('857','3755','Horboden','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('858','3756','Zwischenflh','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('859','3757','Schwenden im Diemtigtal','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('860','3758','Latterbach','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('861','3762','Erlenbach im Simmental','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('862','3763','Drstetten','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('863','3764','Weissenburg','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('864','3765','Oberwil im Simmental','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('865','3766','Boltigen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('866','3770','Zweisimmen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('867','3771','Blankenburg','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('868','3772','St. Stephan','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('869','3773','Matten (St. Stephan)','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('870','3775','Lenk im Simmental','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('871','3776','Oeschseite','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('872','3777','Saanenmser','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('873','3778','Schnried','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('874','3780','Gstaad','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('875','3781','Turbach','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('876','3782','Lauenen b. Gstaad','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('877','3783','Grund b. Gstaad','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('878','3784','Feutersoey','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('879','3785','Gsteig b. Gstaad','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('880','3792','Saanen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('881','3800','Interlaken','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('882','3800','Unterseen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('883','3800','Matten b. Interlaken','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('884','3800','Sundlauenen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('885','3803','Beatenberg','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('886','3804','Habkern','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('887','3805','Goldswil b. Interlaken','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('888','3806','Bnigen b. Interlaken','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('889','3807','Iseltwald','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('890','3812','Wilderswil','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('891','3813','Saxeten','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('892','3814','Gsteigwiler','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('893','3815','Zweiltschinen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('894','3815','Gndlischwand','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('895','3816','Ltschental','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('896','3816','Burglauenen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('897','3818','Grindelwald','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('898','3822','Lauterbrunnen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('899','3822','Isenfluh','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('900','3823','Wengen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('901','3823','Kleine Scheidegg','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('902','3823','Eigergletscher','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('903','3824','Stechelberg','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('904','3825','Mrren','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('905','3826','Gimmelwald','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('906','3852','Ringgenberg BE','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('907','3853','Niederried b. Interlaken','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('908','3854','Oberried am Brienzersee','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('909','3855','Brienz BE','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('910','3855','Axalp','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('911','3855','Schwanden b. Brienz','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('912','3856','Brienzwiler','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('913','3857','Unterbach BE','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('914','3858','Hofstetten b. Brienz','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('915','3860','Meiringen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('916','3860','Brnig','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('917','3860','Rosenlaui','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('918','3860','Schattenhalb','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('919','3862','Innertkirchen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('920','3863','Gadmen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('921','3864','Guttannen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('922','4536','Attiswil','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('923','4537','Wiedlisbach','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('924','4538','Oberbipp','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('925','4539','Rumisberg','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('926','4539','Farnern','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('927','4564','Zielebach','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('928','4704','Niederbipp','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('929','4704','Wolfisberg','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('930','4900','Langenthal','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('931','4901','Langenthal','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('932','4902','Langenthal','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('933','4911','Schwarzhusern','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('934','4912','Aarwangen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('935','4913','Bannwil','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('936','4914','Roggwil BE','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('937','4916','Untersteckholz','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('938','4917','Melchnau','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('939','4917','Busswil b. Melchnau','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('940','4919','Reisiswil','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('941','4922','Btzberg','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('942','4922','Thunstetten','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('943','4923','Wynau','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('944','4924','Obersteckholz','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('945','4932','Lotzwil','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('946','4932','Gutenburg','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('947','4933','Rtschelen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('948','4934','Madiswil','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('949','4935','Leimiswil','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('950','4936','Kleindietwil','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('951','4937','Ursenbach','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('952','4938','Rohrbach','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('953','4938','Rohrbachgraben','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('954','4942','Walterswil BE','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('955','4943','Oeschenbach','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('956','4944','Auswil','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('957','4950','Huttwil','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('958','4952','Eriswil','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('959','4953','Schwarzenbach (Huttwil)','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('960','4954','Wyssachen','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('961','4955','Gondiswil','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('962','6083','Hasliberg Hohfluh','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('963','6084','Hasliberg Wasserwendi','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('964','6085','Hasliberg Goldern','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('965','6086','Hasliberg Reuti','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('966','6197','Schangnau','Bern','BE','194','N');
INSERT INTO PLZ VALUES ('967','2814','Roggenburg','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('968','4023','Basel','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('969','4040','Basel','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('970','4042','Basel PF Operations Center','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('971','4101','Bruderholz','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('972','4102','Binningen','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('973','4102','Binningen 1','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('974','4102','Binningen 2','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('975','4103','Bottmingen','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('976','4104','Oberwil BL','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('977','4105','Biel-Benken BL','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('978','4106','Therwil','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('979','4107','Ettingen','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('980','4117','Burg im Leimental','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('981','4123','Allschwil','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('982','4123','Allschwil 1','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('983','4123','Allschwil 2','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('984','4124','Schnenbuch','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('985','4127','Birsfelden','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('986','4132','Muttenz','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('987','4132','Muttenz 1','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('988','4132','Muttenz 2','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('989','4133','Pratteln','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('990','4133','Pratteln 1','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('991','4133','Pratteln 2','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('992','4142','Mnchenstein','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('993','4142','Mnchenstein 1','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('994','4142','Mnchenstein 3','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('995','4144','Arlesheim','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('996','4147','Aesch BL','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('997','4148','Pfeffingen','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('998','4153','Reinach BL','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('999','4153','Reinach BL 1','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1000','4153','Reinach BL 2','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1001','4202','Duggingen','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1002','4203','Grellingen','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1003','4207','Bretzwil','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1004','4222','Zwingen','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1005','4223','Blauen','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1006','4224','Nenzlingen','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1007','4225','Brislach','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1008','4242','Laufen','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1009','4243','Dittingen','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1010','4244','Rschenz','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1011','4246','Wahlen b. Laufen','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1012','4253','Liesberg','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1013','4254','Liesberg Dorf','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1014','4302','Augst BL','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1015','4304','Giebenach','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1016','4402','Frenkendorf','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1017','4410','Liestal','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1018','4411','Seltisberg','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1019','4414','Fllinsdorf','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1020','4415','Lausen','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1021','4416','Bubendorf','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1022','4417','Ziefen','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1023','4418','Reigoldswil','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1024','4419','Lupsingen','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1025','4422','Arisdorf','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1026','4423','Hersberg','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1027','4424','Arboldswil','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1028','4425','Titterten','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1029','4426','Lauwil','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1030','4431','Bennwil','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1031','4432','Lampenberg','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1032','4433','Ramlinsburg','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1033','4434','Hlstein','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1034','4435','Niederdorf','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1035','4436','Oberdorf BL','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1036','4436','Liedertswil','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1037','4437','Waldenburg','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1038','4438','Langenbruck','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1039','4441','Thrnen','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1040','4442','Diepflingen','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1041','4443','Wittinsburg','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1042','4444','Rmlingen','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1043','4445','Hfelfingen','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1044','4446','Buckten','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1045','4447','Knerkinden','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1046','4448','Lufelfingen','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1047','4450','Sissach','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1048','4451','Wintersingen','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1049','4452','Itingen','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1050','4453','Nusshof','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1051','4455','Zunzgen','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1052','4456','Tenniken','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1053','4457','Diegten','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1054','4458','Eptingen','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1055','4460','Gelterkinden','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1056','4461','Bckten','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1057','4462','Rickenbach BL','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1058','4463','Buus','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1059','4464','Maisprach','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1060','4465','Hemmiken','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1061','4466','Ormalingen','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1062','4467','Rothenfluh','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1063','4469','Anwil','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1064','4492','Tecknau','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1065','4493','Wenslingen','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1066','4494','Oltingen','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1067','4495','Zeglingen','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1068','4496','Kilchberg BL','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1069','4497','Rnenberg','Baselland','BL','194','N');
INSERT INTO PLZ VALUES ('1070','4000','Basel','Basel Stadt','BS','194','N');
INSERT INTO PLZ VALUES ('1071','4001','Basel','Basel Stadt','BS','194','N');
INSERT INTO PLZ VALUES ('1072','4002','Basel','Basel Stadt','BS','194','N');
INSERT INTO PLZ VALUES ('1073','4003','Basel','Basel Stadt','BS','194','N');
INSERT INTO PLZ VALUES ('1074','4004','Basel','Basel Stadt','BS','194','N');
INSERT INTO PLZ VALUES ('1075','4005','Basel','Basel Stadt','BS','194','N');
INSERT INTO PLZ VALUES ('1076','4007','Basel','Basel Stadt','BS','194','N');
INSERT INTO PLZ VALUES ('1077','4008','Basel','Basel Stadt','BS','194','N');
INSERT INTO PLZ VALUES ('1078','4009','Basel','Basel Stadt','BS','194','N');
INSERT INTO PLZ VALUES ('1079','4010','Basel','Basel Stadt','BS','194','N');
INSERT INTO PLZ VALUES ('1080','4011','Basel','Basel Stadt','BS','194','N');
INSERT INTO PLZ VALUES ('1081','4012','Basel','Basel Stadt','BS','194','N');
INSERT INTO PLZ VALUES ('1082','4013','Basel','Basel Stadt','BS','194','N');
INSERT INTO PLZ VALUES ('1083','4015','Basel','Basel Stadt','BS','194','N');
INSERT INTO PLZ VALUES ('1084','4016','Basel','Basel Stadt','BS','194','N');
INSERT INTO PLZ VALUES ('1085','4018','Basel','Basel Stadt','BS','194','N');
INSERT INTO PLZ VALUES ('1086','4019','Basel','Basel Stadt','BS','194','N');
INSERT INTO PLZ VALUES ('1087','4020','Basel','Basel Stadt','BS','194','N');
INSERT INTO PLZ VALUES ('1088','4025','Basel','Basel Stadt','BS','194','N');
INSERT INTO PLZ VALUES ('1089','4030','Basel','Basel Stadt','BS','194','N');
INSERT INTO PLZ VALUES ('1090','4031','Basel Universittsspital','Basel Stadt','BS','194','N');
INSERT INTO PLZ VALUES ('1091','4039','Basel','Basel Stadt','BS','194','N');
INSERT INTO PLZ VALUES ('1092','4041','Basel UBS','Basel Stadt','BS','194','N');
INSERT INTO PLZ VALUES ('1093','4051','Basel','Basel Stadt','BS','194','N');
INSERT INTO PLZ VALUES ('1094','4052','Basel','Basel Stadt','BS','194','N');
INSERT INTO PLZ VALUES ('1095','4053','Basel','Basel Stadt','BS','194','N');
INSERT INTO PLZ VALUES ('1096','4054','Basel','Basel Stadt','BS','194','N');
INSERT INTO PLZ VALUES ('1097','4055','Basel','Basel Stadt','BS','194','N');
INSERT INTO PLZ VALUES ('1098','4056','Basel','Basel Stadt','BS','194','N');
INSERT INTO PLZ VALUES ('1099','4057','Basel','Basel Stadt','BS','194','N');
INSERT INTO PLZ VALUES ('1100','4058','Basel','Basel Stadt','BS','194','N');
INSERT INTO PLZ VALUES ('1101','4059','Basel','Basel Stadt','BS','194','N');
INSERT INTO PLZ VALUES ('1102','4065','Basel SBB Cargo AG','Basel Stadt','BS','194','N');
INSERT INTO PLZ VALUES ('1103','4070','Basel','Basel Stadt','BS','194','N');
INSERT INTO PLZ VALUES ('1104','4075','Basel','Basel Stadt','BS','194','N');
INSERT INTO PLZ VALUES ('1105','4078','Basel Reader\'s Digest','Basel Stadt','BS','194','N');
INSERT INTO PLZ VALUES ('1106','4080','Basel','Basel Stadt','BS','194','N');
INSERT INTO PLZ VALUES ('1107','4083','Basel','Basel Stadt','BS','194','N');
INSERT INTO PLZ VALUES ('1108','4084','Basel','Basel Stadt','BS','194','N');
INSERT INTO PLZ VALUES ('1109','4085','Basel','Basel Stadt','BS','194','N');
INSERT INTO PLZ VALUES ('1110','4086','Basel','Basel Stadt','BS','194','N');
INSERT INTO PLZ VALUES ('1111','4087','Basel','Basel Stadt','BS','194','N');
INSERT INTO PLZ VALUES ('1112','4088','Basel','Basel Stadt','BS','194','N');
INSERT INTO PLZ VALUES ('1113','4089','Basel SPILOG','Basel Stadt','BS','194','N');
INSERT INTO PLZ VALUES ('1114','4089','Basel SPI GLS Retour','Basel Stadt','BS','194','N');
INSERT INTO PLZ VALUES ('1115','4091','Basel','Basel Stadt','BS','194','N');
INSERT INTO PLZ VALUES ('1116','4092','Basel SPI AS 22','Basel Stadt','BS','194','N');
INSERT INTO PLZ VALUES ('1117','4093','Basel SPI AS 23','Basel Stadt','BS','194','N');
INSERT INTO PLZ VALUES ('1118','4094','Basel SPI AS 24','Basel Stadt','BS','194','N');
INSERT INTO PLZ VALUES ('1119','4095','Basel SPI AS 25','Basel Stadt','BS','194','N');
INSERT INTO PLZ VALUES ('1120','4096','Basel SPI AS 26','Basel Stadt','BS','194','N');
INSERT INTO PLZ VALUES ('1121','4125','Riehen','Basel Stadt','BS','194','N');
INSERT INTO PLZ VALUES ('1122','4125','Riehen 1','Basel Stadt','BS','194','N');
INSERT INTO PLZ VALUES ('1123','4125','Riehen 2','Basel Stadt','BS','194','N');
INSERT INTO PLZ VALUES ('1124','4126','Bettingen','Basel Stadt','BS','194','N');
INSERT INTO PLZ VALUES ('1125','8238','Bsingen','Schaffhausen','SH','194','N');
INSERT INTO PLZ VALUES ('1126','9485','Nendeln','Frstentum Liechtenstein','FL','194','N');
INSERT INTO PLZ VALUES ('1127','9486','Schaanwald','Frstentum Liechtenstein','FL','194','N');
INSERT INTO PLZ VALUES ('1128','9487','Gamprin-Bendern','Frstentum Liechtenstein','FL','194','N');
INSERT INTO PLZ VALUES ('1129','9488','Schellenberg','Frstentum Liechtenstein','FL','194','N');
INSERT INTO PLZ VALUES ('1130','9490','Vaduz','Frstentum Liechtenstein','FL','194','N');
INSERT INTO PLZ VALUES ('1131','9491','Ruggell','Frstentum Liechtenstein','FL','194','N');
INSERT INTO PLZ VALUES ('1132','9492','Eschen','Frstentum Liechtenstein','FL','194','N');
INSERT INTO PLZ VALUES ('1133','9493','Mauren FL','Frstentum Liechtenstein','FL','194','N');
INSERT INTO PLZ VALUES ('1134','9494','Schaan','Frstentum Liechtenstein','FL','194','N');
INSERT INTO PLZ VALUES ('1135','9495','Triesen','Frstentum Liechtenstein','FL','194','N');
INSERT INTO PLZ VALUES ('1136','9496','Balzers','Frstentum Liechtenstein','FL','194','N');
INSERT INTO PLZ VALUES ('1137','9497','Triesenberg','Frstentum Liechtenstein','FL','194','N');
INSERT INTO PLZ VALUES ('1138','9498','Planken','Frstentum Liechtenstein','FL','194','N');
INSERT INTO PLZ VALUES ('1139','1410','Prvondavaux','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1140','1468','Cheyres','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1141','1470','Estavayer-le-Lac','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1142','1470','Bollion','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1143','1470','Lully FR','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1144','1470','Seiry','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1145','1473','Font','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1146','1473','Chtillon FR','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1147','1474','Chbles FR','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1148','1475','Autavaux','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1149','1475','Forel FR','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1150','1475','Montbrelloz','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1151','1482','Cugy FR','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1152','1483','Montet (Broye)','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1153','1483','Frasses','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1154','1483','Vesin','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1155','1484','Aumont','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1156','1484','Granges-de-Vesin','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1157','1485','Nuvilly','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1158','1486','Vuissens','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1159','1489','Murist','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1160','1527','Villeneuve FR','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1161','1528','Surpierre','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1162','1528','Praratoud','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1163','1529','Cheiry','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1164','1532','Ftigny','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1165','1533','Mnires','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1166','1534','Chapelle (Broye)','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1167','1541','Bussy FR','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1168','1541','Morens FR','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1169','1541','Svaz','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1170','1542','Rueyres-les-Prs','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1171','1544','Gletterens','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1172','1553','Chtonnaye','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1173','1563','Dompierre FR','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1174','1564','Domdidier','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1175','1565','Vallon','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1176','1566','St-Aubin FR','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1177','1566','Les Friques','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1178','1567','Delley','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1179','1568','Portalban','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1180','1583','Villarepos','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1181','1608','Chapelle (Glne)','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1182','1609','St-Martin FR','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1183','1609','Besencens','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1184','1609','Fiaugres','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1185','1611','Le Crt-prs-Semsales','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1186','1614','Granges (Veveyse)','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1187','1615','Bossonnens','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1188','1616','Attalens','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1189','1617','Remaufens','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1190','1617','Tatroz','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1191','1618','Chtel-St-Denis','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1192','1619','Les Paccots','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1193','1623','Semsales','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1194','1624','La Verrerie','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1195','1624','Grattavache','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1196','1624','Progens','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1197','1625','Sles (Gruyre)','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1198','1625','Maules','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1199','1626','Romanens','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1200','1626','Treyfayes','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1201','1626','Rueyres-Treyfayes','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1202','1627','Vaulruz','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1203','1628','Vuadens','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1204','1630','Bulle','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1205','1630','Bulle 1','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1206','1630','Bulle 2','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1207','1632','Riaz','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1208','1633','Marsens','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1209','1633','Vuippens','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1210','1634','La Roche FR','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1211','1635','La Tour-de-Trme','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1212','1636','Broc','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1213','1637','Charmey (Gruyre)','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1214','1638','Morlon','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1215','1642','Sorens','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1216','1643','Gumefens','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1217','1644','Avry-devant-Pont','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1218','1645','Le Bry','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1219','1646','Echarlens','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1220','1647','Corbires','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1221','1648','Hauteville','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1222','1649','Pont-la-Ville','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1223','1651','Villarvolard','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1224','1652','Botterens','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1225','1652','Villarbeney','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1226','1653','Chtel-sur-Montsalvens','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1227','1653','Crsuz','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1228','1654','Cerniat FR','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1229','1656','Jaun','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1230','1656','Im Fang','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1231','1661','Le Pquier-Montbarry','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1232','1663','Gruyres','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1233','1663','Epagny','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1234','1663','Molson-sur-Gruyres','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1235','1663','Pringy','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1236','1665','Estavannens','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1237','1666','Grandvillard','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1238','1666','Villars-sous-Mont','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1239','1667','Enney','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1240','1669','Albeuve','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1241','1669','Neirivue','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1242','1669','Les Sciernes-d\'Albeuve','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1243','1669','Montbovon','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1244','1669','Lessoc','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1245','1670','Ursy','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1246','1670','Bionnens','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1247','1670','Esmonts','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1248','1673','Promasens','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1249','1673','Auboranges','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1250','1673','Ecublens FR','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1251','1673','Rue','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1252','1673','Gillarens','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1253','1674','Vuarmarens','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1254','1674','Montet (Glne)','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1255','1674','Morlens','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1256','1675','Vauderens','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1257','1675','Blessens','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1258','1675','Mossel','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1259','1676','Chavannes-les-Forts','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1260','1677','Prez-vers-Siviriez','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1261','1678','Siviriez','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1262','1679','Villaraboud','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1263','1680','Romont FR','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1264','1680','Berlens','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1265','1681','Billens','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1266','1681','Hennens','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1267','1684','Mzires FR','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1268','1685','Villariaz','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1269','1686','Grangettes-prs-Romont','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1270','1686','La Neirigue','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1271','1687','Vuisternens-devant-Romont','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1272','1687','Estvenens','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1273','1687','La Magne','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1274','1688','Sommentier','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1275','1688','Lieffrens','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1276','1689','Le Chtelard-prs-Romont','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1277','1690','Villaz-St-Pierre','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1278','1690','Lussy FR','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1279','1691','Villarimboud','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1280','1692','Massonnens','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1281','1694','Villarsiviriaux','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1282','1694','Orsonnens','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1283','1694','Chavannes-sous-Orsonnens','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1284','1694','Villargiroud','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1285','1695','Villarlod','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1286','1695','Estavayer-le-Gibloux','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1287','1695','Rueyres-St-Laurent','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1288','1695','Villarsel-le-Gibloux','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1289','1696','Vuisternens-en-Ogoz','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1290','1697','La Joux FR','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1291','1697','Les Ecasseys','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1292','1699','Porsel','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1293','1699','Bouloz','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1294','1699','Pont (Veveyse)','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1295','1700','Fribourg','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1296','1701','Fribourg','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1297','1702','Fribourg','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1298','1704','Fribourg','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1299','1705','Fribourg','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1300','1707','Fribourg','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1301','1708','Fribourg','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1302','1709','Fribourg','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1303','1712','Tafers','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1304','1713','St. Antoni','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1305','1714','Heitenried','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1306','1715','Alterswil FR','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1307','1716','Schwarzsee','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1308','1716','Plaffeien','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1309','1716','Oberschrot','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1310','1717','St. Ursen','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1311','1718','Rechthalten','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1312','1719','Brnisried','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1313','1719','Zumholz','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1314','1720','Corminboeuf','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1315','1720','Chsopelloz','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1316','1721','Cormrod','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1317','1721','Courtion','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1318','1721','Misery','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1319','1721','Misery-Courtion','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1320','1722','Bourguillon','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1321','1723','Marly','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1322','1723','Pierrafortscha','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1323','1723','Villarsel-sur-Marly','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1324','1723','Marly 2','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1325','1723','Marly 1','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1326','1724','Le Mouret','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1327','1724','Bonnefontaine','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1328','1724','Essert FR','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1329','1724','Ferpicloz','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1330','1724','Montvraz','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1331','1724','Oberried FR','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1332','1724','Sendes','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1333','1724','Znauva','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1334','1725','Posieux','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1335','1726','Farvagny','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1336','1726','Farvagny-le-Petit','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1337','1726','Grenilles','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1338','1726','Posat','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1339','1727','Corpataux-Magnedens','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1340','1727','Magnedens','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1341','1728','Rossens FR','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1342','1730','Ecuvillens','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1343','1731','Ependes FR','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1344','1732','Arconciel','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1345','1733','Treyvaux','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1346','1734','Tentlingen','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1347','1735','Giffers','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1348','1736','St. Silvester','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1349','1737','Plasselb','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1350','1740','Neyruz FR','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1351','1741','Cottens FR','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1352','1742','Autigny','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1353','1744','Chnens','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1354','1745','Lentigny','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1355','1746','Prez-vers-Noraz','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1356','1747','Corserey','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1357','1748','Torny-le-Grand','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1358','1749','Middes','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1359','1752','Villars-sur-Glne','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1360','1752','Villars-sur-Glne 1','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1361','1752','Villars-sur-Glne 2','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1362','1753','Matran','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1363','1754','Avry-Centre FR','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1364','1754','Ros','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1365','1754','Corjolens','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1366','1754','Avry-sur-Matran','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1367','1756','Onnens FR','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1368','1756','Lovens','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1369','1757','Noraz','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1370','1762','Givisiez','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1371','1763','Granges-Paccot','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1372','1772','Grolley','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1373','1772','Ponthaux','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1374','1772','Nierlet-les-Bois','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1375','1773','Lchelles','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1376','1773','Chandon','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1377','1773','Russy','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1378','1774','Cousset','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1379','1774','Montagny-les-Monts','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1380','1775','Mannens','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1381','1775','Grandsivaz','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1382','1776','Montagny-la-Ville','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1383','1782','Belfaux','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1384','1782','Autafond','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1385','1782','La Corbaz','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1386','1782','Cormagens','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1387','1782','Lossy','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1388','1782','Formangueires','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1389','1783','Pensier','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1390','1783','Barberche','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1391','1784','Courtepin','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1392','1784','Cournillens','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1393','1784','Wallenried','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1394','1785','Cressier FR','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1395','1786','Sugiez','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1396','1787','Mtier (Vully)','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1397','1787','Mur (Vully) FR','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1398','1788','Praz (Vully)','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1399','1789','Lugnorre','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1400','1791','Courtaman','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1401','1792','Cordast','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1402','1792','Guschelmuth','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1403','1793','Jeuss','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1404','1794','Salvenach','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1405','1795','Courlevon','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1406','1796','Courgevaux','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1407','3175','Flamatt','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1408','3178','Bsingen','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1409','3182','Ueberstorf','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1410','3184','Wnnewil','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1411','3185','Schmitten FR','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1412','3186','Ddingen','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1413','3206','Wallenbuch','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1414','3210','Kerzers','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1415','3212','Gurmels','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1416','3212','Kleingurmels','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1417','3213','Liebistorf','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1418','3213','Kleinbsingen','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1419','3214','Ulmiz','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1420','3215','Gempenach','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1421','3215','Bchslen','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1422','3215','Lurtigen','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1423','3216','Ried b. Kerzers','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1424','3216','Agriswil','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1425','3280','Murten','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1426','3280','Meyriez','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1427','3280','Greng','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1428','3284','Frschels','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1429','3285','Galmiz','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1430','3286','Muntelier','Fribourg','FR','194','N');
INSERT INTO PLZ VALUES ('1431','1200','Genve','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1432','1201','Genve','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1433','1202','Genve','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1434','1203','Genve','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1435','1204','Genve','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1436','1205','Genve','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1437','1206','Genve','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1438','1207','Genve','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1439','1208','Genve','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1440','1209','Genve','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1441','1211','Genve 1','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1442','1211','Genve 2','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1443','1211','Genve 3','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1444','1211','Genve 4','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1445','1211','Genve 6','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1446','1211','Genve 7','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1447','1211','Genve 8','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1448','1211','Genve 10','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1449','1211','Genve 11','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1450','1211','Genve 12','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1451','1211','Genve 13','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1452','1211','Genve 17','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1453','1211','Genve 19','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1454','1211','Genve 20','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1455','1211','Genve 21','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1456','1211','Genve 22','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1457','1211','Genve 23','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1458','1211','Genve 26','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1459','1211','Genve 27','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1460','1211','Genve 28','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1461','1211','Genve 5','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1462','1211','Genve 2 Swisscom','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1463','1211','Genve 14','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1464','1211','Genve 71 CS CP','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1465','1211','Genve 70 CS','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1466','1211','Genve 84 Votations','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1467','1211','Genve 94 UBS','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1468','1211','Genve 73','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1469','1212','Grand-Lancy','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1470','1212','Grand-Lancy 1','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1471','1212','Grand-Lancy 2','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1472','1213','Onex','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1473','1213','Petit-Lancy','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1474','1213','Petit-Lancy 1','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1475','1213','Petit-Lancy 2','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1476','1214','Vernier','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1477','1215','Genve 15 Aroport','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1478','1215','Genve 15 Aroport Dpt','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1479','1216','Cointrin','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1480','1217','Meyrin','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1481','1217','Meyrin 1','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1482','1217','Meyrin 2','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1483','1218','Le Grand-Saconnex','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1484','1219','Le Lignon','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1485','1219','Are','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1486','1219','Chtelaine','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1487','1220','Les Avanchets','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1488','1222','Vsenaz','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1489','1223','Cologny','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1490','1224','Chne-Bougeries','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1491','1225','Chne-Bourg','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1492','1226','Thnex','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1493','1227','Carouge GE','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1494','1227','Les Acacias','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1495','1228','Plan-les-Ouates','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1496','1231','Conches','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1497','1232','Confignon','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1498','1233','Bernex','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1499','1234','Vessy','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1500','1236','Cartigny','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1501','1237','Avully','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1502','1239','Collex','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1503','1240','Genve','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1504','1241','Puplinge','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1505','1242','Satigny','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1506','1243','Presinge','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1507','1244','Choulex','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1508','1245','Collonge-Bellerive','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1509','1246','Corsier GE','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1510','1247','Anires','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1511','1248','Hermance','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1512','1251','Gy','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1513','1252','Meinier','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1514','1253','Vandoeuvres','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1515','1254','Jussy','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1516','1255','Veyrier','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1517','1256','Troinex','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1518','1257','La Croix-de-Rozon','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1519','1258','Perly','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1520','1281','Russin','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1521','1283','La Plaine','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1522','1283','Dardagny','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1523','1284','Chancy','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1524','1285','Athenaz (Avusy)','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1525','1286','Soral','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1526','1287','Laconnex','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1527','1288','Aire-la-Ville','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1528','1289','Genve Services Spciaux','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1529','1290','Versoix','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1530','1292','Chambsy','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1531','1293','Bellevue','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1532','1294','Genthod','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1533','1298','Cligny','Genve','GE','194','N');
INSERT INTO PLZ VALUES ('1534','8750','Glarus','Glarus','GL','194','N');
INSERT INTO PLZ VALUES ('1535','8750','Riedern','Glarus','GL','194','N');
INSERT INTO PLZ VALUES ('1536','8750','Klntal','Glarus','GL','194','N');
INSERT INTO PLZ VALUES ('1537','8752','Nfels','Glarus','GL','194','N');
INSERT INTO PLZ VALUES ('1538','8753','Mollis','Glarus','GL','194','N');
INSERT INTO PLZ VALUES ('1539','8754','Netstal','Glarus','GL','194','N');
INSERT INTO PLZ VALUES ('1540','8755','Ennenda','Glarus','GL','194','N');
INSERT INTO PLZ VALUES ('1541','8756','Mitldi','Glarus','GL','194','N');
INSERT INTO PLZ VALUES ('1542','8757','Filzbach','Glarus','GL','194','N');
INSERT INTO PLZ VALUES ('1543','8758','Obstalden','Glarus','GL','194','N');
INSERT INTO PLZ VALUES ('1544','8759','Netstal','Glarus','GL','194','N');
INSERT INTO PLZ VALUES ('1545','8762','Schwanden GL','Glarus','GL','194','N');
INSERT INTO PLZ VALUES ('1546','8762','Schwndi b. Schwanden','Glarus','GL','194','N');
INSERT INTO PLZ VALUES ('1547','8762','Sool','Glarus','GL','194','N');
INSERT INTO PLZ VALUES ('1548','8765','Engi','Glarus','GL','194','N');
INSERT INTO PLZ VALUES ('1549','8766','Matt','Glarus','GL','194','N');
INSERT INTO PLZ VALUES ('1550','8767','Elm','Glarus','GL','194','N');
INSERT INTO PLZ VALUES ('1551','8772','Nidfurn','Glarus','GL','194','N');
INSERT INTO PLZ VALUES ('1552','8773','Haslen GL','Glarus','GL','194','N');
INSERT INTO PLZ VALUES ('1553','8774','Leuggelbach','Glarus','GL','194','N');
INSERT INTO PLZ VALUES ('1554','8775','Luchsingen','Glarus','GL','194','N');
INSERT INTO PLZ VALUES ('1555','8775','Htzingen','Glarus','GL','194','N');
INSERT INTO PLZ VALUES ('1556','8775','Luchsingen-Htzingen','Glarus','GL','194','N');
INSERT INTO PLZ VALUES ('1557','8777','Diesbach GL','Glarus','GL','194','N');
INSERT INTO PLZ VALUES ('1558','8777','Betschwanden','Glarus','GL','194','N');
INSERT INTO PLZ VALUES ('1559','8782','Rti GL','Glarus','GL','194','N');
INSERT INTO PLZ VALUES ('1560','8783','Linthal','Glarus','GL','194','N');
INSERT INTO PLZ VALUES ('1561','8784','Braunwald','Glarus','GL','194','N');
INSERT INTO PLZ VALUES ('1562','8865','Bilten','Glarus','GL','194','N');
INSERT INTO PLZ VALUES ('1563','8866','Ziegelbrcke','Glarus','GL','194','N');
INSERT INTO PLZ VALUES ('1564','8867','Niederurnen','Glarus','GL','194','N');
INSERT INTO PLZ VALUES ('1565','8868','Oberurnen','Glarus','GL','194','N');
INSERT INTO PLZ VALUES ('1566','8874','Mhlehorn','Glarus','GL','194','N');
INSERT INTO PLZ VALUES ('1567','6534','S. Vittore','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1568','6535','Roveredo GR','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1569','6537','Grono','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1570','6538','Verdabbio','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1571','6540','Castaneda','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1572','6541','Sta. Maria in Calanca','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1573','6542','Buseno','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1574','6543','Arvigo','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1575','6544','Braggio','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1576','6545','Selma','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1577','6546','Cauco','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1578','6547','Augio','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1579','6548','Rossa','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1580','6549','Laura','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1581','6556','Leggia','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1582','6557','Cama','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1583','6558','Lostallo','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1584','6562','Soazza','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1585','6563','Mesocco','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1586','6565','S. Bernardino','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1587','7000','Chur','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1588','7001','Chur','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1589','7002','Chur','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1590','7004','Chur','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1591','7006','Chur','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1592','7007','Chur','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1593','7012','Felsberg','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1594','7013','Domat/Ems','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1595','7014','Trin','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1596','7015','Tamins','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1597','7016','Trin Mulin','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1598','7017','Flims Dorf','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1599','7018','Flims Waldhaus','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1600','7019','Fidaz','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1601','7023','Haldenstein','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1602','7026','Maladers','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1603','7027','Len','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1604','7027','Castiel','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1605','7027','Calfreisen','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1606','7028','St. Peter','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1607','7028','Pagig','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1608','7029','Peist','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1609','7031','Laax GR','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1610','7031','Laax GR 1','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1611','7032','Laax GR 2','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1612','7050','Arosa','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1613','7056','Molinis','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1614','7057','Langwies','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1615','7058','Litzirti','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1616','7062','Passugg-Araschgen','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1617','7063','Praden','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1618','7064','Tschiertschen','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1619','7074','Malix','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1620','7075','Churwalden','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1621','7076','Parpan','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1622','7077','Valbella','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1623','7078','Lenzerheide/Lai','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1624','7082','Vaz/Obervaz','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1625','7083','Lantsch/Lenz','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1626','7084','Brienz/Brinzauls GR','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1627','7104','Versam','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1628','7104','Arezen','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1629','7106','Tenna','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1630','7107','Safien Platz','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1631','7109','Thalkirch','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1632','7110','Peiden','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1633','7111','Pitasch','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1634','7112','Duvin','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1635','7113','Camuns','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1636','7114','Uors (Lumnezia)','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1637','7115','Surcasti','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1638','7116','Tersnaus','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1639','7116','St. Martin (Lugnez)','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1640','7122','Valendas','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1641','7122','Carrera','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1642','7126','Castrisch','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1643','7127','Sevgein','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1644','7128','Riein','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1645','7130','Ilanz','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1646','7130','Schnaus','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1647','7132','Vals','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1648','7133','Obersaxen Affeier','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1649','7134','Obersaxen Meierhof','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1650','7135','Obersaxen Giraniga','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1651','7136','Obersaxen Friggahs','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1652','7137','Flond','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1653','7138','Surcuolm','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1654','7141','Luven','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1655','7142','Cumbel','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1656','7143','Morissen','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1657','7144','Vella','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1658','7145','Degen','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1659','7146','Vattiz','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1660','7147','Vignogn','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1661','7148','Lumbrein','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1662','7148','Surin','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1663','7149','Vrin','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1664','7151','Schluein','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1665','7152','Sagogn','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1666','7153','Falera','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1667','7154','Ruschein','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1668','7155','Ladir','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1669','7156','Rueun','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1670','7156','Pigniu','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1671','7157','Siat','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1672','7158','Waltensburg/Vuorz','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1673','7159','Andiast','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1674','7162','Tavanasa','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1675','7163','Danis','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1676','7164','Dardin','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1677','7165','Breil/Brigels','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1678','7166','Trun','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1679','7167','Zignau','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1680','7168','Schlans','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1681','7172','Rabius','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1682','7173','Surrein','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1683','7174','S. Benedetg','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1684','7175','Sumvitg','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1685','7176','Cumpadials','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1686','7180','Disentis/Mustr','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1687','7182','Cavardiras','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1688','7183','Momp Medel','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1689','7184','Curaglia','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1690','7185','Platta','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1691','7186','Segnas','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1692','7187','Camischolas','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1693','7188','Sedrun','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1694','7189','Rueras','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1695','7201','Untervaz Bahnhof','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1696','7202','Says','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1697','7203','Trimmis','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1698','7204','Untervaz','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1699','7205','Zizers','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1700','7206','Igis','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1701','7208','Malans GR','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1702','7212','Seewis Dorf','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1703','7213','Valzeina','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1704','7214','Grsch','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1705','7214','Seewis-Pardisla','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1706','7214','Seewis-Schmitten','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1707','7215','Fanas','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1708','7220','Schiers','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1709','7222','Mittellunden','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1710','7223','Buchen im Prttigau','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1711','7224','Putz','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1712','7226','Stels','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1713','7226','Fajauna','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1714','7228','Schuders','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1715','7228','Pusserein','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1716','7231','Pragg-Jenaz','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1717','7232','Furna','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1718','7233','Jenaz','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1719','7235','Fideris','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1720','7240','Kblis','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1721','7241','Conters im Prttigau','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1722','7242','Luzein','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1723','7243','Pany','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1724','7244','Gadensttt','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1725','7245','Ascharina','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1726','7246','St. Antnien','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1727','7247','Saas im Prttigau','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1728','7249','Serneus','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1729','7250','Klosters','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1730','7252','Klosters Dorf','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1731','7260','Davos Dorf','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1732','7265','Davos Wolfgang','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1733','7270','Davos Platz','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1734','7270','Davos Platz 1','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1735','7270','Davos 2','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1736','7272','Davos Clavadel','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1737','7276','Davos Frauenkirch','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1738','7277','Davos Glaris','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1739','7278','Davos Monstein','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1740','7302','Landquart','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1741','7303','Mastrils','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1742','7304','Maienfeld','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1743','7306','Flsch','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1744','7307','Jenins','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1745','7402','Bonaduz','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1746','7403','Rhzns','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1747','7404','Feldis/Veulden','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1748','7405','Rothenbrunnen','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1749','7407','Trans','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1750','7408','Cazis','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1751','7408','Realta','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1752','7411','Sils im Domleschg','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1753','7412','Scharans','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1754','7413','Frstenaubruck','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1755','7414','Frstenau','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1756','7415','Rodels','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1757','7415','Pratval','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1758','7416','Almens','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1759','7417','Paspels','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1760','7418','Tumegl/Tomils','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1761','7419','Scheid','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1762','7421','Summaprada','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1763','7422','Tartar','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1764','7423','Sarn','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1765','7423','Portein','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1766','7424','Prz','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1767','7424','Dalin','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1768','7425','Masein','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1769','7426','Flerden','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1770','7427','Urmein','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1771','7428','Tschappina','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1772','7428','Glaspass','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1773','7430','Thusis','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1774','7430','Rongellen','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1775','7431','Mutten','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1776','7431','Obermutten','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1777','7432','Zillis','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1778','7433','Donat','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1779','7433','Mathon','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1780','7433','Farden','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1781','7433','Wergenstein','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1782','7433','Lohn GR','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1783','7434','Sufers','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1784','7435','Splgen','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1785','7436','Medels im Rheinwald','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1786','7437','Nufenen','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1787','7438','Hinterrhein','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1788','7440','Andeer','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1789','7442','Clugin','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1790','7443','Pignia','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1791','7444','Ausserferrera','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1792','7445','Innerferrera','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1793','7446','Campsut-Crt','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1794','7447','Cresta (Avers)','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1795','7447','Am Bach (Avers)','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1796','7448','Juf','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1797','7450','Tiefencastel','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1798','7451','Alvaschein','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1799','7452','Cunter','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1800','7453','Tinizong','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1801','7454','Rona','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1802','7455','Mulegns','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1803','7456','Sur','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1804','7456','Marmorera','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1805','7457','Bivio','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1806','7458','Mon','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1807','7459','Stierva','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1808','7460','Savognin','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1809','7462','Salouf','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1810','7463','Riom','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1811','7464','Parsonz','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1812','7472','Surava','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1813','7473','Alvaneu Bad','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1814','7477','Filisur','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1815','7482','Bergn/Bravuogn','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1816','7482','Stugl/Stuls','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1817','7482','Preda','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1818','7484','Latsch','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1819','7492','Alvaneu Dorf','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1820','7493','Schmitten (Albula)','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1821','7494','Wiesen GR','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1822','7500','St. Moritz','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1823','7500','St. Moritz 1','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1824','7500','St. Moritz 3','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1825','7502','Bever','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1826','7503','Samedan','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1827','7504','Pontresina','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1828','7505','Celerina/Schlarigna','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1829','7512','Champfr','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1830','7513','Silvaplana','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1831','7513','Silvaplana-Surlej','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1832','7514','Sils/Segl Maria','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1833','7514','Fex','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1834','7515','Sils/Segl Baselgia','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1835','7516','Maloja','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1836','7517','Plaun da Lej','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1837','7522','La Punt-Chamues-ch','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1838','7523','Madulain','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1839','7524','Zuoz','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1840','7525','S-chanf','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1841','7526','Cinuos-chel','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1842','7527','Brail','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1843','7530','Zernez','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1844','7532','Tschierv','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1845','7533','Fuldera','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1846','7534','L','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1847','7535','Valchava','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1848','7536','Sta. Maria Val Mstair','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1849','7537','Mstair','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1850','7542','Susch','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1851','7543','Lavin','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1852','7545','Guarda','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1853','7546','Ardez','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1854','7550','Scuol','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1855','7551','Ftan','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1856','7552','Vulpera','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1857','7553','Tarasp','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1858','7554','Sent','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1859','7554','Crusch','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1860','7556','Ramosch','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1861','7557','Vn','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1862','7558','Strada','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1863','7559','Tschlin','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1864','7560','Martina','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1865','7562','Samnaun-Compatsch','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1866','7563','Samnaun Dorf','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1867','7602','Casaccia','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1868','7603','Vicosoprano','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1869','7604','Borgonovo','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1870','7605','Stampa','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1871','7606','Promontogno','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1872','7608','Castasegna','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1873','7610','Soglio','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1874','7710','Ospizio Bernina','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1875','7710','Alp Grm','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1876','7741','S. Carlo (Poschiavo)','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1877','7742','Poschiavo','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1878','7742','Sfaz','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1879','7742','La Rsa','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1880','7743','Brusio','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1881','7743','Miralago','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1882','7744','Campocologno','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1883','7745','Li Curt','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1884','7746','Le Prese','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1885','7747','Viano','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1886','7748','Campascio','Graubnden','GR','194','N');
INSERT INTO PLZ VALUES ('1887','6911','Campione d\'Italia','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('1888','2336','Les Bois','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1889','2338','Les Emibois','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1890','2338','Muriaux','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1891','2340','Le Noirmont','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1892','2345','Les Breuleux','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1893','2345','Le Cerneux-Veusil','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1894','2345','La Chaux-des-Breuleux','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1895','2350','Saignelgier','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1896','2353','Les Pommerats','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1897','2354','Goumois','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1898','2360','Le Bmont','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1899','2362','Montfaucon','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1900','2362','Montfavergier','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1901','2363','Les Enfers','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1902','2364','St-Brais','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1903','2714','Les Genevez JU','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1904','2714','Le Prdame','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1905','2718','Lajoux JU','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1906','2718','Fornet-Dessus','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1907','2800','Delmont','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1908','2800','Delmont 1','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1909','2800','Delmont 2','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1910','2802','Develier','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1911','2803','Bourrignon','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1912','2805','Soyhires','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1913','2806','Mettembert','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1914','2807','Pleigne','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1915','2807','Lucelle','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1916','2812','Movelier','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1917','2813','Ederswiler','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1918','2822','Courroux','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1919','2823','Courcelon','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1920','2824','Vicques','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1921','2825','Courchapoix','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1922','2826','Corban','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1923','2827','Mervelier','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1924','2828','Montsevelier','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1925','2829','Vermes','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1926','2830','Courrendlin','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1927','2830','Vellerat','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1928','2832','Rebeuvelier','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1929','2842','Rossemaison','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1930','2843','Chtillon JU','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1931','2852','Courttelle','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1932','2853','Courfaivre','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1933','2854','Bassecourt','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1934','2855','Glovelier','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1935','2856','Bocourt','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1936','2857','Montavon','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1937','2863','Undervelier','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1938','2864','Soulce','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1939','2873','Saulcy','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1940','2882','St-Ursanne','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1941','2883','Montmelon','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1942','2884','Montenol','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1943','2885','Epauvillers','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1944','2886','Epiquerez','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1945','2887','Soubey','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1946','2888','Seleute','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1947','2889','Ocourt','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1948','2900','Porrentruy','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1949','2900','Porrentruy 1','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1950','2900','Porrentruy 2','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1951','2902','Fontenais','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1952','2903','Villars-sur Fontenais','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1953','2904','Bressaucourt','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1954','2905','Courtedoux','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1955','2906','Chevenez','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1956','2907','Rocourt','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1957','2908','Grandfontaine','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1958','2912','Roche-d\'Or','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1959','2912','Rclre','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1960','2914','Damvant','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1961','2915','Bure','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1962','2916','Fahy','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1963','2922','Courchavon','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1964','2923','Courtemache','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1965','2924','Montignez','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1966','2925','Buix','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1967','2926','Boncourt','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1968','2932','Coeuve','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1969','2933','Damphreux','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1970','2933','Lugnez','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1971','2935','Beurnevsin','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1972','2942','Alle','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1973','2943','Vendlincourt','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1974','2944','Bonfol','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1975','2946','Micourt','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1976','2947','Charmoille','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1977','2950','Courgenay','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1978','2950','Courtemautruy','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1979','2952','Cornol','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1980','2953','Fregicourt','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1981','2953','Pleujouse','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1982','2953','Fregicourt-Pleujouse','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1983','2954','Asuel','Jura','JU','194','N');
INSERT INTO PLZ VALUES ('1984','4806','Wikon','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('1985','4915','St. Urban','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('1986','5735','Pfeffikon LU','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('1987','6000','Luzern','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('1988','6000','Luzern 4','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('1989','6000','Luzern 5','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('1990','6000','Luzern 6','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('1991','6000','Luzern 7','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('1992','6000','Luzern 14','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('1993','6000','Luzern 15','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('1994','6000','Luzern 16','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('1995','6000','Luzern 30 AAL','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('1996','6002','Luzern','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('1997','6003','Luzern','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('1998','6004','Luzern','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('1999','6005','Luzern','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2000','6005','St. Niklausen LU','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2001','6006','Luzern','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2002','6007','Luzern','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2003','6008','Luzern UBS','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2004','6009','Luzern','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2005','6010','Kriens','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2006','6010','Kriens 2','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2007','6011','Kriens','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2008','6012','Obernau','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2009','6013','Eigenthal','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2010','6014','Luzern','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2011','6015','Luzern','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2012','6016','Hellbhl','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2013','6017','Ruswil','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2014','6018','Buttisholz','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2015','6019','Sigigen','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2016','6020','Emmenbrcke','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2017','6020','Emmenbrcke 2','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2018','6020','Emmenbrcke 3','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2019','6021','Emmenbrcke 1','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2020','6022','Grosswangen','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2021','6023','Rothenburg','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2022','6024','Hildisrieden','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2023','6025','Neudorf','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2024','6026','Rain','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2025','6027','Rmerswil LU','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2026','6028','Herlisberg','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2027','6030','Ebikon','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2028','6031','Ebikon','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2029','6032','Emmen','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2030','6033','Buchrain','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2031','6034','Inwil','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2032','6035','Perlen','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2033','6036','Dierikon','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2034','6037','Root','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2035','6038','Gisikon','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2036','6038','Honau','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2037','6039','Root Lngenbold','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2038','6043','Adligenswil','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2039','6044','Udligenswil','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2040','6045','Meggen','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2041','6047','Kastanienbaum','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2042','6048','Horw','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2043','6102','Malters','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2044','6103','Schwarzenberg LU','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2045','6105','Schachen LU','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2046','6106','Werthenstein','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2047','6110','Wolhusen','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2048','6110','Fontannen b. Wolhusen','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2049','6112','Doppleschwand','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2050','6113','Romoos','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2051','6114','Steinhuserberg','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2052','6122','Menznau','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2053','6123','Geiss','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2054','6125','Menzberg','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2055','6126','Daiwil','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2056','6130','Willisau','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2057','6132','Rohrmatt','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2058','6133','Hergiswil b. Willisau','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2059','6142','Gettnau','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2060','6143','Ohmstal','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2061','6144','Zell LU','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2062','6145','Fischbach LU','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2063','6146','Grossdietwil','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2064','6147','Altbron','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2065','6152','Hswil','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2066','6153','Ufhusen','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2067','6154','Hofstatt','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2068','6156','Luthern','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2069','6156','Luthern Bad','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2070','6160','Entlebuch Businesszentrum','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2071','6162','Entlebuch','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2072','6162','Rengg','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2073','6162','Finsterwald b. Entlebuch','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2074','6163','Ebnet','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2075','6166','Hasle LU','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2076','6167','Bramboden','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2077','6170','Schpfheim','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2078','6173','Flhli LU','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2079','6174','Srenberg','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2080','6182','Escholzmatt','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2081','6192','Wiggen','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2082','6196','Marbach LU','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2083','6203','Sempach Station','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2084','6204','Sempach','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2085','6204','Sempach Stadt','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2086','6205','Eich','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2087','6206','Neuenkirch','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2088','6207','Nottwil','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2089','6207','Nottwil Paraplegikerzentrum','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2090','6208','Oberkirch LU','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2091','6210','Sursee','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2092','6211','Buchs LU','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2093','6212','St. Erhard','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2094','6212','Kaltbach','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2095','6213','Knutwil','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2096','6214','Schenkon','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2097','6215','Beromnster','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2098','6215','Schwarzenbach Beromnster','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2099','6216','Mauensee','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2100','6217','Kottwil','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2101','6218','Ettiswil','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2102','6221','Rickenbach LU','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2103','6222','Gunzwil','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2104','6231','Schlierbach','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2105','6232','Geuensee','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2106','6233','Bron','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2107','6234','Triengen','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2108','6234','Kulmerau','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2109','6235','Winikon','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2110','6236','Wilihof','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2111','6242','Wauwil','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2112','6243','Egolzwil','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2113','6244','Nebikon','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2114','6245','Ebersecken','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2115','6246','Altishofen','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2116','6247','Schtz','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2117','6248','Alberswil','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2118','6252','Dagmersellen','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2119','6253','Uffikon','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2120','6260','Reiden','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2121','6260','Reidermoos','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2122','6260','Hintermoos','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2123','6260','Mehlsecken','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2124','6262','Langnau b. Reiden','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2125','6263','Richenthal','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2126','6264','Pfaffnau','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2127','6265','Roggliswil','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2128','6274','Eschenbach LU','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2129','6275','Ballwil','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2130','6276','Hohenrain','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2131','6277','Kleinwangen','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2132','6277','Lieli LU','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2133','6280','Hochdorf','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2134','6280','Urswil','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2135','6281','Hochdorf','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2136','6283','Baldegg','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2137','6284','Gelfingen','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2138','6284','Sulz LU','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2139','6285','Hitzkirch','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2140','6285','Retschwil','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2141','6286','Altwis','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2142','6287','Aesch LU','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2143','6288','Schongau','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2144','6289','Mswangen','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2145','6289','Hmikon','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2146','6294','Ermensee','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2147','6295','Mosen','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2148','6344','Meierskappel','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2149','6353','Weggis','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2150','6354','Vitznau','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2151','6356','Rigi Kaltbad','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2152','6404','Greppen','Luzern','LU','194','N');
INSERT INTO PLZ VALUES ('2153','2000','Neuchtel','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2154','2001','Neuchtel 1','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2155','2002','Neuchtel 2','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2156','2003','Neuchtel 3','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2157','2004','Neuchtel 4','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2158','2006','Neuchtel 6','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2159','2008','Neuchtel','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2160','2009','Neuchtel 9','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2161','2010','Neuchtel OFS','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2162','2012','Auvernier','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2163','2013','Colombier NE','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2164','2014','Ble','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2165','2015','Areuse','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2166','2016','Cortaillod','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2167','2017','Boudry','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2168','2019','Chambrelien','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2169','2019','Rochefort','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2170','2022','Bevaix','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2171','2023','Gorgier','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2172','2024','St-Aubin-Sauges','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2173','2025','Chez-le-Bart','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2174','2027','Montalchez','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2175','2027','Fresens','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2176','2028','Vaumarcus','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2177','2034','Peseux','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2178','2035','Corcelles NE','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2179','2036','Cormondrche','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2180','2037','Montmollin','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2181','2037','Montezillon','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2182','2042','Valangin','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2183','2043','Boudevilliers','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2184','2046','Fontaines NE','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2185','2052','Fontainemelon','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2186','2052','La Vue-des-Alpes','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2187','2053','Cernier','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2188','2054','Chzard-St-Martin','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2189','2054','Les Vieux-Prs','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2190','2056','Dombresson','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2191','2057','Villiers','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2192','2058','Le Pquier NE','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2193','2063','Vilars NE','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2194','2063','Engollon','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2195','2063','Fenin','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2196','2063','Saules','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2197','2065','Savagnier','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2198','2067','Chaumont','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2199','2068','Hauterive NE','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2200','2072','St-Blaise','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2201','2073','Enges','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2202','2074','Marin-Epagnier','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2203','2075','Thielle','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2204','2075','Wavre','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2205','2087','Cornaux NE','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2206','2088','Cressier NE','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2207','2103','Noiraigue','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2208','2105','Travers','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2209','2108','Couvet','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2210','2112','Mtiers NE','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2211','2113','Boveresse','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2212','2114','Fleurier','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2213','2115','Buttes','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2214','2116','Mont-de-Buttes','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2215','2117','La Cte-aux-Fes','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2216','2123','St-Sulpice NE','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2217','2124','Les Sagnettes','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2218','2126','Les Verrires','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2219','2127','Les Bayards','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2220','2149','Champ-du-Moulin','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2221','2149','Fretereules','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2222','2149','Brot-Dessous','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2223','2206','Les Geneveys-sur-Coffrane','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2224','2207','Coffrane','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2225','2208','Les Hauts-Geneveys','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2226','2300','La Chaux-de-Fonds','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2227','2300','La Cibourg','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2228','2301','La Chaux-de-Fonds','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2229','2302','La Chaux-de-Fonds','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2230','2303','La Chaux-de-Fonds','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2231','2304','La Chaux-de-Fonds','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2232','2306','La Chaux-de-Fonds','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2233','2314','La Sagne NE','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2234','2316','Les Ponts-de-Martel','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2235','2316','Petit-Martel','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2236','2318','Brot-Plamboz','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2237','2322','Le Crt-du-Locle','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2238','2325','Les Planchettes','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2239','2325','Les Joux-Derrire','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2240','2400','Le Locle','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2241','2400','Le Prvoux','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2242','2405','La Chaux-du-Milieu','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2243','2406','La Brvine','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2244','2406','Le Brouillet','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2245','2406','Les Taillres','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2246','2406','La Chtagne','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2247','2414','Le Cerneux-Pquignot','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2248','2416','Les Brenets','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2249','2523','Lignires','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2250','2525','Le Landeron','Neuchtel','NE','194','N');
INSERT INTO PLZ VALUES ('2251','6052','Hergiswil NW','Nidwalden','NW','194','N');
INSERT INTO PLZ VALUES ('2252','6362','Stansstad','Nidwalden','NW','194','N');
INSERT INTO PLZ VALUES ('2253','6363','Obbrgen','Nidwalden','NW','194','N');
INSERT INTO PLZ VALUES ('2254','6363','Brgenstock','Nidwalden','NW','194','N');
INSERT INTO PLZ VALUES ('2255','6363','Frigen','Nidwalden','NW','194','N');
INSERT INTO PLZ VALUES ('2256','6365','Kehrsiten','Nidwalden','NW','194','N');
INSERT INTO PLZ VALUES ('2257','6370','Stans','Nidwalden','NW','194','N');
INSERT INTO PLZ VALUES ('2258','6370','Oberdorf NW','Nidwalden','NW','194','N');
INSERT INTO PLZ VALUES ('2259','6371','Stans','Nidwalden','NW','194','N');
INSERT INTO PLZ VALUES ('2260','6372','Ennetmoos','Nidwalden','NW','194','N');
INSERT INTO PLZ VALUES ('2261','6373','Ennetbrgen','Nidwalden','NW','194','N');
INSERT INTO PLZ VALUES ('2262','6374','Buochs','Nidwalden','NW','194','N');
INSERT INTO PLZ VALUES ('2263','6375','Beckenried','Nidwalden','NW','194','N');
INSERT INTO PLZ VALUES ('2264','6376','Emmetten','Nidwalden','NW','194','N');
INSERT INTO PLZ VALUES ('2265','6382','Bren NW','Nidwalden','NW','194','N');
INSERT INTO PLZ VALUES ('2266','6383','Dallenwil','Nidwalden','NW','194','N');
INSERT INTO PLZ VALUES ('2267','6383','Niederrickenbach','Nidwalden','NW','194','N');
INSERT INTO PLZ VALUES ('2268','6383','Wiesenberg','Nidwalden','NW','194','N');
INSERT INTO PLZ VALUES ('2269','6383','Wirzweli','Nidwalden','NW','194','N');
INSERT INTO PLZ VALUES ('2270','6386','Wolfenschiessen','Nidwalden','NW','194','N');
INSERT INTO PLZ VALUES ('2271','6387','Oberrickenbach','Nidwalden','NW','194','N');
INSERT INTO PLZ VALUES ('2272','6010','Pilatus Kulm','Obwalden','OW','194','N');
INSERT INTO PLZ VALUES ('2273','6053','Alpnachstad','Obwalden','OW','194','N');
INSERT INTO PLZ VALUES ('2274','6055','Alpnach Dorf','Obwalden','OW','194','N');
INSERT INTO PLZ VALUES ('2275','6056','Kgiswil','Obwalden','OW','194','N');
INSERT INTO PLZ VALUES ('2276','6060','Sarnen','Obwalden','OW','194','N');
INSERT INTO PLZ VALUES ('2277','6060','Ramersberg','Obwalden','OW','194','N');
INSERT INTO PLZ VALUES ('2278','6060','Sarnen 2','Obwalden','OW','194','N');
INSERT INTO PLZ VALUES ('2279','6061','Sarnen 1','Obwalden','OW','194','N');
INSERT INTO PLZ VALUES ('2280','6062','Wilen (Sarnen)','Obwalden','OW','194','N');
INSERT INTO PLZ VALUES ('2281','6063','Stalden (Sarnen)','Obwalden','OW','194','N');
INSERT INTO PLZ VALUES ('2282','6064','Kerns','Obwalden','OW','194','N');
INSERT INTO PLZ VALUES ('2283','6066','St. Niklausen OW','Obwalden','OW','194','N');
INSERT INTO PLZ VALUES ('2284','6067','Melchtal','Obwalden','OW','194','N');
INSERT INTO PLZ VALUES ('2285','6068','Melchsee-Frutt','Obwalden','OW','194','N');
INSERT INTO PLZ VALUES ('2286','6072','Sachseln','Obwalden','OW','194','N');
INSERT INTO PLZ VALUES ('2287','6073','Fleli-Ranft','Obwalden','OW','194','N');
INSERT INTO PLZ VALUES ('2288','6074','Giswil','Obwalden','OW','194','N');
INSERT INTO PLZ VALUES ('2289','6078','Lungern','Obwalden','OW','194','N');
INSERT INTO PLZ VALUES ('2290','6078','Brglen OW','Obwalden','OW','194','N');
INSERT INTO PLZ VALUES ('2291','6388','Grafenort','Obwalden','OW','194','N');
INSERT INTO PLZ VALUES ('2292','6390','Engelberg','Obwalden','OW','194','N');
INSERT INTO PLZ VALUES ('2293','6391','Engelberg','Obwalden','OW','194','N');
INSERT INTO PLZ VALUES ('2294','7310','Bad Ragaz','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2295','7312','Pffers','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2296','7313','St. Margrethenberg','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2297','7314','Vadura','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2298','7315','Vttis','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2299','7317','Valens','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2300','7317','Vasn','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2301','7320','Sargans','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2302','7323','Wangs','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2303','7324','Vilters','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2304','7325','Schwendi im Weisstannental','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2305','7326','Weisstannen','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2306','8638','Goldingen','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2307','8640','Rapperswil SG','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2308','8640','Kempraten','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2309','8645','Jona','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2310','8646','Wagen','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2311','8715','Bollingen','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2312','8716','Schmerikon','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2313','8717','Benken SG','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2314','8718','Schnis','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2315','8722','Kaltbrunn','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2316','8723','Rufi','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2317','8725','Ernetschwil','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2318','8725','Gebertingen','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2319','8726','Ricken SG','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2320','8727','Walde SG','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2321','8730','Uznach','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2322','8732','Neuhaus SG','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2323','8733','Eschenbach SG','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2324','8734','Ermenswil','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2325','8735','St. Gallenkappel','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2326','8735','Reterswil','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2327','8737','Gommiswald','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2328','8738','Uetliburg SG','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2329','8739','Rieden SG','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2330','8740','Uznach Vgele Versandhaus','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2331','8872','Weesen','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2332','8873','Amden','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2333','8877','Murg','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2334','8878','Quinten','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2335','8879','Pizolpark (Mels)','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2336','8880','Walenstadt','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2337','8881','Walenstadtberg','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2338','8881','Knoblisbhl','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2339','8881','Tscherlach','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2340','8882','Unterterzen','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2341','8883','Quarten','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2342','8884','Oberterzen','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2343','8885','Mols','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2344','8886','Mdris-Vermol','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2345','8887','Mels','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2346','8888','Heiligkreuz (Mels)','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2347','8889','Plons','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2348','8890','Flums','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2349','8892','Berschis','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2350','8893','Flums Hochwiese','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2351','8894','Flumserberg Saxli','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2352','8895','Flumserberg Portels','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2353','8896','Flumserberg Bergheim','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2354','8897','Flumserberg Tannenheim','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2355','8898','Flumserberg Tannenbodenalp','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2356','9000','St. Gallen','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2357','9001','St. Gallen','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2358','9004','St. Gallen','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2359','9006','St. Gallen','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2360','9007','St. Gallen','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2361','9008','St. Gallen','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2362','9009','St. Gallen','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2363','9010','St. Gallen','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2364','9011','St. Gallen','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2365','9012','St. Gallen','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2366','9013','St. Gallen','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2367','9014','St. Gallen','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2368','9015','St. Gallen','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2369','9016','St. Gallen','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2370','9020','St. Gallen','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2371','9022','St. Gallen','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2372','9024','St.Gallen Presse-Serv. Gll','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2373','9025','St. Gallen Quelle','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2374','9026','St. Gallen Knzler AG','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2375','9027','St. Gallen Mona Versand','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2376','9028','St. Gallen Cornelia Versand','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2377','9029','St. Gallen Sonderdienste','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2378','9030','Abtwil SG','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2379','9032','Engelburg','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2380','9033','Untereggen','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2381','9034','Eggersriet','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2382','9036','Grub SG','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2383','9113','Degersheim','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2384','9114','Hoffeld','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2385','9115','Dicken','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2386','9116','Wolfertswil','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2387','9122','Mogelsberg','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2388','9122','Ebersol','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2389','9123','Nassen','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2390','9125','Brunnadern','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2391','9126','Necker','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2392','9127','St. Peterzell','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2393','9200','Gossau SG','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2394','9200','Gossau SG 2','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2395','9201','Gossau SG','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2396','9203','Niederwil SG','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2397','9204','Andwil SG','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2398','9205','Waldkirch','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2399','9212','Arnegg','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2400','9230','Flawil','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2401','9230','Flawil 1','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2402','9230','Flawil 2 Botsberg','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2403','9231','Egg (Flawil)','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2404','9240','Uzwil','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2405','9240','Niederglatt SG','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2406','9242','Oberuzwil','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2407','9243','Jonschwil','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2408','9244','Niederuzwil','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2409','9245','Oberbren','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2410','9245','Sonnental','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2411','9246','Niederbren','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2412','9247','Henau','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2413','9248','Bichwil','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2414','9249','Algetshausen','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2415','9249','Oberstetten','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2416','9249','Niederstetten','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2417','9300','Wittenbach','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2418','9301','Wittenbach','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2419','9304','Bernhardzell','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2420','9305','Berg SG','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2421','9308','Lmmenschwil','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2422','9312','Hggenschwil','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2423','9313','Muolen','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2424','9323','Steinach','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2425','9327','Tbach','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2426','9400','Rorschach','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2427','9401','Rorschach','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2428','9402','Mrschwil','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2429','9403','Goldach','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2430','9404','Rorschacherberg','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2431','9422','Staad SG','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2432','9423','Altenrhein','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2433','9424','Rheineck','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2434','9425','Thal','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2435','9430','St. Margrethen SG','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2436','9434','Au SG','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2437','9435','Heerbrugg','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2438','9436','Balgach','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2439','9437','Marbach SG','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2440','9442','Berneck','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2441','9443','Widnau','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2442','9444','Diepoldsau','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2443','9445','Rebstein','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2444','9450','Lchingen','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2445','9450','Altsttten SG','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2446','9451','Kriessern','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2447','9452','Hinterforst','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2448','9453','Eichberg','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2449','9462','Montlingen','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2450','9463','Oberriet SG','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2451','9464','Rthi (Rheintal)','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2452','9464','Lienz','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2453','9465','Salez','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2454','9466','Sennwald','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2455','9467','Frmsen','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2456','9468','Sax','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2457','9469','Haag (Rheintal)','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2458','9470','Buchs SG','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2459','9470','Werdenberg','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2460','9471','Buchs SG 1','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2461','9471','Buchs SG 3','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2462','9472','Grabs','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2463','9472','Grabserberg','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2464','9473','Gams','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2465','9475','Sevelen','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2466','9476','Weite','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2467','9476','Fontnas','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2468','9477','Trbbach','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2469','9478','Azmoos','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2470','9479','Oberschan','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2471','9479','Gretschins','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2472','9479','Malans SG','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2473','9500','Wil SG','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2474','9500','Wil SG 2','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2475','9501','Wil SG 1','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2476','9512','Rossrti','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2477','9523','Zberwangen','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2478','9524','Zuzwil SG','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2479','9525','Lenggenwil','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2480','9526','Zuckenriet','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2481','9527','Niederhelfenschwil','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2482','9533','Kirchberg SG','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2483','9534','Ghwil','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2484','9536','Schwarzenbach SG','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2485','9552','Bronschhofen','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2486','9601','Ltisburg Station','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2487','9602','Bazenheid','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2488','9602','Mselbach','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2489','9604','Ltisburg','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2490','9604','Oberrindal','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2491','9604','Unterrindal','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2492','9606','Btschwil','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2493','9607','Mosnang','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2494','9608','Ganterschwil','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2495','9612','Dreien','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2496','9613','Mhlrti','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2497','9614','Libingen','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2498','9615','Dietfurt','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2499','9620','Lichtensteig','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2500','9621','Oberhelfenschwil','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2501','9622','Krinau','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2502','9630','Wattwil','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2503','9631','Ulisbach','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2504','9633','Hemberg','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2505','9633','Bchli (Hemberg)','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2506','9642','Ebnat-Kappel','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2507','9643','Krummenau','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2508','9650','Nesslau','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2509','9651','Ennetbhl','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2510','9652','Neu St. Johann','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2511','9655','Stein SG','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2512','9656','Alt St. Johann','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2513','9657','Unterwasser','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2514','9658','Wildhaus','St. Gallen','SG','194','N');
INSERT INTO PLZ VALUES ('2515','8200','Schaffhausen','Schaffhausen','SH','194','N');
INSERT INTO PLZ VALUES ('2516','8201','Schaffhausen','Schaffhausen','SH','194','N');
INSERT INTO PLZ VALUES ('2517','8203','Schaffhausen','Schaffhausen','SH','194','N');
INSERT INTO PLZ VALUES ('2518','8204','Schaffhausen','Schaffhausen','SH','194','N');
INSERT INTO PLZ VALUES ('2519','8207','Schaffhausen','Schaffhausen','SH','194','N');
INSERT INTO PLZ VALUES ('2520','8208','Schaffhausen','Schaffhausen','SH','194','N');
INSERT INTO PLZ VALUES ('2521','8212','Neuhausen am Rheinfall','Schaffhausen','SH','194','N');
INSERT INTO PLZ VALUES ('2522','8212','Neuhausen am Rheinfall 1','Schaffhausen','SH','194','N');
INSERT INTO PLZ VALUES ('2523','8212','Neuhausen am Rheinfall 2','Schaffhausen','SH','194','N');
INSERT INTO PLZ VALUES ('2524','8213','Neunkirch','Schaffhausen','SH','194','N');
INSERT INTO PLZ VALUES ('2525','8214','Gchlingen','Schaffhausen','SH','194','N');
INSERT INTO PLZ VALUES ('2526','8215','Hallau','Schaffhausen','SH','194','N');
INSERT INTO PLZ VALUES ('2527','8216','Oberhallau','Schaffhausen','SH','194','N');
INSERT INTO PLZ VALUES ('2528','8217','Wilchingen','Schaffhausen','SH','194','N');
INSERT INTO PLZ VALUES ('2529','8218','Osterfingen','Schaffhausen','SH','194','N');
INSERT INTO PLZ VALUES ('2530','8219','Trasadingen','Schaffhausen','SH','194','N');
INSERT INTO PLZ VALUES ('2531','8222','Beringen','Schaffhausen','SH','194','N');
INSERT INTO PLZ VALUES ('2532','8223','Guntmadingen','Schaffhausen','SH','194','N');
INSERT INTO PLZ VALUES ('2533','8224','Lhningen','Schaffhausen','SH','194','N');
INSERT INTO PLZ VALUES ('2534','8225','Siblingen','Schaffhausen','SH','194','N');
INSERT INTO PLZ VALUES ('2535','8226','Schleitheim','Schaffhausen','SH','194','N');
INSERT INTO PLZ VALUES ('2536','8228','Beggingen','Schaffhausen','SH','194','N');
INSERT INTO PLZ VALUES ('2537','8231','Hemmental','Schaffhausen','SH','194','N');
INSERT INTO PLZ VALUES ('2538','8232','Merishausen','Schaffhausen','SH','194','N');
INSERT INTO PLZ VALUES ('2539','8233','Bargen SH','Schaffhausen','SH','194','N');
INSERT INTO PLZ VALUES ('2540','8234','Stetten SH','Schaffhausen','SH','194','N');
INSERT INTO PLZ VALUES ('2541','8235','Lohn SH','Schaffhausen','SH','194','N');
INSERT INTO PLZ VALUES ('2542','8236','Opfertshofen SH','Schaffhausen','SH','194','N');
INSERT INTO PLZ VALUES ('2543','8236','Bttenhardt','Schaffhausen','SH','194','N');
INSERT INTO PLZ VALUES ('2544','8239','Drflingen','Schaffhausen','SH','194','N');
INSERT INTO PLZ VALUES ('2545','8240','Thayngen','Schaffhausen','SH','194','N');
INSERT INTO PLZ VALUES ('2546','8241','Barzheim','Schaffhausen','SH','194','N');
INSERT INTO PLZ VALUES ('2547','8242','Bibern SH','Schaffhausen','SH','194','N');
INSERT INTO PLZ VALUES ('2548','8242','Hofen SH','Schaffhausen','SH','194','N');
INSERT INTO PLZ VALUES ('2549','8243','Altdorf SH','Schaffhausen','SH','194','N');
INSERT INTO PLZ VALUES ('2550','8260','Stein am Rhein','Schaffhausen','SH','194','N');
INSERT INTO PLZ VALUES ('2551','8260','Stein am Rhein 1','Schaffhausen','SH','194','N');
INSERT INTO PLZ VALUES ('2552','8260','Stein am Rhein 2 Stadt','Schaffhausen','SH','194','N');
INSERT INTO PLZ VALUES ('2553','8261','Hemishofen','Schaffhausen','SH','194','N');
INSERT INTO PLZ VALUES ('2554','8262','Ramsen','Schaffhausen','SH','194','N');
INSERT INTO PLZ VALUES ('2555','8263','Buch SH','Schaffhausen','SH','194','N');
INSERT INTO PLZ VALUES ('2556','8454','Buchberg','Schaffhausen','SH','194','N');
INSERT INTO PLZ VALUES ('2557','8455','Rdlingen','Schaffhausen','SH','194','N');
INSERT INTO PLZ VALUES ('2558','2540','Grenchen','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2559','2540','Grenchen 1','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2560','2540','Grenchen 2','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2561','2544','Bettlach','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2562','2545','Selzach','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2563','3253','Schnottwil','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2564','3254','Messen','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2565','3254','Balm b. Messen','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2566','3307','Brunnenthal','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2567','4108','Witterswil','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2568','4112','Bttwil','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2569','4112','Flh','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2570','4112','Bttwil-Flh','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2571','4114','Hofstetten SO','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2572','4115','Mariastein','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2573','4116','Metzerlen','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2574','4118','Rodersdorf','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2575','4143','Dornach','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2576','4143','Dornach 1','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2577','4143','Dornach 2','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2578','4145','Gempen','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2579','4146','Hochwald','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2580','4204','Himmelried','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2581','4206','Seewen SO','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2582','4208','Nunningen','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2583','4226','Breitenbach','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2584','4227','Bsserach','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2585','4228','Erschwil','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2586','4229','Beinwil SO','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2587','4232','Fehren','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2588','4233','Meltingen','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2589','4234','Zullwil','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2590','4245','Kleinltzel','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2591','4247','Grindel','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2592','4252','Brschwil','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2593','4252','Brschwil Dorf','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2594','4412','Nuglar','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2595','4413','Bren SO','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2596','4421','St. Pantaleon','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2597','4468','Kienberg','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2598','4500','Solothurn','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2599','4501','Solothurn','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2600','4502','Solothurn','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2601','4503','Solothurn','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2602','4509','Solothurn','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2603','4512','Bellach','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2604','4513','Langendorf','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2605','4514','Lommiswil','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2606','4515','Oberdorf SO','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2607','4515','Weissenstein b. Solothurn','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2608','4522','Rttenen','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2609','4523','Niederwil SO','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2610','4524','Gnsberg','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2611','4524','Balmberg','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2612','4524','Oberbalmberg','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2613','4525','Balm b. Gnsberg','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2614','4528','Zuchwil','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2615','4532','Feldbrunnen','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2616','4533','Riedholz','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2617','4534','Flumenthal','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2618','4535','Hubersdorf','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2619','4535','Kammersrohr','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2620','4542','Luterbach','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2621','4543','Deitingen','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2622','4551','Derendingen Swisscom','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2623','4552','Derendingen','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2624','4553','Subingen','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2625','4554','Etziken','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2626','4554','Hniken','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2627','4556','Aeschi SO','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2628','4556','Bolken','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2629','4556','Burgschi','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2630','4556','Steinhof SO','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2631','4557','Horriwil','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2632','4558','Hersiwil','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2633','4558','Heinrichswil','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2634','4558','Winistorf','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2635','4562','Biberist','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2636','4563','Gerlafingen','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2637','4564','Obergerlafingen','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2638','4565','Recherswil','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2639','4566','Kriegstetten','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2640','4566','Halten','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2641','4566','Oekingen','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2642','4571','Ichertswil','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2643','4571','Lterkofen','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2644','4573','Lohn-Ammannsegg','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2645','4574','Nennigkofen','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2646','4574','Lsslingen','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2647','4576','Tscheppach','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2648','4577','Hessigkofen','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2649','4578','Bibern SO','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2650','4579','Gossliwil','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2651','4581','Kttigkofen','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2652','4582','Brgglen','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2653','4583','Mhledorf SO','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2654','4583','Aetigkofen','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2655','4584','Gchliwil','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2656','4584','Lterswil','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2657','4585','Biezwil','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2658','4586','Kyburg-Buchegg','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2659','4587','Aetingen','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2660','4588','Unterramsern','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2661','4588','Oberramsern','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2662','4588','Brittern','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2663','4600','Olten','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2664','4601','Olten','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2665','4603','Olten','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2666','4612','Wangen b. Olten','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2667','4613','Rickenbach SO','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2668','4614','Hgendorf','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2669','4615','Allerheiligenberg','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2670','4616','Kappel SO','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2671','4617','Gunzgen','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2672','4618','Boningen','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2673','4622','Egerkingen','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2674','4623','Neuendorf','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2675','4624','Hrkingen','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2676','4625','Oberbuchsiten','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2677','4626','Niederbuchsiten','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2678','4628','Wolfwil','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2679','4629','Fulenbach','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2680','4632','Trimbach','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2681','4633','Hauenstein','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2682','4634','Wisen SO','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2683','4652','Winznau','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2684','4653','Obergsgen','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2685','4654','Lostorf','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2686','4655','Stsslingen','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2687','4655','Rohr b. Olten','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2688','4656','Starrkirch-Wil','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2689','4657','Dulliken','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2690','4658','Dniken SO','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2691','4702','Oensingen','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2692','4703','Kestenholz','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2693','4710','Balsthal','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2694','4712','Laupersdorf','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2695','4713','Matzendorf','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2696','4714','Aedermannsdorf','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2697','4715','Herbetswil','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2698','4716','Welschenrohr','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2699','4716','Gnsbrunnen','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2700','4717','Mmliswil','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2701','4718','Holderbank SO','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2702','4719','Ramiswil','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2703','5012','Schnenwerd','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2704','5012','Eppenberg','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2705','5012','Wschnau','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2706','5013','Niedergsgen','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2707','5014','Gretzenbach','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2708','5015','Erlinsbach SO','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2709','5746','Walterswil SO','Solothurn','SO','194','N');
INSERT INTO PLZ VALUES ('2710','6402','Merlischachen','Schwyz','SZ','194','N');
INSERT INTO PLZ VALUES ('2711','6403','Kssnacht am Rigi','Schwyz','SZ','194','N');
INSERT INTO PLZ VALUES ('2712','6405','Immensee','Schwyz','SZ','194','N');
INSERT INTO PLZ VALUES ('2713','6410','Goldau','Schwyz','SZ','194','N');
INSERT INTO PLZ VALUES ('2714','6410','Rigi Klsterli','Schwyz','SZ','194','N');
INSERT INTO PLZ VALUES ('2715','6410','Rigi Staffel','Schwyz','SZ','194','N');
INSERT INTO PLZ VALUES ('2716','6410','Rigi Kulm','Schwyz','SZ','194','N');
INSERT INTO PLZ VALUES ('2717','6410','Rigi Scheidegg','Schwyz','SZ','194','N');
INSERT INTO PLZ VALUES ('2718','6414','Oberarth','Schwyz','SZ','194','N');
INSERT INTO PLZ VALUES ('2719','6415','Arth','Schwyz','SZ','194','N');
INSERT INTO PLZ VALUES ('2720','6416','Steinerberg','Schwyz','SZ','194','N');
INSERT INTO PLZ VALUES ('2721','6417','Sattel','Schwyz','SZ','194','N');
INSERT INTO PLZ VALUES ('2722','6418','Rothenthurm','Schwyz','SZ','194','N');
INSERT INTO PLZ VALUES ('2723','6422','Steinen','Schwyz','SZ','194','N');
INSERT INTO PLZ VALUES ('2724','6423','Seewen SZ','Schwyz','SZ','194','N');
INSERT INTO PLZ VALUES ('2725','6424','Lauerz','Schwyz','SZ','194','N');
INSERT INTO PLZ VALUES ('2726','6430','Schwyz','Schwyz','SZ','194','N');
INSERT INTO PLZ VALUES ('2727','6430','Schwyz Kantonalbank','Schwyz','SZ','194','N');
INSERT INTO PLZ VALUES ('2728','6431','Schwyz','Schwyz','SZ','194','N');
INSERT INTO PLZ VALUES ('2729','6432','Rickenbach b. Schwyz','Schwyz','SZ','194','N');
INSERT INTO PLZ VALUES ('2730','6433','Stoos SZ','Schwyz','SZ','194','N');
INSERT INTO PLZ VALUES ('2731','6434','Illgau','Schwyz','SZ','194','N');
INSERT INTO PLZ VALUES ('2732','6436','Muotathal','Schwyz','SZ','194','N');
INSERT INTO PLZ VALUES ('2733','6436','Ried (Muotathal)','Schwyz','SZ','194','N');
INSERT INTO PLZ VALUES ('2734','6436','Bisisthal','Schwyz','SZ','194','N');
INSERT INTO PLZ VALUES ('2735','6438','Ibach','Schwyz','SZ','194','N');
INSERT INTO PLZ VALUES ('2736','6440','Brunnen','Schwyz','SZ','194','N');
INSERT INTO PLZ VALUES ('2737','6442','Gersau','Schwyz','SZ','194','N');
INSERT INTO PLZ VALUES ('2738','6443','Morschach','Schwyz','SZ','194','N');
INSERT INTO PLZ VALUES ('2739','6452','Riemenstalden','Schwyz','SZ','194','N');
INSERT INTO PLZ VALUES ('2740','8640','Hurden','Schwyz','SZ','194','N');
INSERT INTO PLZ VALUES ('2741','8806','Bch SZ','Schwyz','SZ','194','N');
INSERT INTO PLZ VALUES ('2742','8807','Freienbach','Schwyz','SZ','194','N');
INSERT INTO PLZ VALUES ('2743','8808','Pfffikon SZ','Schwyz','SZ','194','N');
INSERT INTO PLZ VALUES ('2744','8832','Wollerau','Schwyz','SZ','194','N');
INSERT INTO PLZ VALUES ('2745','8832','Wilen b. Wollerau','Schwyz','SZ','194','N');
INSERT INTO PLZ VALUES ('2746','8834','Schindellegi','Schwyz','SZ','194','N');
INSERT INTO PLZ VALUES ('2747','8835','Feusisberg','Schwyz','SZ','194','N');
INSERT INTO PLZ VALUES ('2748','8836','Bennau','Schwyz','SZ','194','N');
INSERT INTO PLZ VALUES ('2749','8840','Einsiedeln','Schwyz','SZ','194','N');
INSERT INTO PLZ VALUES ('2750','8840','Trachslau','Schwyz','SZ','194','N');
INSERT INTO PLZ VALUES ('2751','8841','Gross','Schwyz','SZ','194','N');
INSERT INTO PLZ VALUES ('2752','8842','Unteriberg','Schwyz','SZ','194','N');
INSERT INTO PLZ VALUES ('2753','8843','Oberiberg','Schwyz','SZ','194','N');
INSERT INTO PLZ VALUES ('2754','8844','Euthal','Schwyz','SZ','194','N');
INSERT INTO PLZ VALUES ('2755','8845','Studen SZ','Schwyz','SZ','194','N');
INSERT INTO PLZ VALUES ('2756','8846','Willerzell','Schwyz','SZ','194','N');
INSERT INTO PLZ VALUES ('2757','8847','Egg SZ','Schwyz','SZ','194','N');
INSERT INTO PLZ VALUES ('2758','8849','Alpthal','Schwyz','SZ','194','N');
INSERT INTO PLZ VALUES ('2759','8852','Altendorf','Schwyz','SZ','194','N');
INSERT INTO PLZ VALUES ('2760','8853','Lachen SZ','Schwyz','SZ','194','N');
INSERT INTO PLZ VALUES ('2761','8854','Siebnen','Schwyz','SZ','194','N');
INSERT INTO PLZ VALUES ('2762','8854','Galgenen','Schwyz','SZ','194','N');
INSERT INTO PLZ VALUES ('2763','8855','Wangen SZ','Schwyz','SZ','194','N');
INSERT INTO PLZ VALUES ('2764','8856','Tuggen','Schwyz','SZ','194','N');
INSERT INTO PLZ VALUES ('2765','8857','Vorderthal','Schwyz','SZ','194','N');
INSERT INTO PLZ VALUES ('2766','8858','Innerthal','Schwyz','SZ','194','N');
INSERT INTO PLZ VALUES ('2767','8862','Schbelbach','Schwyz','SZ','194','N');
INSERT INTO PLZ VALUES ('2768','8863','Buttikon SZ','Schwyz','SZ','194','N');
INSERT INTO PLZ VALUES ('2769','8864','Reichenburg','Schwyz','SZ','194','N');
INSERT INTO PLZ VALUES ('2770','8252','Schlatt TG','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2771','8253','Diessenhofen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2772','8253','Willisdorf','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2773','8254','Basadingen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2774','8255','Schlattingen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2775','8259','Kaltenbach','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2776','8259','Etzwilen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2777','8259','Wagenhausen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2778','8259','Rheinklingen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2779','8264','Eschenz','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2780','8265','Mammern','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2781','8266','Steckborn','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2782','8267','Berlingen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2783','8268','Mannenbach-Salenstein','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2784','8268','Salenstein','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2785','8269','Fruthwilen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2786','8272','Ermatingen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2787','8273','Triboltingen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2788','8274','Tgerwilen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2789','8274','Gottlieben','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2790','8280','Kreuzlingen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2791','8280','Kreuzlingen 1','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2792','8280','Kreuzlingen 2','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2793','8280','Kreuzlingen 3','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2794','8285','Kreuzlingen Ifolor AG','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2795','8355','Aadorf','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2796','8356','Ettenhausen TG','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2797','8357','Guntershausen b. Aadorf','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2798','8360','Eschlikon TG','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2799','8360','Wallenwil','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2800','8362','Balterswil','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2801','8362','Bichelsee-Balterswil','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2802','8363','Bichelsee','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2803','8370','Sirnach','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2804','8370','Busswil TG','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2805','8372','Wiezikon b. Sirnach','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2806','8374','Dussnang','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2807','8374','Oberwangen TG','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2808','8376','Fischingen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2809','8376','Au TG','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2810','8500','Frauenfeld','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2811','8500','Gerlikon','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2812','8501','Frauenfeld','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2813','8502','Frauenfeld','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2814','8503','Frauenfeld','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2815','8505','Pfyn','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2816','8505','Dettighofen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2817','8506','Lanzenneunforn','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2818','8507','Hrhausen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2819','8508','Homburg','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2820','8510','Frauenfeld Kant. Verwaltung','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2821','8512','Thundorf','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2822','8512','Lustdorf','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2823','8512','Wetzikon TG','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2824','8514','Amlikon-Bissegg','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2825','8522','Huslenen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2826','8522','Aawangen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2827','8524','Uesslingen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2828','8524','Buch b. Frauenfeld','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2829','8525','Niederneunforn','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2830','8525','Wilen b. Neunforn','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2831','8526','Oberneunforn','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2832','8532','Warth','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2833','8532','Weiningen TG','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2834','8535','Herdern','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2835','8536','Httwilen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2836','8537','Nussbaumen TG','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2837','8537','Uerschhausen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2838','8546','Islikon','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2839','8546','Kefikon TG','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2840','8547','Gachnang','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2841','8552','Felben-Wellhausen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2842','8553','Eschikofen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2843','8553','Harenwilen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2844','8553','Mettendorf TG','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2845','8553','Httlingen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2846','8554','Mllheim-Wigoltingen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2847','8554','Bonau','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2848','8555','Mllheim Dorf','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2849','8556','Wigoltingen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2850','8556','Engwang','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2851','8556','Illhart','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2852','8556','Lamperswil TG','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2853','8558','Raperswilen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2854','8560','Mrstetten','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2855','8561','Ottoberg','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2856','8564','Hefenhausen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2857','8564','Lipperswil','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2858','8564','Engwilen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2859','8564','Wldi','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2860','8564','Sonterswil','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2861','8564','Wagerswil','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2862','8564','Hattenhausen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2863','8564','Gunterswilen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2864','8565','Hugelshofen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2865','8566','Dotnacht','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2866','8566','Neuwilen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2867','8566','Ellighausen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2868','8566','Lippoldswilen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2869','8570','Weinfelden','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2870','8572','Berg TG','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2871','8572','Andhausen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2872','8572','Graltshausen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2873','8572','Guntershausen b. Berg','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2874','8573','Siegershausen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2875','8573','Alterswilen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2876','8573','Altishausen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2877','8574','Lengwil-Oberhofen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2878','8574','Illighausen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2879','8575','Brglen TG','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2880','8575','Istighofen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2881','8576','Mauren TG','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2882','8577','Schnholzerswilen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2883','8577','Toos','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2884','8580','Amriswil','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2885','8580','Sommeri','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2886','8580','Hagenwil b. Amriswil','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2887','8580','Hefenhofen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2888','8581','Schocherswil','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2889','8582','Dozwil','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2890','8583','Sulgen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2891','8583','Gtighofen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2892','8583','Donzhausen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2893','8584','Leimbach TG','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2894','8584','Opfershofen TG','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2895','8585','Langrickenbach','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2896','8585','Mattwil','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2897','8585','Happerswil','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2898','8585','Eggethof','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2899','8585','Zuben','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2900','8585','Schnenbaumgarten','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2901','8585','Herrenhof','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2902','8585','Birwinken','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2903','8585','Klarsreuti','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2904','8586','Erlen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2905','8586','Andwil TG','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2906','8586','Kmmertshausen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2907','8586','Riedt b. Erlen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2908','8586','Buchackern','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2909','8586','Engishofen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2910','8586','Ennetaach','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2911','8586','Buch b. Kmmertshausen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2912','8587','Oberaach','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2913','8588','Zihlschlacht','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2914','8589','Sitterdorf','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2915','8590','Romanshorn','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2916','8592','Uttwil','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2917','8593','Kesswil','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2918','8594','Gttingen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2919','8595','Altnau','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2920','8596','Scherzingen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2921','8596','Mnsterlingen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2922','8597','Landschlacht','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2923','8598','Bottighofen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2924','8599','Salmsach','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2925','9213','Hauptwil','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2926','9214','Kradolf','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2927','9214','Kradolf-Schnenberg','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2928','9215','Schnenberg an der Thur','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2929','9215','Buhwil','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2930','9216','Heldswil','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2931','9216','Hohentannen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2932','9217','Neukirch an der Thur','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2933','9220','Bischofszell','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2934','9223','Schweizersholz','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2935','9223','Halden','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2936','9225','Wilen (Gottshaus)','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2937','9225','St. Pelagiberg','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2938','9306','Freidorf TG','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2939','9314','Steinebrunn','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2940','9315','Neukirch (Egnach)','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2941','9315','Winden','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2942','9320','Arbon','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2943','9320','Frasnacht','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2944','9320','Stachen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2945','9322','Egnach','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2946','9325','Roggwil TG','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2947','9326','Horn','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2948','9502','Braunau','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2949','9503','Stehrenberg','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2950','9503','Lanterswil','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2951','9504','Friltschen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2952','9506','Lommis','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2953','9507','Stettfurt','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2954','9508','Weingarten-Kalthusern','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2955','9514','Wuppenau','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2956','9515','Hosenruck','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2957','9517','Mettlen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2958','9532','Rickenbach b. Wil','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2959','9535','Wilen b. Wil','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2960','9542','Mnchwilen TG','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2961','9543','St. Margarethen TG','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2962','9545','Wngi','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2963','9546','Tuttwil','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2964','9547','Wittenwil','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2965','9548','Matzingen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2966','9553','Bettwiesen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2967','9554','Tgerschen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2968','9555','Tobel','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2969','9556','Affeltrangen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2970','9556','Zezikon','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2971','9562','Mrwil','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2972','9562','Buch b. Mrwil','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2973','9565','Bussnang','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2974','9565','Rothenhausen','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2975','9565','Schmidshof','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2976','9565','Oppikon','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2977','9565','Oberbussnang','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2978','9573','Littenheid','Thurgau','TG','194','N');
INSERT INTO PLZ VALUES ('2979','6500','Bellinzona','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('2980','6500','Bellinzona 2','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('2981','6500','Bellinzona 5','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('2982','6500','Bellinzona VZ','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('2983','6501','Bellinzona','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('2984','6503','Bellinzona','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('2985','6512','Giubiasco','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('2986','6513','Monte Carasso','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('2987','6514','Sementina','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('2988','6515','Gudo','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('2989','6516','Cugnasco','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('2990','6517','Arbedo','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('2991','6518','Gorduno','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('2992','6523','Preonzo','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('2993','6524','Moleno','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('2994','6525','Gnosca','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('2995','6526','Prosito','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('2996','6527','Lodrino','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('2997','6528','Camorino','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('2998','6532','Castione','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('2999','6533','Lumino','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3000','6571','Indemini','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3001','6572','Quartino','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3002','6573','Magadino','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3003','6574','Vira (Gambarogno)','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3004','6575','S. Nazzaro','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3005','6575','Vairano','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3006','6576','Gerra (Gambarogno)','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3007','6577','Ranzo','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3008','6578','Caviano','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3009','6579','Piazzogna','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3010','6582','Pianezzo','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3011','6583','S. Antonio (Val Morobbia)','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3012','6584','Carena','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3013','6592','S. Antonino','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3014','6593','Cadenazzo','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3015','6594','Contone','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3016','6595','Riazzino','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3017','6596','Gordola','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3018','6597','Agarone','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3019','6598','Tenero','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3020','6599','Robasacco','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3021','6600','Locarno','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3022','6600','Muralto','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3023','6600','Solduno','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3024','6601','Locarno','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3025','6602','Muralto','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3026','6604','Locarno','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3027','6605','Locarno','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3028','6605','Monte Br sopra Locarno','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3029','6611','Mosogno','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3030','6611','Gresso','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3031','6611','Crana','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3032','6612','Ascona','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3033','6613','Porto Ronco','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3034','6614','Brissago','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3035','6614','Isole di Brissago','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3036','6616','Losone','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3037','6618','Arcegno','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3038','6622','Ronco sopra Ascona','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3039','6631','Corippo','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3040','6632','Vogorno','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3041','6633','Lavertezzo','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3042','6634','Brione (Verzasca)','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3043','6635','Gerra (Verzasca)','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3044','6636','Frasco','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3045','6637','Sonogno','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3046','6644','Orselina','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3047','6645','Brione sopra Minusio','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3048','6646','Contra','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3049','6647','Mergoscia','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3050','6648','Minusio','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3051','6652','Tegna','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3052','6653','Verscio','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3053','6654','Cavigliano','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3054','6655','Intragna','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3055','6655','Verdasio','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3056','6655','Rasa','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3057','6656','Golino','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3058','6657','Palagnedra','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3059','6658','Borgnone','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3060','6659','Camedo','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3061','6659','Moneto','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3062','6661','Loco','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3063','6661','Auressio','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3064','6661','Berzona','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3065','6662','Russo','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3066','6663','Comologno','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3067','6663','Spruga','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3068','6664','Vergeletto','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3069','6670','Avegno','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3070','6672','Gordevio','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3071','6673','Maggia','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3072','6674','Riveo','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3073','6674','Someo','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3074','6675','Cevio','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3075','6676','Bignasco','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3076','6677','Moghegno','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3077','6677','Aurigeno','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3078','6678','Coglio','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3079','6678','Lodano','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3080','6678','Giumaglio','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3081','6682','Linescio','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3082','6683','Cerentino','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3083','6683','Niva (Vallemaggia)','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3084','6684','Campo (Vallemaggia)','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3085','6684','Cimalmotto','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3086','6685','Bosco/Gurin','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3087','6690','Cavergno','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3088','6690','S. Carlo (Val Bavona)','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3089','6692','Brontallo','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3090','6692','Menzonio','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3091','6693','Broglio','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3092','6694','Prato-Sornico','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3093','6695','Peccia','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3094','6695','Piano di Peccia','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3095','6696','Fusio','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3096','6702','Claro','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3097','6703','Osogna','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3098','6705','Cresciano','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3099','6707','Iragna','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3100','6710','Biasca','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3101','6710','Biasca Stazione','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3102','6713','Malvaglia','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3103','6714','Semione','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3104','6715','Dongio','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3105','6716','Acquarossa','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3106','6716','Leontica','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3107','6716','Lottigna','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3108','6717','Dangio-Torre','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3109','6717','Torre','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3110','6718','Olivone','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3111','6718','Camperio','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3112','6719','Aquila','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3113','6720','Campo (Blenio)','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3114','6720','Ghirone','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3115','6721','Ludiano','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3116','6721','Motto (Blenio)','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3117','6722','Corzoneso','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3118','6723','Prugiasco','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3119','6723','Castro','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3120','6723','Marolta','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3121','6724','Ponto Valentino','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3122','6724','Largario','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3123','6742','Pollegio','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3124','6743','Bodio TI','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3125','6744','Personico','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3126','6745','Giornico','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3127','6746','Lavorgo','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3128','6746','Calonico','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3129','6746','Nivo','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3130','6747','Chironico','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3131','6748','Anzonico','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3132','6749','Sobrio','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3133','6749','Cavagnago','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3134','6760','Faido','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3135','6760','Campello','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3136','6760','Molare','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3137','6760','Calpiogna','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3138','6760','Car','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3139','6760','Rossura','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3140','6763','Mairengo','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3141','6763','Osco','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3142','6764','Chiggiogna','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3143','6772','Rodi-Fiesso','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3144','6773','Prato (Leventina)','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3145','6774','Dalpe','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3146','6775','Ambr','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3147','6776','Piotta','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3148','6777','Quinto','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3149','6777','Varenzo','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3150','6780','Airolo','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3151','6780','Madrano','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3152','6781','Villa Bedretto','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3153','6781','Bedretto','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3154','6802','Rivera','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3155','6803','Camignolo','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3156','6804','Bironico','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3157','6805','Mezzovico','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3158','6806','Sigirino','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3159','6807','Taverne','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3160','6808','Torricella','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3161','6809','Medeglia','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3162','6810','Isone','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3163','6814','Lamone','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3164','6814','Cadempino','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3165','6814','Lamone-Cadempino','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3166','6815','Melide','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3167','6816','Bissone','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3168','6817','Maroggia','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3169','6818','Melano','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3170','6821','Rovio','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3171','6822','Arogno','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3172','6823','Pugerna','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3173','6825','Capolago','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3174','6826','Riva San Vitale','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3175','6827','Brusino Arsizio','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3176','6828','Balerna','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3177','6830','Chiasso','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3178','6830','Chiasso 1','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3179','6830','Chiasso 3','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3180','6832','Pedrinate','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3181','6832','Seseglio','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3182','6833','Vacallo','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3183','6834','Morbio Inferiore','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3184','6835','Morbio Superiore','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3185','6836','Serfontana','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3186','6837','Caneggio','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3187','6837','Bruzella','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3188','6838','Muggio','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3189','6838','Cabbio','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3190','6838','Scudellate','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3191','6839','Sagno','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3192','6850','Mendrisio','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3193','6850','Mendrisio Stazione','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3194','6850','Mendrisio Borgo','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3195','6852','Genestrerio','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3196','6853','Ligornetto','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3197','6854','S. Pietro','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3198','6855','Stabio','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3199','6862','Rancate','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3200','6863','Besazio','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3201','6864','Arzo','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3202','6865','Tremona','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3203','6866','Meride','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3204','6867','Serpiano','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3205','6872','Salorino','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3206','6872','Somazzo','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3207','6873','Corteglia','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3208','6874','Castel San Pietro','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3209','6875','Monte','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3210','6875','Casima','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3211','6877','Coldrerio','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3212','6883','Novazzano','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3213','6900','Lugano','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3214','6900','Massagno','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3215','6900','Paradiso','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3216','6901','Lugano','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3217','6902','Lugano 2 Paradiso Caselle','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3218','6903','Lugano','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3219','6904','Lugano 4 Molino Nuovo Casel','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3220','6906','Lugano 6 Cassarate Caselle','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3221','6907','Lugano 7 Loreto Caselle','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3222','6908','Massagno Caselle','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3223','6910','Lugano Servizi Speciali','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3224','6912','Pazzallo','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3225','6913','Carabbia','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3226','6914','Carona','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3227','6915','Pambio-Noranco','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3228','6916','Grancia','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3229','6917','Barbengo','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3230','6918','Figino','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3231','6919','Carabietta','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3232','6921','Vico Morcote','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3233','6922','Morcote','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3234','6924','Sorengo','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3235','6925','Gentilino','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3236','6926','Montagnola','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3237','6927','Agra','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3238','6928','Manno','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3239','6929','Gravesano','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3240','6930','Bedano','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3241','6932','Breganzona','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3242','6933','Muzzano','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3243','6934','Bioggio','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3244','6935','Bosco Luganese','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3245','6936','Cademario','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3246','6937','Breno','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3247','6938','Vezio','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3248','6938','Fescoggia','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3249','6939','Arosio','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3250','6939','Mugena','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3251','6939','Arosio-Mugena','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3252','6942','Savosa','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3253','6943','Vezia','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3254','6944','Cureglia','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3255','6945','Origlio','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3256','6946','Ponte Capriasca','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3257','6947','Vaglio','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3258','6948','Porza','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3259','6949','Comano','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3260','6950','Tesserete','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3261','6951','Scareglia','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3262','6951','Insone','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3263','6951','Odogno','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3264','6951','Colla','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3265','6951','Bogno','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3266','6951','Cozzo','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3267','6951','Signra','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3268','6952','Canobbio','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3269','6953','Lugaggia','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3270','6954','Sala Capriasca','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3271','6954','Bigorio','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3272','6955','Cagiallo','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3273','6955','Oggio','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3274','6956','Lopagno','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3275','6957','Roveredo TI','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3276','6958','Bidogno','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3277','6958','Corticiasca','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3278','6959','Maglio di Colla','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3279','6959','Cimadera','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3280','6959','Certara','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3281','6959','Curtina','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3282','6959','Piandera Paese','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3283','6962','Viganello','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3284','6963','Pregassona','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3285','6963','Cureggia','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3286','6964','Davesco-Soragno','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3287','6965','Cadro','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3288','6966','Villa Luganese','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3289','6967','Dino','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3290','6968','Sonvico','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3291','6974','Aldesago','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3292','6976','Castagnola','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3293','6977','Ruvigliana','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3294','6978','Gandria','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3295','6979','Br sopra Lugano','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3296','6980','Castelrotto','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3297','6981','Bedigliora','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3298','6981','Biogno-Beride','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3299','6981','Bombinasco','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3300','6981','Banco','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3301','6982','Agno','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3302','6983','Magliaso','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3303','6984','Pura','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3304','6986','Novaggio','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3305','6986','Miglieglia','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3306','6986','Curio','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3307','6987','Caslano','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3308','6988','Ponte Tresa','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3309','6989','Purasca','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3310','6990','Cassina d\'Agno','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3311','6991','Neggio','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3312','6992','Vernate','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3313','6992','Cimo','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3314','6993','Iseo','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3315','6994','Aranno','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3316','6995','Molinazzo di Monteggio','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3317','6995','Madonna del Piano','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3318','6996','Ponte Cremenaga','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3319','6997','Sessa','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3320','6998','Termine','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3321','6999','Astano','Ticino','TI','194','N');
INSERT INTO PLZ VALUES ('3322','6377','Seelisberg','Uri','UR','194','N');
INSERT INTO PLZ VALUES ('3323','6441','Rtli','Uri','UR','194','N');
INSERT INTO PLZ VALUES ('3324','6452','Sisikon','Uri','UR','194','N');
INSERT INTO PLZ VALUES ('3325','6454','Flelen','Uri','UR','194','N');
INSERT INTO PLZ VALUES ('3326','6460','Altdorf UR','Uri','UR','194','N');
INSERT INTO PLZ VALUES ('3327','6460','Altdorf UR 1','Uri','UR','194','N');
INSERT INTO PLZ VALUES ('3328','6460','Altdorf UR 2','Uri','UR','194','N');
INSERT INTO PLZ VALUES ('3329','6461','Isenthal','Uri','UR','194','N');
INSERT INTO PLZ VALUES ('3330','6462','Seedorf UR','Uri','UR','194','N');
INSERT INTO PLZ VALUES ('3331','6463','Brglen UR','Uri','UR','194','N');
INSERT INTO PLZ VALUES ('3332','6464','Spiringen','Uri','UR','194','N');
INSERT INTO PLZ VALUES ('3333','6465','Unterschchen','Uri','UR','194','N');
INSERT INTO PLZ VALUES ('3334','6466','Bauen','Uri','UR','194','N');
INSERT INTO PLZ VALUES ('3335','6467','Schattdorf','Uri','UR','194','N');
INSERT INTO PLZ VALUES ('3336','6468','Attinghausen','Uri','UR','194','N');
INSERT INTO PLZ VALUES ('3337','6469','Haldi b. Schattdorf','Uri','UR','194','N');
INSERT INTO PLZ VALUES ('3338','6472','Erstfeld','Uri','UR','194','N');
INSERT INTO PLZ VALUES ('3339','6473','Silenen','Uri','UR','194','N');
INSERT INTO PLZ VALUES ('3340','6474','Amsteg','Uri','UR','194','N');
INSERT INTO PLZ VALUES ('3341','6475','Bristen','Uri','UR','194','N');
INSERT INTO PLZ VALUES ('3342','6476','Intschi','Uri','UR','194','N');
INSERT INTO PLZ VALUES ('3343','6482','Gurtnellen','Uri','UR','194','N');
INSERT INTO PLZ VALUES ('3344','6484','Wassen UR','Uri','UR','194','N');
INSERT INTO PLZ VALUES ('3345','6485','Meien','Uri','UR','194','N');
INSERT INTO PLZ VALUES ('3346','6487','Gschenen','Uri','UR','194','N');
INSERT INTO PLZ VALUES ('3347','6490','Andermatt','Uri','UR','194','N');
INSERT INTO PLZ VALUES ('3348','6491','Realp','Uri','UR','194','N');
INSERT INTO PLZ VALUES ('3349','6493','Hospental','Uri','UR','194','N');
INSERT INTO PLZ VALUES ('3350','8751','Urnerboden','Uri','UR','194','N');
INSERT INTO PLZ VALUES ('3351','1000','Lausanne 25','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3352','1000','Lausanne 26','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3353','1000','Lausanne','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3354','1000','Lausanne 27','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3355','1000','Lausanne 3','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3356','1000','Lausanne 6','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3357','1000','Lausanne 7','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3358','1000','Lausanne 8','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3359','1000','Lausanne 12','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3360','1000','Lausanne 14','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3361','1000','Lausanne 16','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3362','1000','Lausanne 20','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3363','1000','Lausanne 21','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3364','1000','Lausanne 22','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3365','1000','Lausanne 23','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3366','1000','Lausanne 30 Grey Cases','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3367','1000','Lausanne Swisscom','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3368','1001','Lausanne','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3369','1002','Lausanne','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3370','1003','Lausanne','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3371','1004','Lausanne','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3372','1005','Lausanne','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3373','1006','Lausanne','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3374','1007','Lausanne','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3375','1008','Prilly','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3376','1008','Jouxtens-Mzery','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3377','1009','Pully','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3378','1010','Lausanne','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3379','1011','Lausanne','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3380','1012','Lausanne','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3381','1014','Lausanne Adm cant VD','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3382','1015','Lausanne','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3383','1017','Lausanne Charles Veillon SA','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3384','1018','Lausanne','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3385','1019','Lausanne Services spciaux','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3386','1020','Renens VD','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3387','1020','Renens VD 1','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3388','1020','Renens VD 2','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3389','1022','Chavannes-prs-Renens','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3390','1023','Crissier','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3391','1023','Crissier 1','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3392','1024','Ecublens VD','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3393','1025','St-Sulpice VD','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3394','1026','Denges','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3395','1026','Echandens','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3396','1026','Echandens-Denges','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3397','1027','Lonay','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3398','1028','Prverenges','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3399','1029','Villars-Ste-Croix','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3400','1030','Bussigny-prs-Lausanne','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3401','1031','Mex VD','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3402','1032','Romanel-sur-Lausanne','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3403','1033','Cheseaux-sur-Lausanne','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3404','1034','Boussens','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3405','1035','Bournens','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3406','1036','Sullens','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3407','1037','Etagnires','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3408','1038','Bercher','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3409','1039','Cheseaux Polyval','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3410','1040','Echallens','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3411','1040','St-Barthlemy VD','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3412','1040','Villars-le-Terroir','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3413','1041','Poliez-le-Grand','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3414','1041','Dommartin','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3415','1041','Poliez-Pittet','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3416','1041','Bottens','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3417','1041','Naz','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3418','1041','Montaubion-Chardonney','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3419','1042','Assens','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3420','1042','Bettens','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3421','1042','Bioley-Orjulaz','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3422','1043','Sugnens','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3423','1044','Fey','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3424','1045','Ogens','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3425','1046','Rueyres','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3426','1047','Oppens','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3427','1052','Le Mont-sur-Lausanne','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3428','1053','Cugy VD','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3429','1053','Bretigny-sur-Morrens','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3430','1054','Morrens VD','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3431','1055','Froideville','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3432','1058','Villars-Tiercelin','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3433','1059','Peney-le-Jorat','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3434','1061','Villars-Mendraz','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3435','1062','Sottens','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3436','1063','Peyres-Possens','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3437','1063','Boulens','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3438','1063','Chapelle-sur-Moudon','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3439','1063','Martherenges','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3440','1066','Epalinges','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3441','1068','Les Monts-de-Pully','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3442','1070','Puidoux','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3443','1070','Puidoux-Gare','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3444','1071','Chexbres','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3445','1071','Rivaz','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3446','1071','St-Saphorin (Lavaux)','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3447','1072','Forel (Lavaux)','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3448','1073','Savigny','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3449','1073','Mollie-Margot','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3450','1076','Ferlens VD','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3451','1077','Servion','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3452','1078','Essertes','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3453','1080','Les Cullayes','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3454','1081','Montpreveyres','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3455','1082','Corcelles-le-Jorat','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3456','1083','Mzires VD','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3457','1084','Carrouge VD','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3458','1085','Vulliens','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3459','1088','Ropraz','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3460','1090','La Croix (Lutry)','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3461','1091','Grandvaux','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3462','1091','Aran','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3463','1091','Chenaux','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3464','1092','Belmont-sur-Lausanne','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3465','1093','La Conversion','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3466','1094','Paudex','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3467','1095','Lutry','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3468','1096','Cully','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3469','1096','Villette (Lavaux)','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3470','1097','Riex','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3471','1098','Epesses','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3472','1099','Montpreveyres Fotolabo Club','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3473','1110','Morges','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3474','1110','Morges 1','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3475','1110','Morges 2','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3476','1110','Morges 3','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3477','1112','Echichens','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3478','1113','St-Saphorin-sur-Morges','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3479','1114','Colombier VD','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3480','1115','Vullierens','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3481','1116','Cottens VD','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3482','1117','Grancy','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3483','1121','Bremblens','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3484','1122','Romanel-sur-Morges','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3485','1123','Aclens','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3486','1124','Gollion','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3487','1125','Monnaz','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3488','1126','Vaux-sur-Morges','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3489','1127','Clarmont','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3490','1128','Reverolle','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3491','1131','Tolochenaz','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3492','1132','Lully VD','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3493','1134','Vufflens-le-Chteau','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3494','1134','Chigny','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3495','1135','Denens','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3496','1136','Bussy-Chardonney','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3497','1141','Svery','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3498','1142','Pampigny','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3499','1143','Apples','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3500','1144','Ballens','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3501','1145','Bire','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3502','1146','Mollens VD','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3503','1147','Montricher','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3504','1148','L\'Isle','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3505','1148','Cuarnens','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3506','1148','Moiry VD','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3507','1148','La Praz','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3508','1148','Mont-la-Ville','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3509','1148','Chavannes-le-Veyron','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3510','1148','Mauraz','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3511','1148','Villars-Bozon','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3512','1148','La Coudre','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3513','1149','Berolle','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3514','1162','St-Prex','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3515','1163','Etoy','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3516','1164','Buchillon','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3517','1165','Allaman','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3518','1166','Perroy','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3519','1167','Lussy-sur-Morges','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3520','1168','Villars-sous-Yens','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3521','1169','Yens','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3522','1170','Aubonne','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3523','1172','Bougy-Villars','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3524','1173','Fchy','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3525','1174','Montherod','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3526','1174','Pizy','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3527','1175','Lavigny','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3528','1176','St-Livres','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3529','1180','Rolle','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3530','1180','Tartegnin','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3531','1182','Gilly','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3532','1183','Bursins','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3533','1184','Vinzel','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3534','1184','Luins','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3535','1185','Mont-sur-Rolle','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3536','1186','Essertines-sur-Rolle','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3537','1187','St-Oyens','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3538','1188','Gimel','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3539','1188','St-George','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3540','1189','Saubraz','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3541','1195','Dully','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3542','1195','Bursinel','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3543','1195','Dully-Bursinel','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3544','1196','Gland','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3545','1197','Prangins','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3546','1260','Nyon','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3547','1260','Nyon 2','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3548','1260','Nyon 1','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3549','1261','Marchissy','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3550','1261','Le Vaud','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3551','1261','Longirod','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3552','1262','Eysins','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3553','1263','Crassier','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3554','1264','St-Cergue','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3555','1265','La Cure','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3556','1266','Duillier','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3557','1267','Vich','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3558','1267','Coinsins','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3559','1267','Vich-Coinsins','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3560','1268','Begnins','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3561','1268','Burtigny','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3562','1269','Bassins','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3563','1270','Trlex','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3564','1271','Givrins','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3565','1272','Genolier','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3566','1273','Arzier','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3567','1273','Le Muids','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3568','1274','Grens','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3569','1274','Signy','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3570','1274','Signy-Centre','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3571','1275','Chserex','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3572','1276','Gingins','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3573','1277','Borex','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3574','1277','Arnex-sur-Nyon','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3575','1278','La Rippe','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3576','1279','Chavannes-de-Bogis','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3577','1279','Bogis-Bossey','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3578','1290','Chavannes-des-Bois','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3579','1291','Commugny','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3580','1295','Mies','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3581','1295','Tannay','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3582','1295','Mies-Tannay','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3583','1296','Coppet','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3584','1297','Founex','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3585','1299','Crans-prs-Cligny','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3586','1302','Vufflens-la-Ville','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3587','1303','Penthaz','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3588','1304','Cossonay-Ville','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3589','1304','Senarclens','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3590','1304','Dizy','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3591','1304','Allens','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3592','1305','Penthalaz','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3593','1306','Daillens','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3594','1307','Lussery-Villars','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3595','1308','La Chaux (Cossonay)','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3596','1312','Eclpens','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3597','1313','Ferreyres','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3598','1315','La Sarraz','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3599','1316','Chevilly','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3600','1317','Orny','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3601','1318','Pompaples','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3602','1321','Arnex-sur-Orbe','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3603','1322','Croy','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3604','1323','Romainmtier','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3605','1324','Premier','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3606','1325','Vaulion','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3607','1326','Juriens','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3608','1329','Bretonnires','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3609','1337','Vallorbe','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3610','1338','Ballaigues','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3611','1341','Orient','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3612','1342','Le Pont','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3613','1343','Les Charbonnires','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3614','1344','L\'Abbaye','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3615','1345','Le Lieu','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3616','1346','Les Bioux','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3617','1347','Le Sentier','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3618','1347','Le Solliat','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3619','1348','Le Brassus','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3620','1350','Orbe','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3621','1352','Agiez','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3622','1353','Bofflens','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3623','1354','Montcherand','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3624','1355','L\'Abergement','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3625','1355','Sergey','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3626','1356','Les Cles','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3627','1356','La Russille','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3628','1357','Lignerolle','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3629','1358','Valeyres-sous-Rances','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3630','1372','Bavois','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3631','1373','Chavornay','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3632','1374','Corcelles-sur-Chavornay','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3633','1375','Penthraz','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3634','1376','Goumoens-la-Ville','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3635','1376','Eclagnens','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3636','1376','Goumoens-le-Jux','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3637','1377','Oulens-sous-Echallens','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3638','1400','Yverdon-les-Bains','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3639','1400','Cheseaux-Noraz','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3640','1400','Yverdon 2','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3641','1400','Yverdon 3','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3642','1401','Yverdon-les-Bains','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3643','1404','Cuarny','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3644','1404','Villars-Epeney','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3645','1405','Pomy','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3646','1406','Cronay','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3647','1407','Donneloye','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3648','1407','Bioley-Magnoux','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3649','1407','Gossens','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3650','1407','Mzery-prs-Donneloye','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3651','1408','Prahins','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3652','1409','Chanaz','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3653','1410','Thierrens','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3654','1410','St-Cierges','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3655','1410','Denezy','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3656','1410','Correvon','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3657','1412','Valeyres-sous-Ursins','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3658','1412','Ursins','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3659','1413','Orzens','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3660','1415','Molondin','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3661','1415','Dmoret','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3662','1416','Pailly','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3663','1417','Epautheyres','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3664','1417','Essertines-sur-Yverdon','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3665','1418','Vuarrens','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3666','1420','Fiez','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3667','1421','Fontaines-sur-Grandson','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3668','1421','Grandevent','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3669','1422','Grandson','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3670','1422','Grandson 1','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3671','1422','Grandson 2','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3672','1423','Villars-Burquin','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3673','1423','Fontanezier','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3674','1423','Romairon','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3675','1423','Vaugondry','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3676','1424','Champagne','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3677','1425','Onnens VD','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3678','1426','Concise','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3679','1426','Corcelles-prs-Concise','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3680','1427','Bonvillars','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3681','1428','Mutrux','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3682','1428','Provence','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3683','1429','Giez','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3684','1430','Orges','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3685','1431','Vugelles-La Mothe','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3686','1431','Novalles','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3687','1432','Belmont-sur-Yverdon','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3688','1432','Gressy','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3689','1433','Suchy','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3690','1434','Ependes VD','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3691','1435','Essert-Pittet','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3692','1436','Treycovagnes','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3693','1436','Chamblon','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3694','1437','Suscvaz','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3695','1438','Mathod','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3696','1439','Rances','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3697','1440','Montagny-Chamard','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3698','1441','Valeyres-sous-Montagny','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3699','1442','Montagny-prs-Yverdon','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3700','1443','Champvent','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3701','1443','Essert-sous-Champvent','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3702','1443','Villars-sous-Champvent','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3703','1445','Vuiteboeuf','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3704','1446','Baulmes','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3705','1450','Ste-Croix','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3706','1450','La Sagne (Ste-Croix)','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3707','1450','Le Chteau-de-Ste-Croix','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3708','1452','Les Rasses','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3709','1453','Mauborget','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3710','1453','Bullet','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3711','1454','L\'Auberson','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3712','1454','La Vraconnaz','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3713','1462','Yvonand','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3714','1463','Rovray','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3715','1464','Chavannes-le-Chne','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3716','1464','Chne-Pquier','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3717','1509','Vucherens','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3718','1510','Moudon','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3719','1510','Syens','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3720','1512','Chavannes-sur-Moudon','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3721','1513','Hermenches','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3722','1513','Rossenges','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3723','1514','Bussy-sur-Moudon','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3724','1515','Villars-le-Comte','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3725','1515','Neyruz-sur-Moudon','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3726','1521','Curtilles','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3727','1522','Lucens','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3728','1522','Oulens-sur-Lucens','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3729','1523','Granges-prs-Marnand','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3730','1524','Marnand','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3731','1525','Henniez','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3732','1525','Seigneux','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3733','1526','Forel-sur-Lucens','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3734','1526','Cremin','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3735','1530','Payerne','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3736','1534','Sassel','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3737','1535','Combremont-le-Grand','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3738','1536','Combremont-le-Petit','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3739','1537','Champtauroz','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3740','1538','Treytorrens (Payerne)','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3741','1543','Grandcour','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3742','1545','Chevroux','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3743','1551','Vers-chez-Perrin','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3744','1552','Trey','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3745','1554','Sdeilles','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3746','1554','Rossens VD','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3747','1555','Villarzel','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3748','1562','Corcelles-prs-Payerne','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3749','1565','Missy','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3750','1580','Avenches','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3751','1580','Oleyres','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3752','1582','Donatyre','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3753','1584','Villars-le-Grand','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3754','1585','Salavaux','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3755','1585','Bellerive VD','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3756','1585','Cotterd','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3757','1586','Vallamand','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3758','1587','Montmagny','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3759','1587','Constantine','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3760','1588','Cudrefin','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3761','1589','Chabrey','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3762','1595','Faoug','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3763','1607','Palzieux-Village','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3764','1607','Palzieux','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3765','1607','Les Tavernes','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3766','1607','Les Thioleyres','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3767','1608','Oron-le-Chtel','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3768','1608','Bussigny-sur-Oron','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3769','1608','Chesalles-sur-Oron','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3770','1610','Oron-la-Ville','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3771','1610','Chtillens','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3772','1610','Vuibroye','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3773','1612','Ecoteaux','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3774','1613','Maracon','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3775','1658','Rossinire','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3776','1658','La Tine','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3777','1659','Rougemont','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3778','1659','Flendruz','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3779','1660','Chteau-d\'Oex','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3780','1660','La Lcherette','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3781','1660','Les Moulins','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3782','1660','L\'Etivaz','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3783','1682','Prvonloup','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3784','1682','Villars-Bramard','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3785','1682','Dompierre VD','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3786','1682','Lovatens','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3787','1682','Cerniaz VD','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3788','1683','Brenles','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3789','1683','Chesalles-sur-Moudon','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3790','1683','Sarzens','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3791','1787','Mur (Vully) VD','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3792','1800','Vevey','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3793','1800','Vevey 1','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3794','1800','Vevey 2','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3795','1801','Le Mont-Plerin','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3796','1802','Corseaux','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3797','1803','Chardonne','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3798','1804','Corsier-sur-Vevey','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3799','1805','Jongny','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3800','1806','St-Lgier-La Chisaz','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3801','1807','Blonay','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3802','1808','Les Monts-de-Corsier','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3803','1809','Fenil-sur-Corsier','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3804','1811','Vevey Services spciaux','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3805','1814','La Tour-de-Peilz','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3806','1815','Clarens','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3807','1816','Chailly-Montreux','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3808','1817','Brent','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3809','1818','Montreux La Redoute','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3810','1820','Montreux','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3811','1820','Veytaux','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3812','1820','Territet','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3813','1820','Montreux 1','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3814','1820','Montreux 2','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3815','1820','Territet-Veytaux','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3816','1822','Chernex','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3817','1823','Glion','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3818','1824','Caux','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3819','1832','Chamby','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3820','1832','Villard-sur-Chamby','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3821','1833','Les Avants','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3822','1844','Villeneuve VD','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3823','1845','Noville','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3824','1846','Chessel','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3825','1847','Rennaz','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3826','1852','Roche VD','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3827','1853','Yvorne','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3828','1854','Leysin','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3829','1856','Corbeyrier','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3830','1860','Aigle','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3831','1862','Les Mosses','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3832','1862','La Comballaz','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3833','1863','Le Spey','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3834','1864','Vers-l\'Eglise','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3835','1865','Les Diablerets','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3836','1866','La Forclaz VD','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3837','1867','Ollon VD','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3838','1867','St-Triphon','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3839','1867','Panex','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3840','1880','Bex','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3841','1880','Fenalet-sur-Bex','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3842','1880','Frenires-sur-Bex','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3843','1880','Les Plans-sur-Bex','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3844','1882','Gryon','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3845','1882','Les Posses-sur-Bex','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3846','1884','Villars-sur-Ollon','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3847','1884','Humoz','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3848','1884','Arveyes','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3849','1885','Chesires','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3850','1892','Lavey-Village','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3851','1892','Lavey-les-Bains','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3852','1892','Morcles','Vaud','VD','194','N');
INSERT INTO PLZ VALUES ('3853','1868','Collombey','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3854','1869','Massongex','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3855','1870','Monthey','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3856','1870','Monthey 1','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3857','1870','Monthey 2','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3858','1871','Chox','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3859','1871','Les Giettes','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3860','1872','Troistorrents','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3861','1873','Val-d\'Illiez','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3862','1873','Champoussin','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3863','1873','Les Crosets','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3864','1874','Champry','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3865','1875','Morgins','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3866','1890','St-Maurice','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3867','1890','Mex VS','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3868','1891','Vrossaz','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3869','1893','Muraz (Collombey)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3870','1895','Vionnaz','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3871','1896','Vouvry','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3872','1896','Miex','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3873','1897','Bouveret','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3874','1897','Les Evouettes','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3875','1898','St-Gingolph','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3876','1899','Torgon','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3877','1902','Evionnaz','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3878','1903','Collonges','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3879','1904','Vernayaz','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3880','1905','Dornaz','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3881','1906','Charrat','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3882','1907','Saxon','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3883','1908','Riddes','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3884','1911','Ovronnaz','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3885','1911','Mayens-de-Chamoson','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3886','1912','Leytron','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3887','1912','Produit (Leytron)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3888','1912','Montagnon (Leytron)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3889','1912','Dugny (Leytron)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3890','1913','Saillon','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3891','1914','Isrables','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3892','1914','Auddes-sur-Riddes','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3893','1918','La Tzoumaz','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3894','1919','Martigny Groupe Mutuel','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3895','1920','Martigny','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3896','1920','Martigny 1','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3897','1920','Martigny 2','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3898','1921','Martigny-Croix','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3899','1922','Salvan','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3900','1922','Les Granges (Salvan)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3901','1923','Le Trtien','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3902','1923','Les Marcottes','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3903','1925','Finhaut','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3904','1925','Le Chtelard VS','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3905','1926','Fully','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3906','1927','Chemin','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3907','1928','Ravoire','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3908','1929','Trient','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3909','1932','Bovernier','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3910','1932','Les Valettes (Bovernier)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3911','1933','Sembrancher','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3912','1933','Vens (Sembrancher)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3913','1933','Chamoille (Sembrancher)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3914','1933','La Garde (Sembrancher)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3915','1934','Le Chble VS','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3916','1934','Bruson','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3917','1934','Cotterg (Le Chble VS)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3918','1934','Villette (Le Chble VS)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3919','1934','Fontenelle (Le Chble VS)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3920','1934','Montagnier (Le Chble VS)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3921','1936','Verbier','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3922','1937','Orsires','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3923','1938','Champex-Lac','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3924','1941','Vollges','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3925','1941','Cries (Vollges)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3926','1942','Levron','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3927','1943','Praz-de-Fort','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3928','1944','La Fouly VS','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3929','1945','Liddes','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3930','1945','Fontaine Dessus (Liddes)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3931','1945','Fontaine Dessous (Liddes)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3932','1945','Dranse (Liddes)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3933','1945','Chandonne (Liddes)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3934','1945','Rive Haute (Liddes)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3935','1945','Fornex (Liddes)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3936','1945','Les Moulins VS (Liddes)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3937','1945','Vichres (Liddes)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3938','1945','Palasuit (Liddes)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3939','1945','Chez Petit (Liddes)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3940','1945','Petit Vichres (Liddes)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3941','1946','Bourg-St-Pierre','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3942','1947','Versegres','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3943','1947','Prarreyer (Versegres)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3944','1947','Les Places (Versegres)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3945','1947','La Montoz (Versegres)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3946','1947','Champsec (Versegres)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3947','1947','Le Fregnoley (Versegres)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3948','1948','Lourtier','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3949','1948','Fionnay','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3950','1948','Sarreyer','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3951','1948','Le Planchamp (Lourtier)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3952','1948','Le Morgnes (Lourtier)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3953','1950','Sion','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3954','1950','Sion 2','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3955','1950','Sion 4','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3956','1951','Sion','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3957','1955','Chamoson','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3958','1955','St-Pierre-de-Clages','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3959','1955','Les Vrines (Chamoson)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3960','1955','Nmiaz (Chamoson)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3961','1955','Grugnay (Chamoson)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3962','1957','Ardon','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3963','1958','St-Lonard','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3964','1958','Uvrier','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3965','1961','Vernamige','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3966','1962','Pont-de-la-Morge (Sion)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3967','1963','Vtroz','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3968','1964','Conthey','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3969','1965','Savise','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3970','1965','Chandolin-prs-Savise','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3971','1965','Drne VS','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3972','1965','Roumaz (Savise)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3973','1965','Granois (Savise)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3974','1965','St-Germain (Savise)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3975','1965','Ormne (Savise)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3976','1965','Mayens-de-la-Zour (Savise)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3977','1965','Monteiller-Savise','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3978','1966','Signse (Ayent)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3979','1966','Fortunau (Ayent)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3980','1966','Luc (Ayent)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3981','1966','St-Romain (Ayent)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3982','1966','Saxonne (Ayent)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3983','1966','Villa (Ayent)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3984','1966','La Place (Ayent)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3985','1966','Botyre (Ayent)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3986','1966','Blignoud (Ayent)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3987','1966','Argnoud (Ayent)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3988','1966','Ayent','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3989','1967','Bramois','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3990','1968','Mase','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3991','1969','St-Martin VS','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3992','1969','Liez (St-Martin)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3993','1969','Trogne (St-Martin)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3994','1969','Suen (St-Martin)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3995','1969','Eison (St.Martin)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3996','1971','Grimisuat','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3997','1971','Champlan (Grimisuat)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3998','1971','Comraz (Grimisuat)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('3999','1972','Anzre','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4000','1973','Nax','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4001','1974','Arbaz','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4002','1975','St-Sverin','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4003','1976','Erde','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4004','1976','Aven','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4005','1976','Daillon','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4006','1977','Icogne','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4007','1978','Lens','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4008','1981','Vex','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4009','1982','Euseigne','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4010','1983','Evolne','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4011','1983','Lana (Evolne)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4012','1984','Les Haudres','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4013','1985','La Sage','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4014','1986','Arolla','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4015','1987','Hrmence','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4016','1987','Mche','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4017','1988','Les Collons','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4018','1988','Thyon','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4019','1988','Thyon-Les Collons','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4020','1991','Salins','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4021','1991','Arvillard (Salins)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4022','1991','Pravidondaz (Salins)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4023','1991','Turin (Salins)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4024','1991','Misriez (Salins)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4025','1992','Les Agettes','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4026','1992','Les Mayens-de-Sion','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4027','1992','La Vernaz (Les Agettes)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4028','1992','Crte--l\'Oeil(Les Agettes)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4029','1993','Veysonnaz','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4030','1993','Clbes (Nendaz)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4031','1994','Aproz (Nendaz)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4032','1996','Basse-Nendaz','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4033','1996','Fey (Nendaz)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4034','1996','Beuson (Nendaz)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4035','1996','Baar (Nendaz)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4036','1996','Brignon (Nendaz)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4037','1996','Bioley-de-Brignon (Nendaz)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4038','1996','Bieudron (Nendaz)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4039','1996','Condmines (Nendaz)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4040','1996','Saclentz (Nendaz)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4041','1997','Haute-Nendaz','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4042','1997','Siviez (Nendaz)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4043','3801','Jungfraujoch','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4044','3900','Brig','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4045','3900','Gamsen','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4046','3900','Brigerbad','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4047','3901','Rothwald','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4048','3902','Glis','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4049','3903','Birgisch','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4050','3903','Mund','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4051','3904','Naters','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4052','3905','Saas-Almagell','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4053','3906','Saas-Fee','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4054','3907','Simplon Dorf','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4055','3907','Simplon Hospiz','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4056','3907','Gabi (Simplon)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4057','3907','Gondo','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4058','3908','Saas-Balen','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4059','3910','Saas-Grund','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4060','3911','Ried-Brig','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4061','3912','Termen','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4062','3913','Rosswald','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4063','3914','Blatten b. Naters','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4064','3914','Belalp','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4065','3916','Ferden','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4066','3917','Kippel','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4067','3917','Goppenstein','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4068','3918','Wiler (Ltschen)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4069','3919','Blatten (Ltschen)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4070','3920','Zermatt','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4071','3922','Stalden VS','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4072','3922','Eisten','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4073','3922','Kalpetran','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4074','3923','Trbel','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4075','3924','St. Niklaus VS','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4076','3924','Gasenried','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4077','3925','Grchen','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4078','3926','Embd','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4079','3927','Herbriggen','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4080','3928','Randa','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4081','3929','Tsch','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4082','3930','Visp','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4083','3930','Eyholz','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4084','3931','Lalden','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4085','3932','Visperterminen','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4086','3933','Staldenried','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4087','3934','Zeneggen','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4088','3935','Brchen','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4089','3937','Baltschieder','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4090','3938','Ausserberg','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4091','3939','Eggerberg','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4092','3940','Steg VS','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4093','3942','St. German','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4094','3942','Raron','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4095','3942','Niedergesteln','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4096','3943','Eischoll','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4097','3944','Unterbch VS','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4098','3945','Gampel','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4099','3945','Niedergampel','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4100','3946','Turtmann','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4101','3946','Gruben','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4102','3947','Ergisch','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4103','3948','Unterems','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4104','3948','Oberems','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4105','3949','Hohtenn','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4106','3951','Agarn','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4107','3952','Susten','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4108','3953','Varen','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4109','3953','Leuk Stadt','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4110','3953','Inden','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4111','3954','Leukerbad','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4112','3955','Albinen','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4113','3956','Guttet-Feschel','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4114','3957','Erschmatt','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4115','3957','Bratsch','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4116','3960','Sierre','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4117','3960','Corin-de-la-Crte','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4118','3960','Loc','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4119','3960','Muraz (Sierre)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4120','3960','Niouc','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4121','3961','Vissoie','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4122','3961','St-Luc','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4123','3961','Zinal','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4124','3961','Grimentz','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4125','3961','Chandolin','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4126','3961','Ayer','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4127','3961','St-Jean VS','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4128','3963','Montana','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4129','3963','Crans-Montana','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4130','3963','Aminona','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4131','3963','Crans-Montana 1','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4132','3963','Crans-Montana 2','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4133','3965','Chippis','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4134','3966','Chalais','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4135','3966','Rchy','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4136','3967','Vercorin','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4137','3968','Veyras','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4138','3970','Salgesch','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4139','3971','Chermignon','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4140','3971','Chermignon-d\'en-Bas','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4141','3971','Ollon VS','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4142','3972','Mige','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4143','3973','Venthne','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4144','3974','Mollens VS','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4145','3975','Randogne','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4146','3976','Nos','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4147','3976','Champzab','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4148','3977','Granges VS','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4149','3978','Flanthey','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4150','3979','Grne','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4151','3982','Bitsch','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4152','3983','Mrel','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4153','3983','Bister','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4154','3983','Filet','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4155','3983','Goppisberg','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4156','3983','Greich','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4157','3984','Fiesch','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4158','3984','Fieschertal','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4159','3985','Mnster VS','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4160','3985','Geschinen','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4161','3986','Ried-Mrel','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4162','3987','Riederalp','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4163','3988','Ulrichen','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4164','3988','Obergesteln','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4165','3989','Niederwald','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4166','3989','Blitzingen','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4167','3989','Biel VS','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4168','3989','Ritzingen','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4169','3989','Selkingen','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4170','3989','Grafschaft','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4171','3991','Betten','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4172','3992','Bettmeralp','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4173','3993','Grengiols','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4174','3994','Lax','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4175','3994','Martisberg','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4176','3995','Ernen','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4177','3995','Ausserbinn','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4178','3995','Mhlebach (Goms)','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4179','3995','Steinhaus','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4180','3996','Binn','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4181','3997','Bellwald','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4182','3998','Reckingen VS','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4183','3998','Gluringen','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4184','3999','Oberwald','Valais','VS','194','N');
INSERT INTO PLZ VALUES ('4185','6300','Zug','Zug','ZG','194','N');
INSERT INTO PLZ VALUES ('4186','6300','Zugerberg','Zug','ZG','194','N');
INSERT INTO PLZ VALUES ('4187','6301','Zug','Zug','ZG','194','N');
INSERT INTO PLZ VALUES ('4188','6302','Zug','Zug','ZG','194','N');
INSERT INTO PLZ VALUES ('4189','6303','Zug','Zug','ZG','194','N');
INSERT INTO PLZ VALUES ('4190','6304','Zug','Zug','ZG','194','N');
INSERT INTO PLZ VALUES ('4191','6310','Zug Sonderdienste','Zug','ZG','194','N');
INSERT INTO PLZ VALUES ('4192','6312','Steinhausen','Zug','ZG','194','N');
INSERT INTO PLZ VALUES ('4193','6313','Menzingen','Zug','ZG','194','N');
INSERT INTO PLZ VALUES ('4194','6313','Edlibach','Zug','ZG','194','N');
INSERT INTO PLZ VALUES ('4195','6313','Finstersee','Zug','ZG','194','N');
INSERT INTO PLZ VALUES ('4196','6314','Untergeri','Zug','ZG','194','N');
INSERT INTO PLZ VALUES ('4197','6314','Neugeri','Zug','ZG','194','N');
INSERT INTO PLZ VALUES ('4198','6315','Obergeri','Zug','ZG','194','N');
INSERT INTO PLZ VALUES ('4199','6315','Morgarten','Zug','ZG','194','N');
INSERT INTO PLZ VALUES ('4200','6315','Alosen','Zug','ZG','194','N');
INSERT INTO PLZ VALUES ('4201','6317','Oberwil b. Zug','Zug','ZG','194','N');
INSERT INTO PLZ VALUES ('4202','6318','Walchwil','Zug','ZG','194','N');
INSERT INTO PLZ VALUES ('4203','6319','Allenwinden','Zug','ZG','194','N');
INSERT INTO PLZ VALUES ('4204','6330','Cham','Zug','ZG','194','N');
INSERT INTO PLZ VALUES ('4205','6330','Cham 2','Zug','ZG','194','N');
INSERT INTO PLZ VALUES ('4206','6330','Cham 1','Zug','ZG','194','N');
INSERT INTO PLZ VALUES ('4207','6331','Hnenberg','Zug','ZG','194','N');
INSERT INTO PLZ VALUES ('4208','6332','Hagendorn','Zug','ZG','194','N');
INSERT INTO PLZ VALUES ('4209','6333','Hnenberg See','Zug','ZG','194','N');
INSERT INTO PLZ VALUES ('4210','6340','Baar','Zug','ZG','194','N');
INSERT INTO PLZ VALUES ('4211','6340','Sihlbrugg','Zug','ZG','194','N');
INSERT INTO PLZ VALUES ('4212','6341','Baar','Zug','ZG','194','N');
INSERT INTO PLZ VALUES ('4213','6342','Baar','Zug','ZG','194','N');
INSERT INTO PLZ VALUES ('4214','6343','Rotkreuz','Zug','ZG','194','N');
INSERT INTO PLZ VALUES ('4215','6343','Buonas','Zug','ZG','194','N');
INSERT INTO PLZ VALUES ('4216','6343','Risch','Zug','ZG','194','N');
INSERT INTO PLZ VALUES ('4217','6343','Holzhusern ZG','Zug','ZG','194','N');
INSERT INTO PLZ VALUES ('4218','6345','Neuheim','Zug','ZG','194','N');
INSERT INTO PLZ VALUES ('4219','6349','Baar Sonderdienste','Zug','ZG','194','N');
INSERT INTO PLZ VALUES ('4220','8000','Zrich','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4221','8001','Zrich','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4222','8002','Zrich','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4223','8003','Zrich','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4224','8004','Zrich','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4225','8005','Zrich','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4226','8006','Zrich','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4227','8008','Zrich','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4228','8010','Zrich','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4229','8012','Zrich','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4230','8020','Zrich 1','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4231','8021','Zrich 1','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4232','8022','Zrich','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4233','8024','Zrich','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4234','8026','Zrich','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4235','8027','Zrich','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4236','8031','Zrich','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4237','8032','Zrich','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4238','8033','Zrich','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4239','8034','Zrich','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4240','8036','Zrich','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4241','8037','Zrich','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4242','8038','Zrich','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4243','8040','Zrich','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4244','8041','Zrich','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4245','8042','Zrich','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4246','8044','Zrich','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4247','8044','Gockhausen','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4248','8045','Zrich','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4249','8046','Zrich','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4250','8047','Zrich','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4251','8048','Zrich','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4252','8049','Zrich','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4253','8050','Zrich','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4254','8051','Zrich','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4255','8052','Zrich','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4256','8053','Zrich','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4257','8055','Zrich','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4258','8057','Zrich','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4259','8058','Zrich','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4260','8060','Zrich','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4261','8063','Zrich','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4262','8064','Zrich','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4263','8065','Zrich','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4264','8066','Zrich','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4265','8070','Zrich','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4266','8071','Zrich CS PZ','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4267','8074','Zrich Voice Publishing','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4268','8075','Zrich Benissimo spezial','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4269','8080','Zrich 80','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4270','8081','Zrich Helsana','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4271','8085','Zrich Versicherung','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4272','8086','Zrich Reader\'s Digest','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4273','8087','Zrich','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4274','8088','Zrich','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4275','8090','Zrich','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4276','8091','Zrich','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4277','8092','Zrich ETH-Zentrum','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4278','8093','Zrich ETH-Hnggerberg','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4279','8096','Zrich IBRS local','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4280','8098','Zrich','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4281','8099','Zrich Sonderdienste','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4282','8102','Oberengstringen','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4283','8103','Unterengstringen','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4284','8104','Weiningen ZH','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4285','8105','Watt','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4286','8105','Regensdorf','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4287','8105','Regensdorf 1','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4288','8106','Adlikon b. Regensdorf','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4289','8107','Buchs ZH','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4290','8108','Dllikon','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4291','8112','Otelfingen','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4292','8113','Boppelsen','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4293','8114','Dnikon ZH','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4294','8115','Httikon','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4295','8117','Fllanden','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4296','8118','Pfaffhausen','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4297','8121','Benglen','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4298','8122','Binz','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4299','8123','Ebmatingen','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4300','8124','Maur','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4301','8125','Zollikerberg','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4302','8126','Zumikon','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4303','8127','Forch','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4304','8130','Zumikon Yves Rocher SA','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4305','8132','Egg b. Zrich','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4306','8132','Hinteregg','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4307','8133','Esslingen','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4308','8134','Adliswil','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4309','8134','Adliswil 1','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4310','8134','Adliswil 2','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4311','8135','Langnau am Albis','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4312','8135','Sihlbrugg Station','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4313','8135','Sihlwald','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4314','8136','Gattikon','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4315','8142','Uitikon Waldegg','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4316','8143','Stallikon','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4317','8143','Uetliberg','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4318','8152','Glattbrugg','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4319','8152','Opfikon','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4320','8152','Glattpark (Opfikon)','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4321','8153','Rmlang','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4322','8154','Oberglatt ZH','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4323','8155','Niederhasli','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4324','8156','Oberhasli','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4325','8157','Dielsdorf','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4326','8158','Regensberg','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4327','8162','Steinmaur','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4328','8164','Bachs','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4329','8165','Schfflisdorf','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4330','8165','Oberweningen','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4331','8165','Schleinikon','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4332','8166','Niederweningen','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4333','8172','Niederglatt ZH','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4334','8173','Neerach','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4335','8174','Stadel b. Niederglatt','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4336','8175','Windlach','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4337','8180','Blach','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4338','8181','Hri','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4339','8182','Hochfelden','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4340','8184','Bachenblach','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4341','8185','Winkel','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4342','8186','Blach LZB','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4343','8187','Weiach','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4344','8192','Glattfelden','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4345','8192','Zweidlen','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4346','8193','Eglisau','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4347','8194','Hntwangen','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4348','8195','Wasterkingen','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4349','8196','Wil ZH','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4350','8197','Rafz','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4351','8212','Nohl','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4352','8245','Feuerthalen','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4353','8246','Langwiesen','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4354','8247','Flurlingen','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4355','8248','Uhwiesen','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4356','8301','Glattzentrum b. Wallisellen','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4357','8302','Kloten','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4358','8303','Bassersdorf','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4359','8304','Wallisellen','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4360','8305','Dietlikon','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4361','8306','Brttisellen','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4362','8307','Effretikon','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4363','8307','Ottikon b. Kemptthal','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4364','8308','Illnau','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4365','8308','Agasul','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4366','8309','Nrensdorf','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4367','8310','Kemptthal','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4368','8310','Grafstal','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4369','8311','Brtten','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4370','8312','Winterberg ZH','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4371','8314','Kyburg','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4372','8315','Lindau','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4373','8317','Tagelswangen','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4374','8320','Fehraltorf','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4375','8322','Madetswil','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4376','8330','Pfffikon ZH','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4377','8330','Hermatswil','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4378','8331','Auslikon','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4379','8332','Russikon','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4380','8335','Hittnau','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4381','8340','Hinwil','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4382','8342','Wernetshausen','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4383','8344','Bretswil','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4384','8345','Adetswil','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4385','8352','Elsau','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4386','8352','Ricketwil (Winterthur)','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4387','8353','Elgg','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4388','8354','Hofstetten ZH','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4389','8400','Winterthur','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4390','8401','Winterthur','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4391','8402','Winterthur','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4392','8404','Winterthur','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4393','8404','Reutlingen (Winterthur)','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4394','8404','Stadel (Winterthur)','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4395','8405','Winterthur','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4396','8406','Winterthur','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4397','8408','Winterthur','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4398','8409','Winterthur','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4399','8411','Winterthur','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4400','8412','Aesch (Neftenbach)','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4401','8412','Riet (Neftenbach)','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4402','8412','Hnikon (Neftenbach)','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4403','8413','Neftenbach','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4404','8414','Buch am Irchel','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4405','8415','Berg am Irchel','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4406','8415','Grslikon','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4407','8416','Flaach','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4408','8418','Schlatt b. Winterthur','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4409','8421','Dttlikon','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4410','8422','Pfungen','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4411','8423','Embrach-Embraport','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4412','8424','Embrach','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4413','8425','Oberembrach','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4414','8426','Lufingen','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4415','8427','Freienstein','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4416','8427','Rorbas','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4417','8427','Rorbas-Freienstein','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4418','8428','Teufen ZH','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4419','8442','Hettlingen','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4420','8444','Henggart','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4421','8447','Dachsen','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4422','8450','Andelfingen','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4423','8451','Kleinandelfingen','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4424','8452','Adlikon b. Andelfingen','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4425','8453','Alten','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4426','8457','Humlikon','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4427','8458','Dorf','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4428','8459','Volken','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4429','8460','Marthalen','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4430','8461','Oerlingen','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4431','8462','Rheinau','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4432','8463','Benken ZH','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4433','8464','Ellikon am Rhein','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4434','8465','Rudolfingen','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4435','8465','Wildensbuch','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4436','8466','Trllikon','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4437','8467','Truttikon','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4438','8468','Guntalingen','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4439','8468','Waltalingen','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4440','8471','Rutschwil (Dgerlen)','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4441','8471','Dgerlen','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4442','8471','Oberwil (Dgerlen)','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4443','8471','Berg (Dgerlen)','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4444','8471','Bnk (Dgerlen)','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4445','8472','Seuzach','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4446','8474','Dinhard','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4447','8475','Ossingen','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4448','8476','Unterstammheim','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4449','8477','Oberstammheim','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4450','8478','Thalheim an der Thur','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4451','8479','Altikon','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4452','8482','Sennhof (Winterthur)','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4453','8483','Kollbrunn','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4454','8484','Weisslingen','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4455','8484','Neschwil','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4456','8484','Theilingen','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4457','8486','Rikon im Tsstal','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4458','8487','Rmismhle','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4459','8487','Zell ZH','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4460','8488','Turbenthal','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4461','8489','Wildberg','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4462','8492','Wila','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4463','8493','Saland','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4464','8494','Bauma','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4465','8495','Schmidrti','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4466','8496','Steg im Tsstal','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4467','8497','Fischenthal','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4468','8498','Gibswil-Ried','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4469','8499','Sternenberg','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4470','8523','Hagenbuch ZH','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4471','8542','Wiesendangen','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4472','8543','Bertschikon','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4473','8543','Gundetswil','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4474','8543','Kefikon ZH','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4475','8544','Attikon','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4476','8545','Rickenbach Sulz','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4477','8545','Rickenbach ZH','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4478','8546','Menzengrt','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4479','8548','Ellikon an der Thur','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4480','8600','Dbendorf','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4481','8600','Dbendorf 1','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4482','8600','Dbendorf 2','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4483','8602','Wangen b. Dbendorf','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4484','8603','Schwerzenbach','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4485','8604','Volketswil','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4486','8605','Gutenswil','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4487','8606','Nnikon','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4488','8606','Greifensee','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4489','8607','Aathal-Seegrben','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4490','8608','Bubikon','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4491','8609','Schwerzenbach','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4492','8610','Uster','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4493','8610','Uster 1','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4494','8612','Uster 2','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4495','8613','Uster 3','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4496','8614','Bertschikon (Gossau ZH)','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4497','8614','Sulzbach','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4498','8615','Wermatswil','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4499','8615','Freudwil','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4500','8616','Riedikon','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4501','8617','Mnchaltorf','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4502','8618','Oetwil am See','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4503','8620','Wetzikon ZH','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4504','8620','Wetzikon ZH 1','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4505','8621','Wetzikon ZH 4','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4506','8622','Wetzikon ZH','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4507','8623','Wetzikon ZH','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4508','8624','Grt (Gossau ZH)','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4509','8625','Gossau ZH','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4510','8626','Ottikon (Gossau ZH)','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4511','8627','Grningen','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4512','8630','Rti ZH','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4513','8632','Tann','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4514','8633','Wolfhausen','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4515','8634','Hombrechtikon','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4516','8635','Drnten','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4517','8636','Wald ZH','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4518','8637','Laupen ZH','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4519','8639','Faltigberg','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4520','8700','Ksnacht ZH','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4521','8702','Zollikon','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4522','8702','Zollikon Dorf','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4523','8703','Erlenbach ZH','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4524','8704','Herrliberg','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4525','8706','Meilen','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4526','8706','Feldmeilen','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4527','8707','Uetikon am See','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4528','8708','Mnnedorf','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4529','8712','Stfa','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4530','8713','Uerikon','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4531','8714','Feldbach','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4532','8800','Thalwil','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4533','8801','Thalwil Fcher','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4534','8802','Kilchberg ZH','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4535','8803','Rschlikon','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4536','8804','Au ZH','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4537','8805','Richterswil','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4538','8810','Horgen','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4539','8810','Horgen 1','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4540','8812','Horgen','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4541','8813','Horgen','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4542','8815','Horgenberg','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4543','8816','Hirzel','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4544','8820','Wdenswil','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4545','8824','Schnenberg ZH','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4546','8825','Htten','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4547','8833','Samstagern','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4548','8901','Urdorf RRD','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4549','8902','Urdorf','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4550','8903','Birmensdorf ZH','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4551','8904','Aesch ZH','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4552','8906','Bonstetten','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4553','8907','Wettswil','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4554','8908','Hedingen','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4555','8909','Zwillikon','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4556','8910','Affoltern am Albis','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4557','8911','Rifferswil','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4558','8912','Obfelden','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4559','8913','Ottenbach','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4560','8914','Aeugst am Albis','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4561','8914','Aeugstertal','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4562','8915','Hausen am Albis','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4563','8925','Ebertswil','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4564','8926','Kappel am Albis','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4565','8926','Hauptikon','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4566','8926','Uerzlikon','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4567','8932','Mettmenstetten','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4568','8933','Maschwanden','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4569','8934','Knonau','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4570','8942','Oberrieden','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4571','8951','Fahrweid','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4572','8952','Schlieren','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4573','8953','Dietikon','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4574','8953','Dietikon 1','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4575','8953','Dietikon 2','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4576','8954','Geroldswil','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4577','8955','Oetwil an der Limmat','Zrich','ZH','194','N');
INSERT INTO PLZ VALUES ('4578','0','Dummy Ortschaft','Dummy','Dmy','194','N');
INSERT INTO PLZ VALUES ('4579','9342','Gurk (AT)','Krnten',NULL,'170','N');



#
# TABLE 'RECHNUNG_EINZELBUCHUNG'
#
drop table if exists `RECHNUNG_EINZELBUCHUNG`;

create table `RECHNUNG_EINZELBUCHUNG` (
  `ID` int(10) Not Null auto_increment,
  `BELEGNR` int(10),
  `ANZAHL` varchar(6),
  `ARTIKEL_ID` int(7),
  `ARTNR` varchar(10),
  `BEZEICHNUNG` varchar(60),
  `BRUTTO` varchar(10),
  `RABATT` varchar(10),
  `VERKAUFSPREIS` varchar(10),
  `MWST_SATZ` varchar(6),
  `GELOESCHT` enum('J','N') Default 'N' Not Null,
  `GELOESCHT_VON` varchar(5),
  `ART_ABGEBUCHT_DATUM` date,
  PRIMARY KEY (ID),
  UNIQUE KEY ID (ID)
);


#
# TABLE 'RECHNUNG_EINZELBUCHUNG' DATA
#
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('1','40001','1','0','','Malschablone','9.90','10.00','8.90','7.60','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('2','40001','3','0','','Ballon zum Modellieren','0.60','10.00','1.60','7.60','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('3','40001','1','0','','Fischkleister','7.90','10.00','7.10','7.60','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('4','40001','2','0','','Nylon Faden','3.50','10.00','6.30','7.60','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('5','40001','2','0','','Quetschperlen','4.50','10.00','8.10','7.60','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('6','40001','1','0','','Sprhkleber','12.90','10.00','11.60','7.60','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('7','40001','1','0','','Texti Farbe','6.80','10.00','6.10','7.60','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('8','40001','1','0','','Strukturschneei','11.50','10.00','10.35','7.60','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('9','40001','1','0','','Malschablone','16.90','10.00','15.20','7.60','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('10','40001','1','0','','Trendy Filz 3mm','11.90','10.00','10.70','7.60','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('11','40002','1','0','','test','2.00','0','2.00','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('12','40003','1','0','','test','2.00','0','2.00','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('13','40003','1','0','','test','2.00','0','2.00','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('14','40004','1','0','900 305','Giessmasse schiefer 5 kg.','43.90','0','43.90','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('15','40004','1','0','100 005','Giessmasse weiss 5 kg.','36.50','0.00','36.50','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('16','40004','1','0','8742 48','Giessform 3-D Budda','26.90','0.00','26.90','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('17','40004','1','0','CP 556','Giessform Asia Kerzenhalter','12.90','0.00','12.90','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('18','40004','1','0','CP 554','Giessform Asia Bilderrahmen','12.90','0.00','12.90','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('19','40004','1','0','CP 553','Giessform Asia Bilderrahmen','12.90','0.00','12.90','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('20','40005','1','0','900 305','Giessmasse schiefer 5 kg.','43.90','0','43.90','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('21','40005','1','0','100 005','Giessmasse weiss 5 kg.','36.50','0.00','36.50','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('22','40005','1','0','8742 48','Giessform 3-D Budda','26.90','0.00','26.90','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('23','40005','1','0','CP 556','Giessform Asia Kerzenhalter','12.90','0.00','12.90','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('24','40005','1','0','CP 554','Giessform Asia Bilderrahmen','12.90','0.00','12.90','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('25','40005','1','0','CP 553','Giessform Asia Bilderrahmen','12.90','0.00','12.90','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('26','40006','1','0','900 305','Giessmasse schiefer 5 kg.','43.90','0','43.90','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('27','40006','1','0','100 005','Giessmasse weiss 5 kg.','36.50','0.00','36.50','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('28','40006','1','0','8742 48','Giessform 3-D Budda','26.90','0.00','26.90','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('29','40006','1','0','CP 556','Giessform Asia Kerzenhalter','12.90','0.00','12.90','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('30','40006','1','0','CP 554','Giessform Asia Bilderrahmen','12.90','0.00','12.90','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('31','40006','1','0','CP 553','Giessform Asia Bilderrahmen','12.90','0.00','12.90','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('32','40007','1','0','900 305','Giessmasse schiefer 5 kg.','43.90','0','43.90','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('33','40007','1','0','100 005','Giessmasse weiss 5 kg.','36.50','0.00','36.50','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('34','40007','1','0','8742 48','Giessform 3-D Budda','26.90','0.00','26.90','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('35','40007','1','0','CP 556','Giessform Asia Kerzenhalter','12.90','0.00','12.90','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('36','40007','1','0','CP 554','Giessform Asia Bilderrahmen','12.90','0.00','12.90','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('37','40007','1','0','CP 553','Giessform Asia Bilderrahmen','12.90','0.00','12.90','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('38','40008','1','0','900 305','Giessmasse schiefer 5 kg.','43.90','0','43.90','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('39','40008','1','0','100 005','Giessmasse weiss 5 kg.','36.50','0.00','36.50','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('40','40008','1','0','8742 48','Giessform 3-D Budda','26.90','0.00','26.90','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('41','40008','1','0','CP 556','Giessform Asia Kerzenhalter','12.90','0.00','12.90','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('42','40008','1','0','CP 554','Giessform Asia Bilderrahmen','12.90','0.00','12.90','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('43','40008','1','0','CP 553','Giessform Asia Bilderrahmen','12.90','0.00','12.90','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('44','40009','1','0','123','Testartikel','12.00','0','12.00','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('45','40010','2','0','','Holzperlen Beutel','3.60','10.00','6.50','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('46','40010','1','0','','Schm. Faden','2.70','10.00','2.45','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('47','40010','2','0','','Polaris Perlen Beutel','6.00','10.00','10.80','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('48','40010','8','0','','Schm. Ringli','0.10','10.00','0.70','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('49','40010','8','0','','Karabiner','0.90','10.00','6.50','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('50','40010','3','0','','Textil Pen','3.80','10.00','10.25','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('51','40010','2','0','-','Textil Plus Farbe','3.40','10.00','6.80','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('52','40010','1','0','','Ton Topf','1.60','10.00','1.45','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('53','40010','1','0','-','1 Meter Drahtgitter','6.90','10.00','6.20','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('54','40010','10','0','','Wackelaugen','0.45','10.00','4.05','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('55','40010','26','0','','Wackelaugen','0.40','10.00','9.35','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('56','40010','20','0','','Wackelaugen','0.35','10.00','6.30','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('57','40010','2','0','','Federn Marabu','2.90','10.00','5.20','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('58','40010','3','0','','Federn Marabu','2.90','10.00','7.85','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('59','40010','3','0','','Bast Farbig','3.20','10.00','8.65','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('60','40010','2','0','-','2 Meter Drahtgitter','6.90','10.00','12.40','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('61','40010','3','0','','Federn Marabu','2.90','10.00','7.85','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('62','40010','1','0','','Textil Pen','3.90','10.00','3.50','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('63','40011','3','0','','Aufsatz Giesskanne','9.90','10','26.75','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('64','40011','1','0','','Bastelbuch','12.95','10.00','11.65','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('65','40011','8','0','','Deko Blume Sisal','2.50','10.00','18.00','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('66','40012','2','0','','Deco-Painter rot','4.90','0.00','9.80','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('67','40012','2','0','','UHU Kraftkleber','5.90','0.00','11.80','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('68','40012','21','0','','Moosgummi ass. Farben','1.90','0.00','39.90','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('69','40013','210','0','','Perlen assortiert','0.20','10.00','37.80','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('70','40013','1','0','','Nylon Draht','12.80','10.00','11.50','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('71','40013','1','0','','Quetsch Perlen','4.50','10.00','4.05','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('72','40013','1','0','','Verschluss Schmuck','2.20','10.00','2.00','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('73','40013','1','0','','Klebepistole','19.90','10.00','17.90','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('74','40013','1','0','','Klebe Stick','6.90','10.00','6.20','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('75','40014','5','0','','Acryl Farben 250 ml.','15.90','10.00','71.55','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('76','40014','3','0','','Acryl Farben 50 ml. ','5.80','10.00','15.65','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('77','40014','2','0','','Acryl Farben 50 ml. ','7.80','10.00','14.05','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('78','40014','1','0','','Fisch Kleister','8.80','10.00','7.90','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('79','40014','1','0','','Modellier Gewebe','6.90','10.00','6.20','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('80','40014','1','0','','Papiermach','4.90','10.00','4.40','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('81','40014','10','0','','Masken aus Papiermischung','9.80','10.00','88.20','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('82','40014','1','0','','Maske aus Kunststoff','7.50','10.00','6.75','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('83','40014','1','0','','Pinselset','7.20','10.00','6.50','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('84','40014','3','0','','Papiermach','4.90','10.00','13.25','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('85','40015','12','0','','Ferienpassmitglieder','12.00','0','144.00','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('86','40016','1','0','-','Drahtgeflecht 2,2 meter  6.90/meter','15.20','10.00','13.70','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('87','40016','26','0','-','Fimo assortiert','3.70','10.00','86.60','0.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('88','40016','2','0','','Perlen','3.90','10.00','7.00','0.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('89','40016','3','0','','Textil Painter','3.80','10.00','10.25','0.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('90','40016','3','0','-','Plakat sen','3.30','10.00','8.65','0.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('91','40016','2','0','','Nylonfaden','2.60','10.00','4.70','0.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('92','40017','3','0','','Modelliergewebe','13.80','10','37.25','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('93','40017','2','0','','Juteband per Meter','1.60','10.00','2.90','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('94','40017','2','0','','Dekoband per meter','1.40','10.00','2.50','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('95','40017','2','0','','Bast','3.20','10.00','5.75','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('96','40017','4','0','','Styropor Pilz','2.40','10.00','8.65','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('97','40017','1','0','','Deko Stern AKTION','7.45','0.00','7.45','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('98','40018','3','0','','Vlies Eissterne Hellblau per Meter','5.90','0.00','17.70','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('99','40019','2','0','','Engelsflgel','5.70','10','10.25','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('100','40019','1','0','','Moosgummi','1.90','10.00','1.70','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('101','40019','7','0','','Figuren Bast Draht','1.70','10.00','10.70','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('102','40019','16','0','','Styropor Kegel 20 cm.','2.30','10.00','33.10','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('103','40019','16','0','','Styropor Kugel 6 cm.','0.70','10.00','10.10','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('104','40019','2','0','','Kerra Flott Giessmasse 5 kg.','36.50','10.00','65.70','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('105','40019','3','0','','Kerra Flott Giessmasse 1kg.','8.60','10.00','23.20','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('106','40019','11','0','','Engelsflgel','6.90','10.00','68.30','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('107','40019','1','0','','Styropor Kegel','3.80','10.00','3.40','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('108','40019','1','0','','Styropor Kugel','1.05','10.00','0.95','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('109','40020','3','0','','Deko Perlen','4.50','10.00','12.15','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('110','40020','4','0','','Deko Perlen','3.90','10.00','14.05','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('111','40020','6','0','','Deko Perlen','5.90','10.00','31.85','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('112','40020','4','0','','Glitter silber','3.30','10.00','11.90','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('113','40020','2','0','','Glitter silber','3.20','10.00','5.75','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('114','40020','1','0','','Gliter blau','3.20','10.00','2.90','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('115','40021','1','0','','Bilderrahmen','6.90','0','6.90','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('116','40022','5','0','','Mosaik Color Pen assortiert','6.90','10','31.05','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('117','40023','1','0','','Deko Federn','2.60','10','2.35','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('118','40023','1','0','','Holz Leiter','2.90','10.00','2.60','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('119','40023','1','0','','Spiegelbox','9.90','10.00','8.90','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('120','40023','1','0','','Glimmer','3.30','10.00','2.95','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('121','40023','1','0','','Glimmer','3.20','10.00','2.90','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('122','40023','1','0','','Flip Flop`s','3.50','10.00','3.15','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('123','40023','6','0','','Perlen Luna','1.10','10.00','5.95','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('124','40023','1','0','','Faltpapier Sort.','7.90','10.00','7.10','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('125','40023','1','0','','Deko Federn','2.60','10.00','2.35','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('126','40023','1','0','','Spiegel Box','3.80','10.00','3.40','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('127','40023','4','0','','Plastk Eier','0.60','10.00','2.15','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('128','40023','1','0','','Ohrhaken','2.00','10.00','1.80','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('129','40023','1','0','','Karabiner','2.20','10.00','2.00','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('130','40023','1','0','','Deko Blten','7.90','10.00','7.10','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('131','40023','1','0','','Bindedraht','2.50','10.00','2.25','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('132','40023','3','0','','Fun Liner Glitter','5.60','10.00','15.10','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('133','40023','2','0','','Deko Sticker','6.50','10.00','11.70','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('134','40023','3','0','','Marmorierfarbe','3.60','10.00','9.70','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('135','40023','1','0','','Natur Bast','3.60','10.00','3.25','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('136','40023','1','0','','Schaschlick Spiesse','3.90','10.00','3.50','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('137','40023','4','0','','Deko Blten','0.30','10.00','1.10','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('138','40024','1','0','','ko - Seifenblock 250 gr.','7.60','10','6.85','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('139','40024','2','0','','ko - Seifenblock 500 gr.','13.90','10.00','25.00','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('140','40024','2','0','','ko - Seifenblock 1500 gr.','39.90','10.00','71.80','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('141','40024','1','0','','Giessform','9.90','10.00','8.90','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('142','40024','2','0','','Frippe Sckchen  6 Stk.','7.90','10.00','14.20','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('143','40024','5','0','','3 - D Liner','5.60','10.00','25.20','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('144','40024','3','0','','Sticker','6.50','10.00','17.55','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('145','40025','1','0','','Crea - Pop Folie','6.90','10','6.20','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('146','40025','1','0','','Perlen ass.','9.90','10.00','8.90','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('147','40025','1','0','','Vlies  1/2 M','1.70','10.00','1.55','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('148','40026','2','0','','Giesspulver Crea-flott','8.60','10.00','15.50','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('149','40026','1','0','','Giessform','24.50','10.00','22.05','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('150','40026','1','0','','Schwemmholz 1 Kg.','36.00','10.00','32.40','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('151','40026','1','0','','Alu Draht 20 M','19.90','10.00','17.90','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('152','40026','60','0','','Acrybello Teile AKTION','0.50','0.00','30.00','8.00','N','',NULL);
INSERT INTO RECHNUNG_EINZELBUCHUNG VALUES ('153','40027','2','0','','Alu Draht  20 Meter','19.90','10','35.80','8.00','N','',NULL);



#
# TABLE 'RECHNUNG_PROTOKOLL'
#
drop table if exists `RECHNUNG_PROTOKOLL`;

create table `RECHNUNG_PROTOKOLL` (
  `ID` int(10) Not Null auto_increment,
  `BELEGNR` varchar(10),
  `BELEGNR_AUFTRAG` varchar(10),
  `BELEGNR_LS` varchar(10),
  `DEBITORNR_AG` int(11),
  `DEBITORNR_WE` int(10),
  `DEBITORNR_RE` int(10),
  `KONTAKTPERSON` varchar(20),
  `KOMMISSION` varchar(40),
  `DATUM` date,
  `DATUM_LIEFERUNG` date,
  `DATUM_VALUTA` date,
  `DATUM_SKONTO` date,
  `SKONTO_PROZENT` varchar(6),
  `BEGLICHEN` enum('N','J'),
  `DATUM_BEGLICHEN` date,
  `DATUM_MAHNSTUFE1` date,
  `DATUM_MAHNSTUFE2` date,
  `DATUM_MAHNSTUFE3` date,
  `DATUM_MAHNSTUFE4` date,
  `INKASSO` enum('J','N'),
  `BRUTTO` varchar(10),
  `RABATT` varchar(10),
  `VERKAUFSPREIS` varchar(10),
  `PORTO` varchar(10),
  `BRUTTOKREDIT` varchar(10),
  `BK_BASIS_MWST1` varchar(10),
  `BK_BASIS_MWST2` varchar(10),
  `BK_MWST1` varchar(10),
  `BK_MWST2` varchar(10),
  `SKONTO` varchar(10),
  `NETTOKREDIT` varchar(10),
  `NK_BASIS_MWST1` varchar(10),
  `NK_BASIS_MWST2` varchar(10),
  `NK_MWST1` varchar(10),
  `NK_MWST2` varchar(10),
  `MAHNBETRAG1` varchar(10),
  `MAHNBETRAG2` varchar(10),
  `MAHNBETRAG3` varchar(10),
  `MAHNBETRAG4` varchar(10),
  `BETRAG_AUSSTEHEND` varchar(10),
  `BEMERKUNGEN` blob,
  `BUCHUNG_BUCHHALTUNG` enum('N','J'),
  `ABGESCHLOSSEN` enum('N','J'),
  `GELOESCHT` enum('N','J'),
  `GELOESCHT_DATUM` date,
  `GELOESCHT_VON` varchar(5),
  `GELOESCHT_GRUND` blob,
  `MWST1_SATZ` varchar(10),
  `MWST2_SATZ` varchar(10),
  PRIMARY KEY (ID),
  UNIQUE KEY Rechnung_ID (ID)
);


#
# TABLE 'RECHNUNG_PROTOKOLL' DATA
#
INSERT INTO RECHNUNG_PROTOKOLL VALUES ('1','40001','1001','','907','907','907','Frau Schr','Frau Schr','2010-11-25',NULL,'2010-12-25','2010-12-05','2.00','J','2010-12-28',NULL,NULL,NULL,NULL,'N','95.60','9.65','85.95','0.00','85.95','0.00','85.95','0.00','6.07','0.00','85.95','','','','','','','','','','Sammelrechnung','N','N','N',NULL,'','',NULL,NULL);
INSERT INTO RECHNUNG_PROTOKOLL VALUES ('2','40002','1012','','151','151','151','','','2011-03-26',NULL,'2011-04-25','2011-04-05','2.00',NULL,NULL,'2012-01-10',NULL,NULL,NULL,'N','2.00','0.00','2.00','10.00','12.00','0.00','12.00','0.00','0.89','','','','','','','','','','','','','N','N','N',NULL,'','',NULL,NULL);
INSERT INTO RECHNUNG_PROTOKOLL VALUES ('3','40003','1013','','151','151','151','','','2011-03-26',NULL,'2011-04-25','2011-04-05','2.00',NULL,NULL,'2012-01-10',NULL,NULL,NULL,'N','4.00','0.00','4.00','0.00','4.00','0.00','4.00','0.00','0.30','','','','','','','','','','','','','N','N','N',NULL,'','',NULL,NULL);
INSERT INTO RECHNUNG_PROTOKOLL VALUES ('4','40004','1005','','369','369','369','','','2011-03-26',NULL,'2011-04-25','2011-04-05','0.00',NULL,NULL,NULL,NULL,NULL,NULL,'N','146.00','0.00','146.00','10.00','156.00','0.00','156.00','0.00','11.56','','','','','','','','','','','','','N','N','J','2011-03-26','1','',NULL,NULL);
INSERT INTO RECHNUNG_PROTOKOLL VALUES ('5','40005','1006','','369','369','369','','','2011-03-26',NULL,'2011-04-25','2011-04-05','0.00',NULL,NULL,NULL,NULL,NULL,NULL,'N','146.00','0.00','146.00','10.00','156.00','0.00','156.00','0.00','11.56','','','','','','','','','','','','','N','N','J','2011-03-26','1','',NULL,NULL);
INSERT INTO RECHNUNG_PROTOKOLL VALUES ('6','40006','1007','','369','369','369','','','2011-03-26',NULL,'2011-04-25','2011-04-05','0.00',NULL,NULL,NULL,NULL,NULL,NULL,'N','146.00','0.00','146.00','10.00','156.00','0.00','156.00','0.00','11.56','','','','','','','','','','','','','N','N','J','2011-03-26','1','',NULL,NULL);
INSERT INTO RECHNUNG_PROTOKOLL VALUES ('7','40007','1008','','369','369','369','','','2011-03-26',NULL,'2011-04-25','2011-04-05','0.00',NULL,NULL,NULL,NULL,NULL,NULL,'N','146.00','0.00','146.00','18.00','164.00','0.00','164.00','0.00','12.15','','','','','','','','','','','','','N','N','J','2011-03-26','1','',NULL,NULL);
INSERT INTO RECHNUNG_PROTOKOLL VALUES ('8','40008','1009','','369','369','369','','','2011-03-26',NULL,'2011-04-25','2011-04-05','0.00',NULL,NULL,NULL,NULL,NULL,NULL,'N','146.00','0.00','146.00','10.00','156.00','0.00','156.00','0.00','11.56','','','','','','','','','','','','','N','N','J','2011-03-26','1','',NULL,NULL);
INSERT INTO RECHNUNG_PROTOKOLL VALUES ('9','40009','1014','30009','369','369','369','Test','','2011-03-26','2011-03-26','2011-04-25','2011-04-05','2.00',NULL,NULL,NULL,NULL,NULL,NULL,'N','12.00','0.00','12.00','10.00','22.00','0.00','22.00','0.00','1.63','','','','','','','','','','','','','N','N','J','2011-03-26','1','',NULL,NULL);
INSERT INTO RECHNUNG_PROTOKOLL VALUES ('10','40010','1015','','579','579','579','','Frau Flury','2011-04-21',NULL,'2011-05-21','2011-05-01','2.00','J','2011-06-04',NULL,NULL,NULL,NULL,'N','129.00','12.20','116.80','0.00','116.80','0.00','116.80','0.00','8.65','0.00','116.80','','','','','','','','','','Ware abgeholt am:  13.1., 25.2, 02.3., 12.3.','N','N','N',NULL,'','',NULL,NULL);
INSERT INTO RECHNUNG_PROTOKOLL VALUES ('11','40011','1016','','912','912','912','z.H. Frau Lomitana','','2011-05-05',NULL,'2011-06-04','2011-05-15','2.00','J','2011-06-04',NULL,NULL,NULL,NULL,'N','62.65','6.25','56.40','0.00','56.40','0.00','56.40','0.00','4.18','0.00','56.40','','','','','','','','','','Ware abgeholt am: 18.02.2011','N','N','N',NULL,'','',NULL,NULL);
INSERT INTO RECHNUNG_PROTOKOLL VALUES ('12','40012','1017','','913','913','913','Frau Hgi Erika','','2011-05-06',NULL,'2011-06-05','2011-05-16','2.00','J','2011-06-17',NULL,NULL,NULL,NULL,'N','61.50','0.00','61.50','10.00','71.50','0.00','71.50','0.00','5.30','0.00','71.50','','','','','','','','','','gem Lieferung vom 20.4.2011\r\nWare mit Rckgaberecht','N','N','N',NULL,'','',NULL,NULL);
INSERT INTO RECHNUNG_PROTOKOLL VALUES ('13','40013','1018','','579','579','579','','z.H. Frau Flury ','2011-08-17',NULL,'2011-09-16','2011-08-27','2.00','J','2011-10-06',NULL,NULL,NULL,NULL,'N','88.30','8.85','79.45','0.00','79.45','0.00','79.45','0.00','5.89','0.00','79.45','','','','','','','','','','Ware abgeholt am: 10.06.2011','N','N','N',NULL,'','','2.50','8.00');
INSERT INTO RECHNUNG_PROTOKOLL VALUES ('14','40014','1019','','914','914','914','','z.H. Frau Jrg- Flury Sandra','2011-08-17',NULL,'2011-09-16','2011-08-27','2.00','J','2011-10-06',NULL,NULL,NULL,NULL,'N','260.50','26.05','234.45','0.00','234.45','0.00','234.45','0.00','17.37','0.00','234.45','','','','','','','','','','Ware abgeholt am: 11.06.2011 + 21.06.2011','N','N','N',NULL,'','','2.50','8.00');
INSERT INTO RECHNUNG_PROTOKOLL VALUES ('15','40015','1020','','916','916','916','Frau Charlotte Borer','','2011-10-19',NULL,'2011-11-18','2011-10-29','2.00','J','2011-12-01',NULL,NULL,NULL,NULL,'N','144.00','0.00','144.00','10','154.00','0.00','154.00','0.00','11.41','0.00','154.00','','','','','','','','','','Ferienpass \"Bilder und Figuren giessen\"','N','N','N',NULL,'','','2.50','8.00');
INSERT INTO RECHNUNG_PROTOKOLL VALUES ('16','40016','1021','','917','917','917','z.H. Frau Pamuk','','2011-11-03',NULL,'2011-12-03','2011-11-13','2.00','J','2011-12-08',NULL,NULL,NULL,NULL,'N','145.70','14.80','130.90','0.00','130.90','0.00','13.70','0.00','1.01','0.00','130.90','','','','','','','','','','Ware abgeholt am: 24.08.2011 und 13.09.2011','N','N','N',NULL,'','','2.50','8.00');
INSERT INTO RECHNUNG_PROTOKOLL VALUES ('17','40017','1022','','918','918','918','z.H. Frau Kohler B.','Ware abgeholt am: 30.08.2011','2011-11-03',NULL,'2011-12-03','2011-11-13','2.00','J','2011-12-08',NULL,NULL,NULL,NULL,'N','70.85','6.35','64.50','0.00','64.50','0.00','64.50','0.00','4.78','0.00','64.50','','','','','','','','','','','N','N','N',NULL,'','','2.50','8.00');
INSERT INTO RECHNUNG_PROTOKOLL VALUES ('18','40018','1023','','356','356','356','','','2011-11-30',NULL,'2011-12-30','2011-12-10','0.00','J','2011-12-08',NULL,NULL,NULL,NULL,'N','17.70','0.00','17.70','3.60','21.30','0.00','21.30','0.00','1.58','0.00','21.30','','','','','','','','','','Telefonische Bestellung vom 30.November 2011','N','N','N',NULL,'','','2.50','8.00');
INSERT INTO RECHNUNG_PROTOKOLL VALUES ('19','40019','1029','','919','919','919','z.H. Frau Zeltner','','2011-12-01',NULL,'2011-12-31','2011-12-11','2.00','J','2012-01-13','2012-01-10',NULL,NULL,NULL,'N','252.75','25.35','227.40','0.00','227.40','0.00','227.40','0.00','16.84','0.00','227.40','','','','','','','','','','Ware abgeholt am: 1.Okt, 23.Nov. / Retouren am: 30.11. (Ware mit Rckgaberecht)','N','N','N',NULL,'','','2.50','8.00');
INSERT INTO RECHNUNG_PROTOKOLL VALUES ('20','40020','1030','','502','502','502','Frau Rickli','','2011-12-02',NULL,'2012-01-01','2011-12-12','2.00','J','2011-12-29',NULL,NULL,NULL,NULL,'N','87.30','8.70','78.60','0.00','78.60','0.00','78.60','0.00','5.82','0.00','78.60','','','','','','','','','','Lieferschein vom 1. Dezember 2011','N','N','N',NULL,'','','2.50','8.00');
INSERT INTO RECHNUNG_PROTOKOLL VALUES ('21','40021','1031','','920','920','920','Frau Jggi','','2011-12-03',NULL,'2012-01-02','2011-12-13','2.00','J','2012-01-10',NULL,NULL,NULL,NULL,'N','6.90','0.00','6.90','6.00','12.90','0.00','12.90','0.00','0.96','0.00','12.90','','','','','','','','','','Nachlieferung','N','N','N',NULL,'','','2.50','8.00');
INSERT INTO RECHNUNG_PROTOKOLL VALUES ('22','40022','1032','','921','921','921','z.H. Frau Emch M.','','2011-12-14',NULL,'2012-01-13','2011-12-24','2.00','J','2012-01-13',NULL,NULL,NULL,NULL,'N','34.50','3.45','31.05','0.00','31.05','0.00','31.05','0.00','2.30','0.00','31.05','','','','','','','','','','Ware abgeholt am: 14.12.2011','N','N','N',NULL,'','','2.50','8.00');
INSERT INTO RECHNUNG_PROTOKOLL VALUES ('23','40023','1033','','921','921','921','Frau Emch','','2012-03-24',NULL,'2012-04-23','2012-04-03','2.00','J','2012-05-04',NULL,NULL,NULL,NULL,'N','112.60','11.30','101.30','0.00','101.30','0.00','101.30','0.00','7.50','0.00','101.30','','','','','','','','','','Lieferschein vom 23.02.2012 Ware abgeholt von Frau Emch\r\nLieferschein vom 17.03.2012 Ware abgeholt von Frau Emch','N','N','N',NULL,'','','2.50','8.00');
INSERT INTO RECHNUNG_PROTOKOLL VALUES ('24','40024','1034','','921','921','921','Frau Emch Michaela','','2012-05-15',NULL,'2012-06-14','2012-05-25','2.00',NULL,NULL,NULL,NULL,NULL,NULL,'N','188.40','18.90','169.50','0.00','169.50','0.00','169.50','0.00','12.56','','','','','','','','','','','','Lieferschein vom 09.05.2012','N','N','N',NULL,'','','2.50','8.00');
INSERT INTO RECHNUNG_PROTOKOLL VALUES ('25','40025','1035','','918','918','918','Frau Kohler','','2012-05-15',NULL,'2012-06-14','2012-05-25','2.00','J','2012-06-13',NULL,NULL,NULL,NULL,'N','18.50','1.85','16.65','0.00','16.65','0.00','16.65','0.00','1.23','0.00','16.65','','','','','','','','','','Lieferschein vom 15.04.2012','N','N','N',NULL,'','','2.50','8.00');
INSERT INTO RECHNUNG_PROTOKOLL VALUES ('26','40026','1036','','579','579','579','Frau B. Flury','','2012-05-15',NULL,'2012-06-14','2012-05-25','2.00','J','2012-06-08',NULL,NULL,NULL,NULL,'N','127.60','9.75','117.85','0.00','117.85','0.00','117.85','0.00','8.73','0.00','117.85','','','','','','','','','','Lieferschein vom 20.04.2012','N','N','N',NULL,'','','2.50','8.00');
INSERT INTO RECHNUNG_PROTOKOLL VALUES ('27','40027','1037','','922','922','922','Freudiger Lukas','','2012-05-15',NULL,'2012-06-14','2012-05-25','2.00',NULL,NULL,NULL,NULL,NULL,NULL,'N','39.80','4.00','35.80','0.00','35.80','0.00','35.80','0.00','2.65','','','','','','','','','','','','Lieferschein vom 20.04.2012\r\n                    vom 21.04.2012','N','N','N',NULL,'','','2.50','8.00');



#
# TABLE 'RECHNUNG_ZAHLUNGEN'
#
drop table if exists `RECHNUNG_ZAHLUNGEN`;

create table `RECHNUNG_ZAHLUNGEN` (
  `ID` int(10) Not Null auto_increment,
  `BELEGNR_RG` int(10),
  `DATUM` date,
  `BETRAG` varchar(10),
  `ZAHLUNGSART` varchar(20),
  `GUTSCHRIFT` varchar(11),
  `GUTSCHEIN` varchar(20),
  `GELOESCHT` enum('N','J') Default 'N',
  PRIMARY KEY (ID),
  UNIQUE KEY ID (ID)
);


#
# TABLE 'RECHNUNG_ZAHLUNGEN' DATA
#
INSERT INTO RECHNUNG_ZAHLUNGEN VALUES ('1','40001','2010-12-28','85.95','Raiffeisenbank','','','N');
INSERT INTO RECHNUNG_ZAHLUNGEN VALUES ('2','40010','2011-05-18','116.80','Raiffeisenbank','','','N');
INSERT INTO RECHNUNG_ZAHLUNGEN VALUES ('3','40011','2001-06-01','56.40','Post','','','N');
INSERT INTO RECHNUNG_ZAHLUNGEN VALUES ('4','40012','2011-06-16','71.50','Post','','','N');
INSERT INTO RECHNUNG_ZAHLUNGEN VALUES ('5','40013','2011-09-01','79.45','Raiffeisenbank','','','N');
INSERT INTO RECHNUNG_ZAHLUNGEN VALUES ('6','40014','2011-08-29','234.45','Raiffeisenbank','','','N');
INSERT INTO RECHNUNG_ZAHLUNGEN VALUES ('7','40015','2011-11-16','154.00','Raiffeisenbank','','','N');
INSERT INTO RECHNUNG_ZAHLUNGEN VALUES ('8','40017','2011-11-25','64.50','Raiffeisenbank','','','N');
INSERT INTO RECHNUNG_ZAHLUNGEN VALUES ('9','40016','2011-11-30','130.90','Raiffeisenbank','','','N');
INSERT INTO RECHNUNG_ZAHLUNGEN VALUES ('10','40018','2011-12-06','21.30','Post','','','N');
INSERT INTO RECHNUNG_ZAHLUNGEN VALUES ('11','40020','2011-12-22','78.60','Raiffeisenbank','','','N');
INSERT INTO RECHNUNG_ZAHLUNGEN VALUES ('12','40021','2011-12-30','12.90','Post','','','N');
INSERT INTO RECHNUNG_ZAHLUNGEN VALUES ('13','40022','2012-01-12','31.05','Post','','','N');
INSERT INTO RECHNUNG_ZAHLUNGEN VALUES ('14','40019','2012-01-09','227.40','Raiffeisenbank','','','N');
INSERT INTO RECHNUNG_ZAHLUNGEN VALUES ('15','40023','2012-04-19','101.30','Raiffeisenbank','','','N');
INSERT INTO RECHNUNG_ZAHLUNGEN VALUES ('16','40026','2012-06-04','117.85','Post','','','N');
INSERT INTO RECHNUNG_ZAHLUNGEN VALUES ('17','40025','2012-06-12','16.65','Post','','','N');



#
# TABLE 'STAMMDATEN'
#
drop table if exists `STAMMDATEN`;

create table `STAMMDATEN` (
  `NAME1` varchar(30) Not Null,
  `NAME2` varchar(30),
  `NAME3` varchar(30),
  `STRASSE1` varchar(30) Not Null,
  `STRASSE2` varchar(30),
  `POSTFACH` varchar(11),
  `PLZ_ID` int(11) Default '0' Not Null,
  `TEL1` varchar(30) Not Null,
  `TEL2` varchar(30),
  `MOBIL1` varchar(30),
  `MOBIL2` varchar(30),
  `FAX1` varchar(30),
  `FAX2` varchar(30),
  `EMAIL1` varchar(30) Not Null,
  `EMAIL2` varchar(30),
  `WEBSITE` varchar(30),
  `BANK1_KONTO` int(20) Default '0' Not Null,
  `BANK1_BLZ` int(11) Default '0' Not Null,
  `BANK1_NAME` varchar(25) Not Null,
  `BANK1_IBAN` varchar(20),
  `BANK1_SWIFT` varchar(20),
  `BANK2_KONTO` int(20),
  `BANK2_BLZ` int(11),
  `BANK2_NAME` varchar(25),
  `BANK2_IBAN` varchar(20),
  `BANK2_SWIFT` varchar(20),
  `USTID` int(11),
  `LOGO1` varchar(20),
  `LOGO2` varchar(20));


#
# TABLE 'TEXTE'
#
drop table if exists `TEXTE`;

create table `TEXTE` (
  `TEXT_ID` int(11) Not Null auto_increment,
  `VORGANGSNUMMER` int(11) Default '0' Not Null,
  `VORGANG` varchar(20),
  `TEXTMODUL` int(11),
  `UEBERSCHRIFT` varchar(20) Not Null,
  `TEXT` varchar(200) Not Null,
  PRIMARY KEY (TEXT_ID)
);


#
# TABLE 'TITEL'
#
drop table if exists `TITEL`;

create table `TITEL` (
  `TITEL_ID` int(3) Not Null auto_increment,
  `TITEL` varchar(20) Not Null,
  `POSITION` int(2),
  `GELOESCHT` enum('J','N') Default 'N' Not Null,
  PRIMARY KEY (TITEL_ID)
);


#
# TABLE 'TITEL' DATA
#
INSERT INTO TITEL VALUES ('1','','1','N');
INSERT INTO TITEL VALUES ('2','Dr.','2','N');



#
# TABLE 'WERBETEXT'
#
drop table if exists `WERBETEXT`;

create table `WERBETEXT` (
  `WERBETEXT_ID` int(3) Not Null auto_increment,
  `WERBETEXT` varchar(80) Not Null,
  `POSITION` int(2) Not Null,
  `GELOESCHT` enum('N','J') Default 'N' Not Null,
  PRIMARY KEY (WERBETEXT_ID)
);


#
# TABLE 'WERBETEXT' DATA
#
INSERT INTO WERBETEXT VALUES ('1','','1','N');
INSERT INTO WERBETEXT VALUES ('2','Besten Dank fr Ihre Anfrage!','2','N');
INSERT INTO WERBETEXT VALUES ('3','Besten Dank fr Ihren Auftrag!','3','N');
INSERT INTO WERBETEXT VALUES ('4','Besten Dank fr Ihren Einkauf!','4','N');



#
# TABLE 'ZIVILSTAND'
#
drop table if exists `ZIVILSTAND`;

create table `ZIVILSTAND` (
  `ZIVILSTAND_ID` int(3) Not Null auto_increment,
  `ZIVILSTAND` varchar(20) Not Null,
  `POSITION` int(2),
  `GELOESCHT` enum('J','N') Default 'N' Not Null,
  PRIMARY KEY (ZIVILSTAND_ID)
);


#
# TABLE 'ZIVILSTAND' DATA
#
INSERT INTO ZIVILSTAND VALUES ('1','','1','N');
INSERT INTO ZIVILSTAND VALUES ('2','Ledig','2','N');
INSERT INTO ZIVILSTAND VALUES ('3','Verheiratet','3','N');
INSERT INTO ZIVILSTAND VALUES ('4','Geschieden','4','N');



#
# TABLE 'ZUGRIFFSRECHTE'
#
drop table if exists `ZUGRIFFSRECHTE`;

create table `ZUGRIFFSRECHTE` (
  `ZUGRIFFSRECHTE_ID` int(11) Not Null auto_increment,
  `MODUL_ID` int(11),
  `SUBMODUL_ID` int(11),
  `BENUTZERGRUPPE_ID` int(11),
  `USER_ID` int(11),
  `BUTTON` int(4),
  `USER` int(4),
  `WERT1_MAX` text,
  `WERT2_MAX` text,
  `WERT3_MAX` text,
  `WERT4_MAX` text,
  `WERT5_MAX` text,
  `WERT6_MAX` text,
  `WERT7_MAX` text,
  `WERT8_MAX` text,
  PRIMARY KEY (ZUGRIFFSRECHTE_ID),
  UNIQUE KEY Benutzerrechte_ID (ZUGRIFFSRECHTE_ID)
);


#
# TABLE 'ZUGRIFFSRECHTE' DATA
#
INSERT INTO ZUGRIFFSRECHTE VALUES ('1','1','0','1','0','255','255',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO ZUGRIFFSRECHTE VALUES ('2','100','0','2','0','15','255','','','','','','','','');
INSERT INTO ZUGRIFFSRECHTE VALUES ('3','101','0','2','0','0','255','','','','','','','','');
INSERT INTO ZUGRIFFSRECHTE VALUES ('4','300','0','2','0','0','255','99.00','10','5.00','99','','','','');
INSERT INTO ZUGRIFFSRECHTE VALUES ('5','200','0','2','0','255','255',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);



